/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.inference;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.coroutines.CoroutineUtilKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.calls.inference.BuilderInferenceData;
import org.jetbrains.kotlin.resolve.calls.inference.TypeTemplate;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.kotlin.resolve.descriptorUtil.AnnotationsForResolveUtilsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.StubTypeForBuilderInference;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=50, d1={"\u00004\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\u0016\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0010\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0005H\u0002\u001a\u001e\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010\u000f\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u0010\u001a\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u0006\u0012\u0002\b\u00030\u0010H\u0002\u00a8\u0006\u0013"}, d2={"containsTypeTemplate", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "isApplicableCallForBuilderInference", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "isGoodCallForOldBuilderInference", "resultingDescriptor", "isBuilderInferenceCall", "parameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "argument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "isResultWithBuilderInference", "Lorg/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResultsImpl;", "getBuilderInferenceData", "Lorg/jetbrains/kotlin/resolve/calls/inference/BuilderInferenceData;", "frontend"})
@SourceDebugExtension(value={"SMAP\nBuilderInferenceUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuilderInferenceUtil.kt\norg/jetbrains/kotlin/resolve/calls/inference/BuilderInferenceUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,360:1\n1755#2,3:361\n1#3:364\n*S KotlinDebug\n*F\n+ 1 BuilderInferenceUtil.kt\norg/jetbrains/kotlin/resolve/calls/inference/BuilderInferenceUtilKt\n*L\n322#1:361,3\n*E\n"})
public final class BuilderInferenceUtilKt {
    private static final boolean containsTypeTemplate(KotlinType $this$containsTypeTemplate) {
        return TypeUtilsKt.contains($this$containsTypeTemplate, (Function1<? super UnwrappedType, Boolean>)((Function1)BuilderInferenceUtilKt::containsTypeTemplate$lambda$0));
    }

    public static final boolean isApplicableCallForBuilderInference(@NotNull CallableDescriptor descriptor, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        if (languageVersionSettings.supportsFeature(LanguageFeature.UnrestrictedBuilderInference)) {
            return true;
        }
        if (!languageVersionSettings.supportsFeature(LanguageFeature.ExperimentalBuilderInference)) {
            return BuilderInferenceUtilKt.isGoodCallForOldBuilderInference(descriptor);
        }
        if (DescriptorUtilsKt.isExtension(descriptor) && !AnnotationsForResolveUtilsKt.hasBuilderInferenceAnnotation(descriptor)) {
            Annotated annotated = descriptor.getExtensionReceiverParameter();
            return annotated != null && (annotated = annotated.getType()) != null ? !BuilderInferenceUtilKt.containsTypeTemplate((KotlinType)annotated) : false;
        }
        KotlinType kotlinType = descriptor.getReturnType();
        if (kotlinType == null) {
            return false;
        }
        KotlinType returnType = kotlinType;
        return !BuilderInferenceUtilKt.containsTypeTemplate(returnType);
    }

    private static final boolean isGoodCallForOldBuilderInference(CallableDescriptor resultingDescriptor) {
        boolean bl;
        block6: {
            KotlinType kotlinType = resultingDescriptor.getReturnType();
            if (kotlinType == null) {
                return false;
            }
            KotlinType returnType = kotlinType;
            if (BuilderInferenceUtilKt.containsTypeTemplate(returnType)) {
                return false;
            }
            if (!(resultingDescriptor instanceof FunctionDescriptor) || ((FunctionDescriptor)resultingDescriptor).isSuspend()) {
                return true;
            }
            List<ValueParameterDescriptor> list = ((FunctionDescriptor)resultingDescriptor).getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getValueParameters(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
                    boolean bl2 = false;
                    KotlinType kotlinType2 = it.getType();
                    Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"getType(...)");
                    if (!BuilderInferenceUtilKt.containsTypeTemplate(kotlinType2)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return !bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isBuilderInferenceCall(@NotNull ValueParameterDescriptor parameterDescriptor, @NotNull ValueArgument argument, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter((Object)parameterDescriptor, (String)"parameterDescriptor");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        boolean parameterHasOptIn = languageVersionSettings.supportsFeature(LanguageFeature.ExperimentalBuilderInference) ? AnnotationsForResolveUtilsKt.hasBuilderInferenceAnnotation(parameterDescriptor) && CoroutineUtilKt.getHasFunctionOrSuspendFunctionType(parameterDescriptor) : CoroutineUtilKt.getHasSuspendFunctionType(parameterDescriptor);
        KtExpression pureExpression = argument.getArgumentExpression();
        KtExpression baseExpression = pureExpression instanceof KtLabeledExpression ? ((KtLabeledExpression)pureExpression).getBaseExpression() : pureExpression;
        if (!parameterHasOptIn) return false;
        if (!(baseExpression instanceof KtLambdaExpression)) return false;
        KotlinType it = parameterDescriptor.getType();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        if (!FunctionTypesKt.isBuiltinFunctionalType(it)) return false;
        if (FunctionTypesKt.getReceiverTypeFromFunctionType(it) == null) return false;
        return true;
    }

    public static final boolean isResultWithBuilderInference(@NotNull OverloadResolutionResultsImpl<?> $this$isResultWithBuilderInference) {
        Intrinsics.checkNotNullParameter($this$isResultWithBuilderInference, (String)"<this>");
        return BuilderInferenceUtilKt.getBuilderInferenceData($this$isResultWithBuilderInference) != null;
    }

    private static final BuilderInferenceData getBuilderInferenceData(OverloadResolutionResultsImpl<?> $this$getBuilderInferenceData) {
        if (!$this$getBuilderInferenceData.isSingleResult()) {
            return null;
        }
        BuilderInferenceData builderInferenceData = BuilderInferenceUtilKt.getBuilderInferenceData$getData($this$getBuilderInferenceData.getResultingCall().getDispatchReceiver());
        if (builderInferenceData == null) {
            builderInferenceData = BuilderInferenceUtilKt.getBuilderInferenceData$getData($this$getBuilderInferenceData.getResultingCall().getExtensionReceiver());
        }
        return builderInferenceData;
    }

    private static final boolean containsTypeTemplate$lambda$0(UnwrappedType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof TypeTemplate || it instanceof StubTypeForBuilderInference;
    }

    private static final boolean getBuilderInferenceData$getData$lambda$4(Ref.ObjectRef $builderInferenceData, UnwrappedType it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$builderInferenceData, (String)"$builderInferenceData");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Object object = it instanceof TypeTemplate ? (TypeTemplate)it : null;
            if (object == null || (object = ((TypeTemplate)object).getBuilderInferenceData()) == null) break block0;
            Object it2 = object;
            boolean bl = false;
            $builderInferenceData.element = it2;
        }
        return false;
    }

    private static final BuilderInferenceData getBuilderInferenceData$getData(ReceiverValue receiverValue) {
        Ref.ObjectRef builderInferenceData;
        block0: {
            builderInferenceData = new Ref.ObjectRef();
            Object object = receiverValue;
            if (object == null || (object = object.getType()) == null) break block0;
            TypeUtilsKt.contains((KotlinType)object, (Function1<? super UnwrappedType, Boolean>)((Function1)arg_0 -> BuilderInferenceUtilKt.getBuilderInferenceData$getData$lambda$4(builderInferenceData, arg_0)));
        }
        return (BuilderInferenceData)builderInferenceData.element;
    }

    public static final /* synthetic */ BuilderInferenceData access$getBuilderInferenceData(OverloadResolutionResultsImpl $receiver) {
        return BuilderInferenceUtilKt.getBuilderInferenceData($receiver);
    }
}

