/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.builtins.UnsignedTypes;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.KotlinLookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.resolve.ArrayFqNames;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.CallResolver;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001(B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J,\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u00192\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010\u001d\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u001d\u001a\u00020\u0013H\u0002J\u0010\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020'H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/resolve/CollectionLiteralResolver;", "", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "callResolver", "Lorg/jetbrains/kotlin/resolve/calls/CallResolver;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "<init>", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/resolve/calls/CallResolver;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "getModule", "()Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "getCallResolver", "()Lorg/jetbrains/kotlin/resolve/calls/CallResolver;", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "resolveCollectionLiteral", "Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "collectionLiteralExpression", "Lorg/jetbrains/kotlin/psi/KtCollectionLiteralExpression;", "context", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "reportUnsupportedLiteral", "", "diagnosticFactory", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory1;", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "", "resolveCollectionLiteralSpecialMethod", "expression", "getFunctionDescriptorForCollectionLiteral", "", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "callName", "Lorg/jetbrains/kotlin/name/Name;", "computeKindOfContainer", "Lorg/jetbrains/kotlin/resolve/CollectionLiteralResolver$ContainerKind;", "getArrayFunctionCallName", "expectedType", "Lorg/jetbrains/kotlin/types/KotlinType;", "ContainerKind", "frontend"})
public final class CollectionLiteralResolver {
    @NotNull
    private final ModuleDescriptor module;
    @NotNull
    private final CallResolver callResolver;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;

    public CollectionLiteralResolver(@NotNull ModuleDescriptor module2, @NotNull CallResolver callResolver, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)callResolver, (String)"callResolver");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        this.module = module2;
        this.callResolver = callResolver;
        this.languageVersionSettings = languageVersionSettings;
    }

    @NotNull
    public final ModuleDescriptor getModule() {
        return this.module;
    }

    @NotNull
    public final CallResolver getCallResolver() {
        return this.callResolver;
    }

    @NotNull
    public final LanguageVersionSettings getLanguageVersionSettings() {
        return this.languageVersionSettings;
    }

    @NotNull
    public final KotlinTypeInfo resolveCollectionLiteral(@NotNull KtCollectionLiteralExpression collectionLiteralExpression, @NotNull ExpressionTypingContext context2) {
        Intrinsics.checkNotNullParameter((Object)collectionLiteralExpression, (String)"collectionLiteralExpression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        switch (WhenMappings.$EnumSwitchMapping$0[this.computeKindOfContainer(collectionLiteralExpression).ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                DiagnosticFactory1<PsiElement, String> diagnosticFactory1;
                boolean bl = context2.languageVersionSettings.supportsFeature(LanguageFeature.ProhibitArrayLiteralsInCompanionOfAnnotation);
                if (bl) {
                    diagnosticFactory1 = Errors.UNSUPPORTED;
                } else if (!bl) {
                    diagnosticFactory1 = Errors.UNSUPPORTED_WARNING;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                DiagnosticFactory1<PsiElement, String> factory2 = diagnosticFactory1;
                Intrinsics.checkNotNull(factory2);
                this.reportUnsupportedLiteral(context2, factory2, collectionLiteralExpression);
                break;
            }
            case 3: {
                DiagnosticFactory1<PsiElement, String> diagnosticFactory1 = Errors.UNSUPPORTED;
                Intrinsics.checkNotNullExpressionValue(diagnosticFactory1, (String)"UNSUPPORTED");
                this.reportUnsupportedLiteral(context2, diagnosticFactory1, collectionLiteralExpression);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return this.resolveCollectionLiteralSpecialMethod(collectionLiteralExpression, context2);
    }

    private final void reportUnsupportedLiteral(ExpressionTypingContext context2, DiagnosticFactory1<PsiElement, String> diagnosticFactory, KtCollectionLiteralExpression collectionLiteralExpression) {
        context2.trace.report(diagnosticFactory.on(collectionLiteralExpression, "Collection literals outside of annotations"));
    }

    private final KotlinTypeInfo resolveCollectionLiteralSpecialMethod(KtCollectionLiteralExpression expression2, ExpressionTypingContext context2) {
        Call call2 = CallMaker.makeCallForCollectionLiteral(expression2);
        KotlinType kotlinType = context2.expectedType;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"expectedType");
        Name callName = this.getArrayFunctionCallName(kotlinType);
        Collection<FunctionDescriptor> functionDescriptors = this.getFunctionDescriptorForCollectionLiteral(expression2, callName);
        if (functionDescriptors.isEmpty()) {
            context2.trace.report(Errors.MISSING_STDLIB.on(expression2, "Collection literal call '" + callName + "()' is unresolved"));
            return TypeInfoFactoryKt.noTypeInfo(context2);
        }
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.callResolver.resolveCollectionLiteralCallWithGivenDescriptor(context2, expression2, call2, functionDescriptors);
        Intrinsics.checkNotNullExpressionValue(overloadResolutionResults, (String)"resolveCollectionLiteral\u2026lWithGivenDescriptor(...)");
        OverloadResolutionResults<FunctionDescriptor> resolutionResults = overloadResolutionResults;
        if (!resolutionResults.isSingleResult()) {
            return TypeInfoFactoryKt.noTypeInfo(context2);
        }
        context2.trace.record(BindingContext.COLLECTION_LITERAL_CALL, expression2, resolutionResults.getResultingCall());
        return TypeInfoFactoryKt.createTypeInfo(resolutionResults.getResultingDescriptor().getReturnType(), context2);
    }

    private final Collection<SimpleFunctionDescriptor> getFunctionDescriptorForCollectionLiteral(KtCollectionLiteralExpression expression2, Name callName) {
        MemberScope memberScopeOfKotlinPackage = this.module.getPackage(StandardNames.BUILT_INS_PACKAGE_FQ_NAME).getMemberScope();
        return memberScopeOfKotlinPackage.getContributedFunctions(callName, new KotlinLookupLocation(expression2));
    }

    private final ContainerKind computeKindOfContainer(KtCollectionLiteralExpression expression2) {
        KtClass containingAnnotation;
        Class[] classArray = new Class[]{KtAnnotationEntry.class, KtClass.class, KtObjectDeclaration.class};
        KtElementImplStub parent2 = (KtElementImplStub)PsiTreeUtil.getParentOfType((PsiElement)expression2, classArray);
        if (parent2 instanceof KtObjectDeclaration && (containingAnnotation = PsiTreeUtil.getParentOfType((PsiElement)parent2, KtClass.class)) != null && containingAnnotation.isAnnotation()) {
            return ContainerKind.CompanionOfAnnotation;
        }
        return parent2 instanceof KtAnnotationEntry || parent2 instanceof KtClass && ((KtClass)parent2).isAnnotation() ? ContainerKind.AnnotationOrAnnotationClass : ContainerKind.Other;
    }

    private final Name getArrayFunctionCallName(KotlinType expectedType) {
        if (TypeUtils.noExpectedType(expectedType) || !KotlinBuiltIns.isPrimitiveArray(expectedType) && !KotlinBuiltIns.isUnsignedArrayType(expectedType)) {
            return ArrayFqNames.INSTANCE.getARRAY_OF_FUNCTION();
        }
        ClassifierDescriptor classifierDescriptor = expectedType.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            return ArrayFqNames.INSTANCE.getARRAY_OF_FUNCTION();
        }
        ClassifierDescriptor descriptor = classifierDescriptor;
        Name name2 = ArrayFqNames.INSTANCE.getPRIMITIVE_TYPE_TO_ARRAY().get((Object)KotlinBuiltIns.getPrimitiveArrayType(descriptor));
        if (name2 == null && (name2 = (Name)((Map)UnsignedTypes.INSTANCE.getUnsignedArrayTypeToArrayCall()).get((Object)UnsignedTypes.toUnsignedArrayType(descriptor))) == null) {
            name2 = ArrayFqNames.INSTANCE.getARRAY_OF_FUNCTION();
        }
        return name2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/resolve/CollectionLiteralResolver$ContainerKind;", "", "<init>", "(Ljava/lang/String;I)V", "AnnotationOrAnnotationClass", "CompanionOfAnnotation", "Other", "frontend"})
    private static final class ContainerKind
    extends Enum<ContainerKind> {
        public static final /* enum */ ContainerKind AnnotationOrAnnotationClass = new ContainerKind();
        public static final /* enum */ ContainerKind CompanionOfAnnotation = new ContainerKind();
        public static final /* enum */ ContainerKind Other = new ContainerKind();
        private static final /* synthetic */ ContainerKind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ContainerKind[] values() {
            return (ContainerKind[])$VALUES.clone();
        }

        public static ContainerKind valueOf(String value2) {
            return Enum.valueOf(ContainerKind.class, value2);
        }

        @NotNull
        public static EnumEntries<ContainerKind> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = containerKindArray = new ContainerKind[]{ContainerKind.AnnotationOrAnnotationClass, ContainerKind.CompanionOfAnnotation, ContainerKind.Other};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=50)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ContainerKind.values().length];
            try {
                nArray[ContainerKind.AnnotationOrAnnotationClass.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ContainerKind.CompanionOfAnnotation.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ContainerKind.Other.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

