/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.callTranslator;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.translate.callTranslator.CallInfoExtensionsKt;
import org.jetbrains.kotlin.js.translate.callTranslator.FunctionCallCase;
import org.jetbrains.kotlin.js.translate.callTranslator.FunctionCallInfo;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\f\u0010\b\u001a\u00020\t*\u00020\u0007H\u0014\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/js/translate/callTranslator/SuperCallCase;", "Lorg/jetbrains/kotlin/js/translate/callTranslator/FunctionCallCase;", "<init>", "()V", "canApply", "", "callInfo", "Lorg/jetbrains/kotlin/js/translate/callTranslator/FunctionCallInfo;", "dispatchReceiver", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "js.translator"})
public final class SuperCallCase
extends FunctionCallCase {
    @NotNull
    public static final SuperCallCase INSTANCE = new SuperCallCase();

    private SuperCallCase() {
    }

    public final boolean canApply(@NotNull FunctionCallInfo callInfo) {
        Intrinsics.checkNotNullParameter((Object)callInfo, (String)"callInfo");
        return CallInfoExtensionsKt.isSuperInvocation(callInfo);
    }

    @Override
    @NotNull
    protected JsExpression dispatchReceiver(@NotNull FunctionCallInfo $this$dispatchReceiver) {
        JsNameRef jsNameRef;
        boolean shouldCallDefault;
        Intrinsics.checkNotNullParameter((Object)$this$dispatchReceiver, (String)"<this>");
        JsExpression jsExpression = JsAstUtils.prototypeOf(CallInfoExtensionsKt.getCalleeOwner($this$dispatchReceiver));
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"prototypeOf(...)");
        JsExpression prototypeClass = jsExpression;
        List arguments = CollectionsKt.toMutableList((Collection)$this$dispatchReceiver.getArgumentsInfo().getTranslateArguments());
        CallableDescriptor callableDescriptor = CallInfoExtensionsKt.getCallableDescriptor($this$dispatchReceiver).getOriginal();
        Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor, (String)"getOriginal(...)");
        CallableDescriptor descriptor = callableDescriptor;
        boolean bl = shouldCallDefault = descriptor instanceof FunctionDescriptor && TranslationUtils.isOverridableFunctionWithDefaultParameters((FunctionDescriptor)descriptor);
        if (shouldCallDefault) {
            int defaultArgumentCount = ((FunctionDescriptor)descriptor).getValueParameters().size() - $this$dispatchReceiver.getArgumentsInfo().getValueArguments().size();
            int n = 0;
            while (n < defaultArgumentCount) {
                int it = n++;
                boolean bl2 = false;
                ((Collection)arguments).add(Namer.getUndefinedExpression());
            }
            JsName it = $this$dispatchReceiver.getContext().getScopeForDescriptor(((FunctionDescriptor)descriptor).getContainingDeclaration()).declareName(CallInfoExtensionsKt.getFunctionName($this$dispatchReceiver).getIdent() + "$default");
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"declareName(...)");
            JsName callbackName = it;
            JsExpression jsExpression2 = $this$dispatchReceiver.getDispatchReceiver();
            Intrinsics.checkNotNull((Object)jsExpression2);
            JsInvocation jsInvocation = JsAstUtils.invokeBind(jsExpression2, new JsNameRef(callbackName, prototypeClass));
            Intrinsics.checkNotNullExpressionValue((Object)jsInvocation, (String)"invokeBind(...)");
            JsInvocation callbackRef = jsInvocation;
            ((Collection)arguments).add(callbackRef);
            jsNameRef = JsAstUtils.pureFqn(CallInfoExtensionsKt.getFunctionName($this$dispatchReceiver), $this$dispatchReceiver.getDispatchReceiver());
        } else {
            JsExpression jsExpression3 = $this$dispatchReceiver.getDispatchReceiver();
            Intrinsics.checkNotNull((Object)jsExpression3);
            arguments.add(0, jsExpression3);
            jsNameRef = Namer.getFunctionCallRef(new JsNameRef(CallInfoExtensionsKt.getFunctionName($this$dispatchReceiver), prototypeClass));
        }
        JsNameRef jsNameRef2 = jsNameRef;
        Intrinsics.checkNotNull((Object)jsNameRef2);
        JsNameRef functionRef = jsNameRef2;
        return new JsInvocation((JsExpression)functionRef, arguments);
    }
}

