/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.sourceMap;

import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007*\u00020\u0003H\u0002J\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0003R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/js/sourceMap/RelativePathCalculator;", "", "baseDir", "Ljava/io/File;", "<init>", "(Ljava/io/File;)V", "getAllParents", "", "baseDirPath", "calculateRelativePathTo", "", "file", "js.sourcemap"})
@SourceDebugExtension(value={"SMAP\nRelativePathCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RelativePathCalculator.kt\norg/jetbrains/kotlin/js/sourceMap/RelativePathCalculator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,33:1\n1782#2,4:34\n*S KotlinDebug\n*F\n+ 1 RelativePathCalculator.kt\norg/jetbrains/kotlin/js/sourceMap/RelativePathCalculator\n*L\n19#1:34,4\n*E\n"})
public final class RelativePathCalculator {
    @NotNull
    private final List<File> baseDirPath;

    public RelativePathCalculator(@NotNull File baseDir) {
        Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
        this.baseDirPath = this.getAllParents(baseDir);
    }

    private final List<File> getAllParents(File $this$getAllParents) {
        File file2 = $this$getAllParents.getAbsoluteFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getAbsoluteFile(...)");
        return CollectionsKt.asReversed((List)SequencesKt.toList((Sequence)SequencesKt.generateSequence((Object)FilesKt.normalize((File)file2), RelativePathCalculator::getAllParents$lambda$0)));
    }

    @Nullable
    public final String calculateRelativePathTo(@NotNull File file2) {
        int i;
        int n;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        List<File> parents = this.getAllParents(file2);
        if (!Intrinsics.areEqual((Object)this.baseDirPath.get(0), (Object)parents.get(0))) {
            return null;
        }
        Iterable $this$count$iv = CollectionsKt.zip((Iterable)this.baseDirPath, (Iterable)parents);
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                File second;
                Pair pair = (Pair)element$iv;
                boolean bl = false;
                File first = (File)pair.component1();
                if (!Intrinsics.areEqual((Object)first, (Object)(second = (File)pair.component2())) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int commonLength = n;
        StringBuilder sb = new StringBuilder();
        int n2 = this.baseDirPath.size();
        for (i = commonLength; i < n2; ++i) {
            sb.append("../");
        }
        n2 = parents.size();
        for (i = commonLength; i < n2; ++i) {
            sb.append(parents.get(i).getName()).append('/');
        }
        sb.setLength(StringsKt.getLastIndex((CharSequence)sb));
        return sb.toString();
    }

    private static final File getAllParents$lambda$0(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getParentFile();
    }
}

