/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.types;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.functions.FunctionTypeKind;
import org.jetbrains.kotlin.builtins.functions.FunctionTypeKindExtractor;
import org.jetbrains.kotlin.fir.FirSessionComponent;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.types.FirFunctionTypeRef;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bJ\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0011J\u0006\u0010\u0012\u001a\u00020\u000fJ\u0016\u0010\u0013\u001a\u0004\u0018\u00010\t2\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015H&J\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u00172\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015H&J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\u00172\u0006\u0010\u0019\u001a\u00020\u001aH&J \u0010\u001b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0017H&R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/fir/types/FirFunctionTypeKindService;", "Lorg/jetbrains/kotlin/fir/FirSessionComponent;", "<init>", "()V", "extractor", "Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKindExtractor;", "getExtractor", "()Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKindExtractor;", "getKindByClassNamePrefix", "Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKind;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "className", "", "hasKindWithSpecificPackage", "", "getFunctionKindPackageNames", "", "hasExtensionKinds", "extractSingleSpecialKindForFunction", "functionSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "extractAllSpecialKindsForFunction", "", "extractAllSpecialKindsForFunctionTypeRef", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirFunctionTypeRef;", "extractSingleExtensionKindForDeserializedConeType", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "annotations", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "tree"})
public abstract class FirFunctionTypeKindService
implements FirSessionComponent {
    @NotNull
    protected abstract FunctionTypeKindExtractor getExtractor();

    @Nullable
    public final FunctionTypeKind getKindByClassNamePrefix(@NotNull FqName packageFqName, @NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        FunctionTypeKindExtractor.KindWithArity kindWithArity = this.getExtractor().getFunctionalClassKindWithArity(packageFqName, className);
        return kindWithArity != null ? kindWithArity.getKind() : null;
    }

    public final boolean hasKindWithSpecificPackage(@NotNull FqName packageFqName) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        return this.getExtractor().hasKindWithSpecificPackage(packageFqName);
    }

    @NotNull
    public final Set<FqName> getFunctionKindPackageNames() {
        return this.getExtractor().getFunctionKindPackageNames();
    }

    public final boolean hasExtensionKinds() {
        return this.getExtractor().hasExtensionKinds();
    }

    @Nullable
    public abstract FunctionTypeKind extractSingleSpecialKindForFunction(@NotNull FirFunctionSymbol<?> var1);

    @NotNull
    public abstract List<FunctionTypeKind> extractAllSpecialKindsForFunction(@NotNull FirFunctionSymbol<?> var1);

    @NotNull
    public abstract List<FunctionTypeKind> extractAllSpecialKindsForFunctionTypeRef(@NotNull FirFunctionTypeRef var1);

    @Nullable
    public abstract FunctionTypeKind extractSingleExtensionKindForDeserializedConeType(@NotNull ClassId var1, @NotNull List<? extends FirAnnotation> var2);
}

