/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.renderer;

import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.fir.renderer.ConeAttributeRenderer;
import org.jetbrains.kotlin.fir.renderer.ConeIdRenderer;
import org.jetbrains.kotlin.fir.renderer.ConeTypeRenderer;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B#\b\u0016\u0012\n\u0010\u0007\u001a\u00060\tj\u0002`\b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010H\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\f\u0010\u0018\u001a\u00020\f*\u00020\u0012H\u0014R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/fir/renderer/ConeTypeRendererForReadability;", "Lorg/jetbrains/kotlin/fir/renderer/ConeTypeRenderer;", "idRendererCreator", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/fir/renderer/ConeIdRenderer;", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "builder", "Lkotlin/text/StringBuilder;", "Ljava/lang/StringBuilder;", "(Ljava/lang/StringBuilder;Lkotlin/jvm/functions/Function0;)V", "render", "", "flexibleType", "Lorg/jetbrains/kotlin/fir/types/ConeFlexibleType;", "renderBound", "", "bound", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "renderFlexibleTypeCompact", "lowerRendered", "upperRendered", "type", "Lorg/jetbrains/kotlin/fir/types/ConeIntegerLiteralType;", "renderAttributes", "cones"})
public final class ConeTypeRendererForReadability
extends ConeTypeRenderer {
    @NotNull
    private final Function0<ConeIdRenderer> idRendererCreator;

    public ConeTypeRendererForReadability(@NotNull Function0<? extends ConeIdRenderer> idRendererCreator) {
        Intrinsics.checkNotNullParameter(idRendererCreator, (String)"idRendererCreator");
        super(ConeAttributeRenderer.ForReadability.INSTANCE);
        this.idRendererCreator = idRendererCreator;
    }

    public ConeTypeRendererForReadability(@NotNull StringBuilder builder, @NotNull Function0<? extends ConeIdRenderer> idRendererCreator) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter(idRendererCreator, (String)"idRendererCreator");
        this(idRendererCreator);
        this.setBuilder(builder);
        this.setIdRenderer((ConeIdRenderer)idRendererCreator.invoke());
        this.getIdRenderer().setBuilder(builder);
    }

    @Override
    protected void render(@NotNull ConeFlexibleType flexibleType) {
        Intrinsics.checkNotNullParameter((Object)flexibleType, (String)"flexibleType");
        ConeSimpleKotlinType lower2 = flexibleType.getLowerBound();
        String lowerRendered = this.renderBound(lower2);
        String upperRendered = this.renderBound(flexibleType.getUpperBound());
        String string2 = this.renderFlexibleTypeCompact(lowerRendered, upperRendered);
        if (string2 == null) {
            ConeTypeRendererForReadability $this$render_u24lambda_u240 = this;
            boolean bl = false;
            String string3 = lower2 instanceof ConeDefinitelyNotNullType ? $this$render_u24lambda_u240.renderFlexibleTypeCompact($this$render_u24lambda_u240.renderBound(((ConeDefinitelyNotNullType)lower2).getOriginal()), upperRendered) : null;
            string2 = string3;
            if (string3 == null) {
                string2 = '(' + lowerRendered + ".." + upperRendered + ')';
            }
        }
        String rendered = string2;
        this.getBuilder().append(rendered);
    }

    private final String renderBound(ConeKotlinType bound) {
        ConeTypeRendererForReadability renderer = new ConeTypeRendererForReadability(new StringBuilder(), this.idRendererCreator);
        renderer.render(bound);
        String string2 = renderer.getBuilder().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    private final String renderFlexibleTypeCompact(String lowerRendered, String upperRendered) {
        String array;
        String mutableEntry;
        String simpleCollection;
        if (RenderingUtilsKt.typeStringsDifferOnlyInNullability(lowerRendered, upperRendered)) {
            if (StringsKt.startsWith$default((String)upperRendered, (String)"(", (boolean)false, (int)2, null)) {
                return '(' + lowerRendered + ")!";
            }
            return lowerRendered + '!';
        }
        String kotlinCollectionsPrefix = StandardNames.COLLECTIONS_PACKAGE_FQ_NAME.asString() + '.';
        String mutablePrefix = "Mutable";
        String string2 = simpleCollection = RenderingUtilsKt.replacePrefixesInTypeRepresentations(lowerRendered, kotlinCollectionsPrefix + mutablePrefix, upperRendered, kotlinCollectionsPrefix, kotlinCollectionsPrefix + '(' + mutablePrefix + ')');
        if (string2 != null) {
            return string2;
        }
        String string3 = mutableEntry = RenderingUtilsKt.replacePrefixesInTypeRepresentations(lowerRendered, kotlinCollectionsPrefix + "MutableMap.MutableEntry", upperRendered, kotlinCollectionsPrefix + "Map.Entry", kotlinCollectionsPrefix + "(Mutable)Map.(Mutable)Entry");
        if (string3 != null) {
            return string3;
        }
        String kotlinPrefix = StandardNames.BUILT_INS_PACKAGE_FQ_NAME.asString() + '.';
        String string4 = array = RenderingUtilsKt.replacePrefixesInTypeRepresentations(lowerRendered, kotlinPrefix + "Array<", upperRendered, kotlinPrefix + "Array<out ", kotlinPrefix + "Array<(out) ");
        if (string4 != null) {
            return string4;
        }
        return null;
    }

    @Override
    protected void render(@NotNull ConeIntegerLiteralType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        this.render(ConeIntegerLiteralType.getApproximatedType$default(type2, null, 1, null));
    }

    @Override
    protected void renderAttributes(@NotNull ConeKotlinType $this$renderAttributes) {
        Intrinsics.checkNotNullParameter((Object)$this$renderAttributes, (String)"<this>");
        this.renderNonCompilerAttributes($this$renderAttributes);
    }
}

