/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.extensions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.common.collect.LinkedHashMultimap;
import org.jetbrains.kotlin.com.google.common.collect.Multimap;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.extensions.FirExtensionApiInternals;
import org.jetbrains.kotlin.fir.extensions.FirPredicateBasedProvider;
import org.jetbrains.kotlin.fir.extensions.FirPredicateBasedProviderImplKt;
import org.jetbrains.kotlin.fir.extensions.FirPredicateBasedProviderKt;
import org.jetbrains.kotlin.fir.extensions.FirRegisteredPluginAnnotations;
import org.jetbrains.kotlin.fir.extensions.FirRegisteredPluginAnnotationsKt;
import org.jetbrains.kotlin.fir.extensions.predicate.AbstractPredicate;
import org.jetbrains.kotlin.fir.extensions.predicate.DeclarationPredicate;
import org.jetbrains.kotlin.fir.extensions.predicate.LookupPredicate;
import org.jetbrains.kotlin.fir.extensions.predicate.PredicateVisitor;
import org.jetbrains.kotlin.fir.resolve.CallableIdUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.kotlinx.collections.immutable.PersistentList;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002!\"B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0018H\u0017J\u001c\u0010\u0019\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0018\u00010\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001e\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0018H\u0002J\u001c\u0010\u001b\u001a\u00020\u00102\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001d\u001a\f\u0012\u0004\u0012\u00020\u001f0\u001eR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010 \u001a\f\u0012\u0004\u0012\u00020\u000e0\u001eR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/fir/extensions/FirPredicateBasedProviderImpl;", "Lorg/jetbrains/kotlin/fir/extensions/FirPredicateBasedProvider;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "registeredPluginAnnotations", "Lorg/jetbrains/kotlin/fir/extensions/FirRegisteredPluginAnnotations;", "cache", "Lorg/jetbrains/kotlin/fir/extensions/FirPredicateBasedProviderImpl$Cache;", "getSymbolsByPredicate", "", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "predicate", "Lorg/jetbrains/kotlin/fir/extensions/predicate/LookupPredicate;", "fileHasPluginAnnotations", "", "file", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "registerAnnotatedDeclaration", "", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "owners", "Lorg/jetbrains/kotlin/kotlinx/collections/immutable/PersistentList;", "getOwnersOfDeclaration", "registerOwnersDeclarations", "matches", "Lorg/jetbrains/kotlin/fir/extensions/predicate/AbstractPredicate;", "declarationPredicateMatcher", "Lorg/jetbrains/kotlin/fir/extensions/FirPredicateBasedProviderImpl$Matcher;", "Lorg/jetbrains/kotlin/fir/extensions/predicate/DeclarationPredicate;", "lookupPredicateMatcher", "Matcher", "Cache", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirPredicateBasedProviderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirPredicateBasedProviderImpl.kt\norg/jetbrains/kotlin/fir/extensions/FirPredicateBasedProviderImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,228:1\n1454#2,5:229\n774#2:234\n865#2,2:235\n1557#2:237\n1628#2,3:238\n1611#2,9:241\n1863#2:250\n1864#2:252\n1620#2:253\n774#2:254\n865#2,2:255\n1863#2,2:258\n1863#2,2:260\n1557#2:262\n1628#2,3:263\n1863#2,2:266\n1863#2,2:268\n1#3:251\n1#3:257\n*S KotlinDebug\n*F\n+ 1 FirPredicateBasedProviderImpl.kt\norg/jetbrains/kotlin/fir/extensions/FirPredicateBasedProviderImpl\n*L\n36#1:229,5\n39#1:234\n39#1:235,2\n39#1:237\n39#1:238,3\n53#1:241,9\n53#1:250\n53#1:252\n53#1:253\n54#1:254\n54#1:255,2\n59#1:258,2\n63#1:260,2\n71#1:262\n71#1:263,3\n79#1:266,2\n83#1:268,2\n53#1:251\n*E\n"})
public final class FirPredicateBasedProviderImpl
extends FirPredicateBasedProvider {
    @NotNull
    private final FirSession session;
    @NotNull
    private final FirRegisteredPluginAnnotations registeredPluginAnnotations;
    @NotNull
    private final Cache cache;
    @NotNull
    private final Matcher<DeclarationPredicate> declarationPredicateMatcher;
    @NotNull
    private final Matcher<LookupPredicate> lookupPredicateMatcher;

    public FirPredicateBasedProviderImpl(@NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.session = session2;
        this.registeredPluginAnnotations = FirRegisteredPluginAnnotationsKt.getRegisteredPluginAnnotations(this.session);
        this.cache = new Cache();
        this.declarationPredicateMatcher = new Matcher();
        this.lookupPredicateMatcher = new Matcher();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<FirBasedSymbol<?>> getSymbolsByPredicate(@NotNull LookupPredicate predicate) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        FirDeclaration it;
        void $this$filterTo$iv$iv;
        void destination$iv;
        void $this$flatMapTo$iv;
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        Set<FqName> annotations2 = predicate.getAnnotations();
        if (annotations2.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable iterable = annotations2;
        Collection collection = new LinkedHashSet();
        boolean $i$f$flatMapTo22 = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            FqName it2 = (FqName)element$iv;
            boolean bl = false;
            Collection<FirDeclaration> collection2 = this.cache.getDeclarationByAnnotation().get(it2);
            Intrinsics.checkNotNullExpressionValue(collection2, (String)"get(...)");
            Collection<FirDeclaration> collection3 = this.cache.getDeclarationsUnderAnnotated().get(it2);
            Intrinsics.checkNotNullExpressionValue(collection3, (String)"get(...)");
            Iterable list$iv = CollectionsKt.plus(collection2, (Iterable)collection3);
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        Set declarations2 = (Set)destination$iv;
        Iterable $this$filter$iv = declarations2;
        boolean $i$f$filter = false;
        Iterable $i$f$flatMapTo22 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (FirDeclaration)element$iv$iv;
            boolean bl = false;
            AbstractPredicate abstractPredicate = predicate;
            Intrinsics.checkNotNull((Object)it);
            if (!this.matches(abstractPredicate, it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (FirDeclaration)item$iv$iv;
            Collection collection4 = destination$iv$iv;
            boolean bl = false;
            collection4.add(it.getSymbol());
        }
        return (List)destination$iv$iv;
    }

    @Override
    public boolean fileHasPluginAnnotations(@NotNull FirFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return this.cache.getFilesWithPluginAnnotations().contains(file2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @FirExtensionApiInternals
    public void registerAnnotatedDeclaration(@NotNull FirDeclaration declaration, @NotNull PersistentList<? extends FirDeclaration> owners) {
        FqName it;
        void $this$filterTo$iv$iv;
        List $this$filter$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter(owners, (String)"owners");
        this.cache.getOwnersForDeclaration().put(declaration, owners);
        this.registerOwnersDeclarations(declaration, owners);
        if (declaration.getAnnotations().isEmpty()) {
            return;
        }
        Iterable iterable = declaration.getAnnotations();
        boolean $i$f$mapNotNull = false;
        void var7_7 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            FqName it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FirAnnotation it2 = (FirAnnotation)element$iv$iv;
            boolean bl2 = false;
            if (CallableIdUtilsKt.fqName(it2, this.session) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (FqName)element$iv$iv;
            boolean bl = false;
            if (!this.registeredPluginAnnotations.getAnnotations().contains(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List it3 = $this$filter$iv = (List)destination$iv$iv;
        boolean bl = false;
        List list = !((Collection)it3).isEmpty() ? $this$filter$iv : null;
        if (list == null) {
            return;
        }
        List matchingAnnotations = list;
        FirDeclaration firDeclaration = (FirDeclaration)CollectionsKt.lastOrNull((List)owners);
        if (firDeclaration != null) {
            FirDeclaration owner = firDeclaration;
            boolean bl4 = false;
            Iterable $this$forEach$iv = matchingAnnotations;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (FqName)element$iv;
                boolean bl5 = false;
                this.cache.getDeclarationsHasAnnotated().put(it, owner);
            }
            this.cache.getAnnotationsOfHasAnnotated().putAll(owner, matchingAnnotations);
        }
        Iterable $this$forEach$iv = matchingAnnotations;
        boolean $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv) {
            FqName it4 = (FqName)element$iv;
            boolean bl6 = false;
            this.cache.getDeclarationByAnnotation().put(it4, declaration);
        }
        this.cache.getAnnotationsOfDeclaration().putAll((Object)declaration, matchingAnnotations);
        Object object = CollectionsKt.first((List)owners);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirFile");
        FirFile file2 = (FirFile)object;
        ((Collection)this.cache.getFilesWithPluginAnnotations()).add(file2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public List<FirBasedSymbol<?>> getOwnersOfDeclaration(@NotNull FirDeclaration declaration) {
        List list;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        PersistentList<FirDeclaration> persistentList = this.cache.getOwnersForDeclaration().get(declaration);
        if (persistentList != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = persistentList;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FirDeclaration firDeclaration = (FirDeclaration)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getSymbol());
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        return list;
    }

    private final void registerOwnersDeclarations(FirDeclaration declaration, PersistentList<? extends FirDeclaration> owners) {
        FirDeclaration firDeclaration = (FirDeclaration)CollectionsKt.lastOrNull((List)owners);
        if (firDeclaration == null) {
            return;
        }
        FirDeclaration lastOwner = firDeclaration;
        Set annotationsFromLastOwner = this.cache.getAnnotationsOfDeclaration().get((Object)lastOwner);
        Set annotationsFromPreviousOwners = this.cache.getAnnotationsOfUnderAnnotated().get((Object)lastOwner);
        Intrinsics.checkNotNull((Object)annotationsFromLastOwner);
        Iterable $this$forEach$iv = annotationsFromLastOwner;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FqName it = (FqName)element$iv;
            boolean bl = false;
            this.cache.getDeclarationsParentAnnotated().put(it, declaration);
        }
        this.cache.getAnnotationsOfParentAnnotated().putAll(declaration, annotationsFromLastOwner);
        Intrinsics.checkNotNull((Object)annotationsFromPreviousOwners);
        Set allParentDeclarations = SetsKt.plus((Set)annotationsFromLastOwner, (Iterable)annotationsFromPreviousOwners);
        Iterable $this$forEach$iv2 = allParentDeclarations;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            FqName it = (FqName)element$iv;
            boolean bl = false;
            this.cache.getDeclarationsUnderAnnotated().put(it, declaration);
        }
        this.cache.getAnnotationsOfUnderAnnotated().putAll((Object)declaration, (Iterable)allParentDeclarations);
    }

    @Override
    public boolean matches(@NotNull AbstractPredicate<?> predicate, @NotNull FirDeclaration declaration) {
        boolean bl;
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        FirSession declarationSession = declaration.getModuleData().getSession();
        if (declarationSession.getKind() == FirSession.Kind.Source && declarationSession != this.session) {
            return FirPredicateBasedProviderKt.getPredicateBasedProvider(declarationSession).matches(predicate, declaration);
        }
        AbstractPredicate<?> abstractPredicate = predicate;
        if (abstractPredicate instanceof DeclarationPredicate) {
            bl = (Boolean)((DeclarationPredicate)predicate).accept((PredicateVisitor)this.declarationPredicateMatcher, declaration);
        } else if (abstractPredicate instanceof LookupPredicate) {
            bl = (Boolean)((LookupPredicate)predicate).accept((PredicateVisitor)this.lookupPredicateMatcher, declaration);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R!\u0010\u0004\u001a\u0012\u0012\b\u0012\u00060\u0007j\u0002`\u0006\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR!\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\b\u0012\u00060\u0007j\u0002`\u00060\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR!\u0010\u000f\u001a\u0012\u0012\b\u0012\u00060\u0007j\u0002`\u0006\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR!\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\b\u0012\u00060\u0007j\u0002`\u00060\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR!\u0010\u0013\u001a\u0012\u0012\b\u0012\u00060\u0007j\u0002`\u0006\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\nR!\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\b\u0012\u00060\u0007j\u0002`\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\nR!\u0010\u0017\u001a\u0012\u0012\b\u0012\u00060\u0007j\u0002`\u0006\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\nR!\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\b\u0012\u00060\u0007j\u0002`\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\nR#\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u001d0\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/fir/extensions/FirPredicateBasedProviderImpl$Cache;", "", "<init>", "()V", "declarationByAnnotation", "Lorg/jetbrains/kotlin/com/google/common/collect/Multimap;", "Lorg/jetbrains/kotlin/fir/extensions/AnnotationFqn;", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "getDeclarationByAnnotation", "()Lcom/google/common/collect/Multimap;", "annotationsOfDeclaration", "Lorg/jetbrains/kotlin/com/google/common/collect/LinkedHashMultimap;", "getAnnotationsOfDeclaration", "()Lcom/google/common/collect/LinkedHashMultimap;", "declarationsUnderAnnotated", "getDeclarationsUnderAnnotated", "annotationsOfUnderAnnotated", "getAnnotationsOfUnderAnnotated", "declarationsParentAnnotated", "getDeclarationsParentAnnotated", "annotationsOfParentAnnotated", "getAnnotationsOfParentAnnotated", "declarationsHasAnnotated", "getDeclarationsHasAnnotated", "annotationsOfHasAnnotated", "getAnnotationsOfHasAnnotated", "ownersForDeclaration", "", "Lorg/jetbrains/kotlin/kotlinx/collections/immutable/PersistentList;", "getOwnersForDeclaration", "()Ljava/util/Map;", "filesWithPluginAnnotations", "", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "getFilesWithPluginAnnotations", "()Ljava/util/Set;", "resolve"})
    private static final class Cache {
        @NotNull
        private final Multimap<FqName, FirDeclaration> declarationByAnnotation;
        @NotNull
        private final LinkedHashMultimap<FirDeclaration, FqName> annotationsOfDeclaration;
        @NotNull
        private final Multimap<FqName, FirDeclaration> declarationsUnderAnnotated;
        @NotNull
        private final LinkedHashMultimap<FirDeclaration, FqName> annotationsOfUnderAnnotated;
        @NotNull
        private final Multimap<FqName, FirDeclaration> declarationsParentAnnotated;
        @NotNull
        private final Multimap<FirDeclaration, FqName> annotationsOfParentAnnotated;
        @NotNull
        private final Multimap<FqName, FirDeclaration> declarationsHasAnnotated;
        @NotNull
        private final Multimap<FirDeclaration, FqName> annotationsOfHasAnnotated;
        @NotNull
        private final Map<FirDeclaration, PersistentList<FirDeclaration>> ownersForDeclaration;
        @NotNull
        private final Set<FirFile> filesWithPluginAnnotations;

        public Cache() {
            LinkedHashMultimap linkedHashMultimap = LinkedHashMultimap.create();
            Intrinsics.checkNotNullExpressionValue(linkedHashMultimap, (String)"create(...)");
            this.declarationByAnnotation = linkedHashMultimap;
            LinkedHashMultimap linkedHashMultimap2 = LinkedHashMultimap.create();
            Intrinsics.checkNotNullExpressionValue(linkedHashMultimap2, (String)"create(...)");
            this.annotationsOfDeclaration = linkedHashMultimap2;
            LinkedHashMultimap linkedHashMultimap3 = LinkedHashMultimap.create();
            Intrinsics.checkNotNullExpressionValue(linkedHashMultimap3, (String)"create(...)");
            this.declarationsUnderAnnotated = linkedHashMultimap3;
            LinkedHashMultimap linkedHashMultimap4 = LinkedHashMultimap.create();
            Intrinsics.checkNotNullExpressionValue(linkedHashMultimap4, (String)"create(...)");
            this.annotationsOfUnderAnnotated = linkedHashMultimap4;
            LinkedHashMultimap linkedHashMultimap5 = LinkedHashMultimap.create();
            Intrinsics.checkNotNullExpressionValue(linkedHashMultimap5, (String)"create(...)");
            this.declarationsParentAnnotated = linkedHashMultimap5;
            LinkedHashMultimap linkedHashMultimap6 = LinkedHashMultimap.create();
            Intrinsics.checkNotNullExpressionValue(linkedHashMultimap6, (String)"create(...)");
            this.annotationsOfParentAnnotated = linkedHashMultimap6;
            LinkedHashMultimap linkedHashMultimap7 = LinkedHashMultimap.create();
            Intrinsics.checkNotNullExpressionValue(linkedHashMultimap7, (String)"create(...)");
            this.declarationsHasAnnotated = linkedHashMultimap7;
            LinkedHashMultimap linkedHashMultimap8 = LinkedHashMultimap.create();
            Intrinsics.checkNotNullExpressionValue(linkedHashMultimap8, (String)"create(...)");
            this.annotationsOfHasAnnotated = linkedHashMultimap8;
            this.ownersForDeclaration = new LinkedHashMap();
            this.filesWithPluginAnnotations = new LinkedHashSet();
        }

        @NotNull
        public final Multimap<FqName, FirDeclaration> getDeclarationByAnnotation() {
            return this.declarationByAnnotation;
        }

        @NotNull
        public final LinkedHashMultimap<FirDeclaration, FqName> getAnnotationsOfDeclaration() {
            return this.annotationsOfDeclaration;
        }

        @NotNull
        public final Multimap<FqName, FirDeclaration> getDeclarationsUnderAnnotated() {
            return this.declarationsUnderAnnotated;
        }

        @NotNull
        public final LinkedHashMultimap<FirDeclaration, FqName> getAnnotationsOfUnderAnnotated() {
            return this.annotationsOfUnderAnnotated;
        }

        @NotNull
        public final Multimap<FqName, FirDeclaration> getDeclarationsParentAnnotated() {
            return this.declarationsParentAnnotated;
        }

        @NotNull
        public final Multimap<FirDeclaration, FqName> getAnnotationsOfParentAnnotated() {
            return this.annotationsOfParentAnnotated;
        }

        @NotNull
        public final Multimap<FqName, FirDeclaration> getDeclarationsHasAnnotated() {
            return this.declarationsHasAnnotated;
        }

        @NotNull
        public final Multimap<FirDeclaration, FqName> getAnnotationsOfHasAnnotated() {
            return this.annotationsOfHasAnnotated;
        }

        @NotNull
        public final Map<FirDeclaration, PersistentList<FirDeclaration>> getOwnersForDeclaration() {
            return this.ownersForDeclaration;
        }

        @NotNull
        public final Set<FirFile> getFilesWithPluginAnnotations() {
            return this.filesWithPluginAnnotations;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003B\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007J#\u0010\b\u001a\u00020\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u0010\n\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u000bJ#\u0010\f\u001a\u00020\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0006\u0010\n\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u000eJ#\u0010\u000f\u001a\u00020\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u00102\u0006\u0010\n\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u0011J#\u0010\u0012\u001a\u00020\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u00132\u0006\u0010\n\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u0014J#\u0010\u0015\u001a\u00020\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u00162\u0006\u0010\n\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u0017J#\u0010\u0018\u001a\u00020\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u00192\u0006\u0010\n\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u001aJ#\u0010\u001b\u001a\u00020\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u001c2\u0006\u0010\n\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u001dJ#\u0010\u001e\u001a\u00020\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u001f2\u0006\u0010\n\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010 J\"\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u00052\u0010\u0010#\u001a\f\u0012\b\u0012\u00060&j\u0002`%0$H\u0002J\"\u0010'\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u00052\u0010\u0010#\u001a\f\u0012\b\u0012\u00060&j\u0002`%0$H\u0002J\"\u0010(\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u00052\u0010\u0010#\u001a\f\u0012\b\u0012\u00060&j\u0002`%0$H\u0002J\"\u0010)\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u00052\u0010\u0010#\u001a\f\u0012\b\u0012\u00060&j\u0002`%0$H\u0002J\"\u0010*\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u00052\u0010\u0010#\u001a\f\u0012\b\u0012\u00060&j\u0002`%0$H\u0002\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/fir/extensions/FirPredicateBasedProviderImpl$Matcher;", "P", "Lorg/jetbrains/kotlin/fir/extensions/predicate/AbstractPredicate;", "Lorg/jetbrains/kotlin/fir/extensions/predicate/PredicateVisitor;", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "<init>", "(Lorg/jetbrains/kotlin/fir/extensions/FirPredicateBasedProviderImpl;)V", "visitPredicate", "predicate", "data", "(Lorg/jetbrains/kotlin/fir/extensions/predicate/AbstractPredicate;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Ljava/lang/Boolean;", "visitAnd", "Lorg/jetbrains/kotlin/fir/extensions/predicate/AbstractPredicate$And;", "(Lorg/jetbrains/kotlin/fir/extensions/predicate/AbstractPredicate$And;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Ljava/lang/Boolean;", "visitOr", "Lorg/jetbrains/kotlin/fir/extensions/predicate/AbstractPredicate$Or;", "(Lorg/jetbrains/kotlin/fir/extensions/predicate/AbstractPredicate$Or;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Ljava/lang/Boolean;", "visitAnnotatedWith", "Lorg/jetbrains/kotlin/fir/extensions/predicate/AbstractPredicate$AnnotatedWith;", "(Lorg/jetbrains/kotlin/fir/extensions/predicate/AbstractPredicate$AnnotatedWith;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Ljava/lang/Boolean;", "visitAncestorAnnotatedWith", "Lorg/jetbrains/kotlin/fir/extensions/predicate/AbstractPredicate$AncestorAnnotatedWith;", "(Lorg/jetbrains/kotlin/fir/extensions/predicate/AbstractPredicate$AncestorAnnotatedWith;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Ljava/lang/Boolean;", "visitParentAnnotatedWith", "Lorg/jetbrains/kotlin/fir/extensions/predicate/AbstractPredicate$ParentAnnotatedWith;", "(Lorg/jetbrains/kotlin/fir/extensions/predicate/AbstractPredicate$ParentAnnotatedWith;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Ljava/lang/Boolean;", "visitHasAnnotatedWith", "Lorg/jetbrains/kotlin/fir/extensions/predicate/AbstractPredicate$HasAnnotatedWith;", "(Lorg/jetbrains/kotlin/fir/extensions/predicate/AbstractPredicate$HasAnnotatedWith;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Ljava/lang/Boolean;", "visitMetaAnnotatedWith", "Lorg/jetbrains/kotlin/fir/extensions/predicate/AbstractPredicate$MetaAnnotatedWith;", "(Lorg/jetbrains/kotlin/fir/extensions/predicate/AbstractPredicate$MetaAnnotatedWith;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Ljava/lang/Boolean;", "matchWith", "declaration", "annotations", "", "Lorg/jetbrains/kotlin/fir/extensions/AnnotationFqn;", "Lorg/jetbrains/kotlin/name/FqName;", "matchNonIndexedDeclaration", "matchUnder", "matchParentWith", "matchHasAnnotatedWith", "resolve"})
    @SourceDebugExtension(value={"SMAP\nFirPredicateBasedProviderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirPredicateBasedProviderImpl.kt\norg/jetbrains/kotlin/fir/extensions/FirPredicateBasedProviderImpl$Matcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,228:1\n1755#2,3:229\n1755#2,3:233\n1755#2,3:236\n1755#2,3:239\n1755#2,3:242\n1755#2,3:245\n54#3:232\n*S KotlinDebug\n*F\n+ 1 FirPredicateBasedProviderImpl.kt\norg/jetbrains/kotlin/fir/extensions/FirPredicateBasedProviderImpl$Matcher\n*L\n147#1:229,3\n159#1:233,3\n165#1:236,3\n169#1:239,3\n173#1:242,3\n177#1:245,3\n157#1:232\n*E\n"})
    private final class Matcher<P extends AbstractPredicate<P>>
    extends PredicateVisitor<P, Boolean, FirDeclaration> {
        @Override
        @NotNull
        public Boolean visitPredicate(@NotNull AbstractPredicate<P> predicate, @NotNull FirDeclaration data) {
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            throw new IllegalStateException("Should not be there");
        }

        @Override
        @NotNull
        public Boolean visitAnd(@NotNull AbstractPredicate.And<P> predicate, @NotNull FirDeclaration data) {
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return (Boolean)predicate.getA().accept(this, (FirDeclaration)data) != false && (Boolean)predicate.getB().accept(this, (FirDeclaration)data) != false;
        }

        @Override
        @NotNull
        public Boolean visitOr(@NotNull AbstractPredicate.Or<P> predicate, @NotNull FirDeclaration data) {
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return (Boolean)predicate.getA().accept(this, (FirDeclaration)data) != false || (Boolean)predicate.getB().accept(this, (FirDeclaration)data) != false;
        }

        @Override
        @NotNull
        public Boolean visitAnnotatedWith(@NotNull AbstractPredicate.AnnotatedWith<P> predicate, @NotNull FirDeclaration data) {
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return this.matchWith(data, predicate.getAnnotations());
        }

        @Override
        @NotNull
        public Boolean visitAncestorAnnotatedWith(@NotNull AbstractPredicate.AncestorAnnotatedWith<P> predicate, @NotNull FirDeclaration data) {
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return this.matchUnder(data, predicate.getAnnotations());
        }

        @Override
        @NotNull
        public Boolean visitParentAnnotatedWith(@NotNull AbstractPredicate.ParentAnnotatedWith<P> predicate, @NotNull FirDeclaration data) {
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return this.matchParentWith(data, predicate.getAnnotations());
        }

        @Override
        @NotNull
        public Boolean visitHasAnnotatedWith(@NotNull AbstractPredicate.HasAnnotatedWith<P> predicate, @NotNull FirDeclaration data) {
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return this.matchHasAnnotatedWith(data, predicate.getAnnotations());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Boolean visitMetaAnnotatedWith(@NotNull AbstractPredicate.MetaAnnotatedWith<P> predicate, @NotNull FirDeclaration data) {
            boolean bl;
            block3: {
                void $this$any$iv;
                Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                Iterable iterable = data.getAnnotations();
                FirPredicateBasedProviderImpl firPredicateBasedProviderImpl = FirPredicateBasedProviderImpl.this;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirAnnotation annotation = (FirAnnotation)element$iv;
                        boolean bl2 = false;
                        if (!FirPredicateBasedProviderImplKt.markedWithMetaAnnotation(annotation, firPredicateBasedProviderImpl.session, data, predicate.getMetaAnnotations(), predicate.getIncludeItself())) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        /*
         * Unable to fully structure code
         */
        private final boolean matchWith(FirDeclaration declaration, Set<FqName> annotations) {
            block9: {
                block10: {
                    var3_3 = declaration.getOrigin();
                    if (!Intrinsics.areEqual((Object)var3_3, (Object)FirDeclarationOrigin.Library.INSTANCE) && !(var3_3 instanceof FirDeclarationOrigin.Java)) break block10;
                    v0 = this.matchNonIndexedDeclaration(declaration, annotations);
                    break block9;
                }
                if (!(declaration instanceof FirClass)) ** GOTO lbl-1000
                $this$isLocal$iv = (FirClassLikeDeclaration)declaration;
                $i$f$isLocal = false;
                if ($this$isLocal$iv.getSymbol().getClassId().isLocal()) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = var4_6 = false;
                }
                if (var4_6) {
                    v0 = this.matchNonIndexedDeclaration(declaration, annotations);
                } else if (!var4_6) {
                    v2 = FirPredicateBasedProviderImpl.access$getCache$p(FirPredicateBasedProviderImpl.this).getAnnotationsOfDeclaration().get((Object)declaration);
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"get(...)");
                    $this$any$iv = v2;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v0 = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            it = (FqName)element$iv;
                            $i$a$-any-FirPredicateBasedProviderImpl$Matcher$matchWith$1 = false;
                            if (!annotations.contains(it)) continue;
                            v0 = true;
                            break block9;
                        }
                        v0 = false;
                    }
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return v0;
        }

        /*
         * WARNING - void declaration
         */
        private final boolean matchNonIndexedDeclaration(FirDeclaration declaration, Set<FqName> annotations2) {
            boolean bl;
            block3: {
                void $this$any$iv;
                Iterable iterable = declaration.getAnnotations();
                FirPredicateBasedProviderImpl firPredicateBasedProviderImpl = FirPredicateBasedProviderImpl.this;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirAnnotation it = (FirAnnotation)element$iv;
                        boolean bl2 = false;
                        if (!CollectionsKt.contains((Iterable)annotations2, (Object)CallableIdUtilsKt.fqName(it, firPredicateBasedProviderImpl.session))) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final boolean matchUnder(FirDeclaration declaration, Set<FqName> annotations2) {
            boolean bl;
            block3: {
                Set set = FirPredicateBasedProviderImpl.this.cache.getAnnotationsOfUnderAnnotated().get((Object)declaration);
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"get(...)");
                Iterable $this$any$iv = set;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FqName it = (FqName)element$iv;
                        boolean bl2 = false;
                        if (!annotations2.contains(it)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final boolean matchParentWith(FirDeclaration declaration, Set<FqName> annotations2) {
            boolean bl;
            block3: {
                Collection<FqName> collection = FirPredicateBasedProviderImpl.this.cache.getAnnotationsOfParentAnnotated().get(declaration);
                Intrinsics.checkNotNullExpressionValue(collection, (String)"get(...)");
                Iterable $this$any$iv = collection;
                boolean $i$f$any = false;
                if (((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FqName it = (FqName)element$iv;
                        boolean bl2 = false;
                        if (!annotations2.contains(it)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final boolean matchHasAnnotatedWith(FirDeclaration declaration, Set<FqName> annotations2) {
            boolean bl;
            block3: {
                Collection<FqName> collection = FirPredicateBasedProviderImpl.this.cache.getAnnotationsOfHasAnnotated().get(declaration);
                Intrinsics.checkNotNullExpressionValue(collection, (String)"get(...)");
                Iterable $this$any$iv = collection;
                boolean $i$f$any = false;
                if (((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FqName it = (FqName)element$iv;
                        boolean bl2 = false;
                        if (!annotations2.contains(it)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }
    }
}

