/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend.native;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.backend.native.interop.FirObjCInteropKt;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.scopes.FirOverrideChecker;
import org.jetbrains.kotlin.fir.scopes.MemberWithBaseScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirOverrideUtilsKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirStandardOverrideChecker;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.native.interop.ObjCMethodInfo;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\u0018\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u000fH\u0016J4\u0010\u0010\u001a\u00020\u0011\"\f\b\u0000\u0010\u0012*\u0006\u0012\u0002\b\u00030\u00132\u0012\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00120\u00160\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\t*\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J#\u0010\u001a\u001a\u0004\u0018\u00010\t*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\u001bJ\u0018\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/fir/backend/native/FirNativeOverrideChecker;", "Lorg/jetbrains/kotlin/fir/scopes/FirOverrideChecker;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "standardOverrideChecker", "Lorg/jetbrains/kotlin/fir/scopes/impl/FirStandardOverrideChecker;", "isOverriddenFunction", "", "overrideCandidate", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "baseDeclaration", "isOverriddenProperty", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "chooseIntersectionVisibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "D", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "extractedOverrides", "", "Lorg/jetbrains/kotlin/fir/scopes/MemberWithBaseScope;", "dispatchClassSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "isObjCClassProperty", "isPlatformOverriddenFunction", "(Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;)Ljava/lang/Boolean;", "parameterNamesMatch", "first", "second", "native"})
@SourceDebugExtension(value={"SMAP\nFirNativeOverrideChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirNativeOverrideChecker.kt\norg/jetbrains/kotlin/fir/backend/native/FirNativeOverrideChecker\n+ 2 FirOverrideUtils.kt\norg/jetbrains/kotlin/fir/scopes/impl/FirOverrideUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n70#2:92\n72#2:95\n74#2,7:97\n774#3:93\n865#3:94\n866#3:96\n1872#3,3:104\n*S KotlinDebug\n*F\n+ 1 FirNativeOverrideChecker.kt\norg/jetbrains/kotlin/fir/backend/native/FirNativeOverrideChecker\n*L\n46#1:92\n46#1:95\n46#1:97,7\n46#1:93\n46#1:94\n46#1:96\n83#1:104,3\n*E\n"})
public final class FirNativeOverrideChecker
implements FirOverrideChecker {
    @NotNull
    private final FirSession session;
    @NotNull
    private final FirStandardOverrideChecker standardOverrideChecker;

    public FirNativeOverrideChecker(@NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.session = session2;
        this.standardOverrideChecker = new FirStandardOverrideChecker(this.session);
    }

    @Override
    public boolean isOverriddenFunction(@NotNull FirSimpleFunction overrideCandidate, @NotNull FirSimpleFunction baseDeclaration) {
        Intrinsics.checkNotNullParameter((Object)overrideCandidate, (String)"overrideCandidate");
        Intrinsics.checkNotNullParameter((Object)baseDeclaration, (String)"baseDeclaration");
        Boolean bl = this.isPlatformOverriddenFunction(overrideCandidate, this.session, baseDeclaration);
        return bl != null ? bl.booleanValue() : this.standardOverrideChecker.isOverriddenFunction(overrideCandidate, baseDeclaration);
    }

    @Override
    public boolean isOverriddenProperty(@NotNull FirCallableDeclaration overrideCandidate, @NotNull FirProperty baseDeclaration) {
        Intrinsics.checkNotNullParameter((Object)overrideCandidate, (String)"overrideCandidate");
        Intrinsics.checkNotNullParameter((Object)baseDeclaration, (String)"baseDeclaration");
        return this.standardOverrideChecker.isOverriddenProperty(overrideCandidate, baseDeclaration);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public <D extends FirCallableSymbol<?>> Visibility chooseIntersectionVisibility(@NotNull Collection<? extends MemberWithBaseScope<? extends D>> extractedOverrides, @Nullable FirRegularClassSymbol dispatchClassSymbol) {
        Visibility visibility;
        Object object;
        void $this$filterTo$iv$iv$iv;
        Intrinsics.checkNotNullParameter(extractedOverrides, (String)"extractedOverrides");
        List<MemberWithBaseScope<FirCallableSymbol<?>>> nonSubsumed = DeclarationUtilsKt.getNonSubsumedNonPhantomOverriddenSymbols(extractedOverrides);
        boolean $i$f$chooseIntersectionVisibilityOrNull = false;
        Iterable $this$filter$iv$iv = nonSubsumed;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv$iv : $this$filterTo$iv$iv$iv) {
            MemberWithBaseScope it$iv = (MemberWithBaseScope)element$iv$iv$iv;
            boolean bl = false;
            MemberWithBaseScope it = it$iv;
            boolean bl2 = false;
            if (!(!(FirOverrideUtilsKt.isAbstract(it) || this.isObjCClassProperty((FirCallableSymbol<?>)it.getMember(), this.session)) && !Intrinsics.areEqual((Object)((FirCallableSymbol)it$iv.getMember()).getCallableId(), (Object)StandardClassIds.Callables.INSTANCE.getClone()))) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        List nonAbstract$iv = (List)destination$iv$iv$iv;
        boolean allAreAbstract$iv = nonAbstract$iv.isEmpty();
        if ((allAreAbstract$iv ? FirOverrideUtilsKt.findMaxVisibilityOrNull((Collection)nonSubsumed) : ((object = (MemberWithBaseScope)CollectionsKt.singleOrNull((List)nonAbstract$iv)) != null && (object = ((MemberWithBaseScope)object).getMember()) != null && (object = ((FirCallableSymbol)object).getRawStatus()) != null ? object.getVisibility() : (visibility = null))) == null) {
            visibility = Visibilities.Unknown.INSTANCE;
        }
        return visibility;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isObjCClassProperty(FirCallableSymbol<?> $this$isObjCClassProperty, FirSession session2) {
        if (!($this$isObjCClassProperty instanceof FirPropertySymbol)) return false;
        ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag($this$isObjCClassProperty);
        FirClassLikeSymbol<?> firClassLikeSymbol = coneClassLikeLookupTag != null ? LookupTagUtilsKt.toSymbol(coneClassLikeLookupTag, session2) : null;
        if (!(firClassLikeSymbol instanceof FirClassSymbol)) return false;
        FirClassSymbol firClassSymbol = (FirClassSymbol)firClassLikeSymbol;
        if (firClassSymbol == null) return false;
        boolean bl = FirObjCInteropKt.isObjCClass(firClassSymbol, session2);
        if (!bl) return false;
        return true;
    }

    private final Boolean isPlatformOverriddenFunction(FirSimpleFunction $this$isPlatformOverriddenFunction, FirSession session2, FirSimpleFunction baseDeclaration) {
        if (!Intrinsics.areEqual((Object)$this$isPlatformOverriddenFunction.getName(), (Object)baseDeclaration.getName())) {
            return null;
        }
        ObjCMethodInfo objCMethodInfo = FirObjCInteropKt.decodeObjCMethodAnnotation(baseDeclaration.getSymbol(), session2);
        if (objCMethodInfo == null) {
            return null;
        }
        ObjCMethodInfo superInfo = objCMethodInfo;
        ObjCMethodInfo subInfo = FirObjCInteropKt.decodeObjCMethodAnnotation($this$isPlatformOverriddenFunction.getSymbol(), session2);
        return subInfo != null ? Boolean.valueOf(Intrinsics.areEqual((Object)superInfo.getSelector(), (Object)subInfo.getSelector())) : (!this.parameterNamesMatch($this$isPlatformOverriddenFunction, baseDeclaration) ? Boolean.valueOf(false) : null);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean parameterNamesMatch(FirSimpleFunction first, FirSimpleFunction second) {
        if (first.getValueParameters().size() != second.getValueParameters().size()) {
            return false;
        }
        Iterable $this$forEachIndexed$iv = first.getValueParameters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void parameter;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            FirValueParameter firValueParameter = (FirValueParameter)item$iv;
            int index = n;
            boolean bl = false;
            if (index <= 0 || Intrinsics.areEqual((Object)parameter.getName(), (Object)second.getValueParameters().get(index).getName())) continue;
            return false;
        }
        return true;
    }
}

