/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.syntax;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.FirSourceUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.syntax.FirDeclarationSyntaxChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirImport;
import org.jetbrains.kotlin.fir.declarations.FirResolvedImport;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedParentInImport;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.resolve.transformers.ImportUtilsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.PackageResolutionResult;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirEnumEntrySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirUnresolvedInMiddleOfImportChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirDeclarationSyntaxChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "Lorg/jetbrains/kotlin/psi/KtFile;", "<init>", "()V", "checkPsiOrLightTree", "", "element", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "processPossiblyUnresolvedImport", "import", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvedImport;", "getOutermostClassName", "", "Lorg/jetbrains/kotlin/name/ClassId;", "isClassIdPointingToEnumEntry", "", "classId", "symbolProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirUnresolvedInMiddleOfImportChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirUnresolvedInMiddleOfImportChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirUnresolvedInMiddleOfImportChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 4 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n1#2:100\n75#3:101\n37#4:102\n1755#5,3:103\n*S KotlinDebug\n*F\n+ 1 FirUnresolvedInMiddleOfImportChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirUnresolvedInMiddleOfImportChecker\n*L\n95#1:101\n95#1:102\n96#1:103,3\n*E\n"})
public final class FirUnresolvedInMiddleOfImportChecker
extends FirDeclarationSyntaxChecker<FirFile, KtFile> {
    @NotNull
    public static final FirUnresolvedInMiddleOfImportChecker INSTANCE = new FirUnresolvedInMiddleOfImportChecker();

    private FirUnresolvedInMiddleOfImportChecker() {
    }

    @Override
    public void checkPsiOrLightTree(@NotNull FirFile element, @NotNull KtSourceElement source, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        for (FirImport firImport : element.getImports()) {
            if (!(firImport instanceof FirResolvedImport)) continue;
            this.processPossiblyUnresolvedImport((FirResolvedImport)firImport, context2, reporter);
        }
    }

    private final void processPossiblyUnresolvedImport(FirResolvedImport firResolvedImport, CheckerContext context2, DiagnosticReporter reporter) {
        Object object = firResolvedImport.getSource();
        boolean bl = object != null && (object = ((KtSourceElement)object).getKind()) != null ? ((KtSourceElementKind)object).getShouldSkipErrorTypeReporting() : false;
        if (bl) {
            return;
        }
        ClassId classId = firResolvedImport.getResolvedParentClassId();
        if (classId == null) {
            return;
        }
        ClassId referencedClass = classId;
        PackageResolutionResult importResolutionResult = ImportUtilsKt.resolveToPackageOrClass(FirSymbolProviderKt.getSymbolProvider(context2.getSession()), referencedClass);
        if (!(importResolutionResult instanceof PackageResolutionResult.Error)) {
            return;
        }
        ConeDiagnostic diagnostic = ((PackageResolutionResult.Error)importResolutionResult).getDiagnostic();
        if (diagnostic instanceof ConeUnresolvedParentInImport) {
            KtSourceElement ktSourceElement = firResolvedImport.getSource();
            if (ktSourceElement == null) {
                return;
            }
            KtSourceElement source = ktSourceElement;
            FirSymbolProvider symbolProvider = FirSymbolProviderKt.getSymbolProvider(context2.getSession());
            ClassId parentClassId = ((ConeUnresolvedParentInImport)diagnostic).getParentClassId();
            if (firResolvedImport.isAllUnder() && this.isClassIdPointingToEnumEntry(parentClassId, symbolProvider)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getCANNOT_ALL_UNDER_IMPORT_FROM_SINGLETON(), (Object)parentClassId.getShortClassName(), (DiagnosticContext)context2, null, 16, null);
                return;
            }
            int errorSegmentIndexFromLast = firResolvedImport.isAllUnder() ? 0 : 1;
            ClassId currentClassId = parentClassId.getParentClassId();
            while (currentClassId != null && symbolProvider.getClassLikeSymbolByClassId(currentClassId) == null) {
                currentClassId = currentClassId.getParentClassId();
                ++errorSegmentIndexFromLast;
            }
            KtSourceElement ktSourceElement2 = FirSourceUtilsKt.getSourceForImportSegment(firResolvedImport, errorSegmentIndexFromLast);
            if (ktSourceElement2 == null) {
                return;
            }
            KtSourceElement unresolvedSource = ktSourceElement2;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)unresolvedSource, FirErrors.INSTANCE.getUNRESOLVED_IMPORT(), (Object)this.getOutermostClassName(parentClassId), (DiagnosticContext)context2, null, 16, null);
        }
    }

    private final String getOutermostClassName(ClassId $this$getOutermostClassName) {
        List<Name> list = $this$getOutermostClassName.getRelativeClassName().pathSegments();
        Intrinsics.checkNotNullExpressionValue(list, (String)"pathSegments(...)");
        String string2 = ((Name)CollectionsKt.first(list)).asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        return string2;
    }

    private final boolean isClassIdPointingToEnumEntry(ClassId classId, FirSymbolProvider symbolProvider) {
        boolean bl;
        block8: {
            Object object;
            block10: {
                block9: {
                    ClassId classId2 = classId.getParentClassId();
                    if (classId2 == null) {
                        return false;
                    }
                    ClassId enumClassId = classId2;
                    FirClassLikeSymbol<?> firClassLikeSymbol = symbolProvider.getClassLikeSymbolByClassId(enumClassId);
                    object = firClassLikeSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol : null;
                    if (object == null) break block9;
                    Object object2 = object;
                    FirRegularClassSymbol it = object2;
                    boolean bl2 = false;
                    FirClassSymbol $this$isEnumClass$iv = it;
                    boolean $i$f$isEnumClass = false;
                    ClassKind $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
                    boolean $i$f$isEnumClass2 = false;
                    object = $this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS ? object2 : null;
                    if (object != null) break block10;
                }
                return false;
            }
            FirRegularClassSymbol enumClass = object;
            Iterable $this$any$iv = DeclarationUtilsKt.collectEnumEntries(enumClass);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirEnumEntrySymbol it = (FirEnumEntrySymbol)element$iv;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getCallableId().getCallableName(), (Object)classId.getShortClassName())) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        return bl;
    }
}

