/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.extended;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u0003H\u0002J\f\u0010\u000f\u001a\u00020\u0010*\u00020\u0011H\u0002J\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0011H\u0002R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UselessCallOnNotNullChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "getCallableId", "Lorg/jetbrains/kotlin/name/CallableId;", "getPackage", "", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "getNullability", "Lorg/jetbrains/kotlin/fir/types/ConeNullability;", "triggerOn", "", "checkers"})
public final class UselessCallOnNotNullChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final UselessCallOnNotNullChecker INSTANCE = new UselessCallOnNotNullChecker();
    @NotNull
    private static final Set<String> triggerOn;

    private UselessCallOnNotNullChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        CallableId callableId = this.getCallableId(expression2);
        if (callableId == null) {
            return;
        }
        CallableId method = callableId;
        FirExpression firExpression = expression2.getExplicitReceiver();
        if (firExpression == null) {
            return;
        }
        FirExpression calleeOn = firExpression;
        String calleePackageName = this.getPackage(calleeOn);
        String string2 = method.getCallableName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        String calleeName = string2;
        if (!triggerOn.contains(calleePackageName + '.' + calleeName)) {
            return;
        }
        if (this.getNullability(calleeOn) == ConeNullability.NOT_NULL) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getUSELESS_CALL_ON_NOT_NULL(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private final CallableId getCallableId(FirQualifiedAccessExpression $this$getCallableId) {
        FirNamedFunctionSymbol firNamedFunctionSymbol = FirReferenceUtilsKt.toResolvedNamedFunctionSymbol$default($this$getCallableId.getCalleeReference(), false, 1, null);
        return firNamedFunctionSymbol != null ? firNamedFunctionSymbol.getCallableId() : null;
    }

    private final String getPackage(FirExpression $this$getPackage) {
        ClassId classId = ConeTypeUtilsKt.getClassId(FirTypeUtilsKt.getResolvedType($this$getPackage));
        return String.valueOf(classId != null ? classId.getPackageFqName() : null);
    }

    private final ConeNullability getNullability(FirExpression $this$getNullability) {
        return FirTypeUtilsKt.getResolvedType($this$getNullability).getNullability();
    }

    static {
        Object[] objectArray = new String[]{"kotlin.collections.orEmpty", "kotlin.sequences.orEmpty", "kotlin.text.orEmpty", "kotlin.text.isNullOrEmpty", "kotlin.text.isNullOrEmpty", "kotlin.text.isNullOrBlank", "kotlin.isNullOrBlank", "kotlin.isNullOrEmpty", "kotlin.orEmpty"};
        triggerOn = SetsKt.setOf((Object[])objectArray);
    }
}

