/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FE10LikeConeSubstitutor;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirUpperBoundViolatedHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirTypeArgumentsOfQualifierOfCallableReferenceChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirCallableReferenceAccessChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirCallableReferenceAccess;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirTypeArgumentsOfQualifierOfCallableReferenceChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirTypeArgumentsOfQualifierOfCallableReferenceChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirTypeArgumentsOfQualifierOfCallableReferenceChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,59:1\n774#2:60\n865#2,2:61\n37#3,2:63\n*S KotlinDebug\n*F\n+ 1 FirTypeArgumentsOfQualifierOfCallableReferenceChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirTypeArgumentsOfQualifierOfCallableReferenceChecker\n*L\n28#1:60\n28#1:61,2\n41#1:63,2\n*E\n"})
public final class FirTypeArgumentsOfQualifierOfCallableReferenceChecker
extends FirExpressionChecker<FirCallableReferenceAccess> {
    @NotNull
    public static final FirTypeArgumentsOfQualifierOfCallableReferenceChecker INSTANCE = new FirTypeArgumentsOfQualifierOfCallableReferenceChecker();

    private FirTypeArgumentsOfQualifierOfCallableReferenceChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull FirCallableReferenceAccess expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirExpression firExpression = expression2.getExplicitReceiver();
        FirResolvedQualifier firResolvedQualifier = firExpression instanceof FirResolvedQualifier ? (FirResolvedQualifier)firExpression : null;
        if (firResolvedQualifier == null) {
            return;
        }
        FirResolvedQualifier lhs = firResolvedQualifier;
        FirClassLikeSymbol<?> firClassLikeSymbol = lhs.getSymbol();
        if (firClassLikeSymbol == null) {
            return;
        }
        FirClassLikeSymbol<?> correspondingDeclaration = firClassLikeSymbol;
        List typeArgumentsWithSourceInfo = FirUpperBoundViolatedHelpersKt.toTypeArgumentsWithSourceInfo(lhs.getTypeArguments());
        Iterable $this$filter$iv = correspondingDeclaration.getTypeParameterSymbols();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FirTypeParameterSymbol it = (FirTypeParameterSymbol)element$iv$iv;
            boolean bl = false;
            if (!(it.getContainingDeclarationSymbol() instanceof FirClassLikeSymbol)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List<FirTypeParameterSymbol> typeParameterSymbols = (List<FirTypeParameterSymbol>)destination$iv$iv;
        if (typeParameterSymbols.size() != typeArgumentsWithSourceInfo.size()) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)lhs.getSource(), FirErrors.INSTANCE.getWRONG_NUMBER_OF_TYPE_ARGUMENTS(), (Object)correspondingDeclaration.getTypeParameterSymbols().size(), correspondingDeclaration, (DiagnosticContext)context2, null, 32, null);
            return;
        }
        if (correspondingDeclaration instanceof FirTypeAliasSymbol) {
            Collection $this$toTypedArray$iv = typeArgumentsWithSourceInfo;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            ConeClassLikeType qualifierType = TypeConstructionUtilsKt.constructType$default(correspondingDeclaration, thisCollection$iv.toArray(new ConeTypeProjection[0]), false, null, 4, null);
            ConeClassLikeType expandedLhsType = TypeExpansionUtilsKt.fullyExpandedType$default(qualifierType, context2.getSession(), null, 2, null);
            typeArgumentsWithSourceInfo = ArraysKt.toList((Object[])expandedLhsType.getTypeArguments());
            FirRegularClassSymbol firRegularClassSymbol = FirHelpersKt.toRegularClassSymbol(((FirTypeAliasSymbol)correspondingDeclaration).getResolvedExpandedTypeRef(), context2.getSession());
            if (firRegularClassSymbol == null) {
                return;
            }
            FirRegularClassSymbol expandedClassSymbol = firRegularClassSymbol;
            typeParameterSymbols = expandedClassSymbol.getTypeParameterSymbols();
        }
        FE10LikeConeSubstitutor substitutor2 = new FE10LikeConeSubstitutor(typeParameterSymbols, typeArgumentsWithSourceInfo, context2.getSession());
        FirUpperBoundViolatedHelpersKt.checkUpperBoundViolated$default(context2, reporter, typeParameterSymbols, typeArgumentsWithSourceInfo, substitutor2, false, false, 96, null);
    }
}

