/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactoryForDeprecation;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeDynamicType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\f\u0010\r\u001a\u00020\u000e*\u00020\u000fH\u0002J\f\u0010\u0010\u001a\u00020\u000e*\u00020\u0011H\u0002J8\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirReifiedChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isReifiedTypeParameterOrFromKotlinArray", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "cannotBeReified", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "checkArgumentAndReport", "typeArgument", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "isExplicit", "isArray", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirReifiedChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirReifiedChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirReifiedChecker\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,100:1\n13346#2,2:101\n*S KotlinDebug\n*F\n+ 1 FirReifiedChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirReifiedChecker\n*L\n75#1:101,2\n*E\n"})
public final class FirReifiedChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirReifiedChecker INSTANCE = new FirReifiedChecker();

    private FirReifiedChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirReference calleeReference = expression2.getCalleeReference();
        List<FirTypeProjection> typeArguments = expression2.getTypeArguments();
        Object object = FirReferenceUtilsKt.toResolvedCallableSymbol$default(calleeReference, false, 1, null);
        if (object == null || (object = ((FirCallableSymbol)object).getTypeParameterSymbols()) == null) {
            return;
        }
        Object typeParameters = object;
        int count = Math.min(typeArguments.size(), typeParameters.size());
        for (int index = 0; index < count; ++index) {
            ConeKotlinType typeArgument;
            FirTypeParameterSymbol typeParameter;
            FirTypeProjection typeArgumentProjection = typeArguments.get(index);
            KtSourceElement ktSourceElement = typeArgumentProjection.getSource();
            if (ktSourceElement == null && (ktSourceElement = calleeReference.getSource()) == null) continue;
            KtSourceElement source = ktSourceElement;
            if (ConeTypeProjectionKt.getType(FirTypeUtilsKt.toConeTypeProjection(typeArgumentProjection)) == null || !this.isReifiedTypeParameterOrFromKotlinArray(typeParameter = (FirTypeParameterSymbol)typeParameters.get(index))) continue;
            KtSourceElement ktSourceElement2 = typeArgumentProjection.getSource();
            this.checkArgumentAndReport(typeArgument, source, Intrinsics.areEqual((Object)(ktSourceElement2 != null ? ktSourceElement2.getKind() : null), (Object)KtRealSourceElementKind.INSTANCE), false, context2, reporter);
        }
    }

    private final boolean isReifiedTypeParameterOrFromKotlinArray(FirTypeParameterSymbol $this$isReifiedTypeParameterOrFromKotlinArray) {
        FirBasedSymbol<?> containingDeclaration = $this$isReifiedTypeParameterOrFromKotlinArray.getContainingDeclarationSymbol();
        return $this$isReifiedTypeParameterOrFromKotlinArray.isReified() || containingDeclaration instanceof FirRegularClassSymbol && Intrinsics.areEqual((Object)((FirRegularClassSymbol)containingDeclaration).getClassId(), (Object)StandardClassIds.INSTANCE.getArray());
    }

    private final boolean cannotBeReified(ConeKotlinType $this$cannotBeReified) {
        ConeKotlinType coneKotlinType = $this$cannotBeReified;
        return coneKotlinType instanceof ConeCapturedType ? true : (coneKotlinType instanceof ConeDynamicType ? true : ConeBuiltinTypeUtilsKt.isNothing($this$cannotBeReified) || ConeBuiltinTypeUtilsKt.isNullableNothing($this$cannotBeReified));
    }

    private final void checkArgumentAndReport(ConeKotlinType typeArgument, KtSourceElement source, boolean isExplicit, boolean isArray, CheckerContext context2, DiagnosticReporter reporter) {
        ConeKotlinType fullyExpandedType = TypeExpansionUtilsKt.fullyExpandedType(typeArgument, context2.getSession());
        if (Intrinsics.areEqual((Object)ConeTypeUtilsKt.getClassId(fullyExpandedType), (Object)StandardClassIds.INSTANCE.getArray())) {
            ConeTypeProjection[] $this$forEach$iv = fullyExpandedType.getTypeArguments();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                ConeTypeProjection element$iv;
                ConeTypeProjection it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                if (!(it instanceof ConeKotlinType)) continue;
                INSTANCE.checkArgumentAndReport((ConeKotlinType)it, source, isExplicit, true, context2, reporter);
            }
            return;
        }
        if (typeArgument instanceof ConeTypeParameterType) {
            FirTypeParameterSymbol symbol = ((ConeTypeParameterType)typeArgument).getLookupTag().getTypeParameterSymbol();
            if (!symbol.isReified()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, isArray ? (KtDiagnosticFactory1)KtDiagnosticReportHelpersKt.chooseFactory((KtDiagnosticFactoryForDeprecation)FirErrors.INSTANCE.getTYPE_PARAMETER_AS_REIFIED_ARRAY(), context2) : FirErrors.INSTANCE.getTYPE_PARAMETER_AS_REIFIED(), (Object)symbol, (DiagnosticContext)context2, null, 16, null);
            }
        } else if (typeArgument instanceof ConeDefinitelyNotNullType && isExplicit) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getDEFINITELY_NON_NULLABLE_AS_REIFIED(), (DiagnosticContext)context2, null, 8, null);
        } else if (this.cannotBeReified(typeArgument)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getREIFIED_TYPE_FORBIDDEN_SUBSTITUTION(), (Object)typeArgument, (DiagnosticContext)context2, null, 16, null);
        }
    }
}

