/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirLocalEntityNotAllowedChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirLocalEntityNotAllowedChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirLocalEntityNotAllowedChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirLocalEntityNotAllowedChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,38:1\n21#2:39\n67#2:40\n*S KotlinDebug\n*F\n+ 1 FirLocalEntityNotAllowedChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirLocalEntityNotAllowedChecker\n*L\n22#1:39\n29#1:40\n*E\n"})
public final class FirLocalEntityNotAllowedChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirLocalEntityNotAllowedChecker INSTANCE = new FirLocalEntityNotAllowedChecker();

    private FirLocalEntityNotAllowedChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void check(@NotNull FirRegularClass declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirMemberDeclaration $this$visibility$iv = declaration;
        boolean $i$f$getVisibility = false;
        if (!Intrinsics.areEqual((Object)$this$visibility$iv.getStatus().getVisibility(), (Object)Visibilities.Local.INSTANCE)) {
            return;
        }
        FirDeclaration container = (FirDeclaration)CollectionsKt.lastOrNull(context2.getContainingDeclarations());
        if (declaration.getClassKind() == ClassKind.OBJECT) {
            FirRegularClass $this$isCompanion$iv = declaration;
            boolean $i$f$isCompanion = false;
            if (!$this$isCompanion$iv.getStatus().isCompanion()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getLOCAL_OBJECT_NOT_ALLOWED(), (Object)declaration.getName(), (DiagnosticContext)context2, null, 16, null);
                return;
            }
        }
        if (declaration.getClassKind() != ClassKind.INTERFACE) return;
        if (container instanceof FirClass) return;
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getLOCAL_INTERFACE_NOT_ALLOWED(), (Object)declaration.getName(), (DiagnosticContext)context2, null, 16, null);
    }
}

