/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.SourceNavigator;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousInitializer;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.impl.FirPrimaryConstructor;
import org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import org.jetbrains.kotlin.fir.types.FirTypeRef;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\b\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\b\u001a\u00020\u0010H\u0002J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u000e2\u0006\u0010\b\u001a\u00020\u0010H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\u0010H\u0002J\u001a\u0010\u0019\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\u00102\b\u0010\u001a\u001a\u0004\u0018\u00010\u0012H\u0002J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\u0010H\u0002J\u0010\u0010\u001c\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\u0010H\u0002J\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\u0010H\u0002\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExpectConsistencyChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "getConstructorProhibitedPropertyParameters", "", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "containingClass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "getConstructorDelegationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirDelegatedConstructorCall;", "getClassSuperTypeReferencesWithInitializers", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "isProhibitedPrivateDeclaration", "", "isProhibitedEnumConstructor", "lastClass", "isProhibitedDeclarationWithBody", "isProhibitedEnumEntryWithBody", "isProhibitedEnumEntryWithInitializer", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirExpectConsistencyChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirExpectConsistencyChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExpectConsistencyChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 SourceNavigator.kt\norg/jetbrains/kotlin/fir/analysis/checkers/SourceNavigator$Companion\n*L\n1#1,125:1\n37#2:126\n37#2:127\n43#2:128\n21#2:136\n70#2:137\n774#3:129\n865#3,2:130\n774#3:133\n865#3,2:134\n78#4:132\n78#4:138\n78#4:139\n*S KotlinDebug\n*F\n+ 1 FirExpectConsistencyChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExpectConsistencyChecker\n*L\n35#1:126\n41#1:127\n78#1:128\n106#1:136\n114#1:137\n80#1:129\n80#1:130,2\n101#1:133\n101#1:134,2\n100#1:132\n118#1:138\n122#1:139\n*E\n"})
public final class FirExpectConsistencyChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirExpectConsistencyChecker INSTANCE = new FirExpectConsistencyChecker();

    private FirExpectConsistencyChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirClass lastClass;
        KtSourceElement source;
        block19: {
            block18: {
                FirMemberDeclaration $this$isExpect$iv;
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                KtSourceElement ktSourceElement = declaration.getSource();
                if (ktSourceElement == null) {
                    return;
                }
                source = ktSourceElement;
                if (source.getKind() instanceof KtFakeSourceElementKind) {
                    return;
                }
                Iterator<FirPureAbstractElement> iterator2 = CollectionsKt.lastOrNull(context2.getContainingDeclarations());
                FirClass firClass = lastClass = iterator2 instanceof FirClass ? (FirClass)((Object)iterator2) : null;
                if (declaration instanceof FirAnonymousInitializer) {
                    boolean bl;
                    FirClass firClass2 = lastClass;
                    if (firClass2 != null) {
                        $this$isExpect$iv = firClass2;
                        boolean $i$f$isExpect = false;
                        bl = $this$isExpect$iv.getStatus().isExpect();
                    } else {
                        bl = false;
                    }
                    if (bl) {
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getEXPECTED_DECLARATION_WITH_BODY(), (DiagnosticContext)context2, null, 8, null);
                    }
                    return;
                }
                if (!(declaration instanceof FirMemberDeclaration)) break block18;
                $this$isExpect$iv = (FirMemberDeclaration)declaration;
                boolean $i$f$isExpect = false;
                if ($this$isExpect$iv.getStatus().isExpect()) break block19;
            }
            return;
        }
        FirDelegatedConstructorCall firDelegatedConstructorCall = this.getConstructorDelegationCall((FirMemberDeclaration)declaration);
        if (firDelegatedConstructorCall != null) {
            FirDelegatedConstructorCall delegatedConstructor = firDelegatedConstructorCall;
            boolean bl = false;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)delegatedConstructor.getSource(), FirErrors.INSTANCE.getEXPECTED_CLASS_CONSTRUCTOR_DELEGATION_CALL(), (DiagnosticContext)context2, null, 8, null);
        }
        for (FirTypeRef superTypeRef : this.getClassSuperTypeReferencesWithInitializers((FirMemberDeclaration)declaration)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getSUPERTYPE_INITIALIZED_IN_EXPECTED_CLASS(), (DiagnosticContext)context2, null, 8, null);
        }
        for (FirValueParameter propertyParameter : this.getConstructorProhibitedPropertyParameters((FirMemberDeclaration)declaration, lastClass)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)propertyParameter.getSource(), FirErrors.INSTANCE.getEXPECTED_CLASS_CONSTRUCTOR_PROPERTY_PARAMETER(), (DiagnosticContext)context2, null, 8, null);
        }
        if (this.isProhibitedEnumConstructor((FirMemberDeclaration)declaration, lastClass)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getEXPECTED_ENUM_CONSTRUCTOR(), (DiagnosticContext)context2, null, 8, null);
        }
        if (this.isProhibitedEnumEntryWithBody((FirMemberDeclaration)declaration)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getEXPECTED_ENUM_ENTRY_WITH_BODY(), (DiagnosticContext)context2, null, 8, null);
        }
        if (this.isProhibitedEnumEntryWithInitializer((FirMemberDeclaration)declaration)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getSUPERTYPE_INITIALIZED_IN_EXPECTED_CLASS(), (DiagnosticContext)context2, null, 8, null);
        }
        if (this.isProhibitedPrivateDeclaration((FirMemberDeclaration)declaration)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getEXPECTED_PRIVATE_DECLARATION(), (DiagnosticContext)context2, null, 8, null);
        }
        if (this.isProhibitedDeclarationWithBody((FirMemberDeclaration)declaration)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getEXPECTED_DECLARATION_WITH_BODY(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<FirValueParameter> getConstructorProhibitedPropertyParameters(FirMemberDeclaration declaration, FirClass containingClass) {
        if (declaration instanceof FirPrimaryConstructor && containingClass != null && containingClass.getClassKind() != ClassKind.ANNOTATION_CLASS) {
            FirMemberDeclaration $this$isInline$iv = containingClass;
            boolean $i$f$isInline = false;
            if (!$this$isInline$iv.getStatus().isInline()) {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = ((FirPrimaryConstructor)declaration).getValueParameters();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    FirValueParameter it = (FirValueParameter)element$iv$iv;
                    boolean bl = false;
                    if (!(FirKeywordUtilsKt.getValOrVarKeyword(it.getSource()) != null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        }
        return CollectionsKt.emptyList();
    }

    private final FirDelegatedConstructorCall getConstructorDelegationCall(FirMemberDeclaration declaration) {
        if (declaration instanceof FirConstructor && !((FirConstructor)declaration).isPrimary()) {
            KtSourceElement delegatedConstructorSource;
            FirDelegatedConstructorCall delegatedConstructor;
            FirDelegatedConstructorCall firDelegatedConstructorCall = delegatedConstructor = ((FirConstructor)declaration).getDelegatedConstructor();
            KtSourceElement ktSourceElement = delegatedConstructorSource = firDelegatedConstructorCall != null ? firDelegatedConstructorCall.getSource() : null;
            if (!((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind)) {
                return delegatedConstructor;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<FirTypeRef> getClassSuperTypeReferencesWithInitializers(FirMemberDeclaration declaration) {
        void $this$filterTo$iv$iv;
        void this_$iv;
        if (!(declaration instanceof FirRegularClass)) {
            return CollectionsKt.emptyList();
        }
        SourceNavigator.Companion companion = SourceNavigator.Companion;
        FirElement $this$withNavigator$iv = declaration;
        boolean $i$f$withNavigator = false;
        SourceNavigator $this$getClassSuperTypeReferencesWithInitializers_u24lambda_u243 = this_$iv.forSource($this$withNavigator$iv.getSource());
        boolean bl = false;
        Iterable $this$filter$iv = ((FirRegularClass)declaration).getSuperTypeRefs();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FirTypeRef it = (FirTypeRef)element$iv$iv;
            boolean bl2 = false;
            if (!$this$getClassSuperTypeReferencesWithInitializers_u24lambda_u243.isInConstructorCallee(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isProhibitedPrivateDeclaration(FirMemberDeclaration declaration) {
        if (declaration instanceof FirConstructor) return false;
        if (declaration instanceof FirPropertyAccessor) return false;
        FirMemberDeclaration $this$visibility$iv = declaration;
        boolean $i$f$getVisibility = false;
        if (!Visibilities.INSTANCE.isPrivate($this$visibility$iv.getStatus().getVisibility())) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isProhibitedEnumConstructor(FirMemberDeclaration declaration, FirClass lastClass) {
        if (!(declaration instanceof FirConstructor)) return false;
        FirClass firClass = lastClass;
        if ((firClass != null ? firClass.getClassKind() : null) != ClassKind.ENUM_CLASS) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isProhibitedDeclarationWithBody(FirMemberDeclaration declaration) {
        if (!(declaration instanceof FirFunction)) return false;
        FirFunction $this$hasBody$iv = (FirFunction)declaration;
        boolean $i$f$getHasBody = false;
        if ($this$hasBody$iv.getBody() == null) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isProhibitedEnumEntryWithBody(FirMemberDeclaration declaration) {
        void this_$iv;
        if (!(declaration instanceof FirEnumEntry)) return false;
        SourceNavigator.Companion companion = SourceNavigator.Companion;
        FirElement $this$withNavigator$iv = declaration;
        boolean $i$f$withNavigator = false;
        SourceNavigator $this$isProhibitedEnumEntryWithBody_u24lambda_u244 = this_$iv.forSource($this$withNavigator$iv.getSource());
        boolean bl = false;
        if (!Intrinsics.areEqual((Object)$this$isProhibitedEnumEntryWithBody_u24lambda_u244.hasBody((FirEnumEntry)declaration), (Object)true)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isProhibitedEnumEntryWithInitializer(FirMemberDeclaration declaration) {
        void this_$iv;
        if (!(declaration instanceof FirEnumEntry)) return false;
        SourceNavigator.Companion companion = SourceNavigator.Companion;
        FirElement $this$withNavigator$iv = declaration;
        boolean $i$f$withNavigator = false;
        SourceNavigator $this$isProhibitedEnumEntryWithInitializer_u24lambda_u245 = this_$iv.forSource($this$withNavigator$iv.getSource());
        boolean bl = false;
        if (!Intrinsics.areEqual((Object)$this$isProhibitedEnumEntryWithInitializer_u24lambda_u245.hasInitializer((FirEnumEntry)declaration), (Object)true)) return false;
        return true;
    }
}

