/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.PrimitivesKt;
import org.jetbrains.kotlin.fir.TypeUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.ArgumentInfo;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.TypeInfo;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirSmartCastExpression;
import org.jetbrains.kotlin.fir.expressions.FirWhenSubjectExpression;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.scopes.FirPlatformClassMapperKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeTypeIntersector;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 0, 0}, k=2, xi=50, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\u0014\u0010\r\u001a\u00020\u0003*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u0014\u0010\f\u001a\u00020\u0003*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u0014\u0010\u0011\u001a\u00020\u0007*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u0014\u0010\u0012\u001a\u00020\u0013*\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u0014\u0010\u0019\u001a\u00020\u001a*\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u001a\u001c\u0010\u001d\u001a\u00020\u0003*\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u001a \u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u001a \u0010\"\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u001a \u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\"\u001c\u0010\u0002\u001a\u00020\u0003*\u0006\u0012\u0002\b\u00030\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0005\"\u0018\u0010\u0006\u001a\u00020\u0003*\u00020\u00078@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\b\"\u0018\u0010\t\u001a\u00020\u0003*\u00020\u00078@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\b\"\u0018\u0010\n\u001a\u00020\u0003*\u00020\u00078@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\b\"\u001c\u0010\u000b\u001a\u00020\u0003*\u0006\u0012\u0002\b\u00030\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0005\"\u001c\u0010\f\u001a\u00020\u0003*\u0006\u0012\u0002\b\u00030\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0005\"\u001e\u0010\u0014\u001a\u00020\u000e*\u00020\u00018BX\u0082\u0004\u00a2\u0006\f\u0012\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006&"}, d2={"unwrapToMoreUsefulExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "isBuiltin", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;)Z", "isNullableEnum", "Lorg/jetbrains/kotlin/fir/analysis/checkers/TypeInfo;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/TypeInfo;)Z", "isIdentityLess", "isNotNullPrimitive", "isFinalClass", "isClass", "isEnum", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "toTypeInfo", "toKotlinTypeIfPlatform", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "mostOriginalTypeIfSmartCast", "getMostOriginalTypeIfSmartCast$annotations", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)V", "getMostOriginalTypeIfSmartCast", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "toArgumentInfo", "Lorg/jetbrains/kotlin/fir/analysis/checkers/ArgumentInfo;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "isSubtypeOf", "other", "areUnrelated", "a", "b", "areRelated", "shouldReportAsPerRules1", "l", "r", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirTypeCompatibilityHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirTypeCompatibilityHelpers.kt\norg/jetbrains/kotlin/fir/analysis/checkers/FirTypeCompatibilityHelpersKt\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,139:1\n75#2:140\n42#2:142\n72#2:143\n75#2:145\n75#2:167\n51#2:178\n37#3:141\n34#3:144\n37#3:146\n37#3:168\n1557#4:147\n1628#4,3:148\n1611#4,9:152\n1863#4:161\n1864#4:163\n1620#4:164\n1755#4,2:165\n1757#4:169\n1755#4,3:170\n1755#4,3:173\n1755#4,2:176\n1757#4:179\n1755#4,3:180\n1755#4,3:183\n188#5:151\n1#6:162\n*S KotlinDebug\n*F\n+ 1 FirTypeCompatibilityHelpers.kt\norg/jetbrains/kotlin/fir/analysis/checkers/FirTypeCompatibilityHelpersKt\n*L\n47#1:140\n55#1:142\n58#1:143\n60#1:145\n73#1:167\n76#1:178\n47#1:141\n58#1:144\n60#1:146\n73#1:168\n65#1:147\n65#1:148,3\n69#1:152,9\n69#1:161\n69#1:163\n69#1:164\n73#1:165,2\n73#1:169\n74#1:170,3\n75#1:173,3\n76#1:176,2\n76#1:179\n77#1:180,3\n78#1:183,3\n66#1:151\n69#1:162\n*E\n"})
public final class FirTypeCompatibilityHelpersKt {
    @NotNull
    public static final FirExpression unwrapToMoreUsefulExpression(@NotNull FirExpression $this$unwrapToMoreUsefulExpression) {
        FirExpression firExpression;
        Intrinsics.checkNotNullParameter((Object)$this$unwrapToMoreUsefulExpression, (String)"<this>");
        if ($this$unwrapToMoreUsefulExpression instanceof FirWhenSubjectExpression) {
            firExpression = ((FirWhenSubjectExpression)$this$unwrapToMoreUsefulExpression).getWhenRef().getValue().getSubject();
            if (firExpression == null) {
                firExpression = $this$unwrapToMoreUsefulExpression;
            }
        } else {
            firExpression = $this$unwrapToMoreUsefulExpression;
        }
        return firExpression;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isBuiltin(FirClassSymbol<?> $this$isBuiltin) {
        if (PrimitivesKt.isPrimitiveType($this$isBuiltin)) return true;
        if (Intrinsics.areEqual((Object)$this$isBuiltin.getClassId(), (Object)StandardClassIds.INSTANCE.getString())) return true;
        FirClassSymbol<?> $this$isEnumClass$iv = $this$isBuiltin;
        boolean $i$f$isEnumClass = false;
        ClassKind $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
        boolean $i$f$isEnumClass2 = false;
        if ($this$isEnumClass$iv$iv != ClassKind.ENUM_CLASS) return false;
        return true;
    }

    public static final boolean isNullableEnum(@NotNull TypeInfo $this$isNullableEnum) {
        Intrinsics.checkNotNullParameter((Object)$this$isNullableEnum, (String)"<this>");
        return $this$isNullableEnum.isEnumClass() && ConeTypeUtilsKt.isNullable($this$isNullableEnum.getType());
    }

    public static final boolean isIdentityLess(@NotNull TypeInfo $this$isIdentityLess) {
        Intrinsics.checkNotNullParameter((Object)$this$isIdentityLess, (String)"<this>");
        return $this$isIdentityLess.isPrimitive() || $this$isIdentityLess.isValueClass();
    }

    public static final boolean isNotNullPrimitive(@NotNull TypeInfo $this$isNotNullPrimitive) {
        Intrinsics.checkNotNullParameter((Object)$this$isNotNullPrimitive, (String)"<this>");
        return $this$isNotNullPrimitive.isPrimitive() && !ConeTypeUtilsKt.isNullable($this$isNotNullPrimitive.getType());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isFinalClass(FirClassSymbol<?> $this$isFinalClass) {
        if (!FirTypeCompatibilityHelpersKt.isClass($this$isFinalClass)) return false;
        FirClassLikeSymbol $this$isFinal$iv = $this$isFinalClass;
        boolean $i$f$isFinal = false;
        if ($this$isFinal$iv.getResolvedStatus().getModality() != Modality.FINAL) return false;
        return true;
    }

    private static final boolean isClass(FirClassSymbol<?> $this$isClass) {
        FirClassSymbol<?> $this$isInterface$iv = $this$isClass;
        boolean $i$f$isInterface = false;
        ClassKind $this$isInterface$iv$iv = $this$isInterface$iv.getClassKind();
        boolean $i$f$isInterface2 = false;
        return !($this$isInterface$iv$iv == ClassKind.INTERFACE);
    }

    public static final boolean isEnum(@NotNull ConeKotlinType $this$isEnum, @NotNull FirSession session2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isEnum, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        FirRegularClassSymbol firRegularClassSymbol = org.jetbrains.kotlin.fir.types.TypeUtilsKt.toRegularClassSymbol($this$isEnum, session2);
        if (firRegularClassSymbol != null) {
            FirClassSymbol $this$isEnumClass$iv = firRegularClassSymbol;
            boolean $i$f$isEnumClass = false;
            ClassKind $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
            boolean $i$f$isEnumClass2 = false;
            bl = $this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS;
        } else {
            bl = false;
        }
        return bl;
    }

    public static final boolean isClass(@NotNull ConeKotlinType $this$isClass, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)$this$isClass, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        return org.jetbrains.kotlin.fir.types.TypeUtilsKt.toRegularClassSymbol($this$isClass, session2) != null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final TypeInfo toTypeInfo(@NotNull ConeKotlinType $this$toTypeInfo, @NotNull FirSession session2) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        boolean bl6;
        ConeKotlinType coneKotlinType;
        ConeKotlinType coneKotlinType2;
        ConeKotlinType coneKotlinType3;
        block28: {
            boolean bl7;
            Iterable $this$any$iv;
            boolean $i$f$any;
            List boundsSymbols;
            block27: {
                boolean bl8;
                block26: {
                    boolean bl9;
                    block25: {
                        boolean bl10;
                        block24: {
                            boolean bl11;
                            List bounds;
                            block23: {
                                void $this$mapNotNullTo$iv$iv;
                                ConeKotlinType coneKotlinType4;
                                ConeKotlinType coneKotlinType5;
                                void $this$mapTo$iv$iv;
                                Intrinsics.checkNotNullParameter((Object)$this$toTypeInfo, (String)"<this>");
                                Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
                                Iterable $this$map$iv = TypeUtilsKt.collectUpperBounds($this$toTypeInfo);
                                boolean $i$f$map = false;
                                Iterable iterable = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                boolean $i$f$mapTo = false;
                                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                    void type2;
                                    ConeClassLikeType coneClassLikeType = (ConeClassLikeType)item$iv$iv;
                                    Collection collection = destination$iv$iv;
                                    boolean bl12 = false;
                                    collection.add(ConeTypeUtilsKt.replaceArgumentsWithStarProjections(FirTypeCompatibilityHelpersKt.toKotlinTypeIfPlatform((ConeClassLikeType)type2, session2)));
                                }
                                bounds = (List)destination$iv$iv;
                                Collection $this$ifNotEmpty$iv = bounds;
                                boolean $i$f$ifNotEmpty = false;
                                if (!$this$ifNotEmpty$iv.isEmpty()) {
                                    List $this$toTypeInfo_u24lambda_u241 = (List)$this$ifNotEmpty$iv;
                                    boolean bl13 = false;
                                    coneKotlinType5 = ConeTypeIntersector.INSTANCE.intersectTypes(TypeComponentsKt.getTypeContext(session2), $this$toTypeInfo_u24lambda_u241);
                                } else {
                                    coneKotlinType5 = coneKotlinType4 = null;
                                }
                                if (coneKotlinType5 == null) {
                                    coneKotlinType4 = session2.getBuiltinTypes().getNullableAnyType().getType();
                                }
                                ConeKotlinType type3 = coneKotlinType4;
                                ConeKotlinType notNullType = org.jetbrains.kotlin.fir.types.TypeUtilsKt.withNullability$default(type3, ConeNullability.NOT_NULL, TypeComponentsKt.getTypeContext(session2), null, false, 12, null);
                                Iterable $this$mapNotNull$iv = bounds;
                                boolean $i$f$mapNotNull = false;
                                Iterable bl13 = $this$mapNotNull$iv;
                                Collection destination$iv$iv2 = new ArrayList();
                                boolean $i$f$mapNotNullTo = false;
                                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                                boolean $i$f$forEach = false;
                                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                                while (iterator2.hasNext()) {
                                    FirClassSymbol<?> it$iv$iv;
                                    Object element$iv$iv$iv;
                                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                                    boolean bl14 = false;
                                    ConeClassLikeType it = (ConeClassLikeType)element$iv$iv;
                                    boolean bl15 = false;
                                    if (org.jetbrains.kotlin.fir.types.TypeUtilsKt.toClassSymbol(it, session2) == null) continue;
                                    boolean bl16 = false;
                                    destination$iv$iv2.add(it$iv$iv);
                                }
                                boundsSymbols = (List)destination$iv$iv2;
                                $this$mapNotNull$iv = boundsSymbols;
                                coneKotlinType3 = $this$toTypeInfo;
                                coneKotlinType2 = notNullType;
                                coneKotlinType = type3;
                                $i$f$any = false;
                                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                    bl11 = false;
                                } else {
                                    for (Object element$iv : $this$any$iv) {
                                        FirClassSymbol it = (FirClassSymbol)element$iv;
                                        boolean bl17 = false;
                                        FirClassSymbol $this$isEnumClass$iv = it;
                                        boolean $i$f$isEnumClass = false;
                                        ClassKind $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
                                        boolean $i$f$isEnumClass2 = false;
                                        boolean bl18 = $this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS;
                                        if (!bl18) continue;
                                        bl11 = true;
                                        break block23;
                                    }
                                    bl11 = false;
                                }
                            }
                            bl6 = bl11;
                            $this$any$iv = bounds;
                            $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl10 = false;
                            } else {
                                for (Object element$iv : $this$any$iv) {
                                    ConeClassLikeType it = (ConeClassLikeType)element$iv;
                                    boolean bl19 = false;
                                    if (!ConeBuiltinTypeUtilsKt.isPrimitiveOrNullablePrimitive(it)) continue;
                                    bl10 = true;
                                    break block24;
                                }
                                bl10 = false;
                            }
                        }
                        bl5 = bl10;
                        $this$any$iv = boundsSymbols;
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl9 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                FirClassSymbol it = (FirClassSymbol)element$iv;
                                boolean bl20 = false;
                                if (!FirTypeCompatibilityHelpersKt.isBuiltin(it)) continue;
                                bl9 = true;
                                break block25;
                            }
                            bl9 = false;
                        }
                    }
                    bl4 = bl9;
                    $this$any$iv = boundsSymbols;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl8 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            FirClassSymbol it = (FirClassSymbol)element$iv;
                            boolean bl21 = false;
                            FirClassLikeSymbol $this$isInline$iv = it;
                            boolean $i$f$isInline = false;
                            if (!$this$isInline$iv.getRawStatus().isInline()) continue;
                            bl8 = true;
                            break block26;
                        }
                        bl8 = false;
                    }
                }
                bl3 = bl8;
                $this$any$iv = boundsSymbols;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl7 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirClassSymbol it = (FirClassSymbol)element$iv;
                        boolean bl22 = false;
                        if (!FirTypeCompatibilityHelpersKt.isFinalClass(it)) continue;
                        bl7 = true;
                        break block27;
                    }
                    bl7 = false;
                }
            }
            bl2 = bl7;
            $this$any$iv = boundsSymbols;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirClassSymbol it = (FirClassSymbol)element$iv;
                    boolean bl23 = false;
                    if (!FirTypeCompatibilityHelpersKt.isClass(it)) continue;
                    bl = true;
                    break block28;
                }
                bl = false;
            }
        }
        boolean bl24 = bl;
        boolean bl25 = org.jetbrains.kotlin.fir.types.TypeUtilsKt.canHaveSubtypesAccordingToK1(org.jetbrains.kotlin.fir.types.TypeUtilsKt.withNullability$default($this$toTypeInfo, ConeNullability.NOT_NULL, TypeComponentsKt.getTypeContext(session2), null, false, 12, null), session2);
        boolean bl26 = bl24;
        boolean bl27 = bl2;
        boolean bl28 = bl3;
        boolean bl29 = bl4;
        boolean bl30 = bl5;
        boolean bl31 = bl6;
        ConeKotlinType coneKotlinType6 = coneKotlinType3;
        ConeKotlinType coneKotlinType7 = coneKotlinType2;
        ConeKotlinType coneKotlinType8 = coneKotlinType;
        return new TypeInfo(coneKotlinType8, coneKotlinType7, coneKotlinType6, bl31, bl30, bl29, bl28, bl27, bl26, bl25);
    }

    @NotNull
    public static final ConeClassLikeType toKotlinTypeIfPlatform(@NotNull ConeClassLikeType $this$toKotlinTypeIfPlatform, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)$this$toKotlinTypeIfPlatform, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        ClassId kotlinClassId = FirPlatformClassMapperKt.getPlatformClassMapper(session2).getCorrespondingKotlinClass($this$toKotlinTypeIfPlatform.getLookupTag().getClassId());
        Object object = kotlinClassId;
        if (object == null || (object = TypeConstructionUtilsKt.constructClassLikeType((ClassId)object, $this$toKotlinTypeIfPlatform.getTypeArguments(), ConeTypeUtilsKt.isNullable($this$toKotlinTypeIfPlatform), $this$toKotlinTypeIfPlatform.getAttributes())) == null) {
            object = $this$toKotlinTypeIfPlatform;
        }
        return object;
    }

    private static final ConeKotlinType getMostOriginalTypeIfSmartCast(FirExpression $this$mostOriginalTypeIfSmartCast) {
        return $this$mostOriginalTypeIfSmartCast instanceof FirSmartCastExpression ? FirTypeCompatibilityHelpersKt.getMostOriginalTypeIfSmartCast(((FirSmartCastExpression)$this$mostOriginalTypeIfSmartCast).getOriginalExpression()) : FirTypeUtilsKt.getResolvedType($this$mostOriginalTypeIfSmartCast);
    }

    @NotNull
    public static final ArgumentInfo toArgumentInfo(@NotNull FirExpression $this$toArgumentInfo, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)$this$toArgumentInfo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new ArgumentInfo($this$toArgumentInfo, FirHelpersKt.finalApproximationOrSelf(FirTypeUtilsKt.getResolvedType($this$toArgumentInfo), context2), FirHelpersKt.finalApproximationOrSelf(TypeExpansionUtilsKt.fullyExpandedType(FirTypeCompatibilityHelpersKt.getMostOriginalTypeIfSmartCast($this$toArgumentInfo), context2.getSession()), context2), context2.getSession());
    }

    private static final boolean isSubtypeOf(TypeInfo $this$isSubtypeOf, TypeInfo other, CheckerContext context2) {
        return org.jetbrains.kotlin.fir.types.TypeUtilsKt.isSubtypeOf$default($this$isSubtypeOf.getNotNullType(), other.getNotNullType(), context2.getSession(), false, 4, null);
    }

    public static final boolean areUnrelated(@NotNull TypeInfo a, @NotNull TypeInfo b, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return !FirTypeCompatibilityHelpersKt.isSubtypeOf(a, b, context2) && !FirTypeCompatibilityHelpersKt.isSubtypeOf(b, a, context2);
    }

    public static final boolean areRelated(@NotNull TypeInfo a, @NotNull TypeInfo b, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return !FirTypeCompatibilityHelpersKt.areUnrelated(a, b, context2);
    }

    public static final boolean shouldReportAsPerRules1(@NotNull TypeInfo l, @NotNull TypeInfo r, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        boolean oneIsFinal = l.isFinal() || r.isFinal();
        return oneIsFinal ? FirTypeCompatibilityHelpersKt.areUnrelated(l, r, context2) : false;
    }
}

