/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponent;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponentKt;
import org.jetbrains.kotlin.fir.FirNameConflictsTrackerComponent;
import org.jetbrains.kotlin.fir.FirNameConflictsTrackerComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirVisibilityChecker;
import org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.DeclarationBuckets;
import org.jetbrains.kotlin.fir.analysis.checkers.FirDeclarationCollector;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirRedeclarationPresenter;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirNameConflictsTracker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.DeprecationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirContextReceiver;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOverloadabilityHelperKt;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirOuterClassTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.impl.FirDeclarationStatusImplKt;
import org.jetbrains.kotlin.fir.declarations.impl.FirResolvedDeclarationStatusImpl;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirComponentCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirProviderKt;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.scopes.CallableCopyTypeCalculator;
import org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScope;
import org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScopeKt;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirNestedClassifierScopeKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirPackageMemberScope;
import org.jetbrains.kotlin.fir.scopes.impl.TypeAliasConstructorsSubstitutingScope;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionOut;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.util.ListMultimap;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.utils.SmartSet;

@Metadata(mv={2, 0, 0}, k=2, xi=50, d1={"\u0000\u00c4\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\f\u001a\u00020\u0005*\u0006\u0012\u0002\b\u00030\rH\u0002\u001a \u0010\u0013\u001a\u00020\u00052\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\r2\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\rH\u0000\u001a*\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u00172\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u001a\u001c\u0010\u001f\u001a\u00020 *\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0!2\u0006\u0010\"\u001a\u00020#\u001a0\u0010(\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030)\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0*0\u00172\u0006\u0010+\u001a\u00020,2\u0006\u0010\u001d\u001a\u00020\u001e\u001aY\u0010-\u001a\u00020 \"\f\b\u0000\u0010.*\u0006\u0012\u0002\b\u00030\r\"\b\b\u0001\u0010/*\u0002H.*\b\u0012\u0004\u0012\u0002H.0!2\u0006\u00100\u001a\u0002H/2\u0006\u00101\u001a\u0002022\u0018\u00103\u001a\u0014\u0012\u0004\u0012\u000202\u0012\n\u0012\b\u0012\u0004\u0012\u0002H/0504H\u0002\u00a2\u0006\u0002\u00106\u001a$\u00107\u001a\u00020 *\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0!2\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;\u001a&\u0010<\u001a\u0010\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020>\u0018\u00010=*\u0006\u0012\u0002\b\u00030?2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u001a \u0010@\u001a\u00020\u00052\n\u0010A\u001a\u0006\u0012\u0002\b\u00030\r2\n\u0010B\u001a\u0006\u0012\u0002\b\u00030\rH\u0002\u001aV\u0010C\u001a\u00020 *\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0!2\n\u00100\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010D\u001a\u0002022\u0006\u0010E\u001a\u0002092\n\u0010F\u001a\u0006\u0012\u0002\b\u00030\r2\n\b\u0002\u0010G\u001a\u0004\u0018\u0001022\n\b\u0002\u0010H\u001a\u0004\u0018\u000109H\u0002\u001a\u0014\u0010I\u001a\u00020\u0005*\u00020\u00062\u0006\u0010J\u001a\u00020KH\u0002\u001a:\u0010L\u001a\u00020\u00052\n\u0010M\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010N\u001a\u0002092\n\u0010O\u001a\u0006\u0012\u0002\b\u00030\r2\b\u0010P\u001a\u0004\u0018\u0001092\u0006\u0010J\u001a\u00020KH\u0002\u001a(\u0010Q\u001a\u00020\u0005*\u0006\u0012\u0002\b\u00030!2\n\u00100\u001a\u0006\u0012\u0002\b\u00030\r2\n\u0010R\u001a\u0006\u0012\u0002\b\u00030\rH\u0002\u001a\u000e\u0010S\u001a\u0004\u0018\u00010T*\u00020UH\u0000\u001a$\u0010V\u001a\u00020 2\f\u0010W\u001a\b\u0012\u0004\u0012\u00020X0\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010Y\u001a\u00020Z\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0018\u0010\u0004\u001a\u00020\u0005*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0018\u0010\t\u001a\u00020\u0005*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000b\"\u0018\u0010\u000e\u001a\u00020\u0005*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\b\"\u001e\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u0006\u0012\u0002\b\u00030\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\"\u001c\u0010$\u001a\u00020\u0018*\u0006\u0012\u0002\b\u00030%8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u00a8\u0006["}, d2={"DEFAULT_STATUS_FOR_NORMAL_MAIN_FUNCTION", "Lorg/jetbrains/kotlin/fir/declarations/impl/FirResolvedDeclarationStatusImpl;", "getDEFAULT_STATUS_FOR_NORMAL_MAIN_FUNCTION", "()Lorg/jetbrains/kotlin/fir/declarations/impl/FirResolvedDeclarationStatusImpl;", "hasMainFunctionStatus", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "getHasMainFunctionStatus", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;)Z", "isTopLevel", "Lorg/jetbrains/kotlin/name/CallableId;", "(Lorg/jetbrains/kotlin/name/CallableId;)Z", "isCollectable", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "isCollectableAccordingToSource", "resolvedStatus", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvedDeclarationStatus;", "getResolvedStatus", "(Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;)Lorg/jetbrains/kotlin/fir/declarations/FirResolvedDeclarationStatus;", "isExpectAndNonExpect", "first", "second", "groupTopLevelByName", "", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/DeclarationBuckets;", "declarations", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "collectClassMembers", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirDeclarationCollector;", "klass", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "name", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassifierSymbol;", "getName", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassifierSymbol;)Lorg/jetbrains/kotlin/name/Name;", "collectConflictingLocalFunctionsFrom", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "", "block", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "collect", "D", "S", "declaration", "representation", "", "map", "", "", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/FirDeclarationCollector;Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;Ljava/lang/String;Ljava/util/Map;)V", "collectTopLevel", "file", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "packageMemberScope", "Lorg/jetbrains/kotlin/fir/scopes/impl/FirPackageMemberScope;", "expandedClassWithConstructorsScope", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "shouldCheckForMultiplatformRedeclaration", "dependency", "dependent", "collectTopLevelConflict", "declarationPresentation", "containingFile", "conflictingSymbol", "conflictingPresentation", "conflictingFile", "representsMainFunctionAllowingConflictingOverloads", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "areCompatibleMainFunctions", "declaration1", "file1", "declaration2", "file2", "areNonConflictingCallables", "conflicting", "getDestructuredParameter", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirValueParameterSymbol;", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "checkForLocalRedeclarations", "elements", "Lorg/jetbrains/kotlin/fir/FirElement;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirConflictsHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirConflictsHelpers.kt\norg/jetbrains/kotlin/fir/analysis/checkers/FirConflictsHelpersKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 FirScope.kt\norg/jetbrains/kotlin/fir/scopes/FirScopeKt\n+ 6 DeclarationUtils.kt\norg/jetbrains/kotlin/fir/resolve/DeclarationUtilsKt\n+ 7 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 8 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,592:1\n1755#2,3:593\n1755#2,3:596\n1755#2,3:599\n774#2:626\n865#2,2:627\n1863#2,2:643\n1782#2,4:653\n381#3,7:602\n381#3,7:609\n381#3,7:616\n381#3,7:629\n381#3,7:636\n381#3,7:662\n1#4:623\n101#5,2:624\n122#6,5:645\n128#6,2:651\n131#6,2:657\n133#6:661\n38#7:650\n37#8,2:659\n*S KotlinDebug\n*F\n+ 1 FirConflictsHelpers.kt\norg/jetbrains/kotlin/fir/analysis/checkers/FirConflictsHelpersKt\n*L\n61#1:593,3\n62#1:596,3\n64#1:599,3\n268#1:626\n268#1:627,2\n405#1:643,2\n440#1:653,4\n125#1:602,7\n128#1:609,7\n138#1:616,7\n300#1:629,7\n307#1:636,7\n492#1:662,7\n251#1:624,2\n440#1:645,5\n440#1:651,2\n440#1:657,2\n440#1:661\n440#1:650\n440#1:659,2\n*E\n"})
public final class FirConflictsHelpersKt {
    @NotNull
    private static final FirResolvedDeclarationStatusImpl DEFAULT_STATUS_FOR_NORMAL_MAIN_FUNCTION = FirResolvedDeclarationStatusImpl.Companion.getDEFAULT_STATUS_FOR_STATUSLESS_DECLARATIONS();

    @NotNull
    public static final FirResolvedDeclarationStatusImpl getDEFAULT_STATUS_FOR_NORMAL_MAIN_FUNCTION() {
        return DEFAULT_STATUS_FOR_NORMAL_MAIN_FUNCTION;
    }

    private static final boolean getHasMainFunctionStatus(FirNamedFunctionSymbol $this$hasMainFunctionStatus) {
        Object object = FirDeclarationStatusImplKt.getModifiersRepresentation($this$hasMainFunctionStatus.getResolvedStatus());
        return Intrinsics.areEqual((Object)object, (Object)FirDeclarationStatusImplKt.getModifiersRepresentation(DEFAULT_STATUS_FOR_NORMAL_MAIN_FUNCTION)) || Intrinsics.areEqual((Object)object, (Object)FirDeclarationStatusImplKt.getModifiersRepresentation(FirResolvedDeclarationStatusImpl.Companion.getDEFAULT_STATUS_FOR_SUSPEND_MAIN_FUNCTION()));
    }

    private static final boolean isTopLevel(CallableId $this$isTopLevel) {
        return $this$isTopLevel.getClassName() == null;
    }

    private static final boolean isCollectable(FirBasedSymbol<?> $this$isCollectable) {
        boolean bl;
        FirBasedSymbol<?> firBasedSymbol;
        if ($this$isCollectable instanceof FirCallableSymbol) {
            boolean bl2;
            Object it;
            boolean $i$f$any;
            Iterable $this$any$iv;
            block25: {
                boolean bl3;
                block24: {
                    $this$any$iv = ((FirCallableSymbol)$this$isCollectable).getResolvedContextReceivers();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (FirContextReceiver)element$iv;
                            boolean bl4 = false;
                            if (!ConeTypeUtilsKt.hasError(FirTypeUtilsKt.getConeType(((FirContextReceiver)it).getTypeRef()))) continue;
                            bl3 = true;
                            break block24;
                        }
                        bl3 = false;
                    }
                }
                if (bl3) {
                    return false;
                }
                $this$any$iv = ((FirCallableSymbol)$this$isCollectable).getTypeParameterSymbols();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (FirTypeParameterSymbol)element$iv;
                        boolean bl5 = false;
                        if (!ConeTypeUtilsKt.hasError(FirNestedClassifierScopeKt.toConeType((FirTypeParameterSymbol)it))) continue;
                        bl2 = true;
                        break block25;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                return false;
            }
            Object object = ((FirCallableSymbol)$this$isCollectable).getReceiverParameter();
            boolean bl6 = object != null && (object = ((FirReceiverParameter)object).getTypeRef()) != null && (object = FirTypeUtilsKt.getConeType((FirTypeRef)object)) != null ? ConeTypeUtilsKt.hasError((ConeKotlinType)object) : false;
            if (bl6) {
                return false;
            }
            if ($this$isCollectable instanceof FirFunctionSymbol) {
                boolean bl7;
                block26: {
                    $this$any$iv = ((FirFunctionSymbol)$this$isCollectable).getValueParameterSymbols();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl7 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (FirValueParameterSymbol)element$iv;
                            boolean bl8 = false;
                            if (!ConeTypeUtilsKt.hasError(((FirCallableSymbol)it).getResolvedReturnType())) continue;
                            bl7 = true;
                            break block26;
                        }
                        bl7 = false;
                    }
                }
                if (bl7) {
                    return false;
                }
            }
            if (Intrinsics.areEqual((Object)DeprecationUtilsKt.isHiddenToOvercomeSignatureClash((FirCallableDeclaration)((FirCallableSymbol)$this$isCollectable).getFir()), (Object)true)) {
                return false;
            }
        }
        if ((firBasedSymbol = $this$isCollectable) instanceof FirNamedFunctionSymbol) {
            bl = FirConflictsHelpersKt.isCollectableAccordingToSource((FirNamedFunctionSymbol)$this$isCollectable) && !Intrinsics.areEqual((Object)((FirNamedFunctionSymbol)$this$isCollectable).getName(), (Object)SpecialNames.NO_NAME_PROVIDED);
        } else if (firBasedSymbol instanceof FirRegularClassSymbol) {
            bl = !Intrinsics.areEqual((Object)((FirRegularClassSymbol)$this$isCollectable).getName(), (Object)SpecialNames.NO_NAME_PROVIDED);
        } else if (firBasedSymbol instanceof FirPropertySymbol) {
            KtSourceElement ktSourceElement = ((FirPropertySymbol)$this$isCollectable).getSource();
            bl = !((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind.EnumGeneratedDeclaration);
        } else if (firBasedSymbol instanceof FirFieldSymbol) {
            KtSourceElement ktSourceElement = ((FirFieldSymbol)$this$isCollectable).getSource();
            bl = !Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.ClassDelegationField.INSTANCE);
        } else {
            bl = true;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isCollectableAccordingToSource(FirNamedFunctionSymbol $this$isCollectableAccordingToSource) {
        KtSourceElement ktSourceElement = $this$isCollectableAccordingToSource.getSource();
        if (!((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind)) return true;
        KtSourceElement ktSourceElement2 = $this$isCollectableAccordingToSource.getSource();
        if (!Intrinsics.areEqual((Object)(ktSourceElement2 != null ? ktSourceElement2.getKind() : null), (Object)KtFakeSourceElementKind.DataClassGeneratedMembers.INSTANCE)) return false;
        return true;
    }

    private static final FirResolvedDeclarationStatus getResolvedStatus(FirBasedSymbol<?> $this$resolvedStatus) {
        FirBasedSymbol<?> firBasedSymbol = $this$resolvedStatus;
        return firBasedSymbol instanceof FirCallableSymbol ? ((FirCallableSymbol)$this$resolvedStatus).getResolvedStatus() : (firBasedSymbol instanceof FirClassLikeSymbol ? ((FirClassLikeSymbol)$this$resolvedStatus).getResolvedStatus() : null);
    }

    public static final boolean isExpectAndNonExpect(@NotNull FirBasedSymbol<?> first, @NotNull FirBasedSymbol<?> second) {
        Intrinsics.checkNotNullParameter(first, (String)"first");
        Intrinsics.checkNotNullParameter(second, (String)"second");
        FirResolvedDeclarationStatus firResolvedDeclarationStatus = FirConflictsHelpersKt.getResolvedStatus(first);
        boolean firstIsExpect = firResolvedDeclarationStatus != null ? firResolvedDeclarationStatus.isExpect() : false;
        FirResolvedDeclarationStatus firResolvedDeclarationStatus2 = FirConflictsHelpersKt.getResolvedStatus(second);
        boolean secondIsExpect = firResolvedDeclarationStatus2 != null ? firResolvedDeclarationStatus2.isExpect() : false;
        return firstIsExpect ^ secondIsExpect;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<Name, DeclarationBuckets> groupTopLevelByName(List<? extends FirDeclaration> declarations2, CheckerContext context2) {
        Map groups = new LinkedHashMap();
        for (FirDeclaration firDeclaration : declarations2) {
            Pair<FirRegularClassSymbol, FirScope> pair;
            String representation;
            Object object;
            void $this$getOrPut$iv;
            Object key$iv;
            if (!FirConflictsHelpersKt.isCollectable(firDeclaration.getSymbol())) continue;
            FirDeclaration firDeclaration2 = firDeclaration;
            if (firDeclaration2 instanceof FirSimpleFunction) {
                Object object2;
                Collection $this$getOrPut$iv2;
                Map map = groups;
                key$iv = ((FirSimpleFunction)firDeclaration).getName();
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv2.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    DeclarationBuckets answer$iv = new DeclarationBuckets();
                    $this$getOrPut$iv2.put(key$iv, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv;
                }
                $this$getOrPut$iv2 = ((DeclarationBuckets)object2).getSimpleFunctions();
                key$iv = TuplesKt.to((Object)((FirSimpleFunction)firDeclaration).getSymbol(), (Object)FirRedeclarationPresenter.INSTANCE.represent(((FirSimpleFunction)firDeclaration).getSymbol()));
                $this$getOrPut$iv2.add(key$iv);
                continue;
            }
            if (firDeclaration2 instanceof FirProperty) {
                Object object3;
                void $this$getOrPut$iv3;
                key$iv = groups;
                Name key$iv2 = ((FirProperty)firDeclaration).getName();
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv3.get(key$iv2);
                if (value$iv == null) {
                    boolean bl = false;
                    DeclarationBuckets answer$iv = new DeclarationBuckets();
                    $this$getOrPut$iv3.put(key$iv2, answer$iv);
                    object3 = answer$iv;
                } else {
                    object3 = value$iv;
                }
                DeclarationBuckets group = (DeclarationBuckets)object3;
                String representation2 = FirRedeclarationPresenter.INSTANCE.represent(((FirProperty)firDeclaration).getSymbol());
                if (((FirProperty)firDeclaration).getReceiverParameter() != null) {
                    ((Collection)group.getExtensionProperties()).add(TuplesKt.to((Object)((FirProperty)firDeclaration).getSymbol(), (Object)representation2));
                    continue;
                }
                ((Collection)group.getProperties()).add(TuplesKt.to((Object)((FirProperty)firDeclaration).getSymbol(), (Object)representation2));
                continue;
            }
            if (!(firDeclaration2 instanceof FirClassLikeDeclaration) || FirRedeclarationPresenter.INSTANCE.represent((FirBasedSymbol)((FirClassLikeDeclaration)firDeclaration).getSymbol()) == null) continue;
            Map key$iv2 = groups;
            Name key$iv3 = FirDeclarationUtilKt.getNameOrSpecialName((FirMemberDeclaration)firDeclaration);
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv3);
            if (value$iv == null) {
                boolean bl = false;
                DeclarationBuckets answer$iv = new DeclarationBuckets();
                $this$getOrPut$iv.put(key$iv3, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            DeclarationBuckets group = (DeclarationBuckets)object;
            ((Collection)group.getClassLikes()).add(TuplesKt.to(((FirClassLikeDeclaration)firDeclaration).getSymbol(), (Object)representation));
            if (FirConflictsHelpersKt.expandedClassWithConstructorsScope(((FirClassLikeDeclaration)firDeclaration).getSymbol(), context2) == null) continue;
            boolean bl = false;
            FirRegularClassSymbol expandedClass = (FirRegularClassSymbol)pair.component1();
            FirScope scopeWithConstructors = (FirScope)pair.component2();
            if (expandedClass.getClassKind() == ClassKind.OBJECT) continue;
            scopeWithConstructors.processDeclaredConstructors((Function1<? super FirConstructorSymbol, Unit>)((Function1)arg_0 -> FirConflictsHelpersKt.groupTopLevelByName$lambda$6$lambda$5(group, firDeclaration, arg_0)));
        }
        return groups;
    }

    /*
     * WARNING - void declaration
     */
    public static final void collectClassMembers(@NotNull FirDeclarationCollector<FirBasedSymbol<?>> $this$collectClassMembers, @NotNull FirRegularClassSymbol klass) {
        Intrinsics.checkNotNullParameter($this$collectClassMembers, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        Map otherDeclarations = new LinkedHashMap();
        Map functionDeclarations = new LinkedHashMap();
        FirContainingNamesAwareScope declaredMemberScope = FirHelpersKt.declaredMemberScope(klass, $this$collectClassMembers.getContext$checkers());
        FirTypeScope unsubstitutedScope = FirHelpersKt.unsubstitutedScope(klass, $this$collectClassMembers.getContext$checkers());
        FirContainingNamesAwareScopeKt.processAllFunctions(declaredMemberScope, (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)arg_0 -> FirConflictsHelpersKt.collectClassMembers$lambda$8($this$collectClassMembers, functionDeclarations, unsubstitutedScope, klass, arg_0)));
        if (FirHelpersKt.isTopLevel($this$collectClassMembers.getContext$checkers())) {
            unsubstitutedScope.processDeclaredConstructors((Function1<? super FirConstructorSymbol, Unit>)((Function1)arg_0 -> FirConflictsHelpersKt.collectClassMembers$lambda$9(klass, $this$collectClassMembers, functionDeclarations, arg_0)));
        }
        FirContainingNamesAwareScopeKt.processAllProperties(declaredMemberScope, arg_0 -> FirConflictsHelpersKt.collectClassMembers$lambda$11($this$collectClassMembers, otherDeclarations, unsubstitutedScope, klass, arg_0));
        for (FirBasedSymbol<?> declaredClassifier : klass.getDeclarationSymbols()) {
            void name$iv;
            void $this$processClassifiersByName$iv;
            if (!(declaredClassifier instanceof FirClassifierSymbol)) continue;
            FirConflictsHelpersKt.collectClassMembers$processClassifier(klass, $this$collectClassMembers, otherDeclarations, functionDeclarations, (FirClassifierSymbol)declaredClassifier);
            FirScope firScope = unsubstitutedScope;
            Name name2 = FirConflictsHelpersKt.getName((FirClassifierSymbol)declaredClassifier);
            Function1 processor$iv = arg_0 -> FirConflictsHelpersKt.collectClassMembers$lambda$14(declaredClassifier, klass, $this$collectClassMembers, otherDeclarations, functionDeclarations, arg_0);
            boolean $i$f$processClassifiersByName = false;
            $this$processClassifiersByName$iv.processClassifiersByNameWithSubstitution((Name)name$iv, (Function2)new Function2<FirClassifierSymbol<?>, ConeSubstitutor, Unit>(processor$iv){
                final /* synthetic */ Function1 $processor;
                {
                    this.$processor = $processor;
                }

                public final void invoke(FirClassifierSymbol<?> symbol, ConeSubstitutor coneSubstitutor) {
                    Intrinsics.checkNotNullParameter(symbol, (String)"symbol");
                    Intrinsics.checkNotNullParameter((Object)coneSubstitutor, (String)"<unused var>");
                    this.$processor.invoke(symbol);
                }
            });
        }
    }

    private static final Name getName(FirClassifierSymbol<?> $this$name) {
        Name name2;
        FirClassifierSymbol<?> firClassifierSymbol = $this$name;
        if (firClassifierSymbol instanceof FirClassLikeSymbol) {
            name2 = ((FirClassLikeSymbol)$this$name).getName();
        } else if (firClassifierSymbol instanceof FirTypeParameterSymbol) {
            name2 = ((FirTypeParameterSymbol)$this$name).getName();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return name2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<FirFunctionSymbol<?>, Set<FirBasedSymbol<?>>> collectConflictingLocalFunctionsFrom(@NotNull FirBlock block, @NotNull CheckerContext context2) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Iterable $this$filter$iv = block.getStatements();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FirStatement it = (FirStatement)element$iv$iv;
            boolean bl = false;
            if (!((it instanceof FirSimpleFunction || it instanceof FirRegularClass) && FirConflictsHelpersKt.isCollectable(((FirDeclaration)((Object)it)).getSymbol()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List collectables = (List)destination$iv$iv;
        if (collectables.isEmpty()) {
            return MapsKt.emptyMap();
        }
        FirDeclarationCollector inspector = new FirDeclarationCollector(context2);
        Map functionDeclarations = new LinkedHashMap();
        for (FirStatement collectable : collectables) {
            Pair<FirRegularClassSymbol, FirScope> pair;
            FirStatement firStatement = collectable;
            if (firStatement instanceof FirSimpleFunction) {
                FirConflictsHelpersKt.collect(inspector, (FirBasedSymbol)((FirSimpleFunction)collectable).getSymbol(), FirRedeclarationPresenter.INSTANCE.represent(((FirSimpleFunction)collectable).getSymbol()), functionDeclarations);
                continue;
            }
            if (!(firStatement instanceof FirClassLikeDeclaration)) continue;
            if (FirConflictsHelpersKt.expandedClassWithConstructorsScope(((FirClassLikeDeclaration)collectable).getSymbol(), context2) == null) continue;
            boolean bl = false;
            FirScope scopeWithConstructors = (FirScope)pair.component2();
            scopeWithConstructors.processDeclaredConstructors((Function1<? super FirConstructorSymbol, Unit>)((Function1)arg_0 -> FirConflictsHelpersKt.collectConflictingLocalFunctionsFrom$lambda$17$lambda$16(inspector, collectable, functionDeclarations, arg_0)));
        }
        return inspector.getDeclarationConflictingSymbols();
    }

    private static final <D extends FirBasedSymbol<?>, S extends D> void collect(FirDeclarationCollector<D> $this$collect, S declaration, String representation, Map<String, List<S>> map) {
        List list;
        List list2;
        Map<String, List<S>> $this$getOrPut$iv = map;
        boolean $i$f$getOrPut = false;
        List value$iv = $this$getOrPut$iv.get(representation);
        if (value$iv == null) {
            boolean bl = false;
            List answer$iv = new ArrayList();
            $this$getOrPut$iv.put(representation, answer$iv);
            list2 = answer$iv;
        } else {
            list2 = value$iv;
        }
        List it = list = list2;
        boolean bl = false;
        it.add(declaration);
        SmartSet<FirBasedSymbol> conflicts = SmartSet.Companion.create();
        for (FirBasedSymbol otherDeclaration : it) {
            Object object;
            if (Intrinsics.areEqual((Object)otherDeclaration, declaration) || FirConflictsHelpersKt.areNonConflictingCallables($this$collect, declaration, otherDeclaration)) continue;
            conflicts.add(otherDeclaration);
            Map $this$getOrPut$iv2 = $this$collect.getDeclarationConflictingSymbols();
            boolean $i$f$getOrPut2 = false;
            Object value$iv2 = $this$getOrPut$iv2.get(otherDeclaration);
            if (value$iv2 == null) {
                boolean bl2 = false;
                SmartSet answer$iv = SmartSet.Companion.create();
                $this$getOrPut$iv2.put(otherDeclaration, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv2;
            }
            ((SmartSet)((Object)object)).add(declaration);
        }
        ((Map)$this$collect.getDeclarationConflictingSymbols()).put(declaration, conflicts);
    }

    /*
     * WARNING - void declaration
     */
    public static final void collectTopLevel(@NotNull FirDeclarationCollector<FirBasedSymbol<?>> $this$collectTopLevel, @NotNull FirFile file2, @NotNull FirPackageMemberScope packageMemberScope) {
        Intrinsics.checkNotNullParameter($this$collectTopLevel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)packageMemberScope, (String)"packageMemberScope");
        for (Map.Entry<Name, DeclarationBuckets> entry : FirConflictsHelpersKt.groupTopLevelByName(file2.getDeclarations(), $this$collectTopLevel.getContext$checkers()).entrySet()) {
            boolean groupHasSimpleFunctions;
            Name declarationName = entry.getKey();
            DeclarationBuckets group = entry.getValue();
            boolean groupHasClassLikesOrProperties = !((Collection)group.getClassLikes()).isEmpty() || !((Collection)group.getProperties()).isEmpty();
            boolean bl = groupHasSimpleFunctions = !((Collection)group.getSimpleFunctions()).isEmpty();
            if (groupHasSimpleFunctions || !((Collection)group.getConstructors()).isEmpty()) {
                packageMemberScope.processFunctionsByName(declarationName, (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)arg_0 -> FirConflictsHelpersKt.collectTopLevel$lambda$23(group, $this$collectTopLevel, file2, declarationName, arg_0)));
            }
            if (groupHasClassLikesOrProperties || groupHasSimpleFunctions) {
                packageMemberScope.processClassifiersByNameWithSubstitution(declarationName, (arg_0, arg_1) -> FirConflictsHelpersKt.collectTopLevel$lambda$24(group, groupHasSimpleFunctions, $this$collectTopLevel, file2, declarationName, arg_0, arg_1));
                FirNameConflictsTrackerComponent firNameConflictsTrackerComponent = FirNameConflictsTrackerComponentKt.getNameConflictsTracker($this$collectTopLevel.getSession$checkers());
                if (firNameConflictsTrackerComponent != null) {
                    HashMap<ClassId, Set<FirNameConflictsTracker.ClassifierWithFile>> hashMap;
                    Object it = firNameConflictsTrackerComponent;
                    boolean bl222 = false;
                    FirNameConflictsTracker firNameConflictsTracker = it instanceof FirNameConflictsTracker ? (FirNameConflictsTracker)it : null;
                    if (firNameConflictsTracker != null && (hashMap = firNameConflictsTracker.getRedeclaredClassifiers()) != null && (it = hashMap.get(new ClassId(UtilsKt.getPackageFqName(file2), declarationName))) != null) {
                        void $this$forEach$iv;
                        Iterable bl222 = (Iterable)it;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            FirNameConflictsTracker.ClassifierWithFile it2 = (FirNameConflictsTracker.ClassifierWithFile)element$iv;
                            boolean bl3 = false;
                            FirConflictsHelpersKt.collectTopLevel$collectFromClassifierSource$default(group, groupHasSimpleFunctions, $this$collectTopLevel, file2, declarationName, it2.getClassifier(), null, it2.getFile(), 64, null);
                        }
                    }
                }
                for (Pair pair : group.getClassLikes()) {
                    FirClassLikeSymbol classLike = (FirClassLikeSymbol)pair.component1();
                    String representation = (String)pair.component2();
                    FirConflictsHelpersKt.collectTopLevel$collectFromClassifierSource(group, groupHasSimpleFunctions, $this$collectTopLevel, file2, declarationName, classLike, representation, file2);
                }
            }
            if (!groupHasClassLikesOrProperties && !(!((Collection)group.getExtensionProperties()).isEmpty())) continue;
            packageMemberScope.processPropertiesByName(declarationName, arg_0 -> FirConflictsHelpersKt.collectTopLevel$lambda$27(group, $this$collectTopLevel, file2, declarationName, arg_0));
        }
    }

    /*
     * Unable to fully structure code
     */
    private static final Pair<FirRegularClassSymbol, FirScope> expandedClassWithConstructorsScope(FirClassLikeSymbol<?> $this$expandedClassWithConstructorsScope, CheckerContext context) {
        block10: {
            block11: {
                block12: {
                    block14: {
                        block13: {
                            block9: {
                                var2_2 = $this$expandedClassWithConstructorsScope;
                                if (!(var2_2 instanceof FirRegularClassSymbol)) break block9;
                                v0 = TuplesKt.to($this$expandedClassWithConstructorsScope, (Object)FirHelpersKt.unsubstitutedScope((FirClassSymbol)$this$expandedClassWithConstructorsScope, context));
                                break block10;
                            }
                            if (!(var2_2 instanceof FirTypeAliasSymbol)) break block11;
                            var4_3 = FirTypeUtilsKt.getConeType(((FirTypeAliasSymbol)$this$expandedClassWithConstructorsScope).getResolvedExpandedTypeRef());
                            v1 = expandedType = var4_3 instanceof ConeClassLikeType != false ? (ConeClassLikeType)var4_3 : null;
                            expandedClass = v1 != null ? TypeUtilsKt.toRegularClassSymbol(v1, context.getSession()) : null;
                            v2 = expandedType;
                            v3 = expandedTypeScope = v2 != null ? ScopeUtilsKt.scope(v2, context.getSession(), context.getScopeSession(), CallableCopyTypeCalculator.DoNothing.INSTANCE, FirResolvePhase.STATUS) : null;
                            if (expandedType == null || expandedClass == null || expandedTypeScope == null) break block12;
                            session$iv = context.getSession();
                            $i$f$outerType = false;
                            fullyExpandedType$iv = TypeExpansionUtilsKt.fullyExpandedType$default(expandedType, session$iv, null, 2, null);
                            v4 = LookupTagUtilsKt.toSymbol(fullyExpandedType$iv.getLookupTag(), session$iv);
                            if (v4 != null) break block13;
                            v5 = null;
                            break block14;
                        }
                        symbol$iv = v4;
                        if (!(symbol$iv instanceof FirRegularClassSymbol)) ** GOTO lbl-1000
                        $this$isInner$iv$iv = (FirMemberDeclaration)((FirRegularClassSymbol)symbol$iv).getFir();
                        $i$f$isInner = false;
                        if (!$this$isInner$iv$iv.getStatus().isInner()) {
                            v5 = null;
                        } else lbl-1000:
                        // 2 sources

                        {
                            it = symbol$iv;
                            $i$a$-outerType-FirConflictsHelpersKt$expandedClassWithConstructorsScope$outerType$1 = false;
                            v6 = FirHelpersKt.outerClassSymbol(it, context);
                            if (v6 == null) {
                                v5 = null;
                            } else {
                                containingSymbol$iv = v6;
                                v7 = symbol$iv instanceof FirRegularClassSymbol != false ? (FirRegularClassSymbol)symbol$iv : null;
                                if (v7 != null && (v7 = (FirRegularClass)v7.getFir()) != null && (v7 = v7.getTypeParameters()) != null) {
                                    $this$count$iv$iv = (Iterable)v7;
                                    $i$f$count = false;
                                    if ($this$count$iv$iv instanceof Collection && ((Collection)$this$count$iv$iv).isEmpty()) {
                                        v8 = 0;
                                    } else {
                                        count$iv$iv = 0;
                                        for (T element$iv$iv : $this$count$iv$iv) {
                                            it$iv = (FirTypeParameterRef)element$iv$iv;
                                            $i$a$-count-DeclarationUtilsKt$outerType$currentTypeArgumentsNumber$1$iv = false;
                                            if (!(it$iv instanceof FirTypeParameter) || ++count$iv$iv >= 0) continue;
                                            CollectionsKt.throwCountOverflow();
                                        }
                                        v8 = count$iv$iv;
                                    }
                                } else {
                                    v8 = 0;
                                }
                                currentTypeArgumentsNumber$iv = v8;
                                $this$toTypedArray$iv$iv = ArraysKt.drop((Object[])fullyExpandedType$iv.getTypeArguments(), (int)currentTypeArgumentsNumber$iv);
                                $i$f$toTypedArray = false;
                                thisCollection$iv$iv = $this$toTypedArray$iv$iv;
                                v5 = TypeConstructionUtilsKt.constructType$default(containingSymbol$iv, thisCollection$iv$iv.toArray(new ConeTypeProjection[0]), false, null, 4, null);
                            }
                        }
                    }
                    outerType = v5;
                    v0 = TuplesKt.to((Object)expandedClass, (Object)new TypeAliasConstructorsSubstitutingScope((FirTypeAliasSymbol)$this$expandedClassWithConstructorsScope, expandedTypeScope, outerType));
                    break block10;
                }
                v0 = null;
                break block10;
            }
            v0 = null;
        }
        return v0;
    }

    private static final boolean shouldCheckForMultiplatformRedeclaration(FirBasedSymbol<?> dependency, FirBasedSymbol<?> dependent) {
        if (!dependent.getModuleData().getAllDependsOnDependencies().contains(dependency.getModuleData())) {
            return false;
        }
        return !FirConflictsHelpersKt.isExpectAndNonExpect(dependency, dependent);
    }

    private static final void collectTopLevelConflict(FirDeclarationCollector<FirBasedSymbol<?>> $this$collectTopLevelConflict, FirBasedSymbol<?> declaration, String declarationPresentation, FirFile containingFile, FirBasedSymbol<?> conflictingSymbol, String conflictingPresentation, FirFile conflictingFile) {
        Object object;
        FirFile actualConflictingFile;
        String actualConflictingPresentation;
        FirLazyDeclarationResolverKt.lazyResolveToPhase(conflictingSymbol, FirResolvePhase.STATUS);
        if (Intrinsics.areEqual(conflictingSymbol, declaration)) {
            return;
        }
        if (!Intrinsics.areEqual((Object)declaration.getModuleData(), (Object)conflictingSymbol.getModuleData()) && !FirConflictsHelpersKt.shouldCheckForMultiplatformRedeclaration(declaration, conflictingSymbol)) {
            return;
        }
        String string2 = conflictingPresentation;
        if (string2 == null) {
            string2 = FirRedeclarationPresenter.INSTANCE.represent(conflictingSymbol);
        }
        if (!Intrinsics.areEqual((Object)(actualConflictingPresentation = string2), (Object)declarationPresentation)) {
            return;
        }
        FirFile firFile = conflictingFile;
        if (firFile == null) {
            FirBasedSymbol<?> firBasedSymbol = conflictingSymbol;
            firFile = firBasedSymbol instanceof FirClassLikeSymbol ? FirProviderKt.getFirProvider($this$collectTopLevelConflict.getSession$checkers()).getFirClassifierContainerFileIfAny((FirClassLikeSymbol)conflictingSymbol) : (actualConflictingFile = firBasedSymbol instanceof FirCallableSymbol ? FirProviderKt.getFirProvider($this$collectTopLevelConflict.getSession$checkers()).getFirCallableContainerFile((FirCallableSymbol)conflictingSymbol) : null);
        }
        if (!FirConflictsHelpersKt.isCollectable(conflictingSymbol)) {
            return;
        }
        if (FirConflictsHelpersKt.areCompatibleMainFunctions(declaration, containingFile, conflictingSymbol, actualConflictingFile, $this$collectTopLevelConflict.getSession$checkers())) {
            return;
        }
        Object conflicting = conflictingSymbol.getFir();
        if (conflicting instanceof FirMemberDeclaration && !FirVisibilityChecker.isVisible$default(FirVisibilityCheckerKt.getVisibilityChecker($this$collectTopLevelConflict.getSession$checkers()), (FirMemberDeclaration)conflicting, $this$collectTopLevelConflict.getSession$checkers(), containingFile, CollectionsKt.emptyList(), null, false, null, false, null, 480, null)) {
            return;
        }
        if (FirConflictsHelpersKt.areNonConflictingCallables($this$collectTopLevelConflict, declaration, conflictingSymbol)) {
            return;
        }
        Map $this$getOrPut$iv = $this$collectTopLevelConflict.getDeclarationConflictingSymbols();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(declaration);
        if (value$iv == null) {
            boolean bl = false;
            SmartSet answer$iv = SmartSet.Companion.create();
            $this$getOrPut$iv.put(declaration, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((SmartSet)((Object)object)).add(conflictingSymbol);
    }

    private static final boolean representsMainFunctionAllowingConflictingOverloads(FirNamedFunctionSymbol $this$representsMainFunctionAllowingConflictingOverloads, FirSession session2) {
        if (!(Intrinsics.areEqual((Object)$this$representsMainFunctionAllowingConflictingOverloads.getName(), (Object)StandardNames.MAIN) && FirConflictsHelpersKt.isTopLevel($this$representsMainFunctionAllowingConflictingOverloads.getCallableId()) && FirConflictsHelpersKt.getHasMainFunctionStatus($this$representsMainFunctionAllowingConflictingOverloads))) {
            return false;
        }
        if ($this$representsMainFunctionAllowingConflictingOverloads.getReceiverParameter() != null || !((Collection)$this$representsMainFunctionAllowingConflictingOverloads.getTypeParameterSymbols()).isEmpty()) {
            return false;
        }
        if ($this$representsMainFunctionAllowingConflictingOverloads.getValueParameterSymbols().isEmpty()) {
            return true;
        }
        Object object = (FirValueParameterSymbol)CollectionsKt.singleOrNull($this$representsMainFunctionAllowingConflictingOverloads.getValueParameterSymbols());
        if (object == null || (object = ((FirCallableSymbol)object).getResolvedReturnTypeRef()) == null || (object = FirTypeUtilsKt.getConeType((FirTypeRef)object)) == null || (object = TypeExpansionUtilsKt.fullyExpandedType((ConeKotlinType)object, session2)) == null) {
            return false;
        }
        Object paramType = object;
        if (!ConeBuiltinTypeUtilsKt.isNonPrimitiveArray((ConeKotlinType)paramType)) {
            return false;
        }
        Object object2 = ArraysKt.singleOrNull((Object[])((ConeKotlinType)paramType).getTypeArguments());
        ConeKotlinTypeProjection coneKotlinTypeProjection = object2 instanceof ConeKotlinTypeProjection ? (ConeKotlinTypeProjection)object2 : null;
        if (coneKotlinTypeProjection == null) {
            return false;
        }
        ConeKotlinTypeProjection typeArgument = coneKotlinTypeProjection;
        if (!(typeArgument instanceof ConeKotlinType) && !(typeArgument instanceof ConeKotlinTypeProjectionOut)) {
            return false;
        }
        return ConeBuiltinTypeUtilsKt.isString(TypeExpansionUtilsKt.fullyExpandedType(typeArgument.getType(), session2));
    }

    private static final boolean areCompatibleMainFunctions(FirBasedSymbol<?> declaration1, FirFile file1, FirBasedSymbol<?> declaration2, FirFile file2, FirSession session2) {
        return !Intrinsics.areEqual((Object)file1, (Object)file2) && declaration1 instanceof FirNamedFunctionSymbol && declaration2 instanceof FirNamedFunctionSymbol && FirConflictsHelpersKt.representsMainFunctionAllowingConflictingOverloads((FirNamedFunctionSymbol)declaration1, session2) && FirConflictsHelpersKt.representsMainFunctionAllowingConflictingOverloads((FirNamedFunctionSymbol)declaration2, session2);
    }

    private static final boolean areNonConflictingCallables(FirDeclarationCollector<?> $this$areNonConflictingCallables, FirBasedSymbol<?> declaration, FirBasedSymbol<?> conflicting) {
        boolean conflictingIsLowPriority;
        if (FirConflictsHelpersKt.isExpectAndNonExpect(declaration, conflicting) && !Intrinsics.areEqual((Object)declaration.getModuleData(), (Object)conflicting.getModuleData())) {
            return true;
        }
        boolean declarationIsLowPriority = FirAnnotationUtilsKt.hasLowPriorityAnnotation(declaration.getAnnotations());
        if (declarationIsLowPriority != (conflictingIsLowPriority = FirAnnotationUtilsKt.hasLowPriorityAnnotation(conflicting.getAnnotations()))) {
            return true;
        }
        if (!(declaration instanceof FirCallableSymbol) || !(conflicting instanceof FirCallableSymbol)) {
            return false;
        }
        boolean declarationIsFinal = DeclarationUtilsKt.isEffectivelyFinal(declaration, $this$areNonConflictingCallables.getSession$checkers());
        boolean conflictingIsFinal = DeclarationUtilsKt.isEffectivelyFinal(conflicting, $this$areNonConflictingCallables.getSession$checkers());
        if (declarationIsFinal && conflictingIsFinal) {
            boolean declarationIsHidden = DeprecationUtilsKt.isDeprecationLevelHidden(declaration, FirLanguageSettingsComponentKt.getLanguageVersionSettings($this$areNonConflictingCallables.getSession$checkers()));
            if (declarationIsHidden) {
                return true;
            }
            boolean conflictingIsHidden = DeprecationUtilsKt.isDeprecationLevelHidden(conflicting, FirLanguageSettingsComponentKt.getLanguageVersionSettings($this$areNonConflictingCallables.getSession$checkers()));
            if (conflictingIsHidden) {
                return true;
            }
        }
        return FirDeclarationOverloadabilityHelperKt.getDeclarationOverloadabilityHelper($this$areNonConflictingCallables.getSession$checkers()).isOverloadable((FirCallableSymbol)declaration, (FirCallableSymbol)conflicting);
    }

    @Nullable
    public static final FirValueParameterSymbol getDestructuredParameter(@NotNull FirVariable $this$getDestructuredParameter) {
        Intrinsics.checkNotNullParameter((Object)$this$getDestructuredParameter, (String)"<this>");
        FirExpression initializer = $this$getDestructuredParameter.getInitializer();
        if (!(initializer instanceof FirComponentCall)) {
            return null;
        }
        KtSourceElement ktSourceElement = ((FirComponentCall)initializer).getSource();
        if (!((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind.DesugaredComponentFunctionCall)) {
            return null;
        }
        FirExpression firExpression = ((FirComponentCall)initializer).getDispatchReceiver();
        if (firExpression == null && (firExpression = ((FirComponentCall)initializer).getExtensionReceiver()) == null) {
            return null;
        }
        FirExpression receiver = firExpression;
        if (!(receiver instanceof FirPropertyAccessExpression)) {
            return null;
        }
        FirReference firReference = ((FirPropertyAccessExpression)receiver).getCalleeReference();
        FirResolvedNamedReference firResolvedNamedReference = firReference instanceof FirResolvedNamedReference ? (FirResolvedNamedReference)firReference : null;
        if (firResolvedNamedReference == null) {
            return null;
        }
        FirResolvedNamedReference calleeReference = firResolvedNamedReference;
        FirBasedSymbol<?> firBasedSymbol = calleeReference.getResolvedSymbol();
        return firBasedSymbol instanceof FirValueParameterSymbol ? (FirValueParameterSymbol)firBasedSymbol : null;
    }

    public static final void checkForLocalRedeclarations(@NotNull List<? extends FirElement> elements, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (elements.size() <= 1) {
            return;
        }
        ListMultimap<Name, FirBasedSymbol> multimap = new ListMultimap<Name, FirBasedSymbol>();
        for (FirElement firElement : elements) {
            Name name2 = null;
            FirBasedSymbol symbol = null;
            FirElement firElement2 = firElement;
            if (firElement2 instanceof FirVariable) {
                symbol = ((FirVariable)firElement).getSymbol();
                name2 = ((FirVariable)firElement).getName();
            } else {
                if (firElement2 instanceof FirOuterClassTypeParameterRef) continue;
                if (firElement2 instanceof FirTypeParameterRef) {
                    symbol = ((FirTypeParameterRef)firElement).getSymbol();
                    name2 = ((FirTypeParameterSymbol)symbol).getName();
                } else {
                    symbol = null;
                    name2 = null;
                }
            }
            Name name3 = name2;
            boolean bl = name3 != null ? !name3.isSpecial() : false;
            if (!bl) continue;
            FirBasedSymbol firBasedSymbol = symbol;
            Intrinsics.checkNotNull((Object)firBasedSymbol);
            multimap.put(name2, firBasedSymbol);
        }
        for (Name name4 : multimap.getKeys()) {
            List conflictingElements = (List)multimap.get(name4);
            if (conflictingElements.size() <= 1) continue;
            for (FirBasedSymbol conflictingElement : conflictingElements) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)conflictingElement.getSource(), FirErrors.INSTANCE.getREDECLARATION(), (Object)conflictingElements, (DiagnosticContext)context2, null, 16, null);
            }
        }
    }

    private static final Unit groupTopLevelByName$lambda$6$lambda$5(DeclarationBuckets $group, FirDeclaration $declaration, FirConstructorSymbol it) {
        Intrinsics.checkNotNullParameter((Object)$group, (String)"$group");
        Intrinsics.checkNotNullParameter((Object)$declaration, (String)"$declaration");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ((Collection)$group.getConstructors()).add(TuplesKt.to((Object)it, (Object)FirRedeclarationPresenter.INSTANCE.represent(it, ((FirClassLikeDeclaration)$declaration).getSymbol())));
        return Unit.INSTANCE;
    }

    private static final Unit collectClassMembers$lambda$8$lambda$7(FirNamedFunctionSymbol $declaredFunction, FirRegularClassSymbol $klass, FirDeclarationCollector $this_collectClassMembers, Map $functionDeclarations, FirNamedFunctionSymbol anotherFunction) {
        Intrinsics.checkNotNullParameter((Object)$declaredFunction, (String)"$declaredFunction");
        Intrinsics.checkNotNullParameter((Object)$klass, (String)"$klass");
        Intrinsics.checkNotNullParameter((Object)$this_collectClassMembers, (String)"$this_collectClassMembers");
        Intrinsics.checkNotNullParameter((Object)$functionDeclarations, (String)"$functionDeclarations");
        Intrinsics.checkNotNullParameter((Object)anotherFunction, (String)"anotherFunction");
        if (!Intrinsics.areEqual((Object)anotherFunction, (Object)$declaredFunction) && FirConflictsHelpersKt.isCollectable(anotherFunction) && FirHelpersKt.isVisibleInClass(anotherFunction, $klass)) {
            FirConflictsHelpersKt.collect($this_collectClassMembers, (FirBasedSymbol)anotherFunction, FirRedeclarationPresenter.INSTANCE.represent(anotherFunction), $functionDeclarations);
        }
        return Unit.INSTANCE;
    }

    private static final Unit collectClassMembers$lambda$8(FirDeclarationCollector $this_collectClassMembers, Map $functionDeclarations, FirTypeScope $unsubstitutedScope, FirRegularClassSymbol $klass, FirNamedFunctionSymbol declaredFunction) {
        Intrinsics.checkNotNullParameter((Object)$this_collectClassMembers, (String)"$this_collectClassMembers");
        Intrinsics.checkNotNullParameter((Object)$functionDeclarations, (String)"$functionDeclarations");
        Intrinsics.checkNotNullParameter((Object)$unsubstitutedScope, (String)"$unsubstitutedScope");
        Intrinsics.checkNotNullParameter((Object)$klass, (String)"$klass");
        Intrinsics.checkNotNullParameter((Object)declaredFunction, (String)"declaredFunction");
        if (!FirConflictsHelpersKt.isCollectable(declaredFunction)) {
            return Unit.INSTANCE;
        }
        FirConflictsHelpersKt.collect($this_collectClassMembers, (FirBasedSymbol)declaredFunction, FirRedeclarationPresenter.INSTANCE.represent(declaredFunction), $functionDeclarations);
        $unsubstitutedScope.processFunctionsByName(declaredFunction.getName(), (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)arg_0 -> FirConflictsHelpersKt.collectClassMembers$lambda$8$lambda$7(declaredFunction, $klass, $this_collectClassMembers, $functionDeclarations, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit collectClassMembers$lambda$9(FirRegularClassSymbol $klass, FirDeclarationCollector $this_collectClassMembers, Map $functionDeclarations, FirConstructorSymbol it) {
        Intrinsics.checkNotNullParameter((Object)$klass, (String)"$klass");
        Intrinsics.checkNotNullParameter((Object)$this_collectClassMembers, (String)"$this_collectClassMembers");
        Intrinsics.checkNotNullParameter((Object)$functionDeclarations, (String)"$functionDeclarations");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (FirConflictsHelpersKt.isCollectable(it) && FirHelpersKt.isVisibleInClass(it, $klass)) {
            FirConflictsHelpersKt.collect($this_collectClassMembers, (FirBasedSymbol)it, FirRedeclarationPresenter.INSTANCE.represent(it, $klass), $functionDeclarations);
        }
        return Unit.INSTANCE;
    }

    private static final Unit collectClassMembers$lambda$11$lambda$10(FirVariableSymbol $declaredProperty, FirRegularClassSymbol $klass, FirDeclarationCollector $this_collectClassMembers, Map $otherDeclarations, FirVariableSymbol anotherProperty) {
        Intrinsics.checkNotNullParameter((Object)$declaredProperty, (String)"$declaredProperty");
        Intrinsics.checkNotNullParameter((Object)$klass, (String)"$klass");
        Intrinsics.checkNotNullParameter((Object)$this_collectClassMembers, (String)"$this_collectClassMembers");
        Intrinsics.checkNotNullParameter((Object)$otherDeclarations, (String)"$otherDeclarations");
        Intrinsics.checkNotNullParameter((Object)anotherProperty, (String)"anotherProperty");
        if (!Intrinsics.areEqual((Object)anotherProperty, (Object)$declaredProperty) && FirConflictsHelpersKt.isCollectable(anotherProperty) && FirHelpersKt.isVisibleInClass(anotherProperty, $klass)) {
            FirConflictsHelpersKt.collect($this_collectClassMembers, (FirBasedSymbol)anotherProperty, FirRedeclarationPresenter.INSTANCE.represent(anotherProperty), $otherDeclarations);
        }
        return Unit.INSTANCE;
    }

    private static final Unit collectClassMembers$lambda$11(FirDeclarationCollector $this_collectClassMembers, Map $otherDeclarations, FirTypeScope $unsubstitutedScope, FirRegularClassSymbol $klass, FirVariableSymbol declaredProperty) {
        Intrinsics.checkNotNullParameter((Object)$this_collectClassMembers, (String)"$this_collectClassMembers");
        Intrinsics.checkNotNullParameter((Object)$otherDeclarations, (String)"$otherDeclarations");
        Intrinsics.checkNotNullParameter((Object)$unsubstitutedScope, (String)"$unsubstitutedScope");
        Intrinsics.checkNotNullParameter((Object)$klass, (String)"$klass");
        Intrinsics.checkNotNullParameter((Object)declaredProperty, (String)"declaredProperty");
        if (!FirConflictsHelpersKt.isCollectable(declaredProperty)) {
            return Unit.INSTANCE;
        }
        FirConflictsHelpersKt.collect($this_collectClassMembers, (FirBasedSymbol)declaredProperty, FirRedeclarationPresenter.INSTANCE.represent(declaredProperty), $otherDeclarations);
        $unsubstitutedScope.processPropertiesByName(declaredProperty.getName(), arg_0 -> FirConflictsHelpersKt.collectClassMembers$lambda$11$lambda$10(declaredProperty, $klass, $this_collectClassMembers, $otherDeclarations, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit collectClassMembers$processClassifier$lambda$13$lambda$12(FirDeclarationCollector $this_collectClassMembers, FirClassifierSymbol $it, Map $functionDeclarations, FirConstructorSymbol constructor2) {
        Intrinsics.checkNotNullParameter((Object)$this_collectClassMembers, (String)"$this_collectClassMembers");
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        Intrinsics.checkNotNullParameter((Object)$functionDeclarations, (String)"$functionDeclarations");
        Intrinsics.checkNotNullParameter((Object)constructor2, (String)"constructor");
        FirConflictsHelpersKt.collect($this_collectClassMembers, (FirBasedSymbol)constructor2, FirRedeclarationPresenter.INSTANCE.represent(constructor2, (FirClassLikeSymbol)$it), $functionDeclarations);
        return Unit.INSTANCE;
    }

    private static final void collectClassMembers$processClassifier(FirRegularClassSymbol $klass, FirDeclarationCollector<FirBasedSymbol<?>> $this_collectClassMembers, Map<String, List<FirBasedSymbol<?>>> otherDeclarations, Map<String, List<FirFunctionSymbol<?>>> functionDeclarations, FirClassifierSymbol<?> it) {
        block6: {
            if (!FirConflictsHelpersKt.isCollectable((FirBasedSymbol)it) || !FirHelpersKt.isVisibleInClass((FirBasedSymbol)it, $klass)) {
                return;
            }
            if (it instanceof FirRegularClassSymbol) {
                FirConflictsHelpersKt.collect($this_collectClassMembers, (FirBasedSymbol)it, FirRedeclarationPresenter.INSTANCE.represent((FirRegularClassSymbol)it), otherDeclarations);
            } else if (it instanceof FirTypeAliasSymbol) {
                FirConflictsHelpersKt.collect($this_collectClassMembers, (FirBasedSymbol)it, FirRedeclarationPresenter.INSTANCE.represent((FirTypeAliasSymbol)it), otherDeclarations);
            }
            if (!(it instanceof FirClassLikeSymbol)) {
                return;
            }
            Pair<FirRegularClassSymbol, FirScope> pair = FirConflictsHelpersKt.expandedClassWithConstructorsScope((FirClassLikeSymbol)it, $this_collectClassMembers.getContext$checkers());
            if (pair == null) break block6;
            Pair<FirRegularClassSymbol, FirScope> pair2 = pair;
            boolean bl = false;
            FirRegularClassSymbol expandedClass = (FirRegularClassSymbol)pair2.component1();
            FirScope scopeWithConstructors = (FirScope)pair2.component2();
            if (expandedClass.getClassKind() != ClassKind.OBJECT) {
                scopeWithConstructors.processDeclaredConstructors((Function1<? super FirConstructorSymbol, Unit>)((Function1)arg_0 -> FirConflictsHelpersKt.collectClassMembers$processClassifier$lambda$13$lambda$12($this_collectClassMembers, it, functionDeclarations, arg_0)));
            }
        }
    }

    private static final Unit collectClassMembers$lambda$14(FirBasedSymbol $declaredClassifier, FirRegularClassSymbol $klass, FirDeclarationCollector $this_collectClassMembers, Map $otherDeclarations, Map $functionDeclarations, FirClassifierSymbol anotherClassifier) {
        Intrinsics.checkNotNullParameter((Object)$declaredClassifier, (String)"$declaredClassifier");
        Intrinsics.checkNotNullParameter((Object)$klass, (String)"$klass");
        Intrinsics.checkNotNullParameter((Object)$this_collectClassMembers, (String)"$this_collectClassMembers");
        Intrinsics.checkNotNullParameter((Object)$otherDeclarations, (String)"$otherDeclarations");
        Intrinsics.checkNotNullParameter((Object)$functionDeclarations, (String)"$functionDeclarations");
        Intrinsics.checkNotNullParameter((Object)anotherClassifier, (String)"anotherClassifier");
        if (!Intrinsics.areEqual((Object)anotherClassifier, (Object)$declaredClassifier)) {
            FirConflictsHelpersKt.collectClassMembers$processClassifier($klass, $this_collectClassMembers, $otherDeclarations, $functionDeclarations, anotherClassifier);
        }
        return Unit.INSTANCE;
    }

    private static final Unit collectConflictingLocalFunctionsFrom$lambda$17$lambda$16(FirDeclarationCollector $inspector, FirStatement $collectable, Map $functionDeclarations, FirConstructorSymbol it) {
        Intrinsics.checkNotNullParameter((Object)$inspector, (String)"$inspector");
        Intrinsics.checkNotNullParameter((Object)$collectable, (String)"$collectable");
        Intrinsics.checkNotNullParameter((Object)$functionDeclarations, (String)"$functionDeclarations");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        FirConflictsHelpersKt.collect($inspector, (FirBasedSymbol)it, FirRedeclarationPresenter.INSTANCE.represent(it, ((FirClassLikeDeclaration)$collectable).getSymbol()), $functionDeclarations);
        return Unit.INSTANCE;
    }

    private static final void collectTopLevel$collect(FirDeclarationCollector<FirBasedSymbol<?>> $this_collectTopLevel, FirFile $file, Name declarationName, List<? extends Pair<? extends FirBasedSymbol<?>, String>> declarations2, FirBasedSymbol<?> conflictingSymbol, String conflictingPresentation, FirFile conflictingFile) {
        for (Pair<FirBasedSymbol<?>, String> pair : declarations2) {
            FirBasedSymbol declaration = (FirBasedSymbol)pair.component1();
            String declarationPresentation = (String)pair.component2();
            FirConflictsHelpersKt.collectTopLevelConflict($this_collectTopLevel, declaration, declarationPresentation, $file, conflictingSymbol, conflictingPresentation, conflictingFile);
            FirLookupTrackerComponent firLookupTrackerComponent = FirLookupTrackerComponentKt.getLookupTracker($this_collectTopLevel.getSession$checkers());
            if (firLookupTrackerComponent == null) continue;
            String string2 = UtilsKt.getPackageFqName($file).asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
            FirLookupTrackerComponentKt.recordNameLookup(firLookupTrackerComponent, declarationName, string2, declaration.getSource(), $file.getSource());
        }
    }

    static /* synthetic */ void collectTopLevel$collect$default(FirDeclarationCollector firDeclarationCollector, FirFile firFile, Name name2, List list, FirBasedSymbol firBasedSymbol, String string2, FirFile firFile2, int n, Object object) {
        if ((n & 0x20) != 0) {
            string2 = null;
        }
        if ((n & 0x40) != 0) {
            firFile2 = null;
        }
        FirConflictsHelpersKt.collectTopLevel$collect(firDeclarationCollector, firFile, name2, list, firBasedSymbol, string2, firFile2);
    }

    private static final Unit collectTopLevel$collectFromClassifierSource$lambda$22$lambda$21(FirClassifierSymbol $conflictingSymbol, DeclarationBuckets $group, FirDeclarationCollector $this_collectTopLevel, FirFile $file, Name $declarationName, FirConstructorSymbol constructor2) {
        Intrinsics.checkNotNullParameter((Object)$conflictingSymbol, (String)"$conflictingSymbol");
        Intrinsics.checkNotNullParameter((Object)$group, (String)"$group");
        Intrinsics.checkNotNullParameter((Object)$this_collectTopLevel, (String)"$this_collectTopLevel");
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        Intrinsics.checkNotNullParameter((Object)$declarationName, (String)"$declarationName");
        Intrinsics.checkNotNullParameter((Object)constructor2, (String)"constructor");
        String ctorRepresentation = FirRedeclarationPresenter.INSTANCE.represent(constructor2, (FirClassLikeSymbol)$conflictingSymbol);
        FirConflictsHelpersKt.collectTopLevel$collect$default($this_collectTopLevel, $file, $declarationName, $group.getSimpleFunctions(), constructor2, ctorRepresentation, null, 64, null);
        return Unit.INSTANCE;
    }

    private static final void collectTopLevel$collectFromClassifierSource(DeclarationBuckets group, boolean groupHasSimpleFunctions, FirDeclarationCollector<FirBasedSymbol<?>> $this_collectTopLevel, FirFile $file, Name declarationName, FirClassifierSymbol<?> conflictingSymbol, String conflictingPresentation, FirFile conflictingFile) {
        block3: {
            FirConflictsHelpersKt.collectTopLevel$collect($this_collectTopLevel, $file, declarationName, group.getClassLikes(), (FirBasedSymbol)conflictingSymbol, conflictingPresentation, conflictingFile);
            FirConflictsHelpersKt.collectTopLevel$collect($this_collectTopLevel, $file, declarationName, group.getProperties(), (FirBasedSymbol)conflictingSymbol, conflictingPresentation, conflictingFile);
            if (!groupHasSimpleFunctions) break block3;
            if (!(conflictingSymbol instanceof FirClassLikeSymbol)) {
                return;
            }
            Pair<FirRegularClassSymbol, FirScope> pair = FirConflictsHelpersKt.expandedClassWithConstructorsScope((FirClassLikeSymbol)conflictingSymbol, $this_collectTopLevel.getContext$checkers());
            if (pair != null) {
                Pair<FirRegularClassSymbol, FirScope> pair2 = pair;
                boolean bl = false;
                FirRegularClassSymbol expandedClass = (FirRegularClassSymbol)pair2.component1();
                FirScope scopeWithConstructors = (FirScope)pair2.component2();
                if (expandedClass.getClassKind() == ClassKind.OBJECT || expandedClass.getClassKind() == ClassKind.ENUM_ENTRY) {
                    return;
                }
                scopeWithConstructors.processDeclaredConstructors((Function1<? super FirConstructorSymbol, Unit>)((Function1)arg_0 -> FirConflictsHelpersKt.collectTopLevel$collectFromClassifierSource$lambda$22$lambda$21(conflictingSymbol, group, $this_collectTopLevel, $file, declarationName, arg_0)));
            }
        }
    }

    static /* synthetic */ void collectTopLevel$collectFromClassifierSource$default(DeclarationBuckets declarationBuckets, boolean bl, FirDeclarationCollector firDeclarationCollector, FirFile firFile, Name name2, FirClassifierSymbol firClassifierSymbol, String string2, FirFile firFile2, int n, Object object) {
        if ((n & 0x40) != 0) {
            string2 = null;
        }
        if ((n & 0x80) != 0) {
            firFile2 = null;
        }
        FirConflictsHelpersKt.collectTopLevel$collectFromClassifierSource(declarationBuckets, bl, firDeclarationCollector, firFile, name2, firClassifierSymbol, string2, firFile2);
    }

    private static final Unit collectTopLevel$lambda$23(DeclarationBuckets $group, FirDeclarationCollector $this_collectTopLevel, FirFile $file, Name $declarationName, FirNamedFunctionSymbol it) {
        Intrinsics.checkNotNullParameter((Object)$group, (String)"$group");
        Intrinsics.checkNotNullParameter((Object)$this_collectTopLevel, (String)"$this_collectTopLevel");
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        Intrinsics.checkNotNullParameter((Object)$declarationName, (String)"$declarationName");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        FirConflictsHelpersKt.collectTopLevel$collect$default($this_collectTopLevel, $file, $declarationName, $group.getSimpleFunctions(), it, null, null, 96, null);
        FirConflictsHelpersKt.collectTopLevel$collect$default($this_collectTopLevel, $file, $declarationName, $group.getConstructors(), it, null, null, 96, null);
        return Unit.INSTANCE;
    }

    private static final Unit collectTopLevel$lambda$24(DeclarationBuckets $group, boolean $groupHasSimpleFunctions, FirDeclarationCollector $this_collectTopLevel, FirFile $file, Name $declarationName, FirClassifierSymbol symbol, ConeSubstitutor coneSubstitutor) {
        Intrinsics.checkNotNullParameter((Object)$group, (String)"$group");
        Intrinsics.checkNotNullParameter((Object)$this_collectTopLevel, (String)"$this_collectTopLevel");
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        Intrinsics.checkNotNullParameter((Object)$declarationName, (String)"$declarationName");
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)coneSubstitutor, (String)"<unused var>");
        FirConflictsHelpersKt.collectTopLevel$collectFromClassifierSource$default($group, $groupHasSimpleFunctions, $this_collectTopLevel, $file, $declarationName, symbol, null, null, 192, null);
        return Unit.INSTANCE;
    }

    private static final Unit collectTopLevel$lambda$27(DeclarationBuckets $group, FirDeclarationCollector $this_collectTopLevel, FirFile $file, Name $declarationName, FirVariableSymbol it) {
        Intrinsics.checkNotNullParameter((Object)$group, (String)"$group");
        Intrinsics.checkNotNullParameter((Object)$this_collectTopLevel, (String)"$this_collectTopLevel");
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        Intrinsics.checkNotNullParameter((Object)$declarationName, (String)"$declarationName");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        FirConflictsHelpersKt.collectTopLevel$collect$default($this_collectTopLevel, $file, $declarationName, $group.getClassLikes(), it, null, null, 96, null);
        FirConflictsHelpersKt.collectTopLevel$collect$default($this_collectTopLevel, $file, $declarationName, $group.getProperties(), it, null, null, 96, null);
        FirConflictsHelpersKt.collectTopLevel$collect$default($this_collectTopLevel, $file, $declarationName, $group.getExtensionProperties(), it, null, null, 96, null);
        return Unit.INSTANCE;
    }
}

