/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.cfa.util;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.cfa.util.DeclaredVariableCollector;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.expressions.FirDoWhileLoop;
import org.jetbrains.kotlin.fir.expressions.FirLoop;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirWhileLoop;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.util.MultimapKt;
import org.jetbrains.kotlin.fir.util.SetMultimap;
import org.jetbrains.kotlin.fir.visitors.FirVisitor;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\b\u0003*\u0001\u0010\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b2\u0006\u0010\f\u001a\u00020\u0006J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0006R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/cfa/util/DeclaredVariableCollector;", "", "<init>", "()V", "declaredVariablesPerElement", "Lorg/jetbrains/kotlin/fir/util/SetMultimap;", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "getDeclaredVariablesPerElement", "()Lorg/jetbrains/kotlin/fir/util/SetMultimap;", "enterCapturingStatement", "", "statement", "exitCapturingStatement", "", "visitor", "org/jetbrains/kotlin/fir/analysis/cfa/util/DeclaredVariableCollector$visitor$1", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/DeclaredVariableCollector$visitor$1;", "checkers"})
public final class DeclaredVariableCollector {
    @NotNull
    private final SetMultimap<FirStatement, FirPropertySymbol> declaredVariablesPerElement = MultimapKt.setMultimapOf();
    @NotNull
    private final visitor.1 visitor = new FirVisitor<Unit, FirStatement>(this){
        final /* synthetic */ DeclaredVariableCollector this$0;
        {
            this.this$0 = $receiver;
        }

        public void visitElement(FirElement element, FirStatement data) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            element.acceptChildren(this, data);
        }

        public void visitProperty(FirProperty property, FirStatement data) {
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            if (property.isLocal()) {
                if (data == null) {
                    String string2 = "Required value was null.";
                    throw new IllegalArgumentException(string2.toString());
                }
                this.this$0.getDeclaredVariablesPerElement().put(data, property.getSymbol());
            }
            this.visitElement((FirElement)property, data);
        }

        public void visitWhileLoop(FirWhileLoop whileLoop, FirStatement data) {
            Intrinsics.checkNotNullParameter((Object)whileLoop, (String)"whileLoop");
            this.visitCapturingStatement(whileLoop, data);
        }

        public void visitDoWhileLoop(FirDoWhileLoop doWhileLoop, FirStatement data) {
            Intrinsics.checkNotNullParameter((Object)doWhileLoop, (String)"doWhileLoop");
            this.visitCapturingStatement(doWhileLoop, data);
        }

        public void visitAnonymousFunction(FirAnonymousFunction anonymousFunction, FirStatement data) {
            Intrinsics.checkNotNullParameter((Object)anonymousFunction, (String)"anonymousFunction");
            this.visitCapturingStatement(anonymousFunction, data);
        }

        public void visitSimpleFunction(FirSimpleFunction simpleFunction, FirStatement data) {
            Intrinsics.checkNotNullParameter((Object)simpleFunction, (String)"simpleFunction");
            this.visitCapturingStatement(simpleFunction, data);
        }

        public void visitRegularClass(FirRegularClass regularClass, FirStatement data) {
            Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
            this.visitCapturingStatement(regularClass, data);
        }

        public void visitAnonymousObject(FirAnonymousObject anonymousObject, FirStatement data) {
            Intrinsics.checkNotNullParameter((Object)anonymousObject, (String)"anonymousObject");
            this.visitCapturingStatement(anonymousObject, data);
        }

        private final void visitCapturingStatement(FirStatement statement, FirStatement parent2) {
            this.visitElement((FirElement)statement, statement);
            if (parent2 != null) {
                this.this$0.getDeclaredVariablesPerElement().putAll(parent2, (Collection<FirPropertySymbol>)this.this$0.getDeclaredVariablesPerElement().get(statement));
            }
        }
    };

    @NotNull
    public final SetMultimap<FirStatement, FirPropertySymbol> getDeclaredVariablesPerElement() {
        return this.declaredVariablesPerElement;
    }

    @NotNull
    public final Set<FirPropertySymbol> enterCapturingStatement(@NotNull FirStatement statement) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        boolean bl2 = bl = statement instanceof FirLoop || statement instanceof FirClass || statement instanceof FirFunction;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        if (!this.declaredVariablesPerElement.contains(statement)) {
            statement.accept(this.visitor, null);
        }
        return (Set)this.declaredVariablesPerElement.get(statement);
    }

    public final void exitCapturingStatement(@NotNull FirStatement statement) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        boolean bl2 = bl = statement instanceof FirLoop || statement instanceof FirClass || statement instanceof FirFunction;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.declaredVariablesPerElement.removeKey(statement);
    }
}

