/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.runtime.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.impl.EmptyPackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.runtime.components.ReflectKotlinClass;
import org.jetbrains.kotlin.descriptors.runtime.components.ReflectKotlinClassFinder;
import org.jetbrains.kotlin.load.kotlin.DeserializedDescriptorResolver;
import org.jetbrains.kotlin.load.kotlin.KotlinClassFinder;
import org.jetbrains.kotlin.load.kotlin.KotlinClassFinderKt;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.scopes.ChainedMemberScope;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.utils.DeserializationHelpersKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/descriptors/runtime/components/PackagePartScopeCache;", "", "resolver", "Lorg/jetbrains/kotlin/load/kotlin/DeserializedDescriptorResolver;", "kotlinClassFinder", "Lorg/jetbrains/kotlin/descriptors/runtime/components/ReflectKotlinClassFinder;", "<init>", "(Lorg/jetbrains/kotlin/load/kotlin/DeserializedDescriptorResolver;Lorg/jetbrains/kotlin/descriptors/runtime/components/ReflectKotlinClassFinder;)V", "cache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "getPackagePartScope", "fileClass", "Lorg/jetbrains/kotlin/descriptors/runtime/components/ReflectKotlinClass;", "descriptors.runtime"})
@SourceDebugExtension(value={"SMAP\nPackagePartScopeCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackagePartScopeCache.kt\norg/jetbrains/kotlin/descriptors/runtime/components/PackagePartScopeCache\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,42:1\n72#2,2:43\n1611#3,9:45\n1863#3:54\n1864#3:56\n1620#3:57\n1611#3,9:58\n1863#3:67\n1864#3:69\n1620#3:70\n1#4:55\n1#4:68\n1#4:71\n*S KotlinDebug\n*F\n+ 1 PackagePartScopeCache.kt\norg/jetbrains/kotlin/descriptors/runtime/components/PackagePartScopeCache\n*L\n22#1:43,2\n27#1:45,9\n27#1:54\n27#1:56\n27#1:57\n35#1:58,9\n35#1:67\n35#1:69\n35#1:70\n27#1:55\n35#1:68\n22#1:71\n*E\n"})
public final class PackagePartScopeCache {
    @NotNull
    private final DeserializedDescriptorResolver resolver;
    @NotNull
    private final ReflectKotlinClassFinder kotlinClassFinder;
    @NotNull
    private final ConcurrentHashMap<ClassId, MemberScope> cache;

    public PackagePartScopeCache(@NotNull DeserializedDescriptorResolver resolver, @NotNull ReflectKotlinClassFinder kotlinClassFinder) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Intrinsics.checkNotNullParameter((Object)kotlinClassFinder, (String)"kotlinClassFinder");
        this.resolver = resolver;
        this.kotlinClassFinder = kotlinClassFinder;
        this.cache = new ConcurrentHashMap();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final MemberScope getPackagePartScope(@NotNull ReflectKotlinClass fileClass) {
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)fileClass, (String)"fileClass");
        ConcurrentMap concurrentMap = this.cache;
        ClassId key$iv = fileClass.getClassId();
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            void $this$mapNotNullTo$iv$iv;
            List list;
            boolean bl = false;
            FqName fqName = fileClass.getClassId().getPackageFqName();
            if (fileClass.getClassHeader().getKind() == KotlinClassHeader.Kind.MULTIFILE_CLASS) {
                void $this$mapNotNullTo$iv$iv2;
                Iterable $this$mapNotNull$iv = fileClass.getClassHeader().getMultifilePartNames();
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    KotlinJvmBinaryClass it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl2 = false;
                    String partName = (String)element$iv$iv;
                    boolean bl3 = false;
                    FqName fqName2 = JvmClassName.byInternalName(partName).getFqNameForTopLevelClassMaybeWithDollars();
                    Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"getFqNameForTopLevelClassMaybeWithDollars(...)");
                    ClassId classId = ClassId.Companion.topLevel(fqName2);
                    if (KotlinClassFinderKt.findKotlinClass((KotlinClassFinder)this.kotlinClassFinder, classId, DeserializationHelpersKt.jvmMetadataVersionOrDefault(this.resolver.getComponents().getConfiguration())) == null) continue;
                    boolean bl4 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                list = (List)destination$iv$iv;
            } else {
                list = CollectionsKt.listOf((Object)fileClass);
            }
            List parts = list;
            EmptyPackageFragmentDescriptor packageFragment = new EmptyPackageFragmentDescriptor(this.resolver.getComponents().getModuleDescriptor(), fqName);
            Iterable $this$mapNotNull$iv = parts;
            boolean $i$f$mapNotNull = false;
            Iterable $i$f$mapNotNullTo = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo2 = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
            while (iterator3.hasNext()) {
                MemberScope it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator3.next();
                boolean bl5 = false;
                KotlinJvmBinaryClass part = (KotlinJvmBinaryClass)element$iv$iv;
                boolean bl6 = false;
                if (this.resolver.createKotlinPackagePartScope(packageFragment, part) == null) continue;
                boolean bl7 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List scopes = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
            MemberScope default$iv = ChainedMemberScope.Companion.create("package " + fqName + " (" + fileClass + ')', scopes);
            boolean bl8 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Intrinsics.checkNotNullExpressionValue(object, (String)"getOrPut(...)");
        return (MemberScope)object;
    }
}

