/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.container;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.container.CacheKt;
import org.jetbrains.kotlin.container.ConstructorBinding;
import org.jetbrains.kotlin.container.ConstructorInfo;
import org.jetbrains.kotlin.container.MethodBinding;
import org.jetbrains.kotlin.container.UnresolvedDependenciesException;
import org.jetbrains.kotlin.container.ValueDescriptor;
import org.jetbrains.kotlin.container.ValueResolveContext;

@Metadata(mv={2, 0, 0}, k=2, xi=50, d1={"\u0000>\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u0001\u001a\u001e\u0010\u0005\u001a\u00020\u0006*\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u001a\u0010\f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a0\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0001*\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00012\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0013"}, d2={"computeArguments", "", "", "argumentDescriptors", "Lorg/jetbrains/kotlin/container/ValueDescriptor;", "bindToConstructor", "Lorg/jetbrains/kotlin/container/ConstructorBinding;", "Ljava/lang/Class;", "containerId", "", "context", "Lorg/jetbrains/kotlin/container/ValueResolveContext;", "bindToMethod", "Lorg/jetbrains/kotlin/container/MethodBinding;", "Ljava/lang/reflect/Method;", "bindArguments", "Ljava/lang/reflect/Member;", "parameters", "Ljava/lang/reflect/Type;", "container"})
@SourceDebugExtension(value={"SMAP\nResolve.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Resolve.kt\norg/jetbrains/kotlin/container/ResolveKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,90:1\n1557#2:91\n1628#2,3:92\n*S KotlinDebug\n*F\n+ 1 Resolve.kt\norg/jetbrains/kotlin/container/ResolveKt\n*L\n53#1:91\n53#1:92,3\n*E\n"})
public final class ResolveKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Object> computeArguments(@NotNull List<? extends ValueDescriptor> argumentDescriptors) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(argumentDescriptors, (String)"argumentDescriptors");
        Iterable $this$map$iv = argumentDescriptors;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ValueDescriptor valueDescriptor = (ValueDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getValue());
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final ConstructorBinding bindToConstructor(@NotNull Class<?> $this$bindToConstructor, @NotNull String containerId, @NotNull ValueResolveContext context2) {
        Intrinsics.checkNotNullParameter($this$bindToConstructor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)containerId, (String)"containerId");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        ConstructorInfo constructorInfo = CacheKt.getInfo($this$bindToConstructor).getConstructorInfo();
        if (constructorInfo == null) {
            throw new IllegalStateException(("No constructor for " + $this$bindToConstructor + ": " + CacheKt.getInfo($this$bindToConstructor) + " in " + containerId).toString());
        }
        ConstructorInfo constructorInfo2 = constructorInfo;
        Constructor<?> candidate2 = constructorInfo2.getConstructor();
        return new ConstructorBinding(candidate2, ResolveKt.bindArguments(candidate2, containerId, constructorInfo2.getParameters(), context2));
    }

    @NotNull
    public static final MethodBinding bindToMethod(@NotNull Method $this$bindToMethod, @NotNull String containerId, @NotNull ValueResolveContext context2) {
        Intrinsics.checkNotNullParameter((Object)$this$bindToMethod, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)containerId, (String)"containerId");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Member member = $this$bindToMethod;
        Type[] typeArray = $this$bindToMethod.getGenericParameterTypes();
        Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"getGenericParameterTypes(...)");
        return new MethodBinding($this$bindToMethod, ResolveKt.bindArguments(member, containerId, ArraysKt.toList((Object[])typeArray), context2));
    }

    private static final List<ValueDescriptor> bindArguments(Member $this$bindArguments, String containerId, List<? extends Type> parameters, ValueResolveContext context2) {
        ArrayList<ValueDescriptor> bound = new ArrayList<ValueDescriptor>(parameters.size());
        List unsatisfied = null;
        for (Type type2 : parameters) {
            boolean bl;
            ValueDescriptor descriptor = context2.resolve(type2);
            if (descriptor == null) {
                if (unsatisfied == null) {
                    unsatisfied = new ArrayList();
                }
                bl = unsatisfied.add(type2);
                continue;
            }
            bl = bound.add(descriptor);
        }
        if (unsatisfied != null) {
            throw new UnresolvedDependenciesException(containerId + ": Dependencies for `" + $this$bindArguments + "` cannot be satisfied:\n  " + unsatisfied);
        }
        return bound;
    }
}

