/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.navigation.ItemPresentation;
import org.jetbrains.kotlin.com.intellij.navigation.ItemPresentationProviders;
import org.jetbrains.kotlin.com.intellij.openapi.application.ReadAction;
import org.jetbrains.kotlin.com.intellij.openapi.ui.Queryable;
import org.jetbrains.kotlin.com.intellij.psi.HierarchicalMethodSignature;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiCodeBlock;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiIdentifier;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierList;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameterList;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecordComponent;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceList;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiSyntheticClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameterList;
import org.jetbrains.kotlin.com.intellij.psi.ResolveState;
import org.jetbrains.kotlin.com.intellij.psi.impl.ElementPresentationUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiClassImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiSuperMethodImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiMemberStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiMethodStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightCompactConstructorParameter;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightParameterListBuilder;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.JavaStubPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaSharedImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.javadoc.PsiDocComment;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.kotlin.com.intellij.psi.search.SearchScope;
import org.jetbrains.kotlin.com.intellij.psi.stub.JavaStubImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.kotlin.com.intellij.psi.util.MethodSignature;
import org.jetbrains.kotlin.com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiModificationTracker;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.reference.SoftReference;
import org.jetbrains.kotlin.com.intellij.ui.IconManager;
import org.jetbrains.kotlin.com.intellij.ui.icons.RowIcon;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.PlatformIcons;

public class PsiMethodImpl
extends JavaStubPsiElement<PsiMethodStub>
implements Queryable,
PsiMethod {
    private SoftReference<PsiType> myCachedType;

    public PsiMethodImpl(PsiMethodStub stub) {
        this(stub, (IStubElementType)JavaStubElementTypes.METHOD);
    }

    protected PsiMethodImpl(PsiMethodStub stub, IStubElementType type2) {
        super(stub, type2);
    }

    public PsiMethodImpl(ASTNode node) {
        super(node);
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        this.dropCached();
    }

    protected void dropCached() {
        this.myCachedType = null;
    }

    @Override
    protected Object clone() {
        PsiMethodImpl clone = (PsiMethodImpl)super.clone();
        clone.dropCached();
        return clone;
    }

    @Override
    public PsiClass getContainingClass() {
        PsiElement parent2 = this.getParent();
        return parent2 instanceof PsiClass ? (PsiClass)parent2 : (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)this, PsiSyntheticClass.class);
    }

    @Override
    public PsiElement getContext() {
        PsiClass cc = this.getContainingClass();
        return cc != null ? cc : super.getContext();
    }

    @Override
    public PsiIdentifier getNameIdentifier() {
        return (PsiIdentifier)this.getNode().findChildByRoleAsPsiElement(9);
    }

    @Override
    public PsiMethod @NotNull [] findSuperMethods() {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethods(this);
        if (psiMethodArray == null) {
            PsiMethodImpl.$$$reportNull$$$0(0);
        }
        return psiMethodArray;
    }

    @Override
    public PsiMethod @NotNull [] findSuperMethods(boolean checkAccess) {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethods((PsiMethod)this, checkAccess);
        if (psiMethodArray == null) {
            PsiMethodImpl.$$$reportNull$$$0(1);
        }
        return psiMethodArray;
    }

    @Override
    public PsiMethod @NotNull [] findSuperMethods(PsiClass parentClass) {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethods((PsiMethod)this, parentClass);
        if (psiMethodArray == null) {
            PsiMethodImpl.$$$reportNull$$$0(2);
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public List<MethodSignatureBackedByPsiMethod> findSuperMethodSignaturesIncludingStatic(boolean checkAccess) {
        List<MethodSignatureBackedByPsiMethod> list = PsiSuperMethodImplUtil.findSuperMethodSignaturesIncludingStatic(this, checkAccess);
        if (list == null) {
            PsiMethodImpl.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    public PsiMethod findDeepestSuperMethod() {
        return PsiSuperMethodImplUtil.findDeepestSuperMethod(this);
    }

    @Override
    public PsiMethod @NotNull [] findDeepestSuperMethods() {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findDeepestSuperMethods(this);
        if (psiMethodArray == null) {
            PsiMethodImpl.$$$reportNull$$$0(4);
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public String getName() {
        PsiIdentifier nameIdentifier;
        PsiMethodStub stub = (PsiMethodStub)this.getGreenStub();
        String name2 = stub != null ? stub.getName() : ((nameIdentifier = this.getNameIdentifier()) == null ? null : nameIdentifier.getText());
        return name2 != null ? name2 : "<unnamed>";
    }

    @Override
    @NotNull
    public HierarchicalMethodSignature getHierarchicalMethodSignature() {
        HierarchicalMethodSignature hierarchicalMethodSignature = PsiSuperMethodImplUtil.getHierarchicalMethodSignature(this);
        if (hierarchicalMethodSignature == null) {
            PsiMethodImpl.$$$reportNull$$$0(5);
        }
        return hierarchicalMethodSignature;
    }

    @Override
    public PsiElement setName(@NotNull String name2) throws IncorrectOperationException {
        PsiIdentifier identifier;
        if (name2 == null) {
            PsiMethodImpl.$$$reportNull$$$0(6);
        }
        if ((identifier = this.getNameIdentifier()) == null) {
            throw new IncorrectOperationException("Empty name: " + this);
        }
        PsiImplUtil.setName(identifier, name2);
        return this;
    }

    @Override
    public PsiTypeElement getReturnTypeElement() {
        if (this.isConstructor()) {
            return null;
        }
        return (PsiTypeElement)this.getNode().findChildByRoleAsPsiElement(10);
    }

    @Override
    public PsiTypeParameterList getTypeParameterList() {
        return this.getRequiredStubOrPsiChild(JavaStubElementTypes.TYPE_PARAMETER_LIST);
    }

    @Override
    public boolean hasTypeParameters() {
        return PsiImplUtil.hasTypeParameters(this);
    }

    @Override
    public PsiTypeParameter @NotNull [] getTypeParameters() {
        PsiTypeParameter[] psiTypeParameterArray = PsiImplUtil.getTypeParameters(this);
        if (psiTypeParameterArray == null) {
            PsiMethodImpl.$$$reportNull$$$0(7);
        }
        return psiTypeParameterArray;
    }

    @Override
    public PsiType getReturnType() {
        if (this.isConstructor()) {
            return null;
        }
        PsiMethodStub stub = (PsiMethodStub)this.getStub();
        if (stub != null) {
            PsiType type2 = SoftReference.dereference(this.myCachedType);
            if (type2 == null) {
                type2 = JavaSharedImplUtil.createTypeFromStub(this, stub.getReturnTypeText());
                this.myCachedType = new SoftReference<PsiType>(type2);
            }
            return type2;
        }
        this.myCachedType = null;
        PsiTypeElement typeElement = this.getReturnTypeElement();
        return typeElement != null ? JavaSharedImplUtil.getType(typeElement, this.getParameterList()) : null;
    }

    @Override
    @NotNull
    public PsiModifierList getModifierList() {
        PsiModifierList psiModifierList = this.getRequiredStubOrPsiChild(JavaStubElementTypes.MODIFIER_LIST);
        if (psiModifierList == null) {
            PsiMethodImpl.$$$reportNull$$$0(8);
        }
        return psiModifierList;
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name2) {
        if (name2 == null) {
            PsiMethodImpl.$$$reportNull$$$0(9);
        }
        return this.getModifierList().hasModifierProperty(name2);
    }

    @Override
    @NotNull
    public PsiParameterList getParameterList() {
        PsiParameterList list = this.getStubOrPsiChild(JavaStubElementTypes.PARAMETER_LIST);
        if (list == null) {
            PsiParameterList psiParameterList = (PsiParameterList)CachedValuesManager.getCachedValue(this, () -> {
                LightParameterListBuilder lightList = new LightParameterListBuilder(this.getManager(), this.getLanguage()){

                    @Override
                    public String getText() {
                        return null;
                    }
                };
                PsiClass aClass = this.getContainingClass();
                if (aClass != null) {
                    PsiRecordComponent[] recordComponents;
                    for (PsiRecordComponent component : recordComponents = aClass.getRecordComponents()) {
                        String name2 = component.getName();
                        if (name2 == null) continue;
                        lightList.addParameter(new LightCompactConstructorParameter(name2, component.getType(), (PsiElement)this, component));
                    }
                }
                return CachedValueProvider.Result.create(lightList, this, PsiModificationTracker.MODIFICATION_COUNT);
            });
            if (psiParameterList == null) {
                PsiMethodImpl.$$$reportNull$$$0(10);
            }
            return psiParameterList;
        }
        PsiParameterList psiParameterList = list;
        if (psiParameterList == null) {
            PsiMethodImpl.$$$reportNull$$$0(11);
        }
        return psiParameterList;
    }

    @Override
    @NotNull
    public PsiReferenceList getThrowsList() {
        PsiReferenceList child = this.getStubOrPsiChild(JavaStubElementTypes.THROWS_LIST);
        if (child != null) {
            PsiReferenceList psiReferenceList = child;
            if (psiReferenceList == null) {
                PsiMethodImpl.$$$reportNull$$$0(12);
            }
            return psiReferenceList;
        }
        PsiMethodStub stub = (PsiMethodStub)this.getStub();
        Stream<String> children = stub != null ? stub.getChildrenStubs().stream().map(s -> s.getClass().getSimpleName() + " : " + s.getStubType()) : Stream.of(this.getChildren()).map(e -> e.getClass().getSimpleName() + " : " + e.getNode().getElementType());
        throw new AssertionError((Object)("Missing throws list, file=" + this.getContainingFile() + " children:\n" + children.collect(Collectors.joining("\n"))));
    }

    @Override
    public PsiCodeBlock getBody() {
        return (PsiCodeBlock)this.getNode().findChildByRoleAsPsiElement(17);
    }

    @Override
    @NotNull
    public CompositeElement getNode() {
        CompositeElement compositeElement = (CompositeElement)super.getNode();
        if (compositeElement == null) {
            PsiMethodImpl.$$$reportNull$$$0(13);
        }
        return compositeElement;
    }

    @Override
    public boolean isDeprecated() {
        return JavaStubImplUtil.isMemberDeprecated(this, (PsiMemberStub)this.getGreenStub());
    }

    @Override
    public PsiDocComment getDocComment() {
        PsiMethodStub stub = (PsiMethodStub)this.getGreenStub();
        if (stub != null && !stub.hasDocComment()) {
            return null;
        }
        return (PsiDocComment)this.getNode().findChildByRoleAsPsiElement(7);
    }

    @Override
    public boolean isConstructor() {
        PsiMethodStub stub = (PsiMethodStub)this.getGreenStub();
        if (stub != null) {
            return stub.isConstructor();
        }
        return this.getNode().findChildByRole(10) == null;
    }

    @Override
    public boolean isVarArgs() {
        PsiMethodStub stub = (PsiMethodStub)this.getGreenStub();
        if (stub != null) {
            return stub.isVarArgs();
        }
        return PsiImplUtil.isVarArgs(this);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiMethodImpl.$$$reportNull$$$0(14);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitMethod(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiMethod:" + this.getName();
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            PsiMethodImpl.$$$reportNull$$$0(15);
        }
        if (state == null) {
            PsiMethodImpl.$$$reportNull$$$0(16);
        }
        if (place == null) {
            PsiMethodImpl.$$$reportNull$$$0(17);
        }
        return PsiImplUtil.processDeclarationsInMethod(this, processor, state, lastParent, place);
    }

    @Override
    @NotNull
    public MethodSignature getSignature(@NotNull PsiSubstitutor substitutor2) {
        if (substitutor2 == null) {
            PsiMethodImpl.$$$reportNull$$$0(18);
        }
        if (substitutor2 == PsiSubstitutor.EMPTY) {
            MethodSignature methodSignature = (MethodSignature)CachedValuesManager.getCachedValue(this, () -> {
                MethodSignatureBackedByPsiMethod signature = MethodSignatureBackedByPsiMethod.create(this, PsiSubstitutor.EMPTY);
                return CachedValueProvider.Result.create(signature, PsiModificationTracker.MODIFICATION_COUNT);
            });
            if (methodSignature == null) {
                PsiMethodImpl.$$$reportNull$$$0(19);
            }
            return methodSignature;
        }
        MethodSignatureBackedByPsiMethod methodSignatureBackedByPsiMethod = MethodSignatureBackedByPsiMethod.create(this, substitutor2);
        if (methodSignatureBackedByPsiMethod == null) {
            PsiMethodImpl.$$$reportNull$$$0(20);
        }
        return methodSignatureBackedByPsiMethod;
    }

    @Override
    public PsiElement getOriginalElement() {
        PsiMethod originalMethod;
        PsiElement original;
        PsiClass containingClass = this.getContainingClass();
        if (containingClass != null && (original = containingClass.getOriginalElement()) != containingClass && (originalMethod = ((PsiClass)original).findMethodBySignature(this, false)) != null) {
            return originalMethod;
        }
        return this;
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    public Icon getElementIcon(int flags) {
        Icon methodIcon = this.hasModifierProperty("abstract") ? PlatformIcons.ABSTRACT_METHOD_ICON : PlatformIcons.METHOD_ICON;
        RowIcon baseIcon = IconManager.getInstance().createLayeredIcon(this, methodIcon, ElementPresentationUtil.getFlags(this, false));
        return ElementPresentationUtil.addVisibilityIcon(this, flags, baseIcon);
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isMethodEquivalentTo(this, another);
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        SearchScope searchScope = ReadAction.compute(() -> PsiImplUtil.getMemberUseScope(this));
        if (searchScope == null) {
            PsiMethodImpl.$$$reportNull$$$0(21);
        }
        return searchScope;
    }

    @Override
    public void putInfo(@NotNull Map<? super String, ? super String> info) {
        if (info == null) {
            PsiMethodImpl.$$$reportNull$$$0(22);
        }
        info.put("methodName", this.getName());
    }

    @Override
    protected boolean isVisibilitySupported() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiMethodImpl";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "findSuperMethods";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findSuperMethodSignaturesIncludingStatic";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findDeepestSuperMethods";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getHierarchicalMethodSignature";
                break;
            }
            case 6: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiMethodImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameters";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifierList";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterList";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getThrowsList";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getNode";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignature";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "hasModifierProperty";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getSignature";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "putInfo";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 6: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

