/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.lower;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.ir.backend.js.utils.IrResolveUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.TypeTranformerKt;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\f\u0010\f\u001a\u00020\r*\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/GenericReturnTypeLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "eraseUpperBoundType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "transformGenericCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "scopeOwnerSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "backend.wasm"})
public final class GenericReturnTypeLowering
implements FileLoweringPass {
    @NotNull
    private final WasmBackendContext context;

    public GenericReturnTypeLowering(@NotNull WasmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @NotNull
    public final WasmBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, new IrElementTransformerVoidWithContext(this){
            final /* synthetic */ GenericReturnTypeLowering this$0;
            {
                this.this$0 = $receiver;
            }

            public IrExpression visitCall(IrCall expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrExpression irExpression = super.visitCall(expression2);
                Intrinsics.checkNotNull((Object)irExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrCall");
                IrCall irCall = (IrCall)irExpression;
                ScopeWithIr scopeWithIr = this.getCurrentScope();
                Intrinsics.checkNotNull((Object)scopeWithIr);
                return GenericReturnTypeLowering.access$transformGenericCall(this.this$0, irCall, scopeWithIr.getScope().getScopeOwnerSymbol());
            }
        });
    }

    private final IrType eraseUpperBoundType(IrType $this$eraseUpperBoundType) {
        IrAnnotationContainer irAnnotationContainer = TypeTranformerKt.getErasedUpperBound($this$eraseUpperBoundType);
        if (irAnnotationContainer == null || (irAnnotationContainer = IrUtilsKt.getDefaultType(irAnnotationContainer)) == null) {
            return this.context.getIrBuiltIns().getAnyNType();
        }
        IrAnnotationContainer type2 = irAnnotationContainer;
        return IrTypeUtilsKt.isNullable($this$eraseUpperBoundType) ? IrTypesKt.makeNullable((IrType)type2) : (IrType)type2;
    }

    private final IrExpression transformGenericCall(IrCall call2, IrSymbol scopeOwnerSymbol) {
        IrSimpleFunction function2 = (IrSimpleFunction)call2.getSymbol().getOwner();
        IrType erasedReturnType = this.eraseUpperBoundType(IrResolveUtilsKt.getRealOverrideTarget(function2).getReturnType());
        IrType callType = call2.getType();
        if (!Intrinsics.areEqual((Object)erasedReturnType, (Object)call2.getType())) {
            if (IrTypePredicatesKt.isNothing(callType)) {
                return call2;
            }
            if (IrTypeUtilsKt.isSubtypeOf(erasedReturnType, callType, this.context.getTypeSystem())) {
                return call2;
            }
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = function2.getSymbol();
            IrClassSymbol irClassSymbol = call2.getSuperQualifierSymbol();
            IrCall newCall = IrUtilsKt.irCall$default((IrFunctionAccessExpression)call2, irSimpleFunctionSymbol, false, false, irClassSymbol, erasedReturnType, 12, null);
            DeclarationIrBuilder $this$transformGenericCall_u24lambda_u240 = LowerUtilsKt.createIrBuilder$default(this.context, scopeOwnerSymbol, 0, 0, 6, null);
            boolean bl = false;
            return ExpressionHelpersKt.irImplicitCast($this$transformGenericCall_u24lambda_u240, newCall, call2.getType());
        }
        return call2;
    }

    public static final /* synthetic */ IrExpression access$transformGenericCall(GenericReturnTypeLowering $this, IrCall call2, IrSymbol scopeOwnerSymbol) {
        return $this.transformGenericCall(call2, scopeOwnerSymbol);
    }
}

