/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.IrValidatorConfig;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithVisibility;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrReturnableBlock;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrDynamicType;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u00ea\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012:\u0010\u0004\u001a6\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r0\u0006j\u0002`\u0005\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0007H\u0016J\u001c\u0010\u001c\u001a\u00020\r*\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0002J\f\u0010!\u001a\u00020\r*\u00020\u001dH\u0002J\u0014\u0010\"\u001a\u00020\r*\u00020\u001d2\u0006\u0010 \u001a\u00020\u001fH\u0002J\u0014\u0010#\u001a\u00020\r*\u00020$2\u0006\u0010%\u001a\u00020\u001dH\u0002J\u0014\u0010&\u001a\u00020\r*\u00020\u00072\u0006\u0010'\u001a\u00020(H\u0002J\u0014\u0010)\u001a\u00020\r2\n\u0010%\u001a\u0006\u0012\u0002\b\u00030*H\u0016J\u0010\u0010+\u001a\u00020\r2\u0006\u0010%\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\r2\u0006\u0010%\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020\r2\u0006\u0010%\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020\r2\u0006\u0010%\u001a\u000202H\u0016J\u0010\u00103\u001a\u00020\r2\u0006\u0010%\u001a\u000204H\u0016J\u0010\u00105\u001a\u00020\r2\u0006\u0010%\u001a\u000206H\u0016J\u0010\u00107\u001a\u00020\r2\u0006\u0010%\u001a\u000208H\u0016J\u0010\u00109\u001a\u00020\r2\u0006\u0010%\u001a\u00020:H\u0016J\u0010\u0010;\u001a\u00020\r2\u0006\u0010%\u001a\u00020<H\u0016J\u0010\u0010=\u001a\u00020\r2\u0006\u0010%\u001a\u00020>H\u0016J\u0010\u0010?\u001a\u00020\r2\u0006\u0010@\u001a\u00020AH\u0016J\u0010\u0010B\u001a\u00020\r2\u0006\u0010C\u001a\u00020DH\u0016J\u0010\u0010E\u001a\u00020\r2\u0006\u0010%\u001a\u00020FH\u0016J\u0010\u0010G\u001a\u00020\r2\u0006\u0010%\u001a\u00020HH\u0016J\u0010\u0010I\u001a\u00020\r2\u0006\u0010J\u001a\u00020KH\u0016J\u0010\u0010L\u001a\u00020\r2\u0006\u0010J\u001a\u00020(H\u0016J\u0010\u0010M\u001a\u00020\r2\u0006\u0010%\u001a\u00020NH\u0016J\u0010\u0010O\u001a\u00020\r2\u0006\u0010J\u001a\u00020PH\u0016J\u0010\u0010Q\u001a\u00020\r2\u0006\u0010%\u001a\u00020RH\u0016J\u0010\u0010S\u001a\u00020\r2\u0006\u0010%\u001a\u00020TH\u0016J\u0010\u0010U\u001a\u00020\r2\u0006\u0010%\u001a\u00020VH\u0016J\u0010\u0010W\u001a\u00020\r2\u0006\u0010%\u001a\u00020XH\u0016J\u0010\u0010Y\u001a\u00020\r2\u0006\u0010%\u001a\u00020\u001dH\u0016J\u0018\u0010Z\u001a\u00020\r2\u0006\u0010[\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u0007H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013RG\u0010\u0004\u001a6\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r0\u0006j\u0002`\u0005\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\\"}, d2={"Lorg/jetbrains/kotlin/backend/common/CheckIrElementVisitor;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementVisitorVoid;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "reportError", "Lorg/jetbrains/kotlin/backend/common/ReportError;", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/ir/IrElement;", "Lkotlin/ParameterName;", "name", "element", "", "message", "", "config", "Lorg/jetbrains/kotlin/backend/common/IrValidatorConfig;", "<init>", "(Lorg/jetbrains/kotlin/ir/IrBuiltIns;Lkotlin/jvm/functions/Function2;Lorg/jetbrains/kotlin/backend/common/IrValidatorConfig;)V", "getIrBuiltIns", "()Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "getReportError", "()Lkotlin/jvm/functions/Function2;", "Lkotlin/jvm/functions/Function2;", "getConfig", "()Lorg/jetbrains/kotlin/backend/common/IrValidatorConfig;", "visitedElements", "Ljava/util/HashSet;", "visitElement", "ensureTypesEqual", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "actualType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "expectedType", "ensureNullable", "ensureTypeIs", "ensureBound", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "expression", "checkFunction", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "visitConst", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "visitStringConcatenation", "Lorg/jetbrains/kotlin/ir/expressions/IrStringConcatenation;", "visitGetObjectValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetObjectValue;", "visitGetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "visitSetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrSetValue;", "visitGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "visitSetField", "Lorg/jetbrains/kotlin/ir/expressions/IrSetField;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "visitInstanceInitializerCall", "Lorg/jetbrains/kotlin/ir/expressions/IrInstanceInitializerCall;", "visitTypeOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "visitLoop", "loop", "Lorg/jetbrains/kotlin/ir/expressions/IrLoop;", "visitBreakContinue", "jump", "Lorg/jetbrains/kotlin/ir/expressions/IrBreakContinue;", "visitReturn", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "visitThrow", "Lorg/jetbrains/kotlin/ir/expressions/IrThrow;", "visitClass", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "visitFunction", "visitDeclarationReference", "Lorg/jetbrains/kotlin/ir/expressions/IrDeclarationReference;", "visitDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationBase;", "visitFunctionAccess", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "visitFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "visitPropertyReference", "Lorg/jetbrains/kotlin/ir/expressions/IrPropertyReference;", "visitLocalDelegatedPropertyReference", "Lorg/jetbrains/kotlin/ir/expressions/IrLocalDelegatedPropertyReference;", "visitExpression", "checkType", "type", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nCheckIrElementVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CheckIrElementVisitor.kt\norg/jetbrains/kotlin/backend/common/CheckIrElementVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,361:1\n808#2,11:362\n774#2:373\n865#2,2:374\n1557#2:376\n1628#2,3:377\n*S KotlinDebug\n*F\n+ 1 CheckIrElementVisitor.kt\norg/jetbrains/kotlin/backend/common/CheckIrElementVisitor\n*L\n259#1:362,11\n260#1:373\n260#1:374,2\n262#1:376\n262#1:377,3\n*E\n"})
public final class CheckIrElementVisitor
implements IrElementVisitorVoid {
    @NotNull
    private final IrBuiltIns irBuiltIns;
    @NotNull
    private final Function2<IrElement, String, Unit> reportError;
    @NotNull
    private final IrValidatorConfig config;
    @NotNull
    private final HashSet<IrElement> visitedElements;

    public CheckIrElementVisitor(@NotNull IrBuiltIns irBuiltIns, @NotNull Function2<? super IrElement, ? super String, Unit> reportError, @NotNull IrValidatorConfig config) {
        Intrinsics.checkNotNullParameter((Object)irBuiltIns, (String)"irBuiltIns");
        Intrinsics.checkNotNullParameter(reportError, (String)"reportError");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.irBuiltIns = irBuiltIns;
        this.reportError = reportError;
        this.config = config;
        this.visitedElements = new HashSet();
    }

    @NotNull
    public final IrBuiltIns getIrBuiltIns() {
        return this.irBuiltIns;
    }

    @NotNull
    public final Function2<IrElement, String, Unit> getReportError() {
        return this.reportError;
    }

    @NotNull
    public final IrValidatorConfig getConfig() {
        return this.config;
    }

    @Override
    public void visitElement(@NotNull IrElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (this.config.getEnsureAllNodesAreDifferent() && !this.visitedElements.add(element)) {
            String renderString = element instanceof IrTypeParameter ? RenderIrElementKt.render$default(element, null, 1, null) + " of " + RenderIrElementKt.render$default(((IrTypeParameter)element).getParent(), null, 1, null) : RenderIrElementKt.render$default(element, null, 1, null);
            this.reportError.invoke((Object)element, (Object)("Duplicate IR node: " + renderString));
        }
    }

    private final void ensureTypesEqual(IrExpression $this$ensureTypesEqual, IrType actualType, IrType expectedType) {
        if (!this.config.getCheckTypes()) {
            return;
        }
        if (!Intrinsics.areEqual((Object)actualType, (Object)expectedType)) {
            this.reportError.invoke((Object)$this$ensureTypesEqual, (Object)("unexpected type: expected " + RenderIrElementKt.render$default(expectedType, null, 1, null) + ", got " + RenderIrElementKt.render$default(actualType, null, 1, null)));
        }
    }

    private final void ensureNullable(IrExpression $this$ensureNullable) {
        if (!this.config.getCheckTypes()) {
            return;
        }
        if (!IrTypeUtilsKt.isNullable($this$ensureNullable.getType())) {
            this.reportError.invoke((Object)$this$ensureNullable, (Object)("expected a nullable type, got " + RenderIrElementKt.render$default($this$ensureNullable.getType(), null, 1, null)));
        }
    }

    private final void ensureTypeIs(IrExpression $this$ensureTypeIs, IrType expectedType) {
        this.ensureTypesEqual($this$ensureTypeIs, $this$ensureTypeIs.getType(), expectedType);
    }

    private final void ensureBound(IrSymbol $this$ensureBound, IrExpression expression2) {
        if (!$this$ensureBound.isBound() && !(expression2.getType() instanceof IrDynamicType)) {
            this.reportError.invoke((Object)expression2, (Object)("Unbound symbol " + $this$ensureBound));
        }
    }

    private final void checkFunction(IrElement $this$checkFunction, IrFunction function2) {
        if (function2 instanceof IrSimpleFunction && this.config.getCheckProperties()) {
            IrProperty property;
            IrPropertySymbol irPropertySymbol = ((IrSimpleFunction)function2).getCorrespondingPropertySymbol();
            IrProperty irProperty = property = irPropertySymbol != null ? (IrProperty)irPropertySymbol.getOwner() : null;
            if (property != null && !Intrinsics.areEqual((Object)property.getGetter(), (Object)function2) && !Intrinsics.areEqual((Object)property.getSetter(), (Object)function2)) {
                this.reportError.invoke((Object)$this$checkFunction, (Object)("Orphaned property getter/setter " + RenderIrElementKt.render$default(function2, null, 1, null)));
            }
        }
        IrValueParameter irValueParameter = function2.getDispatchReceiverParameter();
        if ((irValueParameter != null ? irValueParameter.getType() : null) instanceof IrDynamicType) {
            this.reportError.invoke((Object)$this$checkFunction, (Object)"Dispatch receivers with 'dynamic' type are not allowed");
        }
    }

    @Override
    public void visitConst(@NotNull IrConst<?> expression2) {
        IrType irType;
        Intrinsics.checkNotNullParameter(expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2);
        IrConstKind<?> irConstKind = expression2.getKind();
        if (Intrinsics.areEqual(irConstKind, (Object)IrConstKind.Null.INSTANCE)) {
            this.ensureNullable(expression2);
            return;
        }
        if (Intrinsics.areEqual(irConstKind, (Object)IrConstKind.Boolean.INSTANCE)) {
            irType = this.irBuiltIns.getBooleanType();
        } else if (Intrinsics.areEqual(irConstKind, (Object)IrConstKind.Char.INSTANCE)) {
            irType = this.irBuiltIns.getCharType();
        } else if (Intrinsics.areEqual(irConstKind, (Object)IrConstKind.Byte.INSTANCE)) {
            irType = this.irBuiltIns.getByteType();
        } else if (Intrinsics.areEqual(irConstKind, (Object)IrConstKind.Short.INSTANCE)) {
            irType = this.irBuiltIns.getShortType();
        } else if (Intrinsics.areEqual(irConstKind, (Object)IrConstKind.Int.INSTANCE)) {
            irType = this.irBuiltIns.getIntType();
        } else if (Intrinsics.areEqual(irConstKind, (Object)IrConstKind.Long.INSTANCE)) {
            irType = this.irBuiltIns.getLongType();
        } else if (Intrinsics.areEqual(irConstKind, (Object)IrConstKind.String.INSTANCE)) {
            irType = this.irBuiltIns.getStringType();
        } else if (Intrinsics.areEqual(irConstKind, (Object)IrConstKind.Float.INSTANCE)) {
            irType = this.irBuiltIns.getFloatType();
        } else if (Intrinsics.areEqual(irConstKind, (Object)IrConstKind.Double.INSTANCE)) {
            irType = this.irBuiltIns.getDoubleType();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        IrType naturalType = irType;
    }

    @Override
    public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2);
        this.ensureTypeIs(expression2, this.irBuiltIns.getStringType());
    }

    @Override
    public void visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
        this.ensureTypeIs(expression2, IrTypesKt.createType(expression2.getSymbol(), false, CollectionsKt.emptyList()));
    }

    @Override
    public void visitGetValue(@NotNull IrGetValue expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2);
        this.ensureTypeIs(expression2, expression2.getSymbol().getOwner().getType());
    }

    @Override
    public void visitSetValue(@NotNull IrSetValue expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2);
        IrValueDeclaration declaration = expression2.getSymbol().getOwner();
        if (declaration instanceof IrValueParameter && !declaration.isAssignable()) {
            this.reportError.invoke((Object)expression2, (Object)"Assignment to value parameters not marked assignable");
        }
        this.ensureTypeIs(expression2, this.irBuiltIns.getUnitType());
    }

    @Override
    public void visitGetField(@NotNull IrGetField expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2);
        IrType fieldType = ((IrField)expression2.getSymbol().getOwner()).getType();
        if (fieldType instanceof IrSimpleType && ((IrSimpleType)fieldType).getClassifier() instanceof IrClassSymbol && ((IrSimpleType)fieldType).getArguments().isEmpty()) {
            this.ensureTypeIs(expression2, fieldType);
        }
    }

    @Override
    public void visitSetField(@NotNull IrSetField expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2);
        this.ensureTypeIs(expression2, this.irBuiltIns.getUnitType());
    }

    @Override
    public void visitCall(@NotNull IrCall expression2) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2);
            IrSimpleFunction function2 = (IrSimpleFunction)expression2.getSymbol().getOwner();
            this.checkFunction(expression2, function2);
            IrType returnType = ((IrSimpleFunction)expression2.getSymbol().getOwner()).getReturnType();
            if (returnType instanceof IrSimpleType && ((IrSimpleType)returnType).getClassifier() instanceof IrClassSymbol && ((IrSimpleType)returnType).getArguments().isEmpty()) {
                this.ensureTypeIs(expression2, returnType);
            }
            IrClassSymbol irClassSymbol = expression2.getSuperQualifierSymbol();
            if (irClassSymbol == null) break block1;
            this.ensureBound(irClassSymbol, expression2);
        }
    }

    @Override
    public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2);
        this.ensureTypeIs(expression2, this.irBuiltIns.getUnitType());
    }

    @Override
    public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
        this.ensureTypeIs(expression2, this.irBuiltIns.getUnitType());
        this.ensureBound(expression2.getClassSymbol(), expression2);
    }

    @Override
    public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
        IrType irType;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2);
        IrTypeOperator operator = expression2.getOperator();
        IrType typeOperand = expression2.getTypeOperand();
        switch (WhenMappings.$EnumSwitchMapping$0[operator.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                irType = typeOperand;
                break;
            }
            case 9: {
                irType = IrTypesKt.makeNullable(typeOperand);
                break;
            }
            case 10: 
            case 11: {
                irType = this.irBuiltIns.getBooleanType();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        IrType naturalType = irType;
        if (operator == IrTypeOperator.IMPLICIT_COERCION_TO_UNIT && !IrTypePredicatesKt.isUnit(typeOperand)) {
            this.reportError.invoke((Object)expression2, (Object)("typeOperand is " + RenderIrElementKt.render$default(typeOperand, null, 1, null)));
        }
        this.ensureTypeIs(expression2, naturalType);
    }

    @Override
    public void visitLoop(@NotNull IrLoop loop) {
        Intrinsics.checkNotNullParameter((Object)loop, (String)"loop");
        IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop);
        this.ensureTypeIs(loop, this.irBuiltIns.getUnitType());
    }

    @Override
    public void visitBreakContinue(@NotNull IrBreakContinue jump) {
        Intrinsics.checkNotNullParameter((Object)jump, (String)"jump");
        IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
        this.ensureTypeIs(jump, this.irBuiltIns.getNothingType());
    }

    @Override
    public void visitReturn(@NotNull IrReturn expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2);
        this.ensureTypeIs(expression2, this.irBuiltIns.getNothingType());
        this.ensureBound(expression2.getReturnTargetSymbol(), expression2);
    }

    @Override
    public void visitThrow(@NotNull IrThrow expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2);
        this.ensureTypeIs(expression2, this.irBuiltIns.getNothingType());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitClass(@NotNull IrClass declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration);
        if (this.config.getCheckDescriptors() && !IrUtilsKt.isAnnotationClass(declaration)) {
            void $this$mapTo$iv$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = ResolutionScope.DefaultImpls.getContributedDescriptors$default(declaration.getDescriptor().getUnsubstitutedMemberScope(), null, null, 3, null);
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof CallableMemberDescriptor)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it.getVisibility(), (Object)DescriptorVisibilities.INVISIBLE_FAKE))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List allDescriptors = (List)destination$iv$iv;
            Iterable $this$map$iv = declaration.getDeclarations();
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IrDeclaration bl = (IrDeclaration)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(it.getDescriptor());
            }
            List presentDescriptors = (List)destination$iv$iv2;
            List missingDescriptors = CollectionsKt.minus((Iterable)allDescriptors, (Iterable)presentDescriptors);
            if (!((Collection)missingDescriptors).isEmpty()) {
                this.reportError.invoke((Object)declaration, (Object)("Missing declarations for descriptors:\n" + CollectionsKt.joinToString$default((Iterable)missingDescriptors, (CharSequence)"\n: ", null, null, (int)0, null, null, (int)62, null)));
            }
        }
    }

    @Override
    public void visitFunction(@NotNull IrFunction declaration) {
        IrDeclarationBase p;
        int i;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration);
        this.checkFunction(declaration, declaration);
        Iterator iterator2 = ((Iterable)declaration.getValueParameters()).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            i = n++;
            p = (IrValueParameter)iterator2.next();
            if (((IrValueParameter)p).getIndex() == i) continue;
            this.reportError.invoke((Object)declaration, (Object)("Inconsistent index of value parameter " + ((IrValueParameter)p).getIndex() + " != " + i));
        }
        iterator2 = ((Iterable)declaration.getTypeParameters()).iterator();
        n = 0;
        while (iterator2.hasNext()) {
            i = n++;
            p = (IrTypeParameter)iterator2.next();
            if (((IrTypeParameter)p).getIndex() == i) continue;
            this.reportError.invoke((Object)declaration, (Object)("Inconsistent index of type parameter " + ((IrTypeParameter)p).getIndex() + " != " + i));
        }
    }

    @Override
    public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
        if (expression2 instanceof IrFieldAccessExpression) {
            IrType receiverType;
            IrExpression irExpression = ((IrFieldAccessExpression)expression2).getReceiver();
            IrType irType = receiverType = irExpression != null ? irExpression.getType() : null;
            if (receiverType instanceof IrDynamicType) {
                return;
            }
        }
        this.ensureBound(expression2.getSymbol(), expression2);
    }

    @Override
    public void visitDeclaration(@NotNull IrDeclarationBase declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration);
        if (declaration instanceof IrOverridableDeclaration) {
            for (IrSymbol overriddenSymbol : ((IrOverridableDeclaration)((Object)declaration)).getOverriddenSymbols()) {
                IrDeclarationWithVisibility overriddenDeclaration;
                IrSymbolOwner irSymbolOwner = overriddenSymbol.getOwner();
                IrDeclarationWithVisibility irDeclarationWithVisibility = irSymbolOwner instanceof IrDeclarationWithVisibility ? (IrDeclarationWithVisibility)irSymbolOwner : null;
                if (irDeclarationWithVisibility == null || !Intrinsics.areEqual((Object)(overriddenDeclaration = irDeclarationWithVisibility).getVisibility(), (Object)DescriptorVisibilities.PRIVATE)) continue;
                this.reportError.invoke((Object)declaration, (Object)("Overrides private declaration " + overriddenDeclaration));
            }
        }
    }

    @Override
    public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
        this.ensureBound((IrSymbol)expression2.getSymbol(), expression2);
    }

    @Override
    public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2);
        this.checkFunction(expression2, ((IrFunctionSymbol)expression2.getSymbol()).getOwner());
        this.ensureBound((IrSymbol)expression2.getSymbol(), expression2);
    }

    @Override
    public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2);
            IrFieldSymbol irFieldSymbol = expression2.getField();
            if (irFieldSymbol != null) {
                this.ensureBound(irFieldSymbol, expression2);
            }
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = expression2.getGetter();
            if (irSimpleFunctionSymbol != null) {
                this.ensureBound(irSimpleFunctionSymbol, expression2);
            }
            IrSimpleFunctionSymbol irSimpleFunctionSymbol2 = expression2.getSetter();
            if (irSimpleFunctionSymbol2 == null) break block2;
            this.ensureBound(irSimpleFunctionSymbol2, expression2);
        }
    }

    @Override
    public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
            this.ensureBound(expression2.getDelegate(), expression2);
            this.ensureBound(expression2.getGetter(), expression2);
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = expression2.getSetter();
            if (irSimpleFunctionSymbol == null) break block0;
            this.ensureBound(irSimpleFunctionSymbol, expression2);
        }
    }

    @Override
    public void visitExpression(@NotNull IrExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        this.checkType(expression2.getType(), expression2);
        IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2);
    }

    private final void checkType(IrType type2, IrElement element) {
        if (type2 instanceof IrSimpleType && !((IrSimpleType)type2).getClassifier().isBound()) {
            this.reportError.invoke((Object)element, (Object)("Type: " + RenderIrElementKt.render$default((IrSimpleType)type2, null, 1, null) + " has unbound classifier"));
        }
    }

    @Override
    public void visitElement(@NotNull IrElement element, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitElement(this, element, data);
    }

    @Override
    public void visitConst(@NotNull IrConst<?> expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data);
    }

    @Override
    public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data);
    }

    @Override
    public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data);
    }

    @Override
    public void visitGetValue(@NotNull IrGetValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data);
    }

    @Override
    public void visitSetValue(@NotNull IrSetValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2, data);
    }

    @Override
    public void visitGetField(@NotNull IrGetField expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data);
    }

    @Override
    public void visitSetField(@NotNull IrSetField expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data);
    }

    @Override
    public void visitCall(@NotNull IrCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data);
    }

    @Override
    public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
    }

    @Override
    public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
    }

    @Override
    public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data);
    }

    @Override
    public void visitLoop(@NotNull IrLoop loop, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop, data);
    }

    @Override
    public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data);
    }

    @Override
    public void visitReturn(@NotNull IrReturn expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data);
    }

    @Override
    public void visitThrow(@NotNull IrThrow expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data);
    }

    @Override
    public void visitClass(@NotNull IrClass declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration, data);
    }

    @Override
    public void visitFunction(@NotNull IrFunction declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration, data);
    }

    @Override
    public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data);
    }

    @Override
    public void visitDeclaration(@NotNull IrDeclarationBase declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration, data);
    }

    @Override
    public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data);
    }

    @Override
    public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data);
    }

    @Override
    public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data);
    }

    @Override
    public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
    }

    @Override
    public void visitExpression(@NotNull IrExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data);
    }

    @Override
    public void visitValueParameter(@NotNull IrValueParameter declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration, data);
    }

    @Override
    public void visitValueParameter(@NotNull IrValueParameter declaration) {
        IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration);
    }

    @Override
    public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration, data);
    }

    @Override
    public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration) {
        IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration);
    }

    @Override
    public void visitTypeParameter(@NotNull IrTypeParameter declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration, data);
    }

    @Override
    public void visitTypeParameter(@NotNull IrTypeParameter declaration) {
        IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration);
    }

    @Override
    public void visitConstructor(@NotNull IrConstructor declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration, data);
    }

    @Override
    public void visitConstructor(@NotNull IrConstructor declaration) {
        IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration);
    }

    @Override
    public void visitEnumEntry(@NotNull IrEnumEntry declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration, data);
    }

    @Override
    public void visitEnumEntry(@NotNull IrEnumEntry declaration) {
        IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration);
    }

    @Override
    public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration, data);
    }

    @Override
    public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration) {
        IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration);
    }

    @Override
    public void visitField(@NotNull IrField declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitField(this, declaration, data);
    }

    @Override
    public void visitField(@NotNull IrField declaration) {
        IrElementVisitorVoid.DefaultImpls.visitField(this, declaration);
    }

    @Override
    public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data);
    }

    @Override
    public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration);
    }

    @Override
    public void visitModuleFragment(@NotNull IrModuleFragment declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration, data);
    }

    @Override
    public void visitModuleFragment(@NotNull IrModuleFragment declaration) {
        IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration);
    }

    @Override
    public void visitProperty(@NotNull IrProperty declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration, data);
    }

    @Override
    public void visitProperty(@NotNull IrProperty declaration) {
        IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration);
    }

    @Override
    public void visitScript(@NotNull IrScript declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration, data);
    }

    @Override
    public void visitScript(@NotNull IrScript declaration) {
        IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration);
    }

    @Override
    public void visitSimpleFunction(@NotNull IrSimpleFunction declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration, data);
    }

    @Override
    public void visitSimpleFunction(@NotNull IrSimpleFunction declaration) {
        IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration);
    }

    @Override
    public void visitTypeAlias(@NotNull IrTypeAlias declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration, data);
    }

    @Override
    public void visitTypeAlias(@NotNull IrTypeAlias declaration) {
        IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration);
    }

    @Override
    public void visitVariable(@NotNull IrVariable declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration, data);
    }

    @Override
    public void visitVariable(@NotNull IrVariable declaration) {
        IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration);
    }

    @Override
    public void visitPackageFragment(@NotNull IrPackageFragment declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration, data);
    }

    @Override
    public void visitPackageFragment(@NotNull IrPackageFragment declaration) {
        IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration);
    }

    @Override
    public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration, data);
    }

    @Override
    public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration) {
        IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration);
    }

    @Override
    public void visitFile(@NotNull IrFile declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration, data);
    }

    @Override
    public void visitFile(@NotNull IrFile declaration) {
        IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration);
    }

    @Override
    public void visitBody(@NotNull IrBody body2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBody(this, body2, data);
    }

    @Override
    public void visitBody(@NotNull IrBody body2) {
        IrElementVisitorVoid.DefaultImpls.visitBody(this, body2);
    }

    @Override
    public void visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2, data);
    }

    @Override
    public void visitExpressionBody(@NotNull IrExpressionBody body2) {
        IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2);
    }

    @Override
    public void visitBlockBody(@NotNull IrBlockBody body2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2, data);
    }

    @Override
    public void visitBlockBody(@NotNull IrBlockBody body2) {
        IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2);
    }

    @Override
    public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data);
    }

    @Override
    public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2) {
        IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
    }

    @Override
    public void visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2, data);
    }

    @Override
    public void visitConstructorCall(@NotNull IrConstructorCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2);
    }

    @Override
    public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data);
    }

    @Override
    public void visitSingletonReference(@NotNull IrGetSingletonValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
    }

    @Override
    public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data);
    }

    @Override
    public void visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
    }

    @Override
    public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2, data);
    }

    @Override
    public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2);
    }

    @Override
    public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data);
    }

    @Override
    public void visitContainerExpression(@NotNull IrContainerExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2);
    }

    @Override
    public void visitBlock(@NotNull IrBlock expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data);
    }

    @Override
    public void visitBlock(@NotNull IrBlock expression2) {
        IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
    }

    @Override
    public void visitComposite(@NotNull IrComposite expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data);
    }

    @Override
    public void visitComposite(@NotNull IrComposite expression2) {
        IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
    }

    @Override
    public void visitReturnableBlock(@NotNull IrReturnableBlock expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitReturnableBlock(this, expression2, data);
    }

    @Override
    public void visitReturnableBlock(@NotNull IrReturnableBlock expression2) {
        IrElementVisitorVoid.DefaultImpls.visitReturnableBlock(this, expression2);
    }

    @Override
    public void visitInlinedFunctionBlock(@NotNull IrInlinedFunctionBlock inlinedBlock, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitInlinedFunctionBlock(this, inlinedBlock, data);
    }

    @Override
    public void visitInlinedFunctionBlock(@NotNull IrInlinedFunctionBlock inlinedBlock) {
        IrElementVisitorVoid.DefaultImpls.visitInlinedFunctionBlock(this, inlinedBlock);
    }

    @Override
    public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2, data);
    }

    @Override
    public void visitSyntheticBody(@NotNull IrSyntheticBody body2) {
        IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2);
    }

    @Override
    public void visitBreak(@NotNull IrBreak jump, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data);
    }

    @Override
    public void visitBreak(@NotNull IrBreak jump) {
        IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
    }

    @Override
    public void visitContinue(@NotNull IrContinue jump, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data);
    }

    @Override
    public void visitContinue(@NotNull IrContinue jump) {
        IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
    }

    @Override
    public void visitCallableReference(@NotNull IrCallableReference<?> expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data);
    }

    @Override
    public void visitCallableReference(@NotNull IrCallableReference<?> expression2) {
        IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
    }

    @Override
    public void visitClassReference(@NotNull IrClassReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data);
    }

    @Override
    public void visitClassReference(@NotNull IrClassReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
    }

    @Override
    public void visitConstantValue(@NotNull IrConstantValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2, data);
    }

    @Override
    public void visitConstantValue(@NotNull IrConstantValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2);
    }

    @Override
    public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2, data);
    }

    @Override
    public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2);
    }

    @Override
    public void visitConstantObject(@NotNull IrConstantObject expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2, data);
    }

    @Override
    public void visitConstantObject(@NotNull IrConstantObject expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2);
    }

    @Override
    public void visitConstantArray(@NotNull IrConstantArray expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2, data);
    }

    @Override
    public void visitConstantArray(@NotNull IrConstantArray expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2);
    }

    @Override
    public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2, data);
    }

    @Override
    public void visitDynamicExpression(@NotNull IrDynamicExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2);
    }

    @Override
    public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data);
    }

    @Override
    public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2);
    }

    @Override
    public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2, data);
    }

    @Override
    public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2);
    }

    @Override
    public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
    }

    @Override
    public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
    }

    @Override
    public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data);
    }

    @Override
    public void visitErrorExpression(@NotNull IrErrorExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
    }

    @Override
    public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data);
    }

    @Override
    public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
    }

    @Override
    public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data);
    }

    @Override
    public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
    }

    @Override
    public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2, data);
    }

    @Override
    public void visitFunctionExpression(@NotNull IrFunctionExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2);
    }

    @Override
    public void visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data);
    }

    @Override
    public void visitGetClass(@NotNull IrGetClass expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
    }

    @Override
    public void visitWhileLoop(@NotNull IrWhileLoop loop, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop, data);
    }

    @Override
    public void visitWhileLoop(@NotNull IrWhileLoop loop) {
        IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop);
    }

    @Override
    public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop, data);
    }

    @Override
    public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop) {
        IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop);
    }

    @Override
    public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2, data);
    }

    @Override
    public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2);
    }

    @Override
    public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2, data);
    }

    @Override
    public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2);
    }

    @Override
    public void visitTry(@NotNull IrTry aTry, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data);
    }

    @Override
    public void visitTry(@NotNull IrTry aTry) {
        IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
    }

    @Override
    public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data);
    }

    @Override
    public void visitCatch(@NotNull IrCatch aCatch) {
        IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
    }

    @Override
    public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data);
    }

    @Override
    public void visitValueAccess(@NotNull IrValueAccessExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2);
    }

    @Override
    public void visitVararg(@NotNull IrVararg expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data);
    }

    @Override
    public void visitVararg(@NotNull IrVararg expression2) {
        IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2);
    }

    @Override
    public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data);
    }

    @Override
    public void visitSpreadElement(@NotNull IrSpreadElement spread) {
        IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
    }

    @Override
    public void visitWhen(@NotNull IrWhen expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data);
    }

    @Override
    public void visitWhen(@NotNull IrWhen expression2) {
        IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2);
    }

    @Override
    public void visitBranch(@NotNull IrBranch branch, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data);
    }

    @Override
    public void visitBranch(@NotNull IrBranch branch) {
        IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
    }

    @Override
    public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data);
    }

    @Override
    public void visitElseBranch(@NotNull IrElseBranch branch) {
        IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=50)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IrTypeOperator.values().length];
            try {
                nArray[IrTypeOperator.CAST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.IMPLICIT_CAST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.IMPLICIT_NOTNULL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.IMPLICIT_COERCION_TO_UNIT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.IMPLICIT_INTEGER_COERCION.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.SAM_CONVERSION.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.IMPLICIT_DYNAMIC_CAST.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.REINTERPRET_CAST.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.SAFE_CAST.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.INSTANCEOF.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.NOT_INSTANCEOF.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

