/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.providers.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.konan.K2KotlinNativeMetadataDecompiler;
import org.jetbrains.kotlin.analysis.decompiler.konan.KlibMetaFileType;
import org.jetbrains.kotlin.analysis.decompiler.psi.BuiltInsVirtualFileProvider;
import org.jetbrains.kotlin.analysis.decompiler.psi.KotlinBuiltInDecompiler;
import org.jetbrains.kotlin.analysis.decompiler.psi.KotlinBuiltInFileType;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.ClsKotlinBinaryClassCache;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.KotlinClsStubBuilder;
import org.jetbrains.kotlin.analysis.project.structure.KtModule;
import org.jetbrains.kotlin.analysis.providers.KotlinDeclarationProvider;
import org.jetbrains.kotlin.analysis.providers.KotlinDeclarationProviderFactory;
import org.jetbrains.kotlin.analysis.providers.impl.KotlinFakeClsStubsCache;
import org.jetbrains.kotlin.analysis.providers.impl.KotlinStaticDeclarationIndex;
import org.jetbrains.kotlin.analysis.providers.impl.KotlinStaticDeclarationProvider;
import org.jetbrains.kotlin.com.intellij.ide.highlighter.JavaClassFileType;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolder;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VfsUtilCore;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileVisitor;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.SingleRootFileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.compiled.ClsStubBuilder;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.stubs.PsiFileStub;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.util.indexing.FileContent;
import org.jetbrains.kotlin.com.intellij.util.indexing.FileContentImpl;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.stubs.KotlinClassOrObjectStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinClassStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinFileStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinFunctionStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinObjectStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinPlaceHolderStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinPropertyStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinTypeAliasStubImpl;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0002EFBQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0005H\u0002J\"\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0006H\u0002J\u0010\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020/H\u0002J\u0014\u00100\u001a\u00020\u001f2\n\u00101\u001a\u0006\u0012\u0002\b\u000302H\u0002J\u0010\u00103\u001a\u00020\u001f2\u0006\u00104\u001a\u00020\u001aH\u0002J$\u00105\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001a062\u0006\u00107\u001a\u00020\t2\u0006\u00108\u001a\u000209H\u0002J\u001a\u0010:\u001a\u0004\u0018\u00010\u001a2\u0006\u0010 \u001a\u00020\t2\u0006\u00108\u001a\u000209H\u0002J\u001c\u0010;\u001a\u00020\u001f2\u0012\u0010<\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001a06H\u0002J\u001a\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@2\b\u0010A\u001a\u0004\u0018\u00010BH\u0016J\f\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00060\bJ\f\u0010D\u001a\b\u0012\u0004\u0012\u00020&0\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lorg/jetbrains/kotlin/analysis/providers/impl/KotlinStaticDeclarationProviderFactory;", "Lorg/jetbrains/kotlin/analysis/providers/KotlinDeclarationProviderFactory;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "testKtFiles", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "binaryRoots", "", "Lorg/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFile;", "sharedBinaryRoots", "skipBuiltins", "", "shouldBuildStubsForBinaryLibraries", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/Collection;Ljava/util/List;Ljava/util/List;ZZ)V", "index", "Lorg/jetbrains/kotlin/analysis/providers/impl/KotlinStaticDeclarationIndex;", "psiManager", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiManager;", "Lorg/jetbrains/annotations/NotNull;", "builtInDecompiler", "Lorg/jetbrains/kotlin/analysis/decompiler/psi/KotlinBuiltInDecompiler;", "createdFakeKtFiles", "", "loadBuiltIns", "Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinFileStubImpl;", "createKtFileStub", "fileContent", "Lorg/jetbrains/kotlin/com/intellij/util/indexing/FileContent;", "addToFacadeFileMap", "", "file", "addToScriptMap", "script", "Lorg/jetbrains/kotlin/psi/KtScript;", "addToClassMap", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "addToTypeAliasMap", "typeAlias", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "addToFunctionMap", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "addToPropertyMap", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "indexStub", "stub", "Lorg/jetbrains/kotlin/com/intellij/psi/stubs/StubElement;", "processStub", "ktFileStub", "collectStubsFromBinaryRoot", "", "binaryRoot", "binaryClassCache", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/ClsKotlinBinaryClassCache;", "buildStubByVirtualFile", "processCollectedStubs", "stubs", "createDeclarationProvider", "Lorg/jetbrains/kotlin/analysis/providers/KotlinDeclarationProvider;", "scope", "Lorg/jetbrains/kotlin/com/intellij/psi/search/GlobalSearchScope;", "contextualModule", "Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "getAdditionalCreatedKtFiles", "getAllKtClasses", "KtClassFileViewProvider", "KtDeclarationRecorder", "analysis-api-providers"})
@SourceDebugExtension(value={"SMAP\nKotlinStaticDeclarationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinStaticDeclarationProvider.kt\norg/jetbrains/kotlin/analysis/providers/impl/KotlinStaticDeclarationProviderFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,436:1\n1863#2,2:437\n1557#2:440\n1628#2,3:441\n1863#2,2:444\n1863#2,2:446\n1611#2,9:448\n1863#2:457\n1864#2:459\n1620#2:460\n1863#2,2:461\n1863#2,2:463\n808#2,11:465\n1863#2,2:476\n1863#2,2:478\n1#3:439\n1#3:458\n216#4,2:480\n*S KotlinDebug\n*F\n+ 1 KotlinStaticDeclarationProvider.kt\norg/jetbrains/kotlin/analysis/providers/impl/KotlinStaticDeclarationProviderFactory\n*L\n277#1:437,2\n298#1:440\n298#1:441,3\n299#1:444,2\n302#1:446,2\n166#1:448,9\n166#1:457\n166#1:459\n166#1:460\n312#1:461,2\n317#1:463,2\n324#1:465,11\n324#1:476,2\n344#1:478,2\n166#1:458\n381#1:480,2\n*E\n"})
public final class KotlinStaticDeclarationProviderFactory
extends KotlinDeclarationProviderFactory {
    @NotNull
    private final Project project;
    @NotNull
    private final KotlinStaticDeclarationIndex index;
    @NotNull
    private final PsiManager psiManager;
    @NotNull
    private final KotlinBuiltInDecompiler builtInDecompiler;
    @NotNull
    private final List<KtFile> createdFakeKtFiles;

    /*
     * WARNING - void declaration
     */
    public KotlinStaticDeclarationProviderFactory(@NotNull Project project, @NotNull Collection<? extends KtFile> testKtFiles, @NotNull List<? extends VirtualFile> binaryRoots, @NotNull List<? extends VirtualFile> sharedBinaryRoots, boolean skipBuiltins, boolean shouldBuildStubsForBinaryLibraries) {
        Iterable $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(testKtFiles, (String)"testKtFiles");
        Intrinsics.checkNotNullParameter(binaryRoots, (String)"binaryRoots");
        Intrinsics.checkNotNullParameter(sharedBinaryRoots, (String)"sharedBinaryRoots");
        this.project = project;
        this.index = new KotlinStaticDeclarationIndex();
        PsiManager psiManager = PsiManager.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        this.psiManager = psiManager;
        this.builtInDecompiler = new KotlinBuiltInDecompiler();
        this.createdFakeKtFiles = new ArrayList();
        KtDeclarationRecorder recorder = new KtDeclarationRecorder();
        Set builtins = new LinkedHashSet();
        if (!skipBuiltins) {
            $this$forEach$iv = this.loadBuiltIns();
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                KotlinFileStubImpl stub = (KotlinFileStubImpl)element$iv;
                boolean bl = false;
                this.processStub(stub);
                String string2 = ((KtFile)stub.getPsi()).getVirtualFile().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                builtins.add(string2);
            }
        }
        if (shouldBuildStubsForBinaryLibraries) {
            void $this$forEach$iv2;
            Iterator $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Object element$iv;
            ClsKotlinBinaryClassCache binaryClassCache = ClsKotlinBinaryClassCache.Companion.getInstance();
            for (VirtualFile virtualFile : sharedBinaryRoots) {
                element$iv = KotlinFakeClsStubsCache.Companion.processAdditionalRoot(virtualFile, (Function1<? super VirtualFile, ? extends Map<VirtualFile, KotlinFileStubImpl>>)((Function1)arg_0 -> KotlinStaticDeclarationProviderFactory._init_$lambda$16(this, binaryClassCache, arg_0)));
                if (element$iv == null) continue;
                Object p0 = element$iv;
                boolean bl2 = false;
                this.processCollectedStubs((Map<VirtualFile, KotlinFileStubImpl>)p0);
            }
            Iterable $i$f$forEach2 = binaryRoots;
            boolean bl = false;
            element$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator bl2 = $this$mapTo$iv$iv.iterator();
            while (bl2.hasNext()) {
                void it;
                Object item$iv$iv = bl2.next();
                VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl22 = false;
                collection.add(this.collectStubsFromBinaryRoot((VirtualFile)it, binaryClassCache));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean bl3 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Map it = (Map)element$iv2;
                boolean bl32 = false;
                this.processCollectedStubs(it);
            }
        }
        $this$forEach$iv = testKtFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtFile file2 = (KtFile)element$iv;
            boolean bl = false;
            file2.accept(recorder);
        }
    }

    public /* synthetic */ KotlinStaticDeclarationProviderFactory(Project project, Collection collection, List list, List list2, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        if ((n & 0x20) != 0) {
            bl2 = false;
        }
        this(project, collection, list, list2, bl, bl2);
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<KotlinFileStubImpl> loadBuiltIns() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = BuiltInsVirtualFileProvider.Companion.getInstance().getBuiltInVirtualFiles();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KotlinFileStubImpl it$iv$iv;
            FileContent fileContent;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            VirtualFile virtualFile = (VirtualFile)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)FileContentImpl.createByFile(virtualFile, this.project), (String)"createByFile(...)");
            if (this.createKtFileStub(this.psiManager, this.builtInDecompiler, fileContent) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final KotlinFileStubImpl createKtFileStub(PsiManager psiManager, KotlinBuiltInDecompiler builtInDecompiler, FileContent fileContent) {
        UserDataHolder userDataHolder = builtInDecompiler.getStubBuilder().buildFileStub(fileContent);
        KotlinFileStubImpl kotlinFileStubImpl = userDataHolder instanceof KotlinFileStubImpl ? (KotlinFileStubImpl)userDataHolder : null;
        if (kotlinFileStubImpl == null) {
            return null;
        }
        KotlinFileStubImpl ktFileStub = kotlinFileStubImpl;
        VirtualFile virtualFile = fileContent.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        userDataHolder = new KtClassFileViewProvider(psiManager, virtualFile);
        KtFile fakeFile2 = new KtFile(ktFileStub, (KtClassFileViewProvider)userDataHolder){
            final /* synthetic */ KotlinFileStubImpl $ktFileStub;
            {
                this.$ktFileStub = $ktFileStub;
                super((FileViewProvider)$super_call_param$1, true);
            }

            public KotlinFileStubImpl getStub() {
                return this.$ktFileStub;
            }

            public boolean isPhysical() {
                return false;
            }
        };
        ktFileStub.setPsi((PsiFile)fakeFile2);
        this.createdFakeKtFiles.add(fakeFile2);
        return ktFileStub;
    }

    private final void addToFacadeFileMap(KtFile file2) {
        if (!file2.hasTopLevelCallables()) {
            return;
        }
        this.index.getFacadeFileMap$analysis_api_providers().computeIfAbsent(file2.getPackageFqName(), arg_0 -> KotlinStaticDeclarationProviderFactory.addToFacadeFileMap$lambda$2(KotlinStaticDeclarationProviderFactory::addToFacadeFileMap$lambda$1, arg_0)).add(file2);
    }

    private final void addToScriptMap(KtScript script) {
        this.index.getScriptMap$analysis_api_providers().computeIfAbsent(script.getFqName(), arg_0 -> KotlinStaticDeclarationProviderFactory.addToScriptMap$lambda$4(KotlinStaticDeclarationProviderFactory::addToScriptMap$lambda$3, arg_0)).add(script);
    }

    private final void addToClassMap(KtClassOrObject classOrObject) {
        block0: {
            ClassId classId = classOrObject.getClassId();
            if (classId == null) break block0;
            ClassId classId2 = classId;
            boolean bl = false;
            this.index.getClassMap$analysis_api_providers().computeIfAbsent(classId2.getPackageFqName(), arg_0 -> KotlinStaticDeclarationProviderFactory.addToClassMap$lambda$7$lambda$6(KotlinStaticDeclarationProviderFactory::addToClassMap$lambda$7$lambda$5, arg_0)).add(classOrObject);
        }
    }

    private final void addToTypeAliasMap(KtTypeAlias typeAlias) {
        block0: {
            ClassId classId = typeAlias.getClassId();
            if (classId == null) break block0;
            ClassId classId2 = classId;
            boolean bl = false;
            this.index.getTypeAliasMap$analysis_api_providers().computeIfAbsent(classId2.getPackageFqName(), arg_0 -> KotlinStaticDeclarationProviderFactory.addToTypeAliasMap$lambda$10$lambda$9(KotlinStaticDeclarationProviderFactory::addToTypeAliasMap$lambda$10$lambda$8, arg_0)).add(typeAlias);
        }
    }

    private final void addToFunctionMap(KtNamedFunction function2) {
        if (!function2.isTopLevel()) {
            return;
        }
        PsiElement psiElement = function2.getParent();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        FqName packageFqName = ((KtFile)psiElement).getPackageFqName();
        this.index.getTopLevelFunctionMap$analysis_api_providers().computeIfAbsent(packageFqName, arg_0 -> KotlinStaticDeclarationProviderFactory.addToFunctionMap$lambda$12(KotlinStaticDeclarationProviderFactory::addToFunctionMap$lambda$11, arg_0)).add(function2);
    }

    private final void addToPropertyMap(KtProperty property) {
        if (!property.isTopLevel()) {
            return;
        }
        PsiElement psiElement = property.getParent();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        FqName packageFqName = ((KtFile)psiElement).getPackageFqName();
        this.index.getTopLevelPropertyMap$analysis_api_providers().computeIfAbsent(packageFqName, arg_0 -> KotlinStaticDeclarationProviderFactory.addToPropertyMap$lambda$14(KotlinStaticDeclarationProviderFactory::addToPropertyMap$lambda$13, arg_0)).add(property);
    }

    /*
     * WARNING - void declaration
     */
    private final void indexStub(StubElement<?> stub) {
        block5: {
            void $this$filterIsInstanceTo$iv$iv;
            StubElement<?> stubElement;
            block9: {
                block8: {
                    block7: {
                        block6: {
                            block4: {
                                stubElement = stub;
                                if (!(stubElement instanceof KotlinClassStubImpl)) break block4;
                                Object t = ((KotlinClassStubImpl)stub).getPsi();
                                Intrinsics.checkNotNullExpressionValue(t, (String)"getPsi(...)");
                                this.addToClassMap((KtClassOrObject)t);
                                List<StubElement> list = ((KotlinClassStubImpl)stub).getChildrenStubs();
                                Intrinsics.checkNotNullExpressionValue(list, (String)"getChildrenStubs(...)");
                                Iterable $this$forEach$iv = list;
                                boolean $i$f$forEach = false;
                                for (Object element$iv : $this$forEach$iv) {
                                    StubElement p0 = (StubElement)element$iv;
                                    boolean bl = false;
                                    this.indexStub(p0);
                                }
                                break block5;
                            }
                            if (!(stubElement instanceof KotlinObjectStubImpl)) break block6;
                            Object t = ((KotlinObjectStubImpl)stub).getPsi();
                            Intrinsics.checkNotNullExpressionValue(t, (String)"getPsi(...)");
                            this.addToClassMap((KtClassOrObject)t);
                            List<StubElement> list = ((KotlinObjectStubImpl)stub).getChildrenStubs();
                            Intrinsics.checkNotNullExpressionValue(list, (String)"getChildrenStubs(...)");
                            Iterable $this$forEach$iv = list;
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                StubElement p0 = (StubElement)element$iv;
                                boolean bl = false;
                                this.indexStub(p0);
                            }
                            break block5;
                        }
                        if (!(stubElement instanceof KotlinTypeAliasStubImpl)) break block7;
                        Object t = ((KotlinTypeAliasStubImpl)stub).getPsi();
                        Intrinsics.checkNotNullExpressionValue(t, (String)"getPsi(...)");
                        this.addToTypeAliasMap((KtTypeAlias)t);
                        break block5;
                    }
                    if (!(stubElement instanceof KotlinFunctionStubImpl)) break block8;
                    Object t = ((KotlinFunctionStubImpl)stub).getPsi();
                    Intrinsics.checkNotNullExpressionValue(t, (String)"getPsi(...)");
                    this.addToFunctionMap((KtNamedFunction)t);
                    break block5;
                }
                if (!(stubElement instanceof KotlinPropertyStubImpl)) break block9;
                Object t = ((KotlinPropertyStubImpl)stub).getPsi();
                Intrinsics.checkNotNullExpressionValue(t, (String)"getPsi(...)");
                this.addToPropertyMap((KtProperty)t);
                break block5;
            }
            if (!(stubElement instanceof KotlinPlaceHolderStubImpl) || !Intrinsics.areEqual((Object)((KotlinPlaceHolderStubImpl)stub).getStubType(), KtStubElementTypes.CLASS_BODY)) break block5;
            List<StubElement> list = ((KotlinPlaceHolderStubImpl)stub).getChildrenStubs();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getChildrenStubs(...)");
            Iterable $this$filterIsInstance$iv = list;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof KotlinClassOrObjectStub)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                StubElement p0 = (StubElement)element$iv;
                boolean bl = false;
                this.indexStub(p0);
            }
        }
    }

    private final void processStub(KotlinFileStubImpl ktFileStub) {
        PsiElement psiElement = ktFileStub.getPsi();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsi(...)");
        KtFile ktFile = (KtFile)psiElement;
        this.addToFacadeFileMap(ktFile);
        List<String> partNames = ktFileStub.getFacadePartSimpleNames();
        if (partNames != null) {
            FqName packageFqName = ktFileStub.getPackageFqName();
            for (String partName : partNames) {
                FqName multiFileClassPartFqName;
                Intrinsics.checkNotNullExpressionValue((Object)packageFqName.child(Name.identifier(partName)), (String)"child(...)");
                this.index.getMultiFileClassPartMap$analysis_api_providers().computeIfAbsent(multiFileClassPartFqName, arg_0 -> KotlinStaticDeclarationProviderFactory.processStub$lambda$24(KotlinStaticDeclarationProviderFactory::processStub$lambda$23, arg_0)).add(ktFile);
            }
        }
        List<StubElement> list = ktFileStub.getChildrenStubs();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getChildrenStubs(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StubElement p0 = (StubElement)element$iv;
            boolean bl = false;
            this.indexStub(p0);
        }
    }

    private final Map<VirtualFile, KotlinFileStubImpl> collectStubsFromBinaryRoot(VirtualFile binaryRoot, ClsKotlinBinaryClassCache binaryClassCache) {
        Map map;
        Map $this$collectStubsFromBinaryRoot_u24lambda_u2426 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        VirtualFileVisitor.Option[] optionArray = new VirtualFileVisitor.Option[]{};
        VfsUtilCore.visitChildrenRecursively(binaryRoot, new VirtualFileVisitor<Void>(this, binaryClassCache, (Map<VirtualFile, KotlinFileStubImpl>)$this$collectStubsFromBinaryRoot_u24lambda_u2426, optionArray){
            final /* synthetic */ KotlinStaticDeclarationProviderFactory this$0;
            final /* synthetic */ ClsKotlinBinaryClassCache $binaryClassCache;
            final /* synthetic */ Map<VirtualFile, KotlinFileStubImpl> $this_buildMap;
            {
                this.this$0 = $receiver;
                this.$binaryClassCache = $binaryClassCache;
                this.$this_buildMap = $receiver2;
                super($super_call_param$1);
            }

            public boolean visitFile(VirtualFile file2) {
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                if (!file2.isDirectory()) {
                    KotlinFileStubImpl kotlinFileStubImpl = KotlinStaticDeclarationProviderFactory.access$buildStubByVirtualFile(this.this$0, file2, this.$binaryClassCache);
                    if (kotlinFileStubImpl == null) {
                        return true;
                    }
                    KotlinFileStubImpl stub = kotlinFileStubImpl;
                    this.$this_buildMap.put(file2, stub);
                }
                return true;
            }
        });
        return MapsKt.build((Map)map);
    }

    private final KotlinFileStubImpl buildStubByVirtualFile(VirtualFile file2, ClsKotlinBinaryClassCache binaryClassCache) {
        ClsStubBuilder clsStubBuilder;
        FileContent fileContent = FileContentImpl.createByFile(file2);
        Intrinsics.checkNotNullExpressionValue((Object)fileContent, (String)"createByFile(...)");
        FileContent fileContent2 = fileContent;
        FileType fileType = file2.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
        FileType fileType2 = fileType;
        if (binaryClassCache.isKotlinJvmCompiledFile(file2, fileContent2.getContent()) && Intrinsics.areEqual((Object)fileType2, (Object)JavaClassFileType.INSTANCE)) {
            clsStubBuilder = new KotlinClsStubBuilder();
        } else if (Intrinsics.areEqual((Object)fileType2, (Object)KotlinBuiltInFileType.INSTANCE) && !Intrinsics.areEqual((Object)file2.getExtension(), (Object)"kotlin_builtins")) {
            clsStubBuilder = this.builtInDecompiler.getStubBuilder();
        } else if (Intrinsics.areEqual((Object)fileType2, (Object)KlibMetaFileType.INSTANCE)) {
            clsStubBuilder = new K2KotlinNativeMetadataDecompiler().getStubBuilder();
        } else {
            return null;
        }
        ClsStubBuilder stubBuilder = clsStubBuilder;
        PsiFileStub<?> psiFileStub = stubBuilder.buildFileStub(fileContent2);
        return psiFileStub instanceof KotlinFileStubImpl ? (KotlinFileStubImpl)psiFileStub : null;
    }

    private final void processCollectedStubs(Map<VirtualFile, KotlinFileStubImpl> stubs) {
        Map<VirtualFile, KotlinFileStubImpl> $this$forEach$iv = stubs;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<VirtualFile, KotlinFileStubImpl>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<VirtualFile, KotlinFileStubImpl> element$iv;
            Map.Entry<VirtualFile, KotlinFileStubImpl> entry = element$iv = iterator2.next();
            boolean bl = false;
            KotlinFileStubImpl stub = entry.getValue();
            KtClassFileViewProvider ktClassFileViewProvider = new KtClassFileViewProvider(this.psiManager, entry.getKey());
            KtFile fakeFile2 = new KtFile(stub, ktClassFileViewProvider){
                final /* synthetic */ KotlinFileStubImpl $stub;
                {
                    this.$stub = $stub;
                    super((FileViewProvider)$super_call_param$1, true);
                }

                public KotlinFileStubImpl getStub() {
                    return this.$stub;
                }

                public boolean isPhysical() {
                    return false;
                }
            };
            stub.setPsi((PsiFile)fakeFile2);
            this.createdFakeKtFiles.add(fakeFile2);
            this.processStub(stub);
        }
    }

    @Override
    @NotNull
    public KotlinDeclarationProvider createDeclarationProvider(@NotNull GlobalSearchScope scope2, @Nullable KtModule contextualModule) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        return new KotlinStaticDeclarationProvider(this.index, scope2);
    }

    @NotNull
    public final List<KtFile> getAdditionalCreatedKtFiles() {
        return this.createdFakeKtFiles;
    }

    @NotNull
    public final List<KtClassOrObject> getAllKtClasses() {
        return (List)AddToStdlibKt.flattenTo((Iterable)this.index.getClassMap$analysis_api_providers().values(), (Collection)new ArrayList());
    }

    private static final Set addToFacadeFileMap$lambda$1(FqName it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new LinkedHashSet();
    }

    private static final Set addToFacadeFileMap$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Set)$tmp0.invoke(p0);
    }

    private static final Set addToScriptMap$lambda$3(FqName it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new LinkedHashSet();
    }

    private static final Set addToScriptMap$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Set)$tmp0.invoke(p0);
    }

    private static final Set addToClassMap$lambda$7$lambda$5(FqName it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new LinkedHashSet();
    }

    private static final Set addToClassMap$lambda$7$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Set)$tmp0.invoke(p0);
    }

    private static final Set addToTypeAliasMap$lambda$10$lambda$8(FqName it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new LinkedHashSet();
    }

    private static final Set addToTypeAliasMap$lambda$10$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Set)$tmp0.invoke(p0);
    }

    private static final Set addToFunctionMap$lambda$11(FqName it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new LinkedHashSet();
    }

    private static final Set addToFunctionMap$lambda$12(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Set)$tmp0.invoke(p0);
    }

    private static final Set addToPropertyMap$lambda$13(FqName it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new LinkedHashSet();
    }

    private static final Set addToPropertyMap$lambda$14(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Set)$tmp0.invoke(p0);
    }

    private static final Map _init_$lambda$16(KotlinStaticDeclarationProviderFactory this$0, ClsKotlinBinaryClassCache $binaryClassCache, VirtualFile additionalRoot) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$binaryClassCache, (String)"$binaryClassCache");
        Intrinsics.checkNotNullParameter((Object)additionalRoot, (String)"additionalRoot");
        return this$0.collectStubsFromBinaryRoot(additionalRoot, $binaryClassCache);
    }

    private static final Set processStub$lambda$23(FqName it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new LinkedHashSet();
    }

    private static final Set processStub$lambda$24(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Set)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ KotlinFileStubImpl access$buildStubByVirtualFile(KotlinStaticDeclarationProviderFactory $this, VirtualFile file2, ClsKotlinBinaryClassCache binaryClassCache) {
        return $this.buildStubByVirtualFile(file2, binaryClassCache);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/analysis/providers/impl/KotlinStaticDeclarationProviderFactory$KtClassFileViewProvider;", "Lorg/jetbrains/kotlin/com/intellij/psi/SingleRootFileViewProvider;", "psiManager", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiManager;", "virtualFile", "Lorg/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/psi/PsiManager;Lcom/intellij/openapi/vfs/VirtualFile;)V", "analysis-api-providers"})
    private static final class KtClassFileViewProvider
    extends SingleRootFileViewProvider {
        public KtClassFileViewProvider(@NotNull PsiManager psiManager, @NotNull VirtualFile virtualFile) {
            Intrinsics.checkNotNullParameter((Object)psiManager, (String)"psiManager");
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            super(psiManager, virtualFile, true, KotlinLanguage.INSTANCE);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/analysis/providers/impl/KotlinStaticDeclarationProviderFactory$KtDeclarationRecorder;", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "<init>", "(Lorg/jetbrains/kotlin/analysis/providers/impl/KotlinStaticDeclarationProviderFactory;)V", "visitElement", "", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "visitKtFile", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "visitClassOrObject", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "visitTypeAlias", "typeAlias", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "analysis-api-providers"})
    @SourceDebugExtension(value={"SMAP\nKotlinStaticDeclarationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinStaticDeclarationProvider.kt\norg/jetbrains/kotlin/analysis/providers/impl/KotlinStaticDeclarationProviderFactory$KtDeclarationRecorder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,436:1\n1#2:437\n*E\n"})
    private final class KtDeclarationRecorder
    extends KtVisitorVoid {
        @Override
        public void visitElement(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            element.acceptChildren(this);
        }

        @Override
        public void visitKtFile(@NotNull KtFile file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            KotlinStaticDeclarationProviderFactory.this.addToFacadeFileMap(file2);
            KtScript ktScript = file2.getScript();
            if (ktScript != null) {
                KtScript ktScript2 = ktScript;
                KotlinStaticDeclarationProviderFactory kotlinStaticDeclarationProviderFactory = KotlinStaticDeclarationProviderFactory.this;
                KtScript it = ktScript2;
                boolean bl = false;
                kotlinStaticDeclarationProviderFactory.addToScriptMap(it);
            }
            super.visitKtFile(file2);
        }

        @Override
        public void visitClassOrObject(@NotNull KtClassOrObject classOrObject) {
            Intrinsics.checkNotNullParameter((Object)classOrObject, (String)"classOrObject");
            KotlinStaticDeclarationProviderFactory.this.addToClassMap(classOrObject);
            super.visitClassOrObject(classOrObject);
        }

        @Override
        public void visitTypeAlias(@NotNull KtTypeAlias typeAlias) {
            Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
            KotlinStaticDeclarationProviderFactory.this.addToTypeAliasMap(typeAlias);
            super.visitTypeAlias(typeAlias);
        }

        @Override
        public void visitNamedFunction(@NotNull KtNamedFunction function2) {
            Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
            KotlinStaticDeclarationProviderFactory.this.addToFunctionMap(function2);
            super.visitNamedFunction(function2);
        }

        @Override
        public void visitProperty(@NotNull KtProperty property) {
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            KotlinStaticDeclarationProviderFactory.this.addToPropertyMap(property);
            super.visitProperty(property);
        }
    }
}

