/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.org.objectweb.asm;

import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.ByteVector;
import org.jetbrains.org.objectweb.asm.Symbol;
import org.jetbrains.org.objectweb.asm.SymbolTable;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.TypePath;
import org.jetbrains.org.objectweb.asm.TypeReference;

final class AnnotationWriter
extends AnnotationVisitor {
    private final SymbolTable symbolTable;
    private final boolean useNamedValues;
    private final ByteVector annotation;
    private final int numElementValuePairsOffset;
    private int numElementValuePairs;
    private final AnnotationWriter previousAnnotation;
    private AnnotationWriter nextAnnotation;

    AnnotationWriter(SymbolTable symbolTable, boolean useNamedValues, ByteVector annotation2, AnnotationWriter previousAnnotation) {
        super(589824);
        this.symbolTable = symbolTable;
        this.useNamedValues = useNamedValues;
        this.annotation = annotation2;
        this.numElementValuePairsOffset = annotation2.length == 0 ? -1 : annotation2.length - 2;
        this.previousAnnotation = previousAnnotation;
        if (previousAnnotation != null) {
            previousAnnotation.nextAnnotation = this;
        }
    }

    static AnnotationWriter create(SymbolTable symbolTable, String descriptor2, AnnotationWriter previousAnnotation) {
        ByteVector annotation2 = new ByteVector();
        annotation2.putShort(symbolTable.addConstantUtf8(descriptor2)).putShort(0);
        return new AnnotationWriter(symbolTable, true, annotation2, previousAnnotation);
    }

    static AnnotationWriter create(SymbolTable symbolTable, int typeRef, TypePath typePath, String descriptor2, AnnotationWriter previousAnnotation) {
        ByteVector typeAnnotation = new ByteVector();
        TypeReference.putTarget(typeRef, typeAnnotation);
        TypePath.put(typePath, typeAnnotation);
        typeAnnotation.putShort(symbolTable.addConstantUtf8(descriptor2)).putShort(0);
        return new AnnotationWriter(symbolTable, true, typeAnnotation, previousAnnotation);
    }

    public void visit(String name2, Object value2) {
        ++this.numElementValuePairs;
        if (this.useNamedValues) {
            this.annotation.putShort(this.symbolTable.addConstantUtf8(name2));
        }
        if (value2 instanceof String) {
            this.annotation.put12(115, this.symbolTable.addConstantUtf8((String)value2));
        } else if (value2 instanceof Byte) {
            this.annotation.put12(66, this.symbolTable.addConstantInteger((int)((Byte)value2).byteValue()).index);
        } else if (value2 instanceof Boolean) {
            int booleanValue = (Boolean)value2 != false ? 1 : 0;
            this.annotation.put12(90, this.symbolTable.addConstantInteger((int)booleanValue).index);
        } else if (value2 instanceof Character) {
            this.annotation.put12(67, this.symbolTable.addConstantInteger((int)((Character)value2).charValue()).index);
        } else if (value2 instanceof Short) {
            this.annotation.put12(83, this.symbolTable.addConstantInteger((int)((Short)value2).shortValue()).index);
        } else if (value2 instanceof Type) {
            this.annotation.put12(99, this.symbolTable.addConstantUtf8(((Type)value2).getDescriptor()));
        } else if (value2 instanceof byte[]) {
            byte[] byteArray2 = (byte[])value2;
            this.annotation.put12(91, byteArray2.length);
            for (byte byteValue : byteArray2) {
                this.annotation.put12(66, this.symbolTable.addConstantInteger((int)byteValue).index);
            }
        } else if (value2 instanceof boolean[]) {
            boolean[] booleanArray2 = (boolean[])value2;
            this.annotation.put12(91, booleanArray2.length);
            for (boolean booleanValue : booleanArray2) {
                this.annotation.put12(90, this.symbolTable.addConstantInteger((int)(booleanValue ? 1 : 0)).index);
            }
        } else if (value2 instanceof short[]) {
            short[] shortArray2 = (short[])value2;
            this.annotation.put12(91, shortArray2.length);
            for (short shortValue : shortArray2) {
                this.annotation.put12(83, this.symbolTable.addConstantInteger((int)shortValue).index);
            }
        } else if (value2 instanceof char[]) {
            char[] charArray2 = (char[])value2;
            this.annotation.put12(91, charArray2.length);
            for (char charValue : charArray2) {
                this.annotation.put12(67, this.symbolTable.addConstantInteger((int)charValue).index);
            }
        } else if (value2 instanceof int[]) {
            int[] intArray2 = (int[])value2;
            this.annotation.put12(91, intArray2.length);
            for (int intValue : intArray2) {
                this.annotation.put12(73, this.symbolTable.addConstantInteger((int)intValue).index);
            }
        } else if (value2 instanceof long[]) {
            long[] longArray2 = (long[])value2;
            this.annotation.put12(91, longArray2.length);
            for (long longValue : longArray2) {
                this.annotation.put12(74, this.symbolTable.addConstantLong((long)longValue).index);
            }
        } else if (value2 instanceof float[]) {
            float[] floatArray2 = (float[])value2;
            this.annotation.put12(91, floatArray2.length);
            for (float floatValue : floatArray2) {
                this.annotation.put12(70, this.symbolTable.addConstantFloat((float)floatValue).index);
            }
        } else if (value2 instanceof double[]) {
            double[] doubleArray2 = (double[])value2;
            this.annotation.put12(91, doubleArray2.length);
            for (double doubleValue : doubleArray2) {
                this.annotation.put12(68, this.symbolTable.addConstantDouble((double)doubleValue).index);
            }
        } else {
            Symbol symbol2 = this.symbolTable.addConstant(value2);
            this.annotation.put12(".s.IFJDCS".charAt(symbol2.tag), symbol2.index);
        }
    }

    public void visitEnum(String name2, String descriptor2, String value2) {
        ++this.numElementValuePairs;
        if (this.useNamedValues) {
            this.annotation.putShort(this.symbolTable.addConstantUtf8(name2));
        }
        this.annotation.put12(101, this.symbolTable.addConstantUtf8(descriptor2)).putShort(this.symbolTable.addConstantUtf8(value2));
    }

    public AnnotationVisitor visitAnnotation(String name2, String descriptor2) {
        ++this.numElementValuePairs;
        if (this.useNamedValues) {
            this.annotation.putShort(this.symbolTable.addConstantUtf8(name2));
        }
        this.annotation.put12(64, this.symbolTable.addConstantUtf8(descriptor2)).putShort(0);
        return new AnnotationWriter(this.symbolTable, true, this.annotation, null);
    }

    public AnnotationVisitor visitArray(String name2) {
        ++this.numElementValuePairs;
        if (this.useNamedValues) {
            this.annotation.putShort(this.symbolTable.addConstantUtf8(name2));
        }
        this.annotation.put12(91, 0);
        return new AnnotationWriter(this.symbolTable, false, this.annotation, null);
    }

    public void visitEnd() {
        if (this.numElementValuePairsOffset != -1) {
            byte[] data2 = this.annotation.data;
            data2[this.numElementValuePairsOffset] = (byte)(this.numElementValuePairs >>> 8);
            data2[this.numElementValuePairsOffset + 1] = (byte)this.numElementValuePairs;
        }
    }

    int computeAnnotationsSize(String attributeName) {
        if (attributeName != null) {
            this.symbolTable.addConstantUtf8(attributeName);
        }
        int attributeSize = 8;
        AnnotationWriter annotationWriter = this;
        while (annotationWriter != null) {
            attributeSize += annotationWriter.annotation.length;
            annotationWriter = annotationWriter.previousAnnotation;
        }
        return attributeSize;
    }

    static int computeAnnotationsSize(AnnotationWriter lastRuntimeVisibleAnnotation, AnnotationWriter lastRuntimeInvisibleAnnotation, AnnotationWriter lastRuntimeVisibleTypeAnnotation, AnnotationWriter lastRuntimeInvisibleTypeAnnotation) {
        int size = 0;
        if (lastRuntimeVisibleAnnotation != null) {
            size += lastRuntimeVisibleAnnotation.computeAnnotationsSize("RuntimeVisibleAnnotations");
        }
        if (lastRuntimeInvisibleAnnotation != null) {
            size += lastRuntimeInvisibleAnnotation.computeAnnotationsSize("RuntimeInvisibleAnnotations");
        }
        if (lastRuntimeVisibleTypeAnnotation != null) {
            size += lastRuntimeVisibleTypeAnnotation.computeAnnotationsSize("RuntimeVisibleTypeAnnotations");
        }
        if (lastRuntimeInvisibleTypeAnnotation != null) {
            size += lastRuntimeInvisibleTypeAnnotation.computeAnnotationsSize("RuntimeInvisibleTypeAnnotations");
        }
        return size;
    }

    void putAnnotations(int attributeNameIndex, ByteVector output2) {
        int attributeLength = 2;
        int numAnnotations = 0;
        AnnotationWriter annotationWriter = this;
        AnnotationWriter firstAnnotation = null;
        while (annotationWriter != null) {
            annotationWriter.visitEnd();
            attributeLength += annotationWriter.annotation.length;
            ++numAnnotations;
            firstAnnotation = annotationWriter;
            annotationWriter = annotationWriter.previousAnnotation;
        }
        output2.putShort(attributeNameIndex);
        output2.putInt(attributeLength);
        output2.putShort(numAnnotations);
        annotationWriter = firstAnnotation;
        while (annotationWriter != null) {
            output2.putByteArray(annotationWriter.annotation.data, 0, annotationWriter.annotation.length);
            annotationWriter = annotationWriter.nextAnnotation;
        }
    }

    static void putAnnotations(SymbolTable symbolTable, AnnotationWriter lastRuntimeVisibleAnnotation, AnnotationWriter lastRuntimeInvisibleAnnotation, AnnotationWriter lastRuntimeVisibleTypeAnnotation, AnnotationWriter lastRuntimeInvisibleTypeAnnotation, ByteVector output2) {
        if (lastRuntimeVisibleAnnotation != null) {
            lastRuntimeVisibleAnnotation.putAnnotations(symbolTable.addConstantUtf8("RuntimeVisibleAnnotations"), output2);
        }
        if (lastRuntimeInvisibleAnnotation != null) {
            lastRuntimeInvisibleAnnotation.putAnnotations(symbolTable.addConstantUtf8("RuntimeInvisibleAnnotations"), output2);
        }
        if (lastRuntimeVisibleTypeAnnotation != null) {
            lastRuntimeVisibleTypeAnnotation.putAnnotations(symbolTable.addConstantUtf8("RuntimeVisibleTypeAnnotations"), output2);
        }
        if (lastRuntimeInvisibleTypeAnnotation != null) {
            lastRuntimeInvisibleTypeAnnotation.putAnnotations(symbolTable.addConstantUtf8("RuntimeInvisibleTypeAnnotations"), output2);
        }
    }

    static int computeParameterAnnotationsSize(String attributeName, AnnotationWriter[] annotationWriters, int annotableParameterCount) {
        int attributeSize = 7 + 2 * annotableParameterCount;
        for (int i = 0; i < annotableParameterCount; ++i) {
            AnnotationWriter annotationWriter = annotationWriters[i];
            attributeSize += annotationWriter == null ? 0 : annotationWriter.computeAnnotationsSize(attributeName) - 8;
        }
        return attributeSize;
    }

    static void putParameterAnnotations(int attributeNameIndex, AnnotationWriter[] annotationWriters, int annotableParameterCount, ByteVector output2) {
        AnnotationWriter annotationWriter;
        int i;
        int attributeLength = 1 + 2 * annotableParameterCount;
        for (i = 0; i < annotableParameterCount; ++i) {
            annotationWriter = annotationWriters[i];
            attributeLength += annotationWriter == null ? 0 : annotationWriter.computeAnnotationsSize(null) - 8;
        }
        output2.putShort(attributeNameIndex);
        output2.putInt(attributeLength);
        output2.putByte(annotableParameterCount);
        for (i = 0; i < annotableParameterCount; ++i) {
            annotationWriter = annotationWriters[i];
            AnnotationWriter firstAnnotation = null;
            int numAnnotations = 0;
            while (annotationWriter != null) {
                annotationWriter.visitEnd();
                ++numAnnotations;
                firstAnnotation = annotationWriter;
                annotationWriter = annotationWriter.previousAnnotation;
            }
            output2.putShort(numAnnotations);
            annotationWriter = firstAnnotation;
            while (annotationWriter != null) {
                output2.putByteArray(annotationWriter.annotation.data, 0, annotationWriter.annotation.length);
                annotationWriter = annotationWriter.nextAnnotation;
            }
        }
    }
}

