/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.google.common.collect.Maps;
import org.jetbrains.kotlin.com.google.common.collect.Sets;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.SmartHashSet;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilityUtils;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.Substitutable;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactoryWithPsiElement;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.rendering.DeclarationWithDiagnosticComponents;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.PlatformSpecificDiagnosticComponents;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DataClassDescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.OverridesBackwardCompatibilityHelper;
import org.jetbrains.kotlin.resolve.OverridingUtil;
import org.jetbrains.kotlin.resolve.TopDownAnalysisContext;
import org.jetbrains.kotlin.resolve.calls.util.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.IndexedParametersSubstitution;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeRefiner;
import org.jetbrains.kotlin.types.checker.NewKotlinTypeCheckerImpl;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 32\u00020\u0001:\u0007-./0123B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001aH\u0002J\u0010\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001aH\u0002J\u0010\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010 \u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J \u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010(\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010)\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lorg/jetbrains/kotlin/resolve/OverrideResolver;", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "overridesBackwardCompatibilityHelper", "Lorg/jetbrains/kotlin/resolve/OverridesBackwardCompatibilityHelper;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "kotlinTypeRefiner", "Lorg/jetbrains/kotlin/types/checker/KotlinTypeRefiner;", "platformSpecificDiagnosticComponents", "Lorg/jetbrains/kotlin/platform/PlatformSpecificDiagnosticComponents;", "<init>", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/resolve/OverridesBackwardCompatibilityHelper;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/types/checker/KotlinTypeRefiner;Lorg/jetbrains/kotlin/platform/PlatformSpecificDiagnosticComponents;)V", "check", "", "c", "Lorg/jetbrains/kotlin/resolve/TopDownAnalysisContext;", "checkOverrides", "checkOverridesInAClass", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptorWithResolutionScopes;", "klass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "checkOverrideForMember", "declared", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "checkOverrideForComponentFunction", "componentFunction", "checkOverrideForCopyFunction", "copyFunction", "checkParameterOverridesForAllClasses", "checkOverridesForParameters", "checkNameAndDefaultForDeclaredParameter", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "multipleDefaultsInSuper", "", "checkNameAndDefaultForFakeOverrideParameter", "containingFunction", "checkVisibility", "checkVisibilityForMember", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "memberDescriptor", "CheckInheritedSignaturesReportStrategy", "CollectMissingImplementationsStrategy", "CollectWarningInformationForInheritedMembersStrategy", "CollectErrorInformationForInheritedMembersStrategy", "CheckOverrideReportStrategy", "CheckOverrideReportForDeclaredMemberStrategy", "Companion", "frontend"})
public final class OverrideResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BindingTrace trace;
    @NotNull
    private final OverridesBackwardCompatibilityHelper overridesBackwardCompatibilityHelper;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final KotlinTypeRefiner kotlinTypeRefiner;
    @NotNull
    private final PlatformSpecificDiagnosticComponents platformSpecificDiagnosticComponents;

    public OverrideResolver(@NotNull BindingTrace trace, @NotNull OverridesBackwardCompatibilityHelper overridesBackwardCompatibilityHelper, @NotNull LanguageVersionSettings languageVersionSettings2, @NotNull KotlinTypeRefiner kotlinTypeRefiner, @NotNull PlatformSpecificDiagnosticComponents platformSpecificDiagnosticComponents) {
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)overridesBackwardCompatibilityHelper, (String)"overridesBackwardCompatibilityHelper");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings2, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)kotlinTypeRefiner, (String)"kotlinTypeRefiner");
        Intrinsics.checkNotNullParameter((Object)platformSpecificDiagnosticComponents, (String)"platformSpecificDiagnosticComponents");
        this.trace = trace;
        this.overridesBackwardCompatibilityHelper = overridesBackwardCompatibilityHelper;
        this.languageVersionSettings = languageVersionSettings2;
        this.kotlinTypeRefiner = kotlinTypeRefiner;
        this.platformSpecificDiagnosticComponents = platformSpecificDiagnosticComponents;
    }

    public final void check(@NotNull TopDownAnalysisContext c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        this.checkVisibility(c);
        this.checkOverrides(c);
        this.checkParameterOverridesForAllClasses(c);
    }

    private final void checkOverrides(TopDownAnalysisContext c) {
        Map<KtClassOrObject, ClassDescriptorWithResolutionScopes> map = c.getDeclaredClasses();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getDeclaredClasses(...)");
        for (Map.Entry<KtClassOrObject, ClassDescriptorWithResolutionScopes> entry : map.entrySet()) {
            KtClassOrObject key = entry.getKey();
            ClassDescriptorWithResolutionScopes value2 = entry.getValue();
            Intrinsics.checkNotNull((Object)value2);
            Intrinsics.checkNotNull((Object)key);
            this.checkOverridesInAClass(value2, key);
        }
    }

    private final void checkOverridesInAClass(ClassDescriptorWithResolutionScopes classDescriptor2, KtClassOrObject klass) {
        for (CallableMemberDescriptor member2 : classDescriptor2.getDeclaredCallableMembers()) {
            Intrinsics.checkNotNull((Object)member2);
            this.checkOverrideForMember(member2);
        }
        CollectErrorInformationForInheritedMembersStrategy inheritedMemberErrors = new CollectErrorInformationForInheritedMembersStrategy(klass, classDescriptor2);
        OverrideResolver.Companion.checkInheritedAndDelegatedSignatures(classDescriptor2, inheritedMemberErrors, inheritedMemberErrors, this.kotlinTypeRefiner);
        inheritedMemberErrors.doReportErrors();
    }

    private final void checkOverrideForMember(CallableMemberDescriptor declared) {
        if (declared.getKind() == CallableMemberDescriptor.Kind.SYNTHESIZED) {
            Name name2 = declared.getName();
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"getName(...)");
            if (DataClassDescriptorResolver.INSTANCE.isComponentLike(name2)) {
                this.checkOverrideForComponentFunction(declared);
            } else if (Intrinsics.areEqual((Object)declared.getName(), (Object)DataClassDescriptorResolver.INSTANCE.getCOPY_METHOD_NAME())) {
                this.checkOverrideForCopyFunction(declared);
            }
            return;
        }
        if (declared.getKind() != CallableMemberDescriptor.Kind.DECLARATION) {
            return;
        }
        KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)DescriptorToSourceUtils.descriptorToDeclaration(declared);
        if (ktNamedDeclaration == null) {
            throw new IllegalStateException("declared descriptor is not resolved to declaration: " + declared);
        }
        KtNamedDeclaration member2 = ktNamedDeclaration;
        KtModifierList modifierList2 = member2.getModifierList();
        boolean hasOverrideNode = modifierList2 != null && modifierList2.hasModifier(KtTokens.OVERRIDE_KEYWORD);
        Collection<? extends CallableMemberDescriptor> collection = declared.getOverriddenDescriptors();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getOverriddenDescriptors(...)");
        Collection<? extends CallableMemberDescriptor> overriddenDescriptors = collection;
        if (hasOverrideNode) {
            OverrideResolver.Companion.checkOverridesForMemberMarkedOverride(declared, this.kotlinTypeRefiner, new CheckOverrideReportForDeclaredMemberStrategy(this, member2, declared){
                private boolean finalOverriddenError;
                private boolean typeMismatchError;
                private boolean kindMismatchError;
                final /* synthetic */ OverrideResolver this$0;
                final /* synthetic */ KtNamedDeclaration $member;
                final /* synthetic */ CallableMemberDescriptor $declared;
                {
                    this.this$0 = $receiver;
                    this.$member = $member;
                    this.$declared = $declared;
                }

                public void overridingFinalMember(CallableMemberDescriptor overriding, CallableMemberDescriptor overridden) {
                    Intrinsics.checkNotNullParameter((Object)overriding, (String)"overriding");
                    Intrinsics.checkNotNullParameter((Object)overridden, (String)"overridden");
                    if (!this.finalOverriddenError) {
                        this.finalOverriddenError = true;
                        OverrideResolver.access$getTrace$p(this.this$0).report(Errors.OVERRIDING_FINAL_MEMBER.on((KtNamedDeclaration)((PsiElement)this.$member), overridden, overridden.getContainingDeclaration()));
                    }
                }

                public void returnTypeMismatchOnOverride(CallableMemberDescriptor overriding, CallableMemberDescriptor overridden) {
                    Intrinsics.checkNotNullParameter((Object)overriding, (String)"overriding");
                    Intrinsics.checkNotNullParameter((Object)overridden, (String)"overridden");
                    if (!this.typeMismatchError) {
                        this.typeMismatchError = true;
                        if (overridden instanceof PropertyDescriptor && ((PropertyDescriptor)overridden).isVar()) {
                            OverrideResolver.access$getTrace$p(this.this$0).report(Errors.VAR_TYPE_MISMATCH_ON_OVERRIDE.on((KtNamedDeclaration)((PsiElement)this.$member), this.$declared, overridden));
                        } else if (overridden instanceof PropertyDescriptor && !((PropertyDescriptor)overridden).isVar()) {
                            OverrideResolver.access$getTrace$p(this.this$0).report(Errors.PROPERTY_TYPE_MISMATCH_ON_OVERRIDE.on((KtNamedDeclaration)((PsiElement)this.$member), this.$declared, overridden));
                        } else {
                            OverrideResolver.access$getTrace$p(this.this$0).report(Errors.RETURN_TYPE_MISMATCH_ON_OVERRIDE.on((KtNamedDeclaration)((PsiElement)this.$member), this.$declared, new DeclarationWithDiagnosticComponents(overridden, OverrideResolver.access$getPlatformSpecificDiagnosticComponents$p(this.this$0))));
                        }
                    }
                }

                public void varOverriddenByVal(CallableMemberDescriptor overriding, CallableMemberDescriptor overridden) {
                    Intrinsics.checkNotNullParameter((Object)overriding, (String)"overriding");
                    Intrinsics.checkNotNullParameter((Object)overridden, (String)"overridden");
                    if (!this.kindMismatchError) {
                        this.kindMismatchError = true;
                        BindingTrace bindingTrace = OverrideResolver.access$getTrace$p(this.this$0);
                        PsiElement psiElement = this.$member;
                        CallableMemberDescriptor callableMemberDescriptor = this.$declared;
                        Intrinsics.checkNotNull((Object)callableMemberDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.PropertyDescriptor");
                        bindingTrace.report(Errors.VAR_OVERRIDDEN_BY_VAL.on((KtNamedDeclaration)psiElement, (PropertyDescriptor)callableMemberDescriptor, (PropertyDescriptor)overridden));
                    }
                }

                public void cannotOverrideInvisibleMember(CallableMemberDescriptor overriding, CallableMemberDescriptor invisibleOverridden) {
                    Intrinsics.checkNotNullParameter((Object)overriding, (String)"overriding");
                    Intrinsics.checkNotNullParameter((Object)invisibleOverridden, (String)"invisibleOverridden");
                    OverrideResolver.access$getTrace$p(this.this$0).report(Errors.CANNOT_OVERRIDE_INVISIBLE_MEMBER.on((KtModifierListOwner)((PsiElement)this.$member), this.$declared, invisibleOverridden));
                }

                public void nothingToOverride(CallableMemberDescriptor overriding) {
                    Intrinsics.checkNotNullParameter((Object)overriding, (String)"overriding");
                    OverrideResolver.access$getTrace$p(this.this$0).report(Errors.NOTHING_TO_OVERRIDE.on((KtModifierListOwner)((PsiElement)this.$member), this.$declared));
                }
            }, this.languageVersionSettings);
        } else if (!overriddenDescriptors.isEmpty() && !this.overridesBackwardCompatibilityHelper.overrideCanBeOmitted(declared)) {
            CallableMemberDescriptor overridden = (CallableMemberDescriptor)CollectionsKt.first((Iterable)overriddenDescriptors);
            this.trace.report(Errors.VIRTUAL_MEMBER_HIDDEN.on((KtNamedDeclaration)((PsiElement)member2), declared, overridden, overridden.getContainingDeclaration()));
        }
    }

    private final void checkOverrideForComponentFunction(CallableMemberDescriptor componentFunction) {
        DeclarationDescriptor declarationDescriptor = componentFunction.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
        PsiElement dataModifier = OverrideResolver.Companion.findDataModifierForDataClass(declarationDescriptor);
        Collection<? extends CallableMemberDescriptor> collection = componentFunction.getOverriddenDescriptors();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getOverriddenDescriptors(...)");
        OverrideResolver.Companion.checkOverridesForMember(componentFunction, collection, new CheckOverrideReportStrategy(this, dataModifier, componentFunction){
            private boolean overrideConflict;
            final /* synthetic */ OverrideResolver this$0;
            final /* synthetic */ PsiElement $dataModifier;
            final /* synthetic */ CallableMemberDescriptor $componentFunction;
            {
                this.this$0 = $receiver;
                this.$dataModifier = $dataModifier;
                this.$componentFunction = $componentFunction;
            }

            public void overridingFinalMember(CallableMemberDescriptor overriding, CallableMemberDescriptor overridden) {
                Intrinsics.checkNotNullParameter((Object)overriding, (String)"overriding");
                Intrinsics.checkNotNullParameter((Object)overridden, (String)"overridden");
                if (!this.overrideConflict) {
                    this.overrideConflict = true;
                    OverrideResolver.access$getTrace$p(this.this$0).report(Errors.DATA_CLASS_OVERRIDE_CONFLICT.on(this.$dataModifier, this.$componentFunction, overridden.getContainingDeclaration()));
                }
            }

            public void returnTypeMismatchOnOverride(CallableMemberDescriptor overriding, CallableMemberDescriptor overridden) {
                Intrinsics.checkNotNullParameter((Object)overriding, (String)"overriding");
                Intrinsics.checkNotNullParameter((Object)overridden, (String)"overridden");
                if (!this.overrideConflict) {
                    this.overrideConflict = true;
                    OverrideResolver.access$getTrace$p(this.this$0).report(Errors.DATA_CLASS_OVERRIDE_CONFLICT.on(this.$dataModifier, this.$componentFunction, overridden.getContainingDeclaration()));
                }
            }

            public void varOverriddenByVal(CallableMemberDescriptor overriding, CallableMemberDescriptor overridden) {
                Intrinsics.checkNotNullParameter((Object)overriding, (String)"overriding");
                Intrinsics.checkNotNullParameter((Object)overridden, (String)"overridden");
                throw new IllegalStateException("Component functions are not properties");
            }
        }, this.kotlinTypeRefiner);
    }

    private final void checkOverrideForCopyFunction(CallableMemberDescriptor copyFunction) {
        Collection<? extends CallableMemberDescriptor> collection = copyFunction.getOverriddenDescriptors();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getOverriddenDescriptors(...)");
        CallableMemberDescriptor overridden = (CallableMemberDescriptor)CollectionsKt.firstOrNull((Iterable)collection);
        if (overridden != null) {
            DeclarationDescriptor declarationDescriptor = overridden.getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
            DeclarationDescriptor baseClassifier = declarationDescriptor;
            DeclarationDescriptor declarationDescriptor2 = copyFunction.getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor2, (String)"getContainingDeclaration(...)");
            PsiElement dataModifier = OverrideResolver.Companion.findDataModifierForDataClass(declarationDescriptor2);
            this.trace.report(Errors.DATA_CLASS_OVERRIDE_DEFAULT_VALUES.on(this.languageVersionSettings, dataModifier, copyFunction, baseClassifier));
        }
    }

    private final void checkParameterOverridesForAllClasses(TopDownAnalysisContext c) {
        for (ClassDescriptorWithResolutionScopes classDescriptor2 : c.getDeclaredClasses().values()) {
            for (DeclarationDescriptor member2 : DescriptorUtils.getAllDescriptors(classDescriptor2.getDefaultType().getMemberScope())) {
                if (!(member2 instanceof CallableMemberDescriptor)) continue;
                this.checkOverridesForParameters((CallableMemberDescriptor)member2);
            }
        }
    }

    private final void checkOverridesForParameters(CallableMemberDescriptor declared) {
        KtModifierListOwner declaration;
        boolean isDeclaration;
        boolean bl = isDeclaration = declared.getKind() == CallableMemberDescriptor.Kind.DECLARATION;
        if (isDeclaration && (declaration = (KtModifierListOwner)DescriptorToSourceUtils.descriptorToDeclaration(declared)) != null && !declaration.hasModifier(KtTokens.OVERRIDE_KEYWORD)) {
            return;
        }
        for (ValueParameterDescriptor parameterFromSubclass : declared.getValueParameters()) {
            boolean multipleDefaultsInSuper;
            int defaultsInSuper = 0;
            for (ValueParameterDescriptor parameterFromSuperclass : parameterFromSubclass.getOverriddenDescriptors()) {
                if (!parameterFromSuperclass.declaresDefaultValue()) continue;
                ++defaultsInSuper;
            }
            boolean bl2 = multipleDefaultsInSuper = defaultsInSuper > 1;
            if (isDeclaration) {
                Intrinsics.checkNotNull((Object)parameterFromSubclass);
                this.checkNameAndDefaultForDeclaredParameter(parameterFromSubclass, multipleDefaultsInSuper);
                continue;
            }
            Intrinsics.checkNotNull((Object)parameterFromSubclass);
            this.checkNameAndDefaultForFakeOverrideParameter(declared, parameterFromSubclass, multipleDefaultsInSuper);
        }
    }

    private final void checkNameAndDefaultForDeclaredParameter(ValueParameterDescriptor descriptor2, boolean multipleDefaultsInSuper) {
        PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
        KtParameter ktParameter = psiElement instanceof KtParameter ? (KtParameter)psiElement : null;
        if (ktParameter == null) {
            throw new IllegalStateException(("Declaration not found for parameter: " + descriptor2).toString());
        }
        KtParameter parameter2 = ktParameter;
        if (descriptor2.declaresDefaultValue()) {
            this.trace.report(Errors.DEFAULT_VALUE_NOT_ALLOWED_IN_OVERRIDE.on((KtParameter)((PsiElement)parameter2)));
        }
        if (multipleDefaultsInSuper) {
            this.trace.report(Errors.MULTIPLE_DEFAULTS_INHERITED_FROM_SUPERTYPES.on((KtParameter)((PsiElement)parameter2), descriptor2));
        }
        for (ValueParameterDescriptor parameterFromSuperclass : descriptor2.getOverriddenDescriptors()) {
            if (!Companion.shouldReportParameterNameOverrideWarning(descriptor2, parameterFromSuperclass)) continue;
            PsiElement psiElement2 = parameter2;
            DeclarationDescriptor declarationDescriptor = parameterFromSuperclass.getContainingDeclaration().getContainingDeclaration();
            Intrinsics.checkNotNull((Object)declarationDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            this.trace.report(Errors.PARAMETER_NAME_CHANGED_ON_OVERRIDE.on((KtParameter)psiElement2, (ClassDescriptor)declarationDescriptor, parameterFromSuperclass));
        }
    }

    private final void checkNameAndDefaultForFakeOverrideParameter(CallableMemberDescriptor containingFunction, ValueParameterDescriptor descriptor2, boolean multipleDefaultsInSuper) {
        DeclarationDescriptor declarationDescriptor = containingFunction.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
        DeclarationDescriptor containingClass = declarationDescriptor;
        KtClassOrObject ktClassOrObject = (KtClassOrObject)DescriptorToSourceUtils.descriptorToDeclaration(containingClass);
        if (ktClassOrObject == null) {
            throw new IllegalStateException(("Declaration not found for class: " + containingClass).toString());
        }
        KtClassOrObject classElement = ktClassOrObject;
        if (multipleDefaultsInSuper) {
            this.trace.report(Errors.MULTIPLE_DEFAULTS_INHERITED_FROM_SUPERTYPES_WHEN_NO_EXPLICIT_OVERRIDE.on((KtClassOrObject)((PsiElement)classElement), descriptor2));
        }
        for (ValueParameterDescriptor parameterFromSuperclass : descriptor2.getOverriddenDescriptors()) {
            if (!Companion.shouldReportParameterNameOverrideWarning(descriptor2, parameterFromSuperclass)) continue;
            this.trace.report(Errors.DIFFERENT_NAMES_FOR_THE_SAME_PARAMETER_IN_SUPERTYPES.on((KtClassOrObject)((PsiElement)classElement), containingFunction.getOverriddenDescriptors(), parameterFromSuperclass.getIndex() + 1));
        }
    }

    private final void checkVisibility(TopDownAnalysisContext c) {
        Map<KtCallableDeclaration, CallableMemberDescriptor> map = c.getMembers();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getMembers(...)");
        for (Map.Entry<KtCallableDeclaration, CallableMemberDescriptor> entry : map.entrySet()) {
            KtCallableDeclaration key = entry.getKey();
            CallableMemberDescriptor value2 = entry.getValue();
            Intrinsics.checkNotNull((Object)key);
            KtDeclaration ktDeclaration = key;
            Intrinsics.checkNotNull((Object)value2);
            this.checkVisibilityForMember(ktDeclaration, value2);
            if (!(key instanceof KtProperty) || !(value2 instanceof PropertyDescriptor)) continue;
            KtPropertyAccessor setter2 = ((KtProperty)key).getSetter();
            PropertySetterDescriptor setterDescriptor = ((PropertyDescriptor)value2).getSetter();
            if (setter2 == null || setterDescriptor == null) continue;
            this.checkVisibilityForMember(setter2, setterDescriptor);
        }
    }

    private final void checkVisibilityForMember(KtDeclaration declaration, CallableMemberDescriptor memberDescriptor) {
        DescriptorVisibility descriptorVisibility = memberDescriptor.getVisibility();
        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"getVisibility(...)");
        DescriptorVisibility visibility2 = descriptorVisibility;
        for (CallableMemberDescriptor callableMemberDescriptor : memberDescriptor.getOverriddenDescriptors()) {
            Integer compare = DescriptorVisibilities.compare(visibility2, callableMemberDescriptor.getVisibility());
            if (compare == null) {
                this.trace.report(Errors.CANNOT_CHANGE_ACCESS_PRIVILEGE.on((KtModifierListOwner)((PsiElement)declaration), callableMemberDescriptor.getVisibility(), callableMemberDescriptor, callableMemberDescriptor.getContainingDeclaration()));
                return;
            }
            if (compare >= 0) continue;
            this.trace.report(Errors.CANNOT_WEAKEN_ACCESS_PRIVILEGE.on((KtModifierListOwner)((PsiElement)declaration), callableMemberDescriptor.getVisibility(), callableMemberDescriptor, callableMemberDescriptor.getContainingDeclaration()));
            return;
        }
    }

    public static final /* synthetic */ PlatformSpecificDiagnosticComponents access$getPlatformSpecificDiagnosticComponents$p(OverrideResolver $this) {
        return $this.platformSpecificDiagnosticComponents;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\bb\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0018\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H&J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0018\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005H&J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0010\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/resolve/OverrideResolver$CheckInheritedSignaturesReportStrategy;", "", "abstractMemberNotImplemented", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "abstractBaseClassMemberNotImplemented", "abstractMemberWithMoreSpecificType", "abstractMember", "concreteMember", "multipleImplementationsMemberNotImplemented", "conflictingInterfaceMemberNotImplemented", "typeMismatchOnInheritance", "descriptor1", "descriptor2", "abstractInvisibleMember", "frontend"})
    private static interface CheckInheritedSignaturesReportStrategy {
        public void abstractMemberNotImplemented(@NotNull CallableMemberDescriptor var1);

        public void abstractBaseClassMemberNotImplemented(@NotNull CallableMemberDescriptor var1);

        public void abstractMemberWithMoreSpecificType(@NotNull CallableMemberDescriptor var1, @NotNull CallableMemberDescriptor var2);

        public void multipleImplementationsMemberNotImplemented(@NotNull CallableMemberDescriptor var1);

        public void conflictingInterfaceMemberNotImplemented(@NotNull CallableMemberDescriptor var1);

        public void typeMismatchOnInheritance(@NotNull CallableMemberDescriptor var1, @NotNull CallableMemberDescriptor var2);

        public void abstractInvisibleMember(@NotNull CallableMemberDescriptor var1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bb\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0018\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/resolve/OverrideResolver$CheckOverrideReportForDeclaredMemberStrategy;", "Lorg/jetbrains/kotlin/resolve/OverrideResolver$CheckOverrideReportStrategy;", "nothingToOverride", "", "overriding", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "cannotOverrideInvisibleMember", "invisibleOverridden", "frontend"})
    private static interface CheckOverrideReportForDeclaredMemberStrategy
    extends CheckOverrideReportStrategy {
        public void nothingToOverride(@NotNull CallableMemberDescriptor var1);

        public void cannotOverrideInvisibleMember(@NotNull CallableMemberDescriptor var1, @NotNull CallableMemberDescriptor var2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\bb\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&J\u0018\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&J\u0018\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/resolve/OverrideResolver$CheckOverrideReportStrategy;", "", "overridingFinalMember", "", "overriding", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "overridden", "returnTypeMismatchOnOverride", "varOverriddenByVal", "frontend"})
    private static interface CheckOverrideReportStrategy {
        public void overridingFinalMember(@NotNull CallableMemberDescriptor var1, @NotNull CallableMemberDescriptor var2);

        public void returnTypeMismatchOnOverride(@NotNull CallableMemberDescriptor var1, @NotNull CallableMemberDescriptor var2);

        public void varOverriddenByVal(@NotNull CallableMemberDescriptor var1, @NotNull CallableMemberDescriptor var2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\n\b\u0092\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\n\u0010\u001b\u001a\u00060\u001cR\u00020\u001dJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000fH\u0016J\u0010\u0010!\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000fH\u0016J\u0010\u0010\"\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000fH\u0016J\u0010\u0010#\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000fH\u0016J\u0018\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u000fH\u0016J\u0010\u0010'\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000fH\u0016J\u0018\u0010(\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\u000fH\u0016J2\u0010+\u001a\u00020\u001f2\u0018\u0010,\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0-2\u0006\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u000fH\u0002J\u0018\u0010.\u001a\u00020\u001f2\u0006\u0010/\u001a\u00020\u000f2\u0006\u00100\u001a\u00020\u000fH\u0016J\u0018\u00101\u001a\u00020\u001f2\u0006\u0010/\u001a\u00020\u000f2\u0006\u00100\u001a\u00020\u000fH\u0016J\u0018\u00102\u001a\u00020\u001f2\u0006\u0010/\u001a\u00020\u000f2\u0006\u00100\u001a\u00020\u000fH\u0016JD\u00103\u001a\u00020\u001f2\u0018\u0010,\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0-2\u0010\u00104\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u001a2\u0006\u00105\u001a\u00020\u000f2\u0006\u00100\u001a\u00020\u000fH\u0002J\b\u00106\u001a\u00020\u001fH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0018\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/jetbrains/kotlin/resolve/OverrideResolver$CollectErrorInformationForInheritedMembersStrategy;", "Lorg/jetbrains/kotlin/resolve/OverrideResolver$CheckInheritedSignaturesReportStrategy;", "Lorg/jetbrains/kotlin/resolve/OverrideResolver$CheckOverrideReportStrategy;", "klass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "<init>", "(Lorg/jetbrains/kotlin/resolve/OverrideResolver;Lorg/jetbrains/kotlin/psi/KtClassOrObject;Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;)V", "getKlass", "()Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "getClassDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "abstractNoImpl", "Ljava/util/LinkedHashSet;", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "abstractInBaseClassNoImpl", "getAbstractInBaseClassNoImpl", "()Ljava/util/LinkedHashSet;", "abstractInvisibleSuper", "multipleImplementations", "conflictingInterfaceMembers", "getConflictingInterfaceMembers", "conflictingReturnTypes", "onceErrorsReported", "Lorg/jetbrains/kotlin/com/intellij/util/containers/SmartHashSet;", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactoryWithPsiElement;", "toDeprecationStrategy", "Lorg/jetbrains/kotlin/resolve/OverrideResolver$CollectWarningInformationForInheritedMembersStrategy;", "Lorg/jetbrains/kotlin/resolve/OverrideResolver;", "abstractMemberNotImplemented", "", "descriptor", "abstractBaseClassMemberNotImplemented", "multipleImplementationsMemberNotImplemented", "conflictingInterfaceMemberNotImplemented", "typeMismatchOnInheritance", "descriptor1", "descriptor2", "abstractInvisibleMember", "abstractMemberWithMoreSpecificType", "abstractMember", "concreteMember", "reportInheritanceConflictIfRequired", "diagnosticFactory", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory2;", "overridingFinalMember", "overriding", "overridden", "returnTypeMismatchOnOverride", "varOverriddenByVal", "reportDelegationProblemIfRequired", "relevantDiagnosticFromInheritance", "delegate", "doReportErrors", "frontend"})
    @SourceDebugExtension(value={"SMAP\nOverrideResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OverrideResolver.kt\norg/jetbrains/kotlin/resolve/OverrideResolver$CollectErrorInformationForInheritedMembersStrategy\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,992:1\n1#2:993\n*E\n"})
    private class CollectErrorInformationForInheritedMembersStrategy
    implements CheckInheritedSignaturesReportStrategy,
    CheckOverrideReportStrategy {
        @NotNull
        private final KtClassOrObject klass;
        @NotNull
        private final ClassDescriptor classDescriptor;
        @NotNull
        private final LinkedHashSet<CallableMemberDescriptor> abstractNoImpl;
        @NotNull
        private final LinkedHashSet<CallableMemberDescriptor> abstractInBaseClassNoImpl;
        @NotNull
        private final LinkedHashSet<CallableMemberDescriptor> abstractInvisibleSuper;
        @NotNull
        private final LinkedHashSet<CallableMemberDescriptor> multipleImplementations;
        @NotNull
        private final LinkedHashSet<CallableMemberDescriptor> conflictingInterfaceMembers;
        @NotNull
        private final LinkedHashSet<CallableMemberDescriptor> conflictingReturnTypes;
        @NotNull
        private final SmartHashSet<DiagnosticFactoryWithPsiElement<?, ?>> onceErrorsReported;

        public CollectErrorInformationForInheritedMembersStrategy(@NotNull KtClassOrObject klass, ClassDescriptor classDescriptor2) {
            Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
            Intrinsics.checkNotNullParameter((Object)classDescriptor2, (String)"classDescriptor");
            this.klass = klass;
            this.classDescriptor = classDescriptor2;
            this.abstractNoImpl = new LinkedHashSet();
            this.abstractInBaseClassNoImpl = new LinkedHashSet();
            this.abstractInvisibleSuper = new LinkedHashSet();
            this.multipleImplementations = new LinkedHashSet();
            this.conflictingInterfaceMembers = new LinkedHashSet();
            this.conflictingReturnTypes = new LinkedHashSet();
            this.onceErrorsReported = new SmartHashSet();
        }

        @NotNull
        public final KtClassOrObject getKlass() {
            return this.klass;
        }

        @NotNull
        public final ClassDescriptor getClassDescriptor() {
            return this.classDescriptor;
        }

        @NotNull
        protected final LinkedHashSet<CallableMemberDescriptor> getAbstractInBaseClassNoImpl() {
            return this.abstractInBaseClassNoImpl;
        }

        @NotNull
        protected final LinkedHashSet<CallableMemberDescriptor> getConflictingInterfaceMembers() {
            return this.conflictingInterfaceMembers;
        }

        @NotNull
        public final CollectWarningInformationForInheritedMembersStrategy toDeprecationStrategy() {
            return new CollectWarningInformationForInheritedMembersStrategy(OverrideResolver.this, this);
        }

        @Override
        public void abstractMemberNotImplemented(@NotNull CallableMemberDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            this.abstractNoImpl.add(descriptor2);
        }

        @Override
        public void abstractBaseClassMemberNotImplemented(@NotNull CallableMemberDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            this.abstractInBaseClassNoImpl.add(descriptor2);
        }

        @Override
        public void multipleImplementationsMemberNotImplemented(@NotNull CallableMemberDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            this.multipleImplementations.add(descriptor2);
        }

        @Override
        public void conflictingInterfaceMemberNotImplemented(@NotNull CallableMemberDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            this.conflictingInterfaceMembers.add(descriptor2);
        }

        @Override
        public void typeMismatchOnInheritance(@NotNull CallableMemberDescriptor descriptor1, @NotNull CallableMemberDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)descriptor1, (String)"descriptor1");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor2");
            this.conflictingReturnTypes.add(descriptor1);
            this.conflictingReturnTypes.add(descriptor2);
            if (descriptor1 instanceof PropertyDescriptor && descriptor2 instanceof PropertyDescriptor) {
                if (((PropertyDescriptor)descriptor1).isVar() || ((PropertyDescriptor)descriptor2).isVar()) {
                    DiagnosticFactory2<KtClassOrObject, CallableMemberDescriptor, CallableMemberDescriptor> diagnosticFactory2 = Errors.VAR_TYPE_MISMATCH_ON_INHERITANCE;
                    Intrinsics.checkNotNullExpressionValue(diagnosticFactory2, (String)"VAR_TYPE_MISMATCH_ON_INHERITANCE");
                    this.reportInheritanceConflictIfRequired(diagnosticFactory2, descriptor1, descriptor2);
                } else {
                    DiagnosticFactory2<KtClassOrObject, CallableMemberDescriptor, CallableMemberDescriptor> diagnosticFactory2 = Errors.PROPERTY_TYPE_MISMATCH_ON_INHERITANCE;
                    Intrinsics.checkNotNullExpressionValue(diagnosticFactory2, (String)"PROPERTY_TYPE_MISMATCH_ON_INHERITANCE");
                    this.reportInheritanceConflictIfRequired(diagnosticFactory2, descriptor1, descriptor2);
                }
            } else {
                DiagnosticFactory2<KtClassOrObject, CallableMemberDescriptor, CallableMemberDescriptor> diagnosticFactory2 = Errors.RETURN_TYPE_MISMATCH_ON_INHERITANCE;
                Intrinsics.checkNotNullExpressionValue(diagnosticFactory2, (String)"RETURN_TYPE_MISMATCH_ON_INHERITANCE");
                this.reportInheritanceConflictIfRequired(diagnosticFactory2, descriptor1, descriptor2);
            }
        }

        @Override
        public void abstractInvisibleMember(@NotNull CallableMemberDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            this.abstractInvisibleSuper.add(descriptor2);
        }

        @Override
        public void abstractMemberWithMoreSpecificType(@NotNull CallableMemberDescriptor abstractMember, @NotNull CallableMemberDescriptor concreteMember) {
            Intrinsics.checkNotNullParameter((Object)abstractMember, (String)"abstractMember");
            Intrinsics.checkNotNullParameter((Object)concreteMember, (String)"concreteMember");
            this.typeMismatchOnInheritance(abstractMember, concreteMember);
        }

        private final void reportInheritanceConflictIfRequired(DiagnosticFactory2<KtClassOrObject, CallableMemberDescriptor, CallableMemberDescriptor> diagnosticFactory, CallableMemberDescriptor descriptor1, CallableMemberDescriptor descriptor2) {
            if (!this.onceErrorsReported.contains(diagnosticFactory)) {
                this.onceErrorsReported.add((DiagnosticFactoryWithPsiElement<?, ?>)diagnosticFactory);
                OverrideResolver.this.trace.report(diagnosticFactory.on((KtClassOrObject)((PsiElement)this.klass), descriptor1, descriptor2));
            }
        }

        @Override
        public void overridingFinalMember(@NotNull CallableMemberDescriptor overriding, @NotNull CallableMemberDescriptor overridden) {
            Intrinsics.checkNotNullParameter((Object)overriding, (String)"overriding");
            Intrinsics.checkNotNullParameter((Object)overridden, (String)"overridden");
            DiagnosticFactory2<KtClassOrObject, CallableMemberDescriptor, CallableMemberDescriptor> diagnosticFactory2 = Errors.OVERRIDING_FINAL_MEMBER_BY_DELEGATION;
            Intrinsics.checkNotNullExpressionValue(diagnosticFactory2, (String)"OVERRIDING_FINAL_MEMBER_BY_DELEGATION");
            this.reportDelegationProblemIfRequired(diagnosticFactory2, null, overriding, overridden);
        }

        @Override
        public void returnTypeMismatchOnOverride(@NotNull CallableMemberDescriptor overriding, @NotNull CallableMemberDescriptor overridden) {
            Intrinsics.checkNotNullParameter((Object)overriding, (String)"overriding");
            Intrinsics.checkNotNullParameter((Object)overridden, (String)"overridden");
            Pair pair = overridden instanceof PropertyDescriptor ? TuplesKt.to(Errors.PROPERTY_TYPE_MISMATCH_BY_DELEGATION, Errors.PROPERTY_TYPE_MISMATCH_ON_INHERITANCE) : TuplesKt.to(Errors.RETURN_TYPE_MISMATCH_BY_DELEGATION, Errors.RETURN_TYPE_MISMATCH_ON_INHERITANCE);
            DiagnosticFactory2 diagnosticFactory = (DiagnosticFactory2)pair.component1();
            DiagnosticFactory2 relevantDiagnosticFromInheritance = (DiagnosticFactory2)pair.component2();
            Intrinsics.checkNotNull((Object)diagnosticFactory);
            this.reportDelegationProblemIfRequired(diagnosticFactory, relevantDiagnosticFromInheritance, overriding, overridden);
        }

        @Override
        public void varOverriddenByVal(@NotNull CallableMemberDescriptor overriding, @NotNull CallableMemberDescriptor overridden) {
            Intrinsics.checkNotNullParameter((Object)overriding, (String)"overriding");
            Intrinsics.checkNotNullParameter((Object)overridden, (String)"overridden");
            DiagnosticFactory2<KtClassOrObject, CallableMemberDescriptor, CallableMemberDescriptor> diagnosticFactory2 = Errors.VAR_OVERRIDDEN_BY_VAL_BY_DELEGATION;
            Intrinsics.checkNotNullExpressionValue(diagnosticFactory2, (String)"VAR_OVERRIDDEN_BY_VAL_BY_DELEGATION");
            this.reportDelegationProblemIfRequired(diagnosticFactory2, null, overriding, overridden);
        }

        private final void reportDelegationProblemIfRequired(DiagnosticFactory2<KtClassOrObject, CallableMemberDescriptor, CallableMemberDescriptor> diagnosticFactory, DiagnosticFactoryWithPsiElement<?, ?> relevantDiagnosticFromInheritance, CallableMemberDescriptor delegate2, CallableMemberDescriptor overridden) {
            boolean bl;
            boolean bl2 = bl = delegate2.getKind() == CallableMemberDescriptor.Kind.DELEGATION;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string2 = "Delegate expected, got " + delegate2 + " of kind " + (Object)((Object)delegate2.getKind());
                throw new AssertionError((Object)string2);
            }
            if (!(this.onceErrorsReported.contains(diagnosticFactory) || relevantDiagnosticFromInheritance != null && this.onceErrorsReported.contains(relevantDiagnosticFromInheritance))) {
                this.onceErrorsReported.add((DiagnosticFactoryWithPsiElement<?, ?>)diagnosticFactory);
                OverrideResolver.this.trace.report(diagnosticFactory.on((KtClassOrObject)((PsiElement)this.klass), delegate2, overridden));
            }
        }

        public void doReportErrors() {
            boolean canHaveAbstractMembers = DescriptorUtils.classCanHaveAbstractFakeOverride(this.classDescriptor);
            if (!((Collection)this.abstractInBaseClassNoImpl).isEmpty() && !canHaveAbstractMembers) {
                OverrideResolver.this.trace.report(Errors.ABSTRACT_CLASS_MEMBER_NOT_IMPLEMENTED.on((KtClassOrObject)((PsiElement)this.klass), this.klass, (CallableMemberDescriptor)CollectionsKt.first((Iterable)this.abstractInBaseClassNoImpl)));
            } else if (!((Collection)this.abstractNoImpl).isEmpty() && !canHaveAbstractMembers) {
                OverrideResolver.this.trace.report(Errors.ABSTRACT_MEMBER_NOT_IMPLEMENTED.on((KtClassOrObject)((PsiElement)this.klass), this.klass, (CallableMemberDescriptor)CollectionsKt.first((Iterable)this.abstractNoImpl)));
            }
            if (!((Collection)this.abstractInvisibleSuper).isEmpty() && !canHaveAbstractMembers) {
                OverrideResolver.this.trace.report(Errors.INVISIBLE_ABSTRACT_MEMBER_FROM_SUPER.on(OverrideResolver.this.languageVersionSettings, (KtClassOrObject)((PsiElement)this.klass), this.classDescriptor, this.abstractInvisibleSuper));
            }
            this.conflictingInterfaceMembers.removeAll((Collection)this.conflictingReturnTypes);
            this.multipleImplementations.removeAll((Collection)this.conflictingReturnTypes);
            if (!((Collection)this.conflictingInterfaceMembers).isEmpty()) {
                OverrideResolver.this.trace.report(Errors.MANY_INTERFACES_MEMBER_NOT_IMPLEMENTED.on((KtClassOrObject)((PsiElement)this.klass), this.klass, (CallableMemberDescriptor)CollectionsKt.first((Iterable)this.conflictingInterfaceMembers)));
            } else if (!((Collection)this.multipleImplementations).isEmpty()) {
                OverrideResolver.this.trace.report(Errors.MANY_IMPL_MEMBER_NOT_IMPLEMENTED.on((KtClassOrObject)((PsiElement)this.klass), this.klass, (CallableMemberDescriptor)CollectionsKt.first((Iterable)this.multipleImplementations)));
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\f\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006H\u0016J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\u0018\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0006H\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/resolve/OverrideResolver$CollectMissingImplementationsStrategy;", "Lorg/jetbrains/kotlin/resolve/OverrideResolver$CheckInheritedSignaturesReportStrategy;", "<init>", "()V", "shouldImplement", "Ljava/util/LinkedHashSet;", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "getShouldImplement", "()Ljava/util/LinkedHashSet;", "abstractMemberNotImplemented", "", "descriptor", "abstractBaseClassMemberNotImplemented", "multipleImplementationsMemberNotImplemented", "conflictingInterfaceMemberNotImplemented", "typeMismatchOnInheritance", "descriptor1", "descriptor2", "abstractInvisibleMember", "abstractMemberWithMoreSpecificType", "abstractMember", "concreteMember", "frontend"})
    private static final class CollectMissingImplementationsStrategy
    implements CheckInheritedSignaturesReportStrategy {
        @NotNull
        private final LinkedHashSet<CallableMemberDescriptor> shouldImplement = new LinkedHashSet();

        @NotNull
        public final LinkedHashSet<CallableMemberDescriptor> getShouldImplement() {
            return this.shouldImplement;
        }

        @Override
        public void abstractMemberNotImplemented(@NotNull CallableMemberDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            this.shouldImplement.add(descriptor2);
        }

        @Override
        public void abstractBaseClassMemberNotImplemented(@NotNull CallableMemberDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        }

        @Override
        public void multipleImplementationsMemberNotImplemented(@NotNull CallableMemberDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            this.shouldImplement.add(descriptor2);
        }

        @Override
        public void conflictingInterfaceMemberNotImplemented(@NotNull CallableMemberDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            if (descriptor2.getModality() == Modality.ABSTRACT) {
                this.shouldImplement.add(descriptor2);
            }
        }

        @Override
        public void typeMismatchOnInheritance(@NotNull CallableMemberDescriptor descriptor1, @NotNull CallableMemberDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)descriptor1, (String)"descriptor1");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor2");
        }

        @Override
        public void abstractInvisibleMember(@NotNull CallableMemberDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        }

        @Override
        public void abstractMemberWithMoreSpecificType(@NotNull CallableMemberDescriptor abstractMember, @NotNull CallableMemberDescriptor concreteMember) {
            Intrinsics.checkNotNullParameter((Object)abstractMember, (String)"abstractMember");
            Intrinsics.checkNotNullParameter((Object)concreteMember, (String)"concreteMember");
            this.shouldImplement.add(abstractMember);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u0015\b\u0016\u0012\n\u0010\t\u001a\u00060\u0001R\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/resolve/OverrideResolver$CollectWarningInformationForInheritedMembersStrategy;", "Lorg/jetbrains/kotlin/resolve/OverrideResolver$CollectErrorInformationForInheritedMembersStrategy;", "Lorg/jetbrains/kotlin/resolve/OverrideResolver;", "klass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "<init>", "(Lorg/jetbrains/kotlin/resolve/OverrideResolver;Lorg/jetbrains/kotlin/psi/KtClassOrObject;Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;)V", "delegateStrategy", "(Lorg/jetbrains/kotlin/resolve/OverrideResolver;Lorg/jetbrains/kotlin/resolve/OverrideResolver$CollectErrorInformationForInheritedMembersStrategy;)V", "doReportErrors", "", "frontend"})
    private final class CollectWarningInformationForInheritedMembersStrategy
    extends CollectErrorInformationForInheritedMembersStrategy {
        final /* synthetic */ OverrideResolver this$0;

        public CollectWarningInformationForInheritedMembersStrategy(@NotNull OverrideResolver this$0, @NotNull KtClassOrObject klass, ClassDescriptor classDescriptor2) {
            Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
            Intrinsics.checkNotNullParameter((Object)classDescriptor2, (String)"classDescriptor");
            this.this$0 = this$0;
            super(klass, classDescriptor2);
        }

        public CollectWarningInformationForInheritedMembersStrategy(@NotNull OverrideResolver this$0, CollectErrorInformationForInheritedMembersStrategy delegateStrategy) {
            Intrinsics.checkNotNullParameter((Object)delegateStrategy, (String)"delegateStrategy");
            this(this$0, delegateStrategy.getKlass(), delegateStrategy.getClassDescriptor());
        }

        @Override
        public void doReportErrors() {
            boolean canHaveAbstractMembers = DescriptorUtils.classCanHaveAbstractFakeOverride(this.getClassDescriptor());
            if (!((Collection)this.getAbstractInBaseClassNoImpl()).isEmpty() && !canHaveAbstractMembers) {
                if (this.this$0.languageVersionSettings.supportsFeature(LanguageFeature.AbstractClassMemberNotImplementedWithIntermediateAbstractClass)) {
                    this.this$0.trace.report(Errors.ABSTRACT_CLASS_MEMBER_NOT_IMPLEMENTED.on((KtClassOrObject)((PsiElement)this.getKlass()), this.getKlass(), (CallableMemberDescriptor)CollectionsKt.first((Iterable)this.getAbstractInBaseClassNoImpl())));
                } else {
                    this.this$0.trace.report(Errors.ABSTRACT_CLASS_MEMBER_NOT_IMPLEMENTED_WARNING.on((KtClassOrObject)((PsiElement)this.getKlass()), this.getKlass(), (CallableMemberDescriptor)CollectionsKt.first((Iterable)this.getAbstractInBaseClassNoImpl())));
                }
            }
            if (!((Collection)this.getConflictingInterfaceMembers()).isEmpty()) {
                CallableMemberDescriptor interfaceMember = (CallableMemberDescriptor)CollectionsKt.first((Iterable)this.getConflictingInterfaceMembers());
                if (this.this$0.languageVersionSettings.supportsFeature(LanguageFeature.AbstractClassMemberNotImplementedWithIntermediateAbstractClass)) {
                    this.this$0.trace.report(Errors.MANY_INTERFACES_MEMBER_NOT_IMPLEMENTED.on((KtClassOrObject)((PsiElement)this.getKlass()), this.getKlass(), interfaceMember));
                } else {
                    this.this$0.trace.report(Errors.MANY_INTERFACES_MEMBER_NOT_IMPLEMENTED_WARNING.on((KtClassOrObject)((PsiElement)this.getKlass()), this.getKlass(), interfaceMember));
                }
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nJ\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00050\f2\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J*\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0012\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u000e*\u00020\bH\u0002J*\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J&\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u001a\u001a\u00020\u0013H\u0002J8\u0010\u001d\u001a\u00020\u00052\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\u0006\u0010\u001a\u001a\u00020\u00132\b\b\u0002\u0010\u001f\u001a\u00020 2\u000e\b\u0002\u0010!\u001a\b\u0012\u0004\u0012\u00020\b0\"H\u0002J,\u0010#\u001a\b\u0012\u0004\u0012\u00020\b0$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\b0$2\u0006\u0010&\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J6\u0010'\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\u0018\u0010(\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000e0)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\b0\u000eH\u0002J8\u0010+\u001a\u00020 2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\u0012\u0010-\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000e0\u00072\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\b0\u000eH\u0002J(\u0010.\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000e0)2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J.\u00100\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J(\u00101\u001a\u00020\u00052\u0006\u00102\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H\u0002J.\u00107\u001a\u00020\u00052\u0006\u00108\u001a\u00020\b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u00103\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u00109\u001a\u00020 2\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020;2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001a\u0010=\u001a\u0004\u0018\u00010>2\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020;H\u0002J\u0010\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020BH\u0002J*\u0010C\u001a\u0004\u0018\u00010\b2\u0006\u00102\u001a\u00020\b2\u0006\u0010D\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u00105\u001a\u000206H\u0002J\u0016\u0010E\u001a\u00020 2\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020GJ\u0018\u0010I\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010J\u001a\u00020 H\u0002\u00a8\u0006K"}, d2={"Lorg/jetbrains/kotlin/resolve/OverrideResolver$Companion;", "", "<init>", "()V", "resolveUnknownVisibilities", "", "descriptors", "", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "createCannotInferVisibilityReporter", "Lkotlin/Function1;", "getMissingImplementations", "", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "checkInheritedAndDelegatedSignatures", "inheritedReportStrategy", "Lorg/jetbrains/kotlin/resolve/OverrideResolver$CheckInheritedSignaturesReportStrategy;", "overrideReportStrategyForDelegates", "Lorg/jetbrains/kotlin/resolve/OverrideResolver$CheckOverrideReportStrategy;", "kotlinTypeRefiner", "Lorg/jetbrains/kotlin/types/checker/KotlinTypeRefiner;", "computeRelevantDirectlyOverridden", "descriptor", "reportingStrategy", "checkInvisibleFakeOverride", "overriddenDescriptors", "checkMissingOverridesByJava8Restrictions", "relevantDirectlyOverridden", "onlyBaseClassMembers", "", "overriddenInterfaceMembers", "", "collectAbstractMethodsWithMoreSpecificReturnType", "", "abstractOverridden", "implementation", "getRelevantDirectlyOverridden", "overriddenByParent", "", "allFilteredOverriddenDeclarations", "isRelevant", "declarationSet", "allDeclarationSets", "collectOverriddenDeclarations", "directOverriddenDescriptors", "checkInheritedDescriptorsGroup", "checkOverridesForMemberMarkedOverride", "declared", "reportError", "Lorg/jetbrains/kotlin/resolve/OverrideResolver$CheckOverrideReportForDeclaredMemberStrategy;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "checkOverridesForMember", "memberDescriptor", "isReturnTypeOkForOverride", "superDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "subDescriptor", "prepareTypeSubstitutor", "Lorg/jetbrains/kotlin/types/TypeSubstitutor;", "findDataModifierForDataClass", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "dataClass", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "findInvisibleOverriddenDescriptor", "declaringClass", "shouldReportParameterNameOverrideWarning", "parameterFromSubclass", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "parameterFromSuperclass", "checkPropertyKind", "isVar", "frontend"})
    @SourceDebugExtension(value={"SMAP\nOverrideResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OverrideResolver.kt\norg/jetbrains/kotlin/resolve/OverrideResolver$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,992:1\n764#2:993\n855#2,2:994\n3183#2,10:996\n1853#2,2:1006\n1853#2,2:1008\n1853#2,2:1010\n764#2:1012\n855#2,2:1013\n764#2:1015\n855#2,2:1016\n*S KotlinDebug\n*F\n+ 1 OverrideResolver.kt\norg/jetbrains/kotlin/resolve/OverrideResolver$Companion\n*L\n650#1:993\n650#1:994,2\n651#1:996,10\n656#1:1006,2\n663#1:1008,2\n668#1:1010,2\n682#1:1012\n682#1:1013,2\n764#1:1015\n764#1:1016,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void resolveUnknownVisibilities(@NotNull Collection<? extends CallableMemberDescriptor> descriptors, @NotNull BindingTrace trace) {
            Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
            Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
            for (CallableMemberDescriptor callableMemberDescriptor : descriptors) {
                OverridingUtil.resolveUnknownVisibilityForMember(callableMemberDescriptor, this.createCannotInferVisibilityReporter(trace));
            }
        }

        @NotNull
        public final Function1<CallableMemberDescriptor, Unit> createCannotInferVisibilityReporter(@NotNull BindingTrace trace) {
            Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
            return (Function1)new Function1<CallableMemberDescriptor, Unit>(trace){
                final /* synthetic */ BindingTrace $trace;
                {
                    this.$trace = $trace;
                    super(1);
                }

                public final void invoke(CallableMemberDescriptor descriptor2) {
                    DeclarationDescriptor reportOn;
                    PsiElement element;
                    Substitutable<ClassifierDescriptorWithTypeParameters> substitutable;
                    Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                    if (descriptor2.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE || descriptor2.getKind() == CallableMemberDescriptor.Kind.DELEGATION) {
                        substitutable = DescriptorUtils.getContainingClass(descriptor2);
                        if (substitutable == null) {
                            throw new AssertionError((Object)("Class member expected: " + descriptor2));
                        }
                    } else if (descriptor2 instanceof PropertyAccessorDescriptor && ((PropertyAccessorDescriptor)descriptor2).isDefault()) {
                        PropertyDescriptor propertyDescriptor = ((PropertyAccessorDescriptor)descriptor2).getCorrespondingProperty();
                        substitutable = propertyDescriptor;
                        Intrinsics.checkNotNullExpressionValue((Object)propertyDescriptor, (String)"getCorrespondingProperty(...)");
                    } else {
                        substitutable = descriptor2;
                    }
                    if ((element = DescriptorToSourceUtils.descriptorToDeclaration(reportOn = (DeclarationDescriptor)((Object)substitutable))) instanceof KtDeclaration) {
                        this.$trace.report(Errors.CANNOT_INFER_VISIBILITY.on((KtDeclaration)element, descriptor2));
                    }
                }
            };
        }

        @NotNull
        public final Set<CallableMemberDescriptor> getMissingImplementations(@NotNull ClassDescriptor classDescriptor2) {
            Intrinsics.checkNotNullParameter((Object)classDescriptor2, (String)"classDescriptor");
            CollectMissingImplementationsStrategy collector2 = new CollectMissingImplementationsStrategy();
            this.checkInheritedAndDelegatedSignatures(classDescriptor2, (CheckInheritedSignaturesReportStrategy)collector2, null, (KotlinTypeRefiner)KotlinTypeRefiner.Default.INSTANCE);
            return collector2.getShouldImplement();
        }

        private final void checkInheritedAndDelegatedSignatures(ClassDescriptor classDescriptor2, CheckInheritedSignaturesReportStrategy inheritedReportStrategy, CheckOverrideReportStrategy overrideReportStrategyForDelegates, KotlinTypeRefiner kotlinTypeRefiner) {
            for (DeclarationDescriptor member2 : DescriptorUtils.getAllDescriptors(classDescriptor2.getDefaultType().getMemberScope())) {
                if (!(member2 instanceof CallableMemberDescriptor)) continue;
                this.checkInheritedAndDelegatedSignatures((CallableMemberDescriptor)member2, inheritedReportStrategy, overrideReportStrategyForDelegates, kotlinTypeRefiner);
            }
        }

        private final Set<CallableMemberDescriptor> computeRelevantDirectlyOverridden(CallableMemberDescriptor $this$computeRelevantDirectlyOverridden) {
            Collection<? extends CallableMemberDescriptor> collection = $this$computeRelevantDirectlyOverridden.getOverriddenDescriptors();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getOverriddenDescriptors(...)");
            Collection<? extends CallableMemberDescriptor> directOverridden = collection;
            if (directOverridden.isEmpty()) {
                return SetsKt.emptySet();
            }
            Map<CallableMemberDescriptor, Set<CallableMemberDescriptor>> overriddenDeclarationsByDirectParent = this.collectOverriddenDeclarations(directOverridden);
            List list2 = ContainerUtil.flatten((Iterable)overriddenDeclarationsByDirectParent.values());
            Intrinsics.checkNotNullExpressionValue(list2, (String)"flatten(...)");
            List allOverriddenDeclarations = list2;
            Set set = OverridingUtil.filterOutOverridden(Sets.newLinkedHashSet(allOverriddenDeclarations));
            Intrinsics.checkNotNullExpressionValue(set, (String)"filterOutOverridden(...)");
            Set allFilteredOverriddenDeclarations = set;
            return this.getRelevantDirectlyOverridden(overriddenDeclarationsByDirectParent, allFilteredOverriddenDeclarations);
        }

        /*
         * WARNING - void declaration
         */
        private final void checkInheritedAndDelegatedSignatures(CallableMemberDescriptor descriptor2, CheckInheritedSignaturesReportStrategy reportingStrategy, CheckOverrideReportStrategy overrideReportStrategyForDelegates, KotlinTypeRefiner kotlinTypeRefiner) {
            void $this$partition$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            CallableMemberDescriptor.Kind kind = descriptor2.getKind();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)kind), (String)"getKind(...)");
            CallableMemberDescriptor.Kind kind2 = kind;
            if (kind2 != CallableMemberDescriptor.Kind.FAKE_OVERRIDE && kind2 != CallableMemberDescriptor.Kind.DELEGATION) {
                return;
            }
            Set<CallableMemberDescriptor> relevantDirectlyOverridden = this.computeRelevantDirectlyOverridden(descriptor2);
            if (relevantDirectlyOverridden.isEmpty()) {
                return;
            }
            if (descriptor2.getVisibility() == DescriptorVisibilities.INVISIBLE_FAKE) {
                this.checkInvisibleFakeOverride(descriptor2, (Collection<? extends CallableMemberDescriptor>)relevantDirectlyOverridden, reportingStrategy);
                return;
            }
            this.checkInheritedDescriptorsGroup(descriptor2, (Collection<? extends CallableMemberDescriptor>)relevantDirectlyOverridden, reportingStrategy, kotlinTypeRefiner);
            if (kind2 == CallableMemberDescriptor.Kind.DELEGATION && overrideReportStrategyForDelegates != null) {
                this.checkOverridesForMember(descriptor2, (Collection<? extends CallableMemberDescriptor>)relevantDirectlyOverridden, overrideReportStrategyForDelegates, kotlinTypeRefiner);
            }
            if (kind2 != CallableMemberDescriptor.Kind.DELEGATION) {
                org.jetbrains.kotlin.resolve.OverrideResolver$Companion.checkMissingOverridesByJava8Restrictions$default(this, relevantDirectlyOverridden, reportingStrategy, false, null, 12, null);
            }
            Iterable iterable = relevantDirectlyOverridden;
            boolean $i$f$filter = false;
            void var10_10 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv$iv;
                boolean bl = false;
                if (!(!CallResolverUtilKt.isOrOverridesSynthesized(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv;
                boolean bl = false;
                if (it.getModality() != Modality.ABSTRACT) {
                    first$iv.add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List concreteOverridden = (List)pair.component1();
            List abstractOverridden = (List)pair.component2();
            switch (concreteOverridden.size()) {
                case 0: {
                    if (kind2 == CallableMemberDescriptor.Kind.DELEGATION) break;
                    Iterable $this$forEach$iv = abstractOverridden;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv;
                        boolean bl = false;
                        reportingStrategy.abstractMemberNotImplemented(it);
                    }
                    break;
                }
                case 1: {
                    if (kind2 == CallableMemberDescriptor.Kind.DELEGATION) break;
                    CallableMemberDescriptor implementation2 = (CallableMemberDescriptor)CollectionsKt.first((List)concreteOverridden);
                    Iterable $this$forEach$iv = this.collectAbstractMethodsWithMoreSpecificReturnType(abstractOverridden, implementation2, kotlinTypeRefiner);
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv;
                        boolean bl = false;
                        reportingStrategy.abstractMemberWithMoreSpecificType(it, implementation2);
                    }
                    break;
                }
                default: {
                    Iterable $this$forEach$iv = concreteOverridden;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv;
                        boolean bl = false;
                        reportingStrategy.multipleImplementationsMemberNotImplemented(it);
                    }
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void checkInvisibleFakeOverride(CallableMemberDescriptor descriptor2, Collection<? extends CallableMemberDescriptor> overriddenDescriptors, CheckInheritedSignaturesReportStrategy reportingStrategy) {
            void $this$filterTo$iv$iv;
            DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
            ClassDescriptor classDescriptor2 = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
            if ((classDescriptor2 != null ? classDescriptor2.getModality() : null) == Modality.ABSTRACT) {
                return;
            }
            Iterable $this$filter$iv = overriddenDescriptors;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv$iv;
                boolean bl = false;
                if (!(it.getModality() == Modality.ABSTRACT)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List abstractOverrides = (List)destination$iv$iv;
            if (abstractOverrides.size() != overriddenDescriptors.size()) {
                return;
            }
            for (CallableMemberDescriptor override : abstractOverrides) {
                reportingStrategy.abstractInvisibleMember(override);
            }
        }

        private final void checkMissingOverridesByJava8Restrictions(Set<? extends CallableMemberDescriptor> relevantDirectlyOverridden, CheckInheritedSignaturesReportStrategy reportingStrategy, boolean onlyBaseClassMembers, List<CallableMemberDescriptor> overriddenInterfaceMembers) {
            boolean overridesClassMember = false;
            boolean overridesNonAbstractInterfaceMember = false;
            CallableMemberDescriptor overridesAbstractInBaseClass = null;
            CallableMemberDescriptor overridesNonAbstractInBaseClass = null;
            CallableMemberDescriptor fakeOverrideInBaseClass = null;
            for (CallableMemberDescriptor callableMemberDescriptor : relevantDirectlyOverridden) {
                DeclarationDescriptor declarationDescriptor = callableMemberDescriptor.getContainingDeclaration();
                ClassDescriptor classDescriptor2 = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
                if (classDescriptor2 == null) continue;
                ClassDescriptor containingDeclaration = classDescriptor2;
                if (containingDeclaration.getKind() == ClassKind.CLASS) {
                    if (callableMemberDescriptor.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE && !containingDeclaration.isExpect()) {
                        fakeOverrideInBaseClass = callableMemberDescriptor;
                    }
                    overridesClassMember = true;
                    if (callableMemberDescriptor.getModality() == Modality.ABSTRACT) {
                        overridesAbstractInBaseClass = callableMemberDescriptor;
                        continue;
                    }
                    overridesNonAbstractInBaseClass = callableMemberDescriptor;
                    continue;
                }
                if (containingDeclaration.getKind() != ClassKind.INTERFACE) continue;
                overriddenInterfaceMembers.add(callableMemberDescriptor);
                if (callableMemberDescriptor.getModality() == Modality.ABSTRACT) continue;
                overridesNonAbstractInterfaceMember = true;
            }
            if (overridesAbstractInBaseClass != null && overridesNonAbstractInBaseClass == null) {
                reportingStrategy.abstractBaseClassMemberNotImplemented(overridesAbstractInBaseClass);
            } else if (!onlyBaseClassMembers && !overridesClassMember && overridesNonAbstractInterfaceMember && overriddenInterfaceMembers.size() > 1) {
                for (CallableMemberDescriptor callableMemberDescriptor : overriddenInterfaceMembers) {
                    reportingStrategy.conflictingInterfaceMemberNotImplemented(callableMemberDescriptor);
                }
            } else if (fakeOverrideInBaseClass != null) {
                CheckInheritedSignaturesReportStrategy newReportingStrategy = reportingStrategy instanceof CollectErrorInformationForInheritedMembersStrategy ? (CheckInheritedSignaturesReportStrategy)((CollectErrorInformationForInheritedMembersStrategy)reportingStrategy).toDeprecationStrategy() : reportingStrategy;
                this.checkMissingOverridesByJava8Restrictions(this.computeRelevantDirectlyOverridden(fakeOverrideInBaseClass), newReportingStrategy, overriddenInterfaceMembers.isEmpty(), overriddenInterfaceMembers);
                if (newReportingStrategy instanceof CollectWarningInformationForInheritedMembersStrategy) {
                    ((CollectWarningInformationForInheritedMembersStrategy)newReportingStrategy).doReportErrors();
                }
            }
        }

        static /* synthetic */ void checkMissingOverridesByJava8Restrictions$default(Companion companion, Set set, CheckInheritedSignaturesReportStrategy checkInheritedSignaturesReportStrategy, boolean bl, List list2, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            if ((n & 8) != 0) {
                list2 = new SmartList();
            }
            companion.checkMissingOverridesByJava8Restrictions(set, checkInheritedSignaturesReportStrategy, bl, list2);
        }

        /*
         * WARNING - void declaration
         */
        private final List<CallableMemberDescriptor> collectAbstractMethodsWithMoreSpecificReturnType(List<? extends CallableMemberDescriptor> abstractOverridden, CallableMemberDescriptor implementation2, KotlinTypeRefiner kotlinTypeRefiner) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = abstractOverridden;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                CallableMemberDescriptor abstractMember = (CallableMemberDescriptor)element$iv$iv;
                boolean bl = false;
                if (!(!Companion.isReturnTypeOkForOverride(abstractMember, implementation2, kotlinTypeRefiner))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private final Set<CallableMemberDescriptor> getRelevantDirectlyOverridden(Map<CallableMemberDescriptor, Set<CallableMemberDescriptor>> overriddenByParent, Set<? extends CallableMemberDescriptor> allFilteredOverriddenDeclarations) {
            Iterator<Map.Entry<CallableMemberDescriptor, Set<CallableMemberDescriptor>>> iterator2 = overriddenByParent.entrySet().iterator();
            while (iterator2.hasNext()) {
                if (this.isRelevant(iterator2.next().getValue(), overriddenByParent.values(), allFilteredOverriddenDeclarations)) continue;
                iterator2.remove();
            }
            return overriddenByParent.keySet();
        }

        private final boolean isRelevant(Set<? extends CallableMemberDescriptor> declarationSet, Collection<? extends Set<? extends CallableMemberDescriptor>> allDeclarationSets, Set<? extends CallableMemberDescriptor> allFilteredOverriddenDeclarations) {
            for (Set<? extends CallableMemberDescriptor> set : allDeclarationSets) {
                if (set == declarationSet) continue;
                if (set.containsAll((Collection)declarationSet)) {
                    return false;
                }
                if (!Collections.disjoint((Collection)allFilteredOverriddenDeclarations, (Collection)declarationSet)) continue;
                return false;
            }
            return true;
        }

        private final Map<CallableMemberDescriptor, Set<CallableMemberDescriptor>> collectOverriddenDeclarations(Collection<? extends CallableMemberDescriptor> directOverriddenDescriptors) {
            LinkedHashMap overriddenDeclarationsByDirectParent = Maps.newLinkedHashMap();
            for (CallableMemberDescriptor callableMemberDescriptor : directOverriddenDescriptors) {
                Set<CallableMemberDescriptor> filteredOverrides;
                Set<CallableMemberDescriptor> overriddenDeclarations;
                Intrinsics.checkNotNullExpressionValue(OverridingUtil.getOverriddenDeclarations(callableMemberDescriptor), (String)"getOverriddenDeclarations(...)");
                Intrinsics.checkNotNullExpressionValue(OverridingUtil.filterOutOverridden(overriddenDeclarations), (String)"filterOutOverridden(...)");
                Intrinsics.checkNotNull(overriddenDeclarationsByDirectParent);
                ((Map)overriddenDeclarationsByDirectParent).put(callableMemberDescriptor, new LinkedHashSet(filteredOverrides));
            }
            Intrinsics.checkNotNull(overriddenDeclarationsByDirectParent);
            return overriddenDeclarationsByDirectParent;
        }

        private final void checkInheritedDescriptorsGroup(CallableMemberDescriptor descriptor2, Collection<? extends CallableMemberDescriptor> overriddenDescriptors, CheckInheritedSignaturesReportStrategy reportingStrategy, KotlinTypeRefiner kotlinTypeRefiner) {
            if (overriddenDescriptors.size() <= 1) {
                return;
            }
            for (CallableMemberDescriptor callableMemberDescriptor : overriddenDescriptors) {
                if (!(!(descriptor2 instanceof PropertyDescriptor) || callableMemberDescriptor instanceof PropertyDescriptor)) {
                    boolean bl = false;
                    String string2 = callableMemberDescriptor + " is not a property";
                    throw new IllegalArgumentException(string2.toString());
                }
                if (this.isReturnTypeOkForOverride(callableMemberDescriptor, descriptor2, kotlinTypeRefiner)) continue;
                reportingStrategy.typeMismatchOnInheritance(descriptor2, callableMemberDescriptor);
            }
        }

        private final void checkOverridesForMemberMarkedOverride(CallableMemberDescriptor declared, KotlinTypeRefiner kotlinTypeRefiner, CheckOverrideReportForDeclaredMemberStrategy reportError2, LanguageVersionSettings languageVersionSettings2) {
            Collection<? extends CallableMemberDescriptor> collection = declared.getOverriddenDescriptors();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getOverriddenDescriptors(...)");
            Collection<? extends CallableMemberDescriptor> overriddenDescriptors = collection;
            this.checkOverridesForMember(declared, overriddenDescriptors, reportError2, kotlinTypeRefiner);
            if (overriddenDescriptors.isEmpty()) {
                DeclarationDescriptor declarationDescriptor = declared.getContainingDeclaration();
                Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
                DeclarationDescriptor containingDeclaration = declarationDescriptor;
                ClassDescriptor classDescriptor2 = containingDeclaration instanceof ClassDescriptor ? (ClassDescriptor)containingDeclaration : null;
                if (classDescriptor2 == null) {
                    throw new IllegalStateException(("Overrides may only be resolved in a class, but " + declared + " comes from " + containingDeclaration).toString());
                }
                ClassDescriptor declaringClass = classDescriptor2;
                CallableMemberDescriptor invisibleOverriddenDescriptor = this.findInvisibleOverriddenDescriptor(declared, declaringClass, kotlinTypeRefiner, languageVersionSettings2);
                if (invisibleOverriddenDescriptor != null) {
                    reportError2.cannotOverrideInvisibleMember(declared, invisibleOverriddenDescriptor);
                } else {
                    reportError2.nothingToOverride(declared);
                }
            }
        }

        private final void checkOverridesForMember(CallableMemberDescriptor memberDescriptor, Collection<? extends CallableMemberDescriptor> overriddenDescriptors, CheckOverrideReportStrategy reportError2, KotlinTypeRefiner kotlinTypeRefiner) {
            for (CallableMemberDescriptor callableMemberDescriptor : overriddenDescriptors) {
                if (callableMemberDescriptor.getModality() == Modality.FINAL) {
                    reportError2.overridingFinalMember(memberDescriptor, callableMemberDescriptor);
                }
                if (!this.isReturnTypeOkForOverride(callableMemberDescriptor, memberDescriptor, kotlinTypeRefiner)) {
                    if (!(!(memberDescriptor instanceof PropertyDescriptor) || callableMemberDescriptor instanceof PropertyDescriptor)) {
                        boolean bl = false;
                        String string2 = callableMemberDescriptor + " is overridden by property " + memberDescriptor;
                        throw new IllegalArgumentException(string2.toString());
                    }
                    reportError2.returnTypeMismatchOnOverride(memberDescriptor, callableMemberDescriptor);
                }
                if (!this.checkPropertyKind(callableMemberDescriptor, true) || !this.checkPropertyKind(memberDescriptor, false)) continue;
                reportError2.varOverriddenByVal(memberDescriptor, callableMemberDescriptor);
            }
        }

        private final boolean isReturnTypeOkForOverride(CallableDescriptor superDescriptor, CallableDescriptor subDescriptor, KotlinTypeRefiner kotlinTypeRefiner) {
            TypeSubstitutor typeSubstitutor2 = this.prepareTypeSubstitutor(superDescriptor, subDescriptor);
            if (typeSubstitutor2 == null) {
                return false;
            }
            TypeSubstitutor typeSubstitutor3 = typeSubstitutor2;
            KotlinType kotlinType = superDescriptor.getReturnType();
            Intrinsics.checkNotNull((Object)kotlinType);
            KotlinType superReturnType = kotlinType;
            KotlinType kotlinType2 = subDescriptor.getReturnType();
            Intrinsics.checkNotNull((Object)kotlinType2);
            KotlinType subReturnType = kotlinType2;
            KotlinType kotlinType3 = typeSubstitutor3.substitute(superReturnType, Variance.OUT_VARIANCE);
            Intrinsics.checkNotNull((Object)kotlinType3);
            KotlinType substitutedSuperReturnType = kotlinType3;
            NewKotlinTypeCheckerImpl typeChecker = new NewKotlinTypeCheckerImpl(kotlinTypeRefiner, null, 2, null);
            return superDescriptor instanceof PropertyDescriptor && ((PropertyDescriptor)superDescriptor).isVar() ? typeChecker.equalTypes(subReturnType, substitutedSuperReturnType) : typeChecker.isSubtypeOf(subReturnType, substitutedSuperReturnType);
        }

        private final TypeSubstitutor prepareTypeSubstitutor(CallableDescriptor superDescriptor, CallableDescriptor subDescriptor) {
            List<TypeParameterDescriptor> list2 = superDescriptor.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getTypeParameters(...)");
            List<TypeParameterDescriptor> superTypeParameters = list2;
            List<TypeParameterDescriptor> list3 = subDescriptor.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"getTypeParameters(...)");
            List<TypeParameterDescriptor> subTypeParameters = list3;
            if (subTypeParameters.size() != superTypeParameters.size()) {
                return null;
            }
            ArrayList<TypeProjectionImpl> arguments2 = new ArrayList<TypeProjectionImpl>(subTypeParameters.size());
            int n = superTypeParameters.size();
            for (int i = 0; i < n; ++i) {
                arguments2.add(new TypeProjectionImpl(subTypeParameters.get(i).getDefaultType()));
            }
            return new IndexedParametersSubstitution(superTypeParameters, (List<? extends TypeProjection>)arguments2).buildSubstitutor();
        }

        private final PsiElement findDataModifierForDataClass(DeclarationDescriptor dataClass) {
            KtClassOrObject classDeclaration;
            KtClassOrObject ktClassOrObject = classDeclaration = (KtClassOrObject)DescriptorToSourceUtils.getSourceFromDescriptor(dataClass);
            if ((ktClassOrObject != null ? ktClassOrObject.getModifierList() : null) != null) {
                KtModifierList ktModifierList = classDeclaration.getModifierList();
                Intrinsics.checkNotNull((Object)ktModifierList);
                PsiElement modifier = ktModifierList.getModifier(KtTokens.DATA_KEYWORD);
                if (modifier != null) {
                    return modifier;
                }
            }
            throw new IllegalStateException("No data modifier is found for data class " + dataClass);
        }

        private final CallableMemberDescriptor findInvisibleOverriddenDescriptor(CallableMemberDescriptor declared, ClassDescriptor declaringClass, KotlinTypeRefiner kotlinTypeRefiner, LanguageVersionSettings languageVersionSettings2) {
            for (KotlinType supertype2 : kotlinTypeRefiner.refineSupertypes(declaringClass)) {
                Iterator iterator2;
                LinkedHashSet<CallableMemberDescriptor> all2 = new LinkedHashSet<CallableMemberDescriptor>();
                MemberScope memberScope2 = supertype2.getMemberScope();
                Name name2 = declared.getName();
                Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"getName(...)");
                all2.addAll(memberScope2.getContributedFunctions(name2, NoLookupLocation.WHEN_CHECK_OVERRIDES));
                MemberScope memberScope3 = supertype2.getMemberScope();
                Name name3 = declared.getName();
                Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"getName(...)");
                all2.addAll(memberScope3.getContributedVariables(name3, NoLookupLocation.WHEN_CHECK_OVERRIDES));
                Intrinsics.checkNotNullExpressionValue(all2.iterator(), (String)"iterator(...)");
                while (iterator2.hasNext()) {
                    CallableMemberDescriptor fromSuper = (CallableMemberDescriptor)iterator2.next();
                    if (OverridingUtil.DEFAULT.isOverridableBy(fromSuper, declared, null).getResult() != OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE) continue;
                    if (OverridingUtil.isVisibleForOverride(declared, fromSuper, DescriptorVisibilityUtils.INSTANCE.getUseSpecialRulesForPrivateSealedConstructors(languageVersionSettings2))) {
                        throw new IllegalStateException("Descriptor " + fromSuper + " is overridable by " + declared + " and visible but does not appear in its getOverriddenDescriptors()");
                    }
                    return fromSuper;
                }
            }
            return null;
        }

        public final boolean shouldReportParameterNameOverrideWarning(@NotNull ValueParameterDescriptor parameterFromSubclass, @NotNull ValueParameterDescriptor parameterFromSuperclass) {
            Intrinsics.checkNotNullParameter((Object)parameterFromSubclass, (String)"parameterFromSubclass");
            Intrinsics.checkNotNullParameter((Object)parameterFromSuperclass, (String)"parameterFromSuperclass");
            return parameterFromSubclass.getContainingDeclaration().hasStableParameterNames() && parameterFromSuperclass.getContainingDeclaration().hasStableParameterNames() && !Intrinsics.areEqual((Object)parameterFromSuperclass.getName(), (Object)parameterFromSubclass.getName());
        }

        private final boolean checkPropertyKind(CallableMemberDescriptor descriptor2, boolean isVar) {
            return descriptor2 instanceof PropertyDescriptor && ((PropertyDescriptor)descriptor2).isVar() == isVar;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

