/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.util.rewriters;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsLoop;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00172\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00182\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016J\u001e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u00182\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/js/inline/util/rewriters/ContinueReplacingVisitor;", "Lorg/jetbrains/kotlin/js/backend/ast/JsVisitorWithContextImpl;", "loopLabelName", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "guardLabelName", "<init>", "(Lorg/jetbrains/kotlin/js/backend/ast/JsName;Lorg/jetbrains/kotlin/js/backend/ast/JsName;)V", "getLoopLabelName", "()Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "getGuardLabelName", "loopNestingLevel", "", "getLoopNestingLevel", "()I", "setLoopNestingLevel", "(I)V", "visit", "", "x", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "ctx", "Lorg/jetbrains/kotlin/js/backend/ast/JsContext;", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "Lorg/jetbrains/kotlin/js/backend/ast/JsContinue;", "Lorg/jetbrains/kotlin/js/backend/ast/JsLoop;", "endVisit", "", "js.translator"})
public final class ContinueReplacingVisitor
extends JsVisitorWithContextImpl {
    @Nullable
    private final JsName loopLabelName;
    @NotNull
    private final JsName guardLabelName;
    private int loopNestingLevel;

    public ContinueReplacingVisitor(@Nullable JsName loopLabelName, @NotNull JsName guardLabelName) {
        Intrinsics.checkNotNullParameter((Object)guardLabelName, (String)"guardLabelName");
        this.loopLabelName = loopLabelName;
        this.guardLabelName = guardLabelName;
    }

    @Nullable
    public final JsName getLoopLabelName() {
        return this.loopLabelName;
    }

    @NotNull
    public final JsName getGuardLabelName() {
        return this.guardLabelName;
    }

    public final int getLoopNestingLevel() {
        return this.loopNestingLevel;
    }

    public final void setLoopNestingLevel(int n) {
        this.loopNestingLevel = n;
    }

    public boolean visit(@NotNull JsFunction x, @NotNull JsContext<JsNode> ctx) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        return false;
    }

    public boolean visit(@NotNull JsContinue x, @NotNull JsContext<JsNode> ctx) {
        boolean bl;
        JsName target;
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        JsNameRef jsNameRef = x.getLabel();
        JsName jsName = target = jsNameRef != null ? jsNameRef.getName() : null;
        boolean shouldReplace = jsName == null ? this.loopNestingLevel == 0 : Intrinsics.areEqual((Object)jsName, (Object)this.loopLabelName);
        boolean bl2 = bl = this.loopNestingLevel >= 0;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        if (shouldReplace) {
            ctx.replaceMe((JsNode)new JsBreak(this.guardLabelName.makeRef()));
        }
        return false;
    }

    public boolean visit(@NotNull JsLoop x, @NotNull JsContext<JsNode> ctx) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        if (this.loopLabelName == null) {
            return false;
        }
        int n = this.loopNestingLevel;
        this.loopNestingLevel = n + 1;
        return super.visit(x, ctx);
    }

    public void endVisit(@NotNull JsLoop x, @NotNull JsContext<JsNode> ctx) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        super.endVisit(x, ctx);
        if (this.loopLabelName == null) {
            return;
        }
        int n = this.loopNestingLevel;
        this.loopNestingLevel = n + -1;
    }
}

