/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.incremental.storage.LookupMap;
import org.jetbrains.kotlin.incremental.storage.LookupSymbolKey;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0019\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00102\u0006\u0010\u0014\u001a\u00020\nH\u0086\u0002J\u001f\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\n2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u0010H\u0086\u0002J\u001c\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\n2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u0010J\u000e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\nJ\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\nH\u0002J\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0019\u0010\r\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\f\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/incremental/TrackedLookupMap;", "", "lookupMap", "Lorg/jetbrains/kotlin/incremental/storage/LookupMap;", "trackChanges", "", "<init>", "(Lorg/jetbrains/kotlin/incremental/storage/LookupMap;Z)V", "addedKeys", "", "Lorg/jetbrains/kotlin/incremental/storage/LookupSymbolKey;", "getAddedKeys", "()Ljava/util/Set;", "removedKeys", "getRemovedKeys", "keys", "", "getKeys", "get", "", "key", "set", "", "fileIds", "append", "remove", "recordSet", "recordRemove", "kotlin-build-common"})
final class TrackedLookupMap {
    @NotNull
    private final LookupMap lookupMap;
    private final boolean trackChanges;
    @Nullable
    private final Set<LookupSymbolKey> addedKeys;
    @Nullable
    private final Set<LookupSymbolKey> removedKeys;

    public TrackedLookupMap(@NotNull LookupMap lookupMap, boolean trackChanges) {
        Intrinsics.checkNotNullParameter((Object)lookupMap, (String)"lookupMap");
        this.lookupMap = lookupMap;
        this.trackChanges = trackChanges;
        this.addedKeys = this.trackChanges ? (Set)new LinkedHashSet() : null;
        this.removedKeys = this.trackChanges ? (Set)new LinkedHashSet() : null;
    }

    @Nullable
    public final Set<LookupSymbolKey> getAddedKeys() {
        return this.addedKeys;
    }

    @Nullable
    public final Set<LookupSymbolKey> getRemovedKeys() {
        return this.removedKeys;
    }

    @NotNull
    public final Set<LookupSymbolKey> getKeys() {
        return this.lookupMap.getKeys();
    }

    @Nullable
    public final Set<Integer> get(@NotNull LookupSymbolKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.lookupMap.get(key);
    }

    public final void set(@NotNull LookupSymbolKey key, @NotNull Set<Integer> fileIds) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(fileIds, (String)"fileIds");
        this.recordSet(key);
        this.lookupMap.set(key, fileIds);
    }

    public final void append(@NotNull LookupSymbolKey key, @NotNull Set<Integer> fileIds) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(fileIds, (String)"fileIds");
        this.recordSet(key);
        this.lookupMap.append(key, fileIds);
    }

    public final void remove(@NotNull LookupSymbolKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.recordRemove(key);
        this.lookupMap.remove(key);
    }

    private final void recordSet(LookupSymbolKey key) {
        if (!this.trackChanges) {
            return;
        }
        LookupSymbolKey lookupSymbolKey = key;
        if (!this.lookupMap.contains(lookupSymbolKey)) {
            Set<LookupSymbolKey> set = this.removedKeys;
            Intrinsics.checkNotNull(set);
            if (set.contains(lookupSymbolKey)) {
                this.removedKeys.remove(key);
            } else {
                Set<LookupSymbolKey> set2 = this.addedKeys;
                Intrinsics.checkNotNull(set2);
                set2.add(key);
            }
        }
    }

    private final void recordRemove(LookupSymbolKey key) {
        if (!this.trackChanges) {
            return;
        }
        LookupSymbolKey lookupSymbolKey = key;
        if (this.lookupMap.contains(lookupSymbolKey)) {
            Set<LookupSymbolKey> set = this.addedKeys;
            Intrinsics.checkNotNull(set);
            if (set.contains(lookupSymbolKey)) {
                this.addedKeys.remove(key);
            } else {
                Set<LookupSymbolKey> set2 = this.removedKeys;
                Intrinsics.checkNotNull(set2);
                set2.add(key);
            }
        }
    }
}

