/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.providers;

import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolNamesProviderKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bH&J\u0010\u0010\t\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0005H&J\u0018\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bH&J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0006H\u0016R\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolNamesProvider;", "", "<init>", "()V", "getTopLevelClassifierNamesInPackage", "", "Lorg/jetbrains/kotlin/name/Name;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "getPackageNamesWithTopLevelCallables", "", "getTopLevelCallableNamesInPackage", "mayHaveSyntheticFunctionTypes", "", "getMayHaveSyntheticFunctionTypes", "()Z", "mayHaveSyntheticFunctionType", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "mayHaveTopLevelClassifier", "mayHaveTopLevelCallable", "name", "providers"})
public abstract class FirSymbolNamesProvider {
    private final boolean mayHaveSyntheticFunctionTypes;

    @Nullable
    public abstract Set<Name> getTopLevelClassifierNamesInPackage(@NotNull FqName var1);

    @Nullable
    public abstract Set<String> getPackageNamesWithTopLevelCallables();

    @Nullable
    public abstract Set<Name> getTopLevelCallableNamesInPackage(@NotNull FqName var1);

    public boolean getMayHaveSyntheticFunctionTypes() {
        return this.mayHaveSyntheticFunctionTypes;
    }

    public boolean mayHaveSyntheticFunctionType(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        return this.getMayHaveSyntheticFunctionTypes();
    }

    public boolean mayHaveTopLevelClassifier(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        if (this.getMayHaveSyntheticFunctionTypes() && this.mayHaveSyntheticFunctionType(classId)) {
            return true;
        }
        Set<Name> set = this.getTopLevelClassifierNamesInPackage(classId.getPackageFqName());
        if (set == null) {
            return true;
        }
        Set<Name> names2 = set;
        return !(classId.getOuterClassId() == null ? !FirSymbolNamesProviderKt.access$mayContainTopLevelClassifier(names2, classId.getShortClassName()) : !FirSymbolNamesProviderKt.access$mayContainTopLevelClassifier(names2, classId.getOutermostClassId().getShortClassName()));
    }

    public boolean mayHaveTopLevelCallable(@NotNull FqName packageFqName, @NotNull Name name2) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        if (name2.isSpecial()) {
            return true;
        }
        Set<Name> set = this.getTopLevelCallableNamesInPackage(packageFqName);
        if (set == null) {
            return true;
        }
        Set<Name> names2 = set;
        return names2.contains(name2);
    }
}

