/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.inference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.expressions.FirResolvable;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.resolve.BodyResolveComponents;
import org.jetbrains.kotlin.fir.resolve.ResolutionMode;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.CandidateFactoryKt;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import org.jetbrains.kotlin.fir.resolve.inference.FirInferenceSession;
import org.jetbrains.kotlin.types.model.StubTypeMarker;
import org.jetbrains.kotlin.types.model.TypeVariableMarker;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J+\u0010\u0015\u001a\u00020\u0016\"\f\b\u0000\u0010\u0017*\u00020\u000b*\u00020\u00182\u0006\u0010\u0019\u001a\u0002H\u00172\u0006\u0010\u001a\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\u001bJ+\u0010\u001c\u001a\u00020\u0016\"\f\b\u0000\u0010\u0017*\u00020\u000b*\u00020\u00182\u0006\u0010\u0019\u001a\u0002H\u00172\u0006\u0010\u001d\u001a\u00020\u001eH\u0016\u00a2\u0006\u0002\u0010\u001fJ\u001c\u0010 \u001a\u00020\u00162\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020$0\"H\u0016J\b\u0010'\u001a\u00020\u0016H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R&\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0018\u0010\u001a\u001a\u00020\f*\u00020\u000b8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/fir/resolve/inference/FirInferenceSessionForChainedResolve;", "Lorg/jetbrains/kotlin/fir/resolve/inference/FirInferenceSession;", "resolutionContext", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "<init>", "(Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;)V", "getResolutionContext", "()Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "partiallyResolvedCalls", "", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/fir/expressions/FirResolvable;", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "getPartiallyResolvedCalls", "()Ljava/util/List;", "completedCalls", "", "components", "Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;", "getComponents", "()Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;", "addCompletedCall", "", "T", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "call", "candidate", "(Lorg/jetbrains/kotlin/fir/expressions/FirResolvable;Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;)V", "processPartiallyResolvedCall", "resolutionMode", "Lorg/jetbrains/kotlin/fir/resolve/ResolutionMode;", "(Lorg/jetbrains/kotlin/fir/expressions/FirResolvable;Lorg/jetbrains/kotlin/fir/resolve/ResolutionMode;)V", "registerStubTypes", "map", "", "Lorg/jetbrains/kotlin/types/model/TypeVariableMarker;", "Lorg/jetbrains/kotlin/types/model/StubTypeMarker;", "getCandidate", "(Lorg/jetbrains/kotlin/fir/expressions/FirResolvable;)Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "clear", "resolve"})
public abstract class FirInferenceSessionForChainedResolve
extends FirInferenceSession {
    @NotNull
    private final ResolutionContext resolutionContext;
    @NotNull
    private final List<Pair<FirResolvable, Candidate>> partiallyResolvedCalls;
    @NotNull
    private final Set<FirResolvable> completedCalls;

    public FirInferenceSessionForChainedResolve(@NotNull ResolutionContext resolutionContext) {
        Intrinsics.checkNotNullParameter((Object)resolutionContext, (String)"resolutionContext");
        this.resolutionContext = resolutionContext;
        this.partiallyResolvedCalls = new ArrayList();
        this.completedCalls = new LinkedHashSet();
    }

    @NotNull
    protected final ResolutionContext getResolutionContext() {
        return this.resolutionContext;
    }

    @NotNull
    protected final List<Pair<FirResolvable, Candidate>> getPartiallyResolvedCalls() {
        return this.partiallyResolvedCalls;
    }

    @NotNull
    protected final BodyResolveComponents getComponents() {
        return this.resolutionContext.getBodyResolveComponents();
    }

    @Override
    public <T extends FirResolvable & FirStatement> void addCompletedCall(@NotNull T call2, @NotNull Candidate candidate2) {
        Intrinsics.checkNotNullParameter(call2, (String)"call");
        Intrinsics.checkNotNullParameter((Object)candidate2, (String)"candidate");
    }

    @Override
    public <T extends FirResolvable & FirStatement> void processPartiallyResolvedCall(@NotNull T call2, @NotNull ResolutionMode resolutionMode) {
        Intrinsics.checkNotNullParameter(call2, (String)"call");
        Intrinsics.checkNotNullParameter((Object)resolutionMode, (String)"resolutionMode");
        ((Collection)this.partiallyResolvedCalls).add(TuplesKt.to(call2, (Object)this.getCandidate(call2)));
    }

    @Override
    public void registerStubTypes(@NotNull Map<TypeVariableMarker, ? extends StubTypeMarker> map) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
    }

    @NotNull
    protected final Candidate getCandidate(@NotNull FirResolvable $this$candidate) {
        Intrinsics.checkNotNullParameter((Object)$this$candidate, (String)"<this>");
        Candidate candidate2 = CandidateFactoryKt.candidate($this$candidate);
        Intrinsics.checkNotNull((Object)candidate2);
        return candidate2;
    }

    @Override
    public void clear() {
        this.partiallyResolvedCalls.clear();
        this.completedCalls.clear();
    }
}

