/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.resolve.calls.CallInfo;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.CheckerSink;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionStage;
import org.jetbrains.kotlin.fir.resolve.calls.TypeArgumentMapping;
import org.jetbrains.kotlin.fir.resolve.inference.ConeTypeParameterBasedTypeVariable;
import org.jetbrains.kotlin.fir.resolve.inference.ConstraintSystemCompleterKt;
import org.jetbrains.kotlin.fir.resolve.inference.FirBuilderInferenceSessionKt;
import org.jetbrains.kotlin.fir.resolve.inference.LambdaWithTypeVariableAsExpectedTypeAtom;
import org.jetbrains.kotlin.fir.resolve.inference.PostponedResolvedAtom;
import org.jetbrains.kotlin.fir.resolve.inference.ResolvedCallableReferenceAtom;
import org.jetbrains.kotlin.fir.resolve.inference.ResolvedLambdaAtom;
import org.jetbrains.kotlin.fir.symbols.ConeTypeParameterLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeTypeVariable;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0096@\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/PostponedVariablesInitializerResolutionStage;", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionStage;", "<init>", "()V", "check", "", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "callInfo", "Lorg/jetbrains/kotlin/fir/resolve/calls/CallInfo;", "sink", "Lorg/jetbrains/kotlin/fir/resolve/calls/CheckerSink;", "context", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "(Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;Lorg/jetbrains/kotlin/fir/resolve/calls/CallInfo;Lorg/jetbrains/kotlin/fir/resolve/calls/CheckerSink;Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "resolve"})
@SourceDebugExtension(value={"SMAP\nResolutionStages.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResolutionStages.kt\norg/jetbrains/kotlin/fir/resolve/calls/PostponedVariablesInitializerResolutionStage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,844:1\n1853#2,2:845\n*S KotlinDebug\n*F\n+ 1 ResolutionStages.kt\norg/jetbrains/kotlin/fir/resolve/calls/PostponedVariablesInitializerResolutionStage\n*L\n716#1:845,2\n*E\n"})
public final class PostponedVariablesInitializerResolutionStage
extends ResolutionStage {
    @NotNull
    public static final PostponedVariablesInitializerResolutionStage INSTANCE = new PostponedVariablesInitializerResolutionStage();

    private PostponedVariablesInitializerResolutionStage() {
    }

    @Override
    @Nullable
    public Object check(@NotNull Candidate candidate2, @NotNull CallInfo callInfo, @NotNull CheckerSink sink, @NotNull ResolutionContext context2, @NotNull Continuation<? super Unit> $completion) {
        LinkedHashMap<FirExpression, FirValueParameter> linkedHashMap = candidate2.getArgumentMapping();
        if (linkedHashMap == null) {
            return Unit.INSTANCE;
        }
        LinkedHashMap<FirExpression, FirValueParameter> argumentMapping2 = linkedHashMap;
        if (candidate2.getTypeArgumentMapping() instanceof TypeArgumentMapping.Mapped) {
            return Unit.INSTANCE;
        }
        Set atomsToMark = new LinkedHashSet();
        for (Map.Entry entry : ((Map)argumentMapping2).entrySet()) {
            boolean dontUseBuilderInferenceIfPossible;
            ConeKotlinType type2;
            FirExpression argument2 = (FirExpression)entry.getKey();
            FirValueParameter parameter2 = (FirValueParameter)entry.getValue();
            if (!FirBuilderInferenceSessionKt.hasBuilderInferenceAnnotation(parameter2, context2.getSession())) continue;
            FirExpression unwrapped = FirExpressionUtilKt.unwrapArgument(argument2);
            if (unwrapped instanceof FirAnonymousFunctionExpression) {
                atomsToMark.add(((FirAnonymousFunctionExpression)unwrapped).getAnonymousFunction());
            }
            if (FunctionalTypeUtilsKt.receiverType(type2 = FirTypeUtilsKt.getConeType(parameter2.getReturnTypeRef()), callInfo.getSession()) == null || (dontUseBuilderInferenceIfPossible = FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession()).supportsFeature(LanguageFeature.UseBuilderInferenceOnlyIfNeeded))) continue;
            for (ConeTypeVariable freshVariable : candidate2.getFreshVariables()) {
                FirTypeParameterSymbol typeParameterSymbol;
                ConeKotlinType receiverType;
                boolean typeHasVariable2;
                if (ConstraintSystemCompleterKt.getCsBuilder(candidate2).isPostponedTypeVariable(freshVariable) || !(freshVariable instanceof ConeTypeParameterBasedTypeVariable) || !(typeHasVariable2 = ConeTypeUtilsKt.contains(receiverType, (Function1<? super ConeKotlinType, Boolean>)((Function1)new Function1<ConeKotlinType, Boolean>(typeParameterSymbol = ((ConeTypeParameterBasedTypeVariable)freshVariable).getTypeParameterSymbol()){
                    final /* synthetic */ FirTypeParameterSymbol $typeParameterSymbol;
                    {
                        this.$typeParameterSymbol = $typeParameterSymbol;
                        super(1);
                    }

                    public final Boolean invoke(ConeKotlinType it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        Object object = it instanceof ConeTypeParameterType ? (ConeTypeParameterType)it : null;
                        return Intrinsics.areEqual((Object)(object != null && (object = ((ConeTypeParameterType)object).getLookupTag()) != null ? ((ConeTypeParameterLookupTag)object).getTypeParameterSymbol() : null), (Object)this.$typeParameterSymbol);
                    }
                })))) continue;
                ConstraintSystemCompleterKt.getCsBuilder(candidate2).markPostponedVariable(freshVariable);
            }
        }
        Iterable $this$forEach$iv = candidate2.getPostponedAtoms();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PostponedResolvedAtom postponedAtomContainer = (PostponedResolvedAtom)element$iv;
            boolean bl = false;
            PostponedResolvedAtom postponedResolvedAtom = postponedAtomContainer;
            if (postponedResolvedAtom instanceof ResolvedLambdaAtom) {
                if (!atomsToMark.contains(((ResolvedLambdaAtom)postponedAtomContainer).getAtom())) continue;
                ((ResolvedLambdaAtom)postponedAtomContainer).setCorrespondingParameterAnnotatedWithBuilderInference(true);
                continue;
            }
            if (postponedResolvedAtom instanceof LambdaWithTypeVariableAsExpectedTypeAtom || postponedResolvedAtom instanceof ResolvedCallableReferenceAtom) continue;
            throw new NoWhenBranchMatchedException();
        }
        return Unit.INSTANCE;
    }
}

