/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.declarations.DeprecationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirSuperReference;
import org.jetbrains.kotlin.fir.resolve.calls.CallInfo;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.CheckerSink;
import org.jetbrains.kotlin.fir.resolve.calls.HiddenCandidate;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionDiagnostic;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionStage;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationInfo;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationLevelValue;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0096@\u00a2\u0006\u0002\u0010\u000eJ$\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\f\u0010\u0013\u001a\u00020\u0010*\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u0010*\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0013\u001a\u00020\u0010H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/CheckHiddenDeclaration;", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionStage;", "<init>", "()V", "check", "", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "callInfo", "Lorg/jetbrains/kotlin/fir/resolve/calls/CallInfo;", "sink", "Lorg/jetbrains/kotlin/fir/resolve/calls/CheckerSink;", "context", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "(Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;Lorg/jetbrains/kotlin/fir/resolve/calls/CallInfo;Lorg/jetbrains/kotlin/fir/resolve/calls/CheckerSink;Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isHiddenForThisCallSite", "", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "isSuperCall", "Lorg/jetbrains/kotlin/fir/FirElement;", "isHidden", "resolve"})
@SourceDebugExtension(value={"SMAP\nResolutionStages.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResolutionStages.kt\norg/jetbrains/kotlin/fir/resolve/calls/CheckHiddenDeclaration\n+ 2 CheckerSink.kt\norg/jetbrains/kotlin/fir/resolve/calls/CheckerSinkKt\n*L\n1#1,844:1\n28#2,2:845\n22#2,9:847\n*S KotlinDebug\n*F\n+ 1 ResolutionStages.kt\norg/jetbrains/kotlin/fir/resolve/calls/CheckHiddenDeclaration\n*L\n762#1:845,2\n762#1:847,9\n*E\n"})
public final class CheckHiddenDeclaration
extends ResolutionStage {
    @NotNull
    public static final CheckHiddenDeclaration INSTANCE = new CheckHiddenDeclaration();

    private CheckHiddenDeclaration() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object check(@NotNull Candidate candidate2, @NotNull CallInfo callInfo, @NotNull CheckerSink sink, @NotNull ResolutionContext context2, @NotNull Continuation<? super Unit> $completion) {
        DeprecationInfo deprecation;
        FirBasedSymbol<?> firBasedSymbol = candidate2.getSymbol();
        FirCallableSymbol firCallableSymbol = firBasedSymbol instanceof FirCallableSymbol ? (FirCallableSymbol)firBasedSymbol : null;
        if (firCallableSymbol == null) {
            return Unit.INSTANCE;
        }
        FirCallableSymbol symbol2 = firCallableSymbol;
        DeprecationInfo deprecationInfo = deprecation = DeprecationUtilsKt.getDeprecation(symbol2, context2.getSession(), callInfo.getCallSite());
        if ((deprecationInfo != null ? deprecationInfo.getDeprecationLevel() : null) == DeprecationLevelValue.HIDDEN || this.isHiddenForThisCallSite(symbol2, callInfo, candidate2)) {
            void $this$yieldDiagnostic$iv;
            firBasedSymbol = sink;
            ResolutionDiagnostic diagnostic$iv = HiddenCandidate.INSTANCE;
            boolean $i$f$yieldDiagnostic = false;
            $this$yieldDiagnostic$iv.reportDiagnostic(diagnostic$iv);
            void $this$yieldIfNeed$iv$iv = $this$yieldDiagnostic$iv;
            boolean $i$f$yieldIfNeed = false;
            if ($this$yieldIfNeed$iv$iv.getNeedYielding()) {
                Object object = $this$yieldIfNeed$iv$iv.yield($completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    private final boolean isHiddenForThisCallSite(FirCallableSymbol<?> symbol2, CallInfo callInfo, Candidate candidate2) {
        boolean isSuperCall = this.isSuperCall(callInfo.getCallSite());
        if (((FirCallableDeclaration)symbol2.getFir()).getDispatchReceiverType() == null || !(symbol2 instanceof FirNamedFunctionSymbol)) {
            return false;
        }
        if (this.isHidden(symbol2, isSuperCall)) {
            return true;
        }
        FirScope firScope = candidate2.getOriginScope();
        FirTypeScope firTypeScope = firScope instanceof FirTypeScope ? (FirTypeScope)firScope : null;
        if (firTypeScope == null) {
            return false;
        }
        FirTypeScope scope2 = firTypeScope;
        Ref.BooleanRef result2 = new Ref.BooleanRef();
        FirTypeScopeKt.processOverriddenFunctions(scope2, (FirNamedFunctionSymbol)symbol2, (Function1<? super FirNamedFunctionSymbol, ? extends ProcessorAction>)((Function1)new Function1<FirNamedFunctionSymbol, ProcessorAction>(isSuperCall, result2){
            final /* synthetic */ boolean $isSuperCall;
            final /* synthetic */ Ref.BooleanRef $result;
            {
                this.$isSuperCall = $isSuperCall;
                this.$result = $result;
                super(1);
            }

            public final ProcessorAction invoke(FirNamedFunctionSymbol it) {
                ProcessorAction processorAction;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (CheckHiddenDeclaration.access$isHidden(CheckHiddenDeclaration.INSTANCE, it, this.$isSuperCall)) {
                    this.$result.element = true;
                    processorAction = ProcessorAction.STOP;
                } else {
                    processorAction = ProcessorAction.NEXT;
                }
                return processorAction;
            }
        }));
        return result2.element;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSuperCall(FirElement $this$isSuperCall) {
        if (!($this$isSuperCall instanceof FirQualifiedAccessExpression)) return false;
        FirExpression firExpression2 = ((FirQualifiedAccessExpression)$this$isSuperCall).getExplicitReceiver();
        if (!((firExpression2 != null ? FirExpressionUtilKt.getCalleeReference(firExpression2) : null) instanceof FirSuperReference)) return false;
        return true;
    }

    private final boolean isHidden(FirCallableSymbol<?> $this$isHidden, boolean isSuperCall) {
        FirCallableDeclaration fir = (FirCallableDeclaration)$this$isHidden.getFir();
        return !isSuperCall && Intrinsics.areEqual((Object)DeprecationUtilsKt.isHiddenEverywhereBesideSuperCalls(fir), (Object)true) || Intrinsics.areEqual((Object)DeprecationUtilsKt.isHiddenToOvercomeSignatureClash(fir), (Object)true);
    }

    public static final /* synthetic */ boolean access$isHidden(CheckHiddenDeclaration $this, FirCallableSymbol $receiver, boolean isSuperCall) {
        return $this.isHidden($receiver, isSuperCall);
    }
}

