/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.wasm.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.wasm.FirWasmErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.utils.FirWebCommonHelpersKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/wasm/checkers/declaration/FirWasmExternalInheritanceChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.wasm"})
public final class FirWasmExternalInheritanceChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirWasmExternalInheritanceChecker INSTANCE = new FirWasmExternalInheritanceChecker();

    private FirWasmExternalInheritanceChecker() {
    }

    @Override
    public void check(@NotNull FirClass declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirSession session2 = context2.getSession();
        boolean isCurrentClassExternal = FirWebCommonHelpersKt.isEffectivelyExternal((FirBasedSymbol)declaration.getSymbol(), session2);
        for (FirTypeRef superTypeRef : declaration.getSuperTypeRefs()) {
            FirClassLikeSymbol<?> superClass;
            if (FirHelpersKt.toClassLikeSymbol(superTypeRef, session2) == null || Intrinsics.areEqual((Object)superClass.getClassId(), (Object)StandardClassIds.INSTANCE.getAny())) continue;
            boolean isSuperClassExternal = FirWebCommonHelpersKt.isEffectivelyExternal((FirBasedSymbol)superClass, session2);
            if (!isCurrentClassExternal && isSuperClassExternal) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirWasmErrors.INSTANCE.getNON_EXTERNAL_TYPE_EXTENDS_EXTERNAL_TYPE(), (Object)FirTypeUtilsKt.getConeType(superTypeRef), (DiagnosticContext)context2, null, 16, null);
                continue;
            }
            if (!isCurrentClassExternal || isSuperClassExternal || declaration.getClassKind() == ClassKind.ANNOTATION_CLASS && Intrinsics.areEqual((Object)superClass.getClassId(), (Object)StandardClassIds.INSTANCE.getAnnotation()) || declaration.getClassKind() == ClassKind.ENUM_CLASS && Intrinsics.areEqual((Object)superClass.getClassId(), (Object)StandardClassIds.INSTANCE.getEnum())) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirWasmErrors.INSTANCE.getEXTERNAL_TYPE_EXTENDS_NON_EXTERNAL_TYPE(), (Object)FirTypeUtilsKt.getConeType(superTypeRef), (DiagnosticContext)context2, null, 16, null);
        }
    }
}

