/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.diagnostics.FirDiagnosticHolder;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeDiagnosticWithSingleCandidate;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u0007*\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00070\u0010H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencyClassChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "forEachClassLikeType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "action", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirMissingDependencyClassChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirMissingDependencyClassChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencyClassChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,72:1\n1#2:73\n1853#3,2:74\n1853#3,2:76\n*S KotlinDebug\n*F\n+ 1 FirMissingDependencyClassChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencyClassChecker\n*L\n51#1:74,2\n66#1:76,2\n*E\n"})
public final class FirMissingDependencyClassChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirMissingDependencyClassChecker INSTANCE = new FirMissingDependencyClassChecker();

    private FirMissingDependencyClassChecker() {
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirReference calleeReference = expression2.getCalleeReference();
        if (FirReferenceUtilsKt.isError(calleeReference) && !(((FirDiagnosticHolder)((Object)calleeReference)).getDiagnostic() instanceof ConeDiagnosticWithSingleCandidate)) {
            return;
        }
        Set missingTypes = new LinkedHashSet();
        FirCallableSymbol firCallableSymbol = FirReferenceUtilsKt.toResolvedCallableSymbol$default(calleeReference, false, 1, null);
        if (firCallableSymbol == null) {
            return;
        }
        FirCallableSymbol symbol2 = firCallableSymbol;
        FirMissingDependencyClassChecker.check$consider(context2, missingTypes, FirTypeUtilsKt.getConeType(symbol2.getResolvedReturnTypeRef()));
        Object object2 = symbol2.getResolvedReceiverTypeRef();
        if (object2 != null && (object2 = FirTypeUtilsKt.getConeType((FirTypeRef)object2)) != null) {
            Object p0 = object2;
            boolean bl = false;
            FirMissingDependencyClassChecker.check$consider(context2, missingTypes, (ConeKotlinType)p0);
        }
        if ((object = symbol2 instanceof FirFunctionSymbol ? (FirFunctionSymbol)symbol2 : null) != null && (object = ((FirFunctionSymbol)object).getValueParameterSymbols()) != null) {
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirValueParameterSymbol it = (FirValueParameterSymbol)element$iv;
                boolean bl = false;
                FirMissingDependencyClassChecker.check$consider(context2, missingTypes, FirTypeUtilsKt.getConeType(it.getResolvedReturnTypeRef()));
            }
        }
        for (ConeKotlinType missingType : missingTypes) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getMISSING_DEPENDENCY_CLASS(), (Object)missingType, (DiagnosticContext)context2, null, 16, null);
        }
    }

    private final void forEachClassLikeType(ConeKotlinType $this$forEachClassLikeType, Function1<? super ConeClassLikeType, Unit> action) {
        ConeKotlinType coneKotlinType = $this$forEachClassLikeType;
        if (coneKotlinType instanceof ConeFlexibleType) {
            this.forEachClassLikeType(((ConeFlexibleType)$this$forEachClassLikeType).getLowerBound(), action);
            this.forEachClassLikeType(((ConeFlexibleType)$this$forEachClassLikeType).getUpperBound(), action);
        } else if (coneKotlinType instanceof ConeDefinitelyNotNullType) {
            this.forEachClassLikeType(((ConeDefinitelyNotNullType)$this$forEachClassLikeType).getOriginal(), action);
        } else if (coneKotlinType instanceof ConeIntersectionType) {
            Iterable $this$forEach$iv = ((ConeIntersectionType)$this$forEachClassLikeType).getIntersectedTypes();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ConeKotlinType it = (ConeKotlinType)element$iv;
                boolean bl = false;
                INSTANCE.forEachClassLikeType(it, action);
            }
        } else if (coneKotlinType instanceof ConeClassLikeType) {
            action.invoke((Object)$this$forEachClassLikeType);
        }
    }

    private static final void check$consider(CheckerContext $context, Set<ConeKotlinType> missingTypes, ConeKotlinType type2) {
        Ref.BooleanRef hasError2 = new Ref.BooleanRef();
        Ref.BooleanRef hasMissingClass = new Ref.BooleanRef();
        INSTANCE.forEachClassLikeType(type2, (Function1<? super ConeClassLikeType, Unit>)((Function1)new Function1<ConeClassLikeType, Unit>(hasError2, hasMissingClass, $context){
            final /* synthetic */ Ref.BooleanRef $hasError;
            final /* synthetic */ Ref.BooleanRef $hasMissingClass;
            final /* synthetic */ CheckerContext $context;
            {
                this.$hasError = $hasError;
                this.$hasMissingClass = $hasMissingClass;
                this.$context = $context;
                super(1);
            }

            public final void invoke(ConeClassLikeType it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (it instanceof ConeErrorType) {
                    this.$hasError.element = true;
                } else {
                    this.$hasMissingClass.element = this.$hasMissingClass.element || LookupTagUtilsKt.toSymbol(it.getLookupTag(), this.$context.getSession()) == null;
                }
            }
        }));
        if (hasMissingClass.element && !hasError2.element) {
            ConeKotlinType reportedType = TypeUtilsKt.withArguments(TypeUtilsKt.withNullability$default(type2, ConeNullability.NOT_NULL, TypeComponentsKt.getTypeContext($context.getSession()), null, false, 12, null), new ConeTypeProjection[0]);
            missingTypes.add(reportedType);
        }
    }
}

