/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common;

import java.io.PrintStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.ArgumentsKt;
import org.jetbrains.kotlin.cli.common.CompilerSystemProperties;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.Usage;
import org.jetbrains.kotlin.cli.common.arguments.CommonToolArguments;
import org.jetbrains.kotlin.cli.common.arguments.ParseCommandLineArgumentsKt;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.FilteringMessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;
import org.jetbrains.kotlin.cli.common.messages.PlainTextMessageRenderer;
import org.jetbrains.kotlin.cli.common.messages.PrintingMessageCollector;
import org.jetbrains.kotlin.cli.jvm.compiler.CompatKt;
import org.jetbrains.kotlin.cli.jvm.compiler.CompileEnvironmentException;
import org.jetbrains.kotlin.config.KotlinCompilerVersion;
import org.jetbrains.kotlin.config.Services;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\b&\u0018\u0000 '*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001'B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J'\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\"\u00020\f\u00a2\u0006\u0002\u0010\rJ/\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\"\u00020\f\u00a2\u0006\u0002\u0010\u0010J5\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000bH\u0004\u00a2\u0006\u0002\u0010\u0013J#\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0002J%\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0017J\r\u0010\u001b\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u001cJ#\u0010\u001d\u001a\u00020\u00192\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b2\u0006\u0010\u0016\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001eJ'\u0010\u001f\u001a\u00020\u0019\"\b\b\u0001\u0010\u0001*\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u0002H\u0001H\u0002\u00a2\u0006\u0002\u0010 J\b\u0010!\u001a\u00020\fH&R\u001a\u0010\"\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010$\"\u0004\b%\u0010&\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/cli/common/CLITool;", "A", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonToolArguments;", "", "<init>", "()V", "exec", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "errStream", "Ljava/io/PrintStream;", "args", "", "", "(Ljava/io/PrintStream;[Ljava/lang/String;)Lorg/jetbrains/kotlin/cli/common/ExitCode;", "messageRenderer", "Lorg/jetbrains/kotlin/cli/common/messages/MessageRenderer;", "(Ljava/io/PrintStream;Lorg/jetbrains/kotlin/cli/common/messages/MessageRenderer;[Ljava/lang/String;)Lorg/jetbrains/kotlin/cli/common/ExitCode;", "services", "Lorg/jetbrains/kotlin/config/Services;", "(Ljava/io/PrintStream;Lorg/jetbrains/kotlin/config/Services;Lorg/jetbrains/kotlin/cli/common/messages/MessageRenderer;[Ljava/lang/String;)Lorg/jetbrains/kotlin/cli/common/ExitCode;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "arguments", "(Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Lorg/jetbrains/kotlin/config/Services;Lorg/jetbrains/kotlin/cli/common/arguments/CommonToolArguments;)Lorg/jetbrains/kotlin/cli/common/ExitCode;", "disableURLConnectionCaches", "", "execImpl", "createArguments", "()Lorg/jetbrains/kotlin/cli/common/arguments/CommonToolArguments;", "parseArguments", "([Ljava/lang/String;Lorg/jetbrains/kotlin/cli/common/arguments/CommonToolArguments;)V", "printVersionIfNeeded", "(Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Lorg/jetbrains/kotlin/cli/common/arguments/CommonToolArguments;)V", "executableScriptFileName", "isReadingSettingsFromEnvironmentAllowed", "", "()Z", "setReadingSettingsFromEnvironmentAllowed", "(Z)V", "Companion", "cli"})
public abstract class CLITool<A extends CommonToolArguments> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isReadingSettingsFromEnvironmentAllowed = this.getClass().getClassLoader().getResource("META-INF/allow-configuring-from-environment") != null;

    @NotNull
    public final ExitCode exec(@NotNull PrintStream errStream, String ... args) {
        Intrinsics.checkNotNullParameter((Object)errStream, (String)"errStream");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return this.exec(errStream, Services.EMPTY, CLITool.Companion.defaultMessageRenderer(), args);
    }

    @NotNull
    public final ExitCode exec(@NotNull PrintStream errStream, @NotNull MessageRenderer messageRenderer, String ... args) {
        Intrinsics.checkNotNullParameter((Object)errStream, (String)"errStream");
        Intrinsics.checkNotNullParameter((Object)messageRenderer, (String)"messageRenderer");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return this.exec(errStream, Services.EMPTY, messageRenderer, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected final ExitCode exec(@NotNull PrintStream errStream, @NotNull Services services, @NotNull MessageRenderer messageRenderer, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)errStream, (String)"errStream");
        Intrinsics.checkNotNullParameter((Object)services, (String)"services");
        Intrinsics.checkNotNullParameter((Object)messageRenderer, (String)"messageRenderer");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        A arguments2 = this.createArguments();
        ParseCommandLineArgumentsKt.parseCommandLineArguments$default(ArraysKt.asList((Object[])args), arguments2, false, 4, null);
        if (this.isReadingSettingsFromEnvironmentAllowed) {
            ParseCommandLineArgumentsKt.parseCommandLineArgumentsFromEnvironment(arguments2);
        }
        PrintingMessageCollector collector2 = new PrintingMessageCollector(errStream, messageRenderer, ((CommonToolArguments)arguments2).getVerbose());
        try {
            if (messageRenderer instanceof PlainTextMessageRenderer) {
                ((PlainTextMessageRenderer)messageRenderer).enableColorsIfNeeded();
            }
            errStream.print(messageRenderer.renderPreamble());
            String errorMessage2 = ParseCommandLineArgumentsKt.validateArguments(((CommonToolArguments)arguments2).getErrors());
            if (errorMessage2 != null) {
                collector2.report(CompilerMessageSeverity.ERROR, errorMessage2, null);
                collector2.report(CompilerMessageSeverity.INFO, "Use -help for more information", null);
                ExitCode exitCode = ExitCode.COMPILATION_ERROR;
                return exitCode;
            }
            if (((CommonToolArguments)arguments2).getHelp() || ((CommonToolArguments)arguments2).getExtraHelp()) {
                errStream.print(messageRenderer.renderUsage(Usage.render(this, arguments2)));
                ExitCode exitCode = ExitCode.OK;
                return exitCode;
            }
            ExitCode exitCode = this.exec(collector2, services, arguments2);
            return exitCode;
        }
        finally {
            errStream.print(messageRenderer.renderConclusion());
            if (messageRenderer instanceof PlainTextMessageRenderer) {
                ((PlainTextMessageRenderer)messageRenderer).disableColorsIfNeeded();
            }
        }
    }

    @NotNull
    public final ExitCode exec(@NotNull MessageCollector messageCollector, @NotNull Services services, @NotNull A arguments2) {
        Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
        Intrinsics.checkNotNullParameter((Object)services, (String)"services");
        Intrinsics.checkNotNullParameter(arguments2, (String)"arguments");
        this.disableURLConnectionCaches();
        this.printVersionIfNeeded(messageCollector, arguments2);
        MessageCollector fixedMessageCollector = ((CommonToolArguments)arguments2).getSuppressWarnings() && !((CommonToolArguments)arguments2).getAllWarningsAsErrors() ? (MessageCollector)new FilteringMessageCollector(messageCollector, Predicate.isEqual((Object)CompilerMessageSeverity.WARNING)) : messageCollector;
        ArgumentsKt.reportArgumentParseProblems(fixedMessageCollector, arguments2);
        return this.execImpl(fixedMessageCollector, services, arguments2);
    }

    private final void disableURLConnectionCaches() {
        URL uRL = new URL("file:.");
        new URLConnection(uRL){

            public Void connect() {
                throw new UnsupportedOperationException();
            }
        }.setDefaultUseCaches(false);
    }

    @NotNull
    protected abstract ExitCode execImpl(@NotNull MessageCollector var1, @NotNull Services var2, @NotNull A var3);

    @NotNull
    public abstract A createArguments();

    public final void parseArguments(@NotNull String[] args, @NotNull A arguments2) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter(arguments2, (String)"arguments");
        ParseCommandLineArgumentsKt.parseCommandLineArguments$default(ArraysKt.asList((Object[])args), arguments2, false, 4, null);
        String message2 = ParseCommandLineArgumentsKt.validateArguments(((CommonToolArguments)arguments2).getErrors());
        if (message2 != null) {
            throw new IllegalArgumentException(message2);
        }
    }

    private final <A extends CommonToolArguments> void printVersionIfNeeded(MessageCollector messageCollector, A arguments2) {
        if (arguments2.getVersion()) {
            String jreVersion = System.getProperty("java.runtime.version");
            MessageCollector.report$default(messageCollector, CompilerMessageSeverity.INFO, this.executableScriptFileName() + ' ' + KotlinCompilerVersion.VERSION + " (JRE " + jreVersion + ')', null, 4, null);
        }
    }

    @NotNull
    public abstract String executableScriptFileName();

    public final boolean isReadingSettingsFromEnvironmentAllowed() {
        return this.isReadingSettingsFromEnvironmentAllowed;
    }

    public final void setReadingSettingsFromEnvironmentAllowed(boolean bl) {
        this.isReadingSettingsFromEnvironmentAllowed = bl;
    }

    @JvmStatic
    public static final void doMain(@NotNull CLITool<?> compiler, @NotNull String[] args) {
        Companion.doMain(compiler, args);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final ExitCode doMainNoExit(@NotNull CLITool<?> compiler, @NotNull String[] args, @NotNull MessageRenderer messageRenderer) {
        return Companion.doMainNoExit(compiler, args, messageRenderer);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final ExitCode doMainNoExit(@NotNull CLITool<?> compiler, @NotNull String[] args) {
        return Companion.doMainNoExit(compiler, args);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J'\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0007\u00a2\u0006\u0002\u0010\rJ1\u0010\u000e\u001a\u00020\u000f2\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\b\u0002\u0010\u0010\u001a\u00020\u0005H\u0007\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/cli/common/CLITool$Companion;", "", "<init>", "()V", "defaultMessageRenderer", "Lorg/jetbrains/kotlin/cli/common/messages/MessageRenderer;", "doMain", "", "compiler", "Lorg/jetbrains/kotlin/cli/common/CLITool;", "args", "", "", "(Lorg/jetbrains/kotlin/cli/common/CLITool;[Ljava/lang/String;)V", "doMainNoExit", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "messageRenderer", "(Lorg/jetbrains/kotlin/cli/common/CLITool;[Ljava/lang/String;Lorg/jetbrains/kotlin/cli/common/messages/MessageRenderer;)Lorg/jetbrains/kotlin/cli/common/ExitCode;", "cli"})
    public static final class Companion {
        private Companion() {
        }

        private final MessageRenderer defaultMessageRenderer() {
            String string2 = System.getProperty("org.jetbrains.kotlin.cliMessageRenderer");
            MessageRenderer messageRenderer = Intrinsics.areEqual((Object)string2, (Object)MessageRenderer.XML.getName()) ? MessageRenderer.XML : (Intrinsics.areEqual((Object)string2, (Object)MessageRenderer.GRADLE_STYLE.getName()) ? MessageRenderer.GRADLE_STYLE : (Intrinsics.areEqual((Object)string2, (Object)MessageRenderer.XCODE_STYLE.getName()) ? MessageRenderer.XCODE_STYLE : (Intrinsics.areEqual((Object)string2, (Object)MessageRenderer.WITHOUT_PATHS.getName()) ? MessageRenderer.WITHOUT_PATHS : (Intrinsics.areEqual((Object)string2, (Object)MessageRenderer.PLAIN_FULL_PATHS.getName()) ? MessageRenderer.PLAIN_FULL_PATHS : MessageRenderer.PLAIN_RELATIVE_PATHS))));
            Intrinsics.checkNotNull((Object)messageRenderer);
            return messageRenderer;
        }

        @JvmStatic
        public final void doMain(@NotNull CLITool<?> compiler, @NotNull String[] args) {
            Intrinsics.checkNotNullParameter(compiler, (String)"compiler");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            if (System.getProperty("java.awt.headless") == null) {
                System.setProperty("java.awt.headless", "true");
            }
            if (CompilerSystemProperties.KOTLIN_COLORS_ENABLED_PROPERTY.getValue() == null) {
                CompilerSystemProperties.KOTLIN_COLORS_ENABLED_PROPERTY.setValue("true");
            }
            CompatKt.setupIdeaStandaloneExecution();
            ExitCode exitCode = org.jetbrains.kotlin.cli.common.CLITool$Companion.doMainNoExit$default(this, compiler, args, null, 4, null);
            if (exitCode != ExitCode.OK) {
                System.exit(exitCode.getCode());
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final ExitCode doMainNoExit(@NotNull CLITool<?> compiler, @NotNull String[] args, @NotNull MessageRenderer messageRenderer) {
            ExitCode exitCode;
            Intrinsics.checkNotNullParameter(compiler, (String)"compiler");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            Intrinsics.checkNotNullParameter((Object)messageRenderer, (String)"messageRenderer");
            try {
                PrintStream printStream = System.err;
                Intrinsics.checkNotNullExpressionValue((Object)printStream, (String)"err");
                exitCode = compiler.exec(printStream, messageRenderer, Arrays.copyOf(args, args.length));
            }
            catch (CompileEnvironmentException e) {
                System.err.println(e.getMessage());
                exitCode = ExitCode.INTERNAL_ERROR;
            }
            return exitCode;
        }

        public static /* synthetic */ ExitCode doMainNoExit$default(Companion companion, CLITool cLITool, String[] stringArray, MessageRenderer messageRenderer, int n, Object object) {
            if ((n & 4) != 0) {
                messageRenderer = companion.defaultMessageRenderer();
            }
            return companion.doMainNoExit(cLITool, stringArray, messageRenderer);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final ExitCode doMainNoExit(@NotNull CLITool<?> compiler, @NotNull String[] args) {
            Intrinsics.checkNotNullParameter(compiler, (String)"compiler");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            return org.jetbrains.kotlin.cli.common.CLITool$Companion.doMainNoExit$default(this, compiler, args, null, 4, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

