/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.build.report.statistics;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=50, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u000e\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0003\u001a\u0014\u0010\n\u001a\u00020\u0001*\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"formatTime", "", "ms", "", "kbSize", "", "mbSize", "gbSize", "formatSize", "sizeInBytes", "asString", "", "decPoints", "kotlin-build-statistics"})
public final class FormattingUtilsKt {
    @NotNull
    public static final String formatTime(long ms) {
        double seconds = (double)ms / (double)1000;
        return FormattingUtilsKt.asString(seconds, 2) + " s";
    }

    @NotNull
    public static final String formatSize(long sizeInBytes) {
        return sizeInBytes / (long)0x40000000 >= 1L ? FormattingUtilsKt.asString((double)sizeInBytes / (double)0x40000000, 1) + " GB" : (sizeInBytes / (long)0x100000 >= 1L ? FormattingUtilsKt.asString((double)sizeInBytes / (double)0x100000, 1) + " MB" : (sizeInBytes / (long)1024 >= 1L ? FormattingUtilsKt.asString((double)sizeInBytes / (double)1024, 1) + " KB" : sizeInBytes + " B"));
    }

    @NotNull
    public static final String asString(double $this$asString, int decPoints) {
        String string2 = "%,." + decPoints + 'f';
        Object[] objectArray = new Object[]{$this$asString};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        return string3;
    }
}

