/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.LoggingContext;
import org.jetbrains.kotlin.backend.common.linkage.issues.ChecksKt;
import org.jetbrains.kotlin.backend.common.phaser.PhaseConfig;
import org.jetbrains.kotlin.backend.common.phaser.PhaserState;
import org.jetbrains.kotlin.backend.common.phaser.SimpleNamedCompilerPhase;
import org.jetbrains.kotlin.backend.wasm.CompilerKt;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.WasmCompilerResult;
import org.jetbrains.kotlin.backend.wasm.WasmLoweringPhasesKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.JsHelpersKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.JsModuleAndQualifierReference;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmCompiledModuleFragment;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmModuleFragmentGenerator;
import org.jetbrains.kotlin.backend.wasm.lower.MarkAdditionalExportedDeclarationsKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.backend.js.IrModuleInfo;
import org.jetbrains.kotlin.ir.backend.js.KlibKt;
import org.jetbrains.kotlin.ir.backend.js.MainModule;
import org.jetbrains.kotlin.ir.backend.js.ModulesStructure;
import org.jetbrains.kotlin.ir.backend.js.SourceMapsInfo;
import org.jetbrains.kotlin.ir.backend.js.lower.serialization.ir.JsIrLinker;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.util.ExternalDependenciesGenerator;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.config.WasmTarget;
import org.jetbrains.kotlin.js.sourceMap.SourceFilePathResolver;
import org.jetbrains.kotlin.js.sourceMap.SourceMap3Builder;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.wasm.ir.WasmModule;
import org.jetbrains.kotlin.wasm.ir.convertors.WasmIrToBinary;
import org.jetbrains.kotlin.wasm.ir.convertors.WasmIrToText;
import org.jetbrains.kotlin.wasm.ir.source.location.SourceLocation;
import org.jetbrains.kotlin.wasm.ir.source.location.SourceLocationMapping;

@Metadata(mv={2, 0, 0}, k=2, xi=50, d1={"\u0000v\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001aH\u0010\u0000\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u00040\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f\u001aL\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u000f2\b\b\u0002\u0010\u0017\u001a\u00020\u000f2\b\b\u0002\u0010\u0018\u001a\u00020\u000f2\b\b\u0002\u0010\u0019\u001a\u00020\u000f\u001a\"\u0010\u001a\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u000e\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001eH\u0002\u001a\u0012\u0010 \u001a\u00020\u0015*\u00020!2\u0006\u0010\"\u001a\u00020\u0015\u001a \u0010#\u001a\u00020\u0015*\u00020!2\u0006\u0010\"\u001a\u00020\u00152\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\f\u001a\u000e\u0010&\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\u0015\u001a\u001e\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00112\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0015\u00a8\u0006."}, d2={"compileToLoweredIr", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "depsDescriptors", "Lorg/jetbrains/kotlin/ir/backend/js/ModulesStructure;", "phaseConfig", "Lorg/jetbrains/kotlin/backend/common/phaser/PhaseConfig;", "irFactory", "Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "exportedDeclarations", "", "Lorg/jetbrains/kotlin/name/FqName;", "propertyLazyInitialization", "", "compileWasm", "Lorg/jetbrains/kotlin/backend/wasm/WasmCompilerResult;", "allModules", "backendContext", "baseFileName", "", "emitNameSection", "allowIncompleteImplementations", "generateWat", "generateSourceMaps", "generateSourceMap", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "sourceLocationMappings", "", "Lorg/jetbrains/kotlin/wasm/ir/source/location/SourceLocationMapping;", "generateAsyncWasiWrapper", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmCompiledModuleFragment;", "wasmFilePath", "generateAsyncJsWrapper", "jsModuleAndQualifierReferences", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/JsModuleAndQualifierReference;", "generateEsmExportsWrapper", "asyncWrapperFileName", "writeCompilationResult", "", "result", "dir", "Ljava/io/File;", "fileNameBase", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\ncompiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 compiler.kt\norg/jetbrains/kotlin/backend/wasm/CompilerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,378:1\n1853#2,2:379\n1853#2,2:381\n1862#2,2:383\n1853#2,2:385\n1864#2:387\n1853#2,2:388\n1853#2,2:390\n1547#2:393\n1618#2,3:394\n1#3:392\n*S KotlinDebug\n*F\n+ 1 compiler.kt\norg/jetbrains/kotlin/backend/wasm/CompilerKt\n*L\n71#1:379,2\n77#1:381,2\n88#1:383,2\n89#1:385,2\n88#1:387\n111#1:388,2\n112#1:390,2\n239#1:393\n239#1:394,3\n*E\n"})
public final class CompilerKt {
    @NotNull
    public static final Pair<List<IrModuleFragment>, WasmBackendContext> compileToLoweredIr(@NotNull ModulesStructure depsDescriptors, @NotNull PhaseConfig phaseConfig, @NotNull IrFactory irFactory, @NotNull Set<FqName> exportedDeclarations2, boolean propertyLazyInitialization) {
        IrModuleFragment it;
        Object element$iv;
        List list2;
        Intrinsics.checkNotNullParameter((Object)depsDescriptors, (String)"depsDescriptors");
        Intrinsics.checkNotNullParameter((Object)phaseConfig, (String)"phaseConfig");
        Intrinsics.checkNotNullParameter((Object)irFactory, (String)"irFactory");
        Intrinsics.checkNotNullParameter(exportedDeclarations2, (String)"exportedDeclarations");
        MainModule mainModule = depsDescriptors.getMainModule();
        CompilerConfiguration configuration2 = depsDescriptors.getCompilerConfiguration();
        IrModuleInfo irModuleInfo = KlibKt.loadIr$default(depsDescriptors, irFactory, false, null, true, 8, null);
        IrModuleFragment moduleFragment = irModuleInfo.component1();
        List dependencyModules = irModuleInfo.component2();
        IrBuiltIns irBuiltIns = irModuleInfo.component3();
        SymbolTable symbolTable = irModuleInfo.component4();
        JsIrLinker irLinker = irModuleInfo.component5();
        MainModule mainModule2 = mainModule;
        if (mainModule2 instanceof MainModule.SourceFiles) {
            list2 = CollectionsKt.plus((Collection)dependencyModules, (Iterable)CollectionsKt.listOf((Object)moduleFragment));
        } else if (mainModule2 instanceof MainModule.Klib) {
            list2 = dependencyModules;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        List allModules2 = list2;
        ModuleDescriptor moduleDescriptor = moduleFragment.getDescriptor();
        WasmBackendContext context2 = new WasmBackendContext(moduleDescriptor, irBuiltIns, symbolTable, moduleFragment, propertyLazyInitialization, configuration2);
        Object $this$forEach$iv = allModules2;
        boolean $i$f$forEach = false;
        Iterator<Object> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv = iterator2.next();
            it = (IrModuleFragment)element$iv;
            boolean bl = false;
            new ExternalDependenciesGenerator(symbolTable, CollectionsKt.listOf((Object)irLinker)).generateUnboundSymbolsAsDependencies();
        }
        new ExternalDependenciesGenerator(symbolTable, CollectionsKt.listOf((Object)irLinker)).generateUnboundSymbolsAsDependencies();
        $this$forEach$iv = allModules2;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv = iterator2.next();
            it = (IrModuleFragment)element$iv;
            boolean bl = false;
            PatchDeclarationParentsKt.patchDeclarationParents$default(it, null, 1, null);
        }
        irLinker.postProcess(true);
        ChecksKt.checkNoUnboundSymbols(irLinker, symbolTable, "at the end of IR linkage process");
        irLinker.clear();
        for (IrModuleFragment module2 : allModules2) {
            for (IrFile file2 : module2.getFiles()) {
                MarkAdditionalExportedDeclarationsKt.markExportedDeclarations(context2, file2, exportedDeclarations2);
            }
        }
        PhaserState phaserState = new PhaserState(null, 0, 0, null, 15, null);
        Iterable $this$forEachIndexed$iv = WasmLoweringPhasesKt.getLoweringList();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            SimpleNamedCompilerPhase lowering = (SimpleNamedCompilerPhase)item$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = allModules2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                IrModuleFragment module3 = (IrModuleFragment)element$iv2;
                boolean bl2 = false;
                lowering.invoke(phaseConfig, phaserState, (LoggingContext)context2, module3);
            }
        }
        return new Pair((Object)allModules2, (Object)context2);
    }

    public static /* synthetic */ Pair compileToLoweredIr$default(ModulesStructure modulesStructure, PhaseConfig phaseConfig, IrFactory irFactory, Set set, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            set = SetsKt.emptySet();
        }
        return CompilerKt.compileToLoweredIr(modulesStructure, phaseConfig, irFactory, set, bl);
    }

    @NotNull
    public static final WasmCompilerResult compileWasm(@NotNull List<? extends IrModuleFragment> allModules2, @NotNull WasmBackendContext backendContext, @NotNull String baseFileName, boolean emitNameSection, boolean allowIncompleteImplementations, boolean generateWat, boolean generateSourceMaps) {
        String string2;
        Object it;
        Intrinsics.checkNotNullParameter(allModules2, (String)"allModules");
        Intrinsics.checkNotNullParameter((Object)backendContext, (String)"backendContext");
        Intrinsics.checkNotNullParameter((Object)baseFileName, (String)"baseFileName");
        WasmCompiledModuleFragment compiledWasmModule = new WasmCompiledModuleFragment(backendContext.getIrBuiltIns(), backendContext.getConfiguration().getBoolean(JSConfigurationKeys.WASM_USE_TRAPS_INSTEAD_OF_EXCEPTIONS));
        WasmModuleFragmentGenerator codeGenerator = new WasmModuleFragmentGenerator(backendContext, compiledWasmModule, allowIncompleteImplementations);
        Iterable $this$forEach$iv = allModules2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (IrModuleFragment)element$iv;
            boolean bl = false;
            codeGenerator.collectInterfaceTables((IrModuleFragment)it);
        }
        $this$forEach$iv = allModules2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (IrModuleFragment)element$iv;
            boolean bl = false;
            codeGenerator.generateModule((IrModuleFragment)it);
        }
        WasmModule linkedModule = compiledWasmModule.linkWasmCompiledFragments();
        if (generateWat) {
            WasmIrToText watGenerator = new WasmIrToText();
            watGenerator.appendWasmModule(linkedModule);
            string2 = watGenerator.toString();
        } else {
            string2 = null;
        }
        String wat = string2;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        Object it2 = it = baseFileName + ".map";
        boolean bl = false;
        Object sourceMapFileName = generateSourceMaps ? it : null;
        List sourceLocationMappings = generateSourceMaps ? (List)new ArrayList() : null;
        OutputStream outputStream2 = os;
        String string3 = ((IrModuleFragment)CollectionsKt.last(allModules2)).getDescriptor().getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asString(...)");
        WasmIrToBinary wasmIrToBinary = new WasmIrToBinary(outputStream2, linkedModule, string3, emitNameSection, (String)sourceMapFileName, sourceLocationMappings);
        wasmIrToBinary.appendWasmModule();
        byte[] byteArray2 = os.toByteArray();
        String jsUninstantiatedWrapper = null;
        String jsWrapper = null;
        if (backendContext.getConfiguration().get(JSConfigurationKeys.WASM_TARGET, WasmTarget.JS) == WasmTarget.JS) {
            jsUninstantiatedWrapper = CompilerKt.generateAsyncJsWrapper(compiledWasmModule, "./" + baseFileName + ".wasm", backendContext.getJsModuleAndQualifierReferences());
            jsWrapper = CompilerKt.generateEsmExportsWrapper("./" + baseFileName + ".uninstantiated.mjs");
        } else {
            jsUninstantiatedWrapper = null;
            jsWrapper = CompilerKt.generateAsyncWasiWrapper(compiledWasmModule, "./" + baseFileName + ".wasm");
        }
        Intrinsics.checkNotNull((Object)byteArray2);
        return new WasmCompilerResult(wat, jsUninstantiatedWrapper, jsWrapper, byteArray2, CompilerKt.generateSourceMap(backendContext.getConfiguration(), sourceLocationMappings));
    }

    public static /* synthetic */ WasmCompilerResult compileWasm$default(List list2, WasmBackendContext wasmBackendContext, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        if ((n & 0x20) != 0) {
            bl3 = false;
        }
        if ((n & 0x40) != 0) {
            bl4 = false;
        }
        return CompilerKt.compileWasm(list2, wasmBackendContext, string2, bl, bl2, bl3, bl4);
    }

    private static final String generateSourceMap(CompilerConfiguration configuration2, List<SourceLocationMapping> sourceLocationMappings) {
        if (sourceLocationMappings == null) {
            return null;
        }
        SourceMapsInfo sourceMapsInfo = SourceMapsInfo.Companion.from(configuration2);
        if (sourceMapsInfo == null) {
            return null;
        }
        SourceMapsInfo sourceMapsInfo2 = sourceMapsInfo;
        SourceMap3Builder sourceMapBuilder2 = new SourceMap3Builder(null, (Function0<Integer>)((Function0)generateSourceMap.sourceMapBuilder.1.INSTANCE), sourceMapsInfo2.getSourceMapPrefix());
        SourceFilePathResolver pathResolver = SourceFilePathResolver.Companion.create(sourceMapsInfo2.getSourceRoots(), sourceMapsInfo2.getSourceMapPrefix(), sourceMapsInfo2.getOutputDir());
        SourceLocation prev = null;
        for (SourceLocationMapping mapping2 : sourceLocationMappings) {
            String relativePath;
            SourceLocation.Location location;
            SourceLocation.Location location2;
            SourceLocation sourceLocation = mapping2.getSourceLocation();
            SourceLocation.Location location3 = sourceLocation instanceof SourceLocation.Location ? (SourceLocation.Location)sourceLocation : null;
            if (location3 == null || Intrinsics.areEqual((Object)(location2 = location3), prev)) continue;
            prev = location2;
            SourceLocation.Location $this$generateSourceMap_u24lambda_u248 = location = location2;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)pathResolver.getPathRelativeToSourceRoots(new File($this$generateSourceMap_u24lambda_u248.getFile())).substring(3), (String)"substring(...)");
            sourceMapBuilder2.addMapping(relativePath, null, CompilerKt::generateSourceMap$lambda$8$lambda$7, $this$generateSourceMap_u24lambda_u248.getLine(), $this$generateSourceMap_u24lambda_u248.getColumn(), null, mapping2.getOffset());
        }
        return sourceMapBuilder2.build();
    }

    @NotNull
    public static final String generateAsyncWasiWrapper(@NotNull WasmCompiledModuleFragment $this$generateAsyncWasiWrapper, @NotNull String wasmFilePath) {
        Intrinsics.checkNotNullParameter((Object)$this$generateAsyncWasiWrapper, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)wasmFilePath, (String)"wasmFilePath");
        return "\nimport { WASI } from 'wasi';\nimport { argv, env } from 'node:process';\n\nconst wasi = new WASI({ version: 'preview1', args: argv, env, });\n\nconst module = await import(/* webpackIgnore: true */'node:module');\nconst require = module.default.createRequire(import.meta.url);\nconst fs = require('fs');\nconst path = require('path');\nconst url = require('url');\nconst filepath = url.fileURLToPath(import.meta.url);\nconst dirpath = path.dirname(filepath);\nconst wasmBuffer = fs.readFileSync(path.resolve(dirpath, '" + wasmFilePath + "'));\nconst wasmModule = new WebAssembly.Module(wasmBuffer);\nconst wasmInstance = new WebAssembly.Instance(wasmModule, wasi.getImportObject());\n\nwasi.initialize(wasmInstance);\n\nexport default wasmInstance.exports;\n";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String generateAsyncJsWrapper(@NotNull WasmCompiledModuleFragment $this$generateAsyncJsWrapper, @NotNull String wasmFilePath, @NotNull Set<JsModuleAndQualifierReference> jsModuleAndQualifierReferences) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$this$generateAsyncJsWrapper, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)wasmFilePath, (String)"wasmFilePath");
        Intrinsics.checkNotNullParameter(jsModuleAndQualifierReferences, (String)"jsModuleAndQualifierReferences");
        String jsCodeBody2 = CollectionsKt.joinToString$default((Iterable)$this$generateAsyncJsWrapper.getJsFuns(), (CharSequence)",\n", null, null, (int)0, null, (Function1)generateAsyncJsWrapper.jsCodeBody.1.INSTANCE, (int)30, null);
        String jsCodeBodyIndented = StringsKt.prependIndent((String)jsCodeBody2, (String)"        ");
        String imports2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)CollectionsKt.toList((Iterable)$this$generateAsyncJsWrapper.getJsModuleImports())), (CharSequence)"", null, null, (int)0, null, (Function1)generateAsyncJsWrapper.imports.1.INSTANCE, (int)30, null);
        Iterable iterable = jsModuleAndQualifierReferences;
        boolean $i$f$map = false;
        void var9_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            StringBuilder stringBuilder2;
            void it;
            JsModuleAndQualifierReference jsModuleAndQualifierReference = (JsModuleAndQualifierReference)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String module2 = it.getModule();
            String qualifier2 = it.getQualifier();
            StringBuilder $this$generateAsyncJsWrapper_u24lambda_u2410_u24lambda_u249 = stringBuilder2 = new StringBuilder();
            boolean bl2 = false;
            $this$generateAsyncJsWrapper_u24lambda_u2410_u24lambda_u249.append("    const ");
            $this$generateAsyncJsWrapper_u24lambda_u2410_u24lambda_u249.append(it.getJsVariableName());
            $this$generateAsyncJsWrapper_u24lambda_u2410_u24lambda_u249.append(" = ");
            if (module2 != null) {
                $this$generateAsyncJsWrapper_u24lambda_u2410_u24lambda_u249.append("(imports[" + JsHelpersKt.toJsStringLiteral(module2) + "] ?? await import(" + JsHelpersKt.toJsStringLiteral(module2) + "))");
                if (qualifier2 != null) {
                    $this$generateAsyncJsWrapper_u24lambda_u2410_u24lambda_u249.append(".");
                }
            }
            if (qualifier2 != null) {
                $this$generateAsyncJsWrapper_u24lambda_u2410_u24lambda_u249.append(qualifier2);
            }
            $this$generateAsyncJsWrapper_u24lambda_u2410_u24lambda_u249.append(";");
            String string2 = stringBuilder2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            collection.add(string2);
        }
        String referencesToQualifiedAndImportedDeclarations = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv)), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        return "\nexport async function instantiate(imports={}, runInitializer=true) {\n    const externrefBoxes = new WeakMap();\n    // ref must be non-null\n    function tryGetOrSetExternrefBox(ref, ifNotCached) {\n        if (typeof ref !== 'object') return ifNotCached;\n        const cachedBox = externrefBoxes.get(ref);\n        if (cachedBox !== void 0) return cachedBox;\n        externrefBoxes.set(ref, ifNotCached);\n        return ifNotCached;\n    }\n\n" + referencesToQualifiedAndImportedDeclarations + "\n    \n    const js_code = {\n" + jsCodeBodyIndented + "\n    }\n    \n    // Placed here to give access to it from externals (js_code)\n    let wasmInstance;\n    let require; \n    let wasmExports;\n\n    const isNodeJs = (typeof process !== 'undefined') && (process.release.name === 'node');\n    const isStandaloneJsVM =\n        !isNodeJs && (\n            typeof d8 !== 'undefined' // V8\n            || typeof inIon !== 'undefined' // SpiderMonkey\n            || typeof jscOptions !== 'undefined' // JavaScriptCore\n        );\n    const isBrowser = !isNodeJs && !isStandaloneJsVM && (typeof window !== 'undefined');\n    \n    if (!isNodeJs && !isStandaloneJsVM && !isBrowser) {\n      throw \"Supported JS engine not detected\";\n    }\n    \n    const wasmFilePath = " + JsHelpersKt.toJsStringLiteral(wasmFilePath) + ";\n    const importObject = {\n        js_code,\n" + imports2 + "\n    };\n    \n    try {\n      if (isNodeJs) {\n        const module = await import(/* webpackIgnore: true */'node:module');\n        require = module.default.createRequire(import.meta.url);\n        const fs = require('fs');\n        const path = require('path');\n        const url = require('url');\n        const filepath = url.fileURLToPath(import.meta.url);\n        const dirpath = path.dirname(filepath);\n        const wasmBuffer = fs.readFileSync(path.resolve(dirpath, wasmFilePath));\n        const wasmModule = new WebAssembly.Module(wasmBuffer);\n        wasmInstance = new WebAssembly.Instance(wasmModule, importObject);\n      }\n      \n      if (isStandaloneJsVM) {\n        const wasmBuffer = read(wasmFilePath, 'binary');\n        const wasmModule = new WebAssembly.Module(wasmBuffer);\n        wasmInstance = new WebAssembly.Instance(wasmModule, importObject);\n      }\n      \n      if (isBrowser) {\n        wasmInstance = (await WebAssembly.instantiateStreaming(fetch(wasmFilePath), importObject)).instance;\n      }\n    } catch (e) {\n      if (e instanceof WebAssembly.CompileError) {\n        let text = `Please make sure that your runtime environment supports the latest version of Wasm GC and Exception-Handling proposals.\nFor more information, see https://kotl.in/wasm-help\n`;\n        if (isBrowser) {\n          console.error(text);\n        } else {\n          const t = \"\\n\" + text;\n          if (typeof console !== \"undefined\" && console.log !== void 0) \n            console.log(t);\n          else \n            print(t);\n        }\n      }\n      throw e;\n    }\n    \n    wasmExports = wasmInstance.exports;\n    if (runInitializer) {\n        wasmExports._initialize();\n    }\n\n    return { instance: wasmInstance,  exports: wasmExports };\n}\n";
    }

    @NotNull
    public static final String generateEsmExportsWrapper(@NotNull String asyncWrapperFileName) {
        Intrinsics.checkNotNullParameter((Object)asyncWrapperFileName, (String)"asyncWrapperFileName");
        return "\nimport { instantiate } from " + JsHelpersKt.toJsStringLiteral(asyncWrapperFileName) + ";\nexport default (await instantiate()).exports;\n";
    }

    public static final void writeCompilationResult(@NotNull WasmCompilerResult result2, @NotNull File dir2, @NotNull String fileNameBase) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Intrinsics.checkNotNullParameter((Object)dir2, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)fileNameBase, (String)"fileNameBase");
        dir2.mkdirs();
        if (result2.getWat() != null) {
            FilesKt.writeText$default((File)new File(dir2, fileNameBase + ".wat"), (String)result2.getWat(), null, (int)2, null);
        }
        FilesKt.writeBytes((File)new File(dir2, fileNameBase + ".wasm"), (byte[])result2.getWasm());
        if (result2.getJsUninstantiatedWrapper() != null) {
            FilesKt.writeText$default((File)new File(dir2, fileNameBase + ".uninstantiated.mjs"), (String)result2.getJsUninstantiatedWrapper(), null, (int)2, null);
        }
        FilesKt.writeText$default((File)new File(dir2, fileNameBase + ".mjs"), (String)result2.getJsWrapper(), null, (int)2, null);
        if (result2.getSourceMap() != null) {
            FilesKt.writeText$default((File)new File(dir2, fileNameBase + ".map"), (String)result2.getSourceMap(), null, (int)2, null);
        }
    }

    private static final Reader generateSourceMap$lambda$8$lambda$7() {
        return null;
    }
}

