/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/RenameFieldsLowering;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "<init>", "()V", "lower", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nRenameFieldsLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenameFieldsLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/RenameFieldsLowering\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,51:1\n1000#2,2:52\n*S KotlinDebug\n*F\n+ 1 RenameFieldsLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/RenameFieldsLowering\n*L\n24#1:52,2\n*E\n"})
final class RenameFieldsLowering
implements ClassLoweringPass {
    @Override
    public void lower(@NotNull IrClass irClass) {
        List fields2;
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        List $this$sortBy$iv = fields2 = SequencesKt.toMutableList(IrUtilsKt.getFields(irClass));
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    IrField it = (IrField)a;
                    boolean bl = false;
                    int n = it.getVisibility().isPublicAPI() ? 0 : (it.isStatic() ? 1 : 2);
                    it = (IrField)b;
                    Comparable comparable = Integer.valueOf(n);
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(it.getVisibility().isPublicAPI() ? 0 : (it.isStatic() ? 1 : 2)));
                }
            });
        }
        HashMap count = new HashMap();
        for (IrField field2 : fields2) {
            int index2;
            Name oldName = field2.getName();
            Integer n = (Integer)count.get(oldName);
            int n2 = index2 = n != null ? n : 0;
            if (index2 != 0 && !field2.getVisibility().isPublicAPI()) {
                field2.setName(Name.identifier("" + oldName + '$' + index2));
            }
            ((Map)count).put(oldName, index2 + 1);
        }
    }
}

