/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.intrinsics;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.jvm.codegen.BlockInfo;
import org.jetbrains.kotlin.backend.jvm.codegen.BooleanValue;
import org.jetbrains.kotlin.backend.jvm.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.backend.jvm.codegen.MaterialValue;
import org.jetbrains.kotlin.backend.jvm.codegen.PromisedValue;
import org.jetbrains.kotlin.backend.jvm.codegen.PromisedValueKt;
import org.jetbrains.kotlin.backend.jvm.intrinsics.BooleanComparison;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IntrinsicMethod;
import org.jetbrains.kotlin.backend.jvm.intrinsics.NonIEEE754FloatComparison;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.resolve.jvm.JvmPrimitiveType;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\"\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/PrimitiveComparison;", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicMethod;", "primitiveNumberType", "Lorg/jetbrains/kotlin/builtins/PrimitiveType;", "operatorToken", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "<init>", "(Lorg/jetbrains/kotlin/builtins/PrimitiveType;Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;)V", "invoke", "Lorg/jetbrains/kotlin/backend/jvm/codegen/PromisedValue;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "codegen", "Lorg/jetbrains/kotlin/backend/jvm/codegen/ExpressionCodegen;", "data", "Lorg/jetbrains/kotlin/backend/jvm/codegen/BlockInfo;", "backend.jvm.codegen"})
public final class PrimitiveComparison
extends IntrinsicMethod {
    @NotNull
    private final PrimitiveType primitiveNumberType;
    @NotNull
    private final KtSingleValueToken operatorToken;

    public PrimitiveComparison(@NotNull PrimitiveType primitiveNumberType, @NotNull KtSingleValueToken operatorToken) {
        Intrinsics.checkNotNullParameter((Object)((Object)primitiveNumberType), (String)"primitiveNumberType");
        Intrinsics.checkNotNullParameter((Object)operatorToken, (String)"operatorToken");
        this.primitiveNumberType = primitiveNumberType;
        this.operatorToken = operatorToken;
    }

    @Override
    @Nullable
    public PromisedValue invoke(@NotNull IrFunctionAccessExpression expression2, @NotNull ExpressionCodegen codegen2, @NotNull BlockInfo data2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)codegen2, (String)"codegen");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Type parameterType = Type.getType(JvmPrimitiveType.get(this.primitiveNumberType).getDesc());
        List<IrExpression> list2 = JvmIrUtilsKt.receiverAndArgs(expression2);
        IrExpression left = list2.get(0);
        IrExpression right = list2.get(1);
        PromisedValue promisedValue = (PromisedValue)left.accept(codegen2, data2);
        Intrinsics.checkNotNull((Object)parameterType);
        MaterialValue a = PromisedValueKt.materializedAt$default(promisedValue, parameterType, left.getType(), false, 4, null);
        MaterialValue b = PromisedValueKt.materializedAt$default((PromisedValue)right.accept(codegen2, data2), parameterType, right.getType(), false, 4, null);
        boolean useNonIEEE754Comparison = !(codegen2.getContext().getConfig().getLanguageVersionSettings().supportsFeature(LanguageFeature.ProperIeee754Comparisons) || !Intrinsics.areEqual((Object)parameterType, (Object)Type.FLOAT_TYPE) && !Intrinsics.areEqual((Object)parameterType, (Object)Type.DOUBLE_TYPE) || !JvmIrUtilsKt.isSmartcastFromHigherThanNullable(left, codegen2.getContext()) && !JvmIrUtilsKt.isSmartcastFromHigherThanNullable(right, codegen2.getContext()));
        return useNonIEEE754Comparison ? (BooleanValue)new NonIEEE754FloatComparison(this.operatorToken, a, b) : (BooleanValue)new BooleanComparison(this.operatorToken, a, b);
    }
}

