/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.intrinsics;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.codegen.ClassCodegen;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IntrinsicFunction;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IntrinsicMethod;
import org.jetbrains.kotlin.backend.jvm.mapping.IrTypeMapper;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/CompareTo;", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicMethod;", "<init>", "()V", "genInvoke", "", "type", "Lorg/jetbrains/org/objectweb/asm/Type;", "v", "Lorg/jetbrains/org/objectweb/asm/commons/InstructionAdapter;", "toCallable", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicFunction;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "signature", "Lorg/jetbrains/kotlin/resolve/jvm/jvmSignature/JvmMethodSignature;", "classCodegen", "Lorg/jetbrains/kotlin/backend/jvm/codegen/ClassCodegen;", "backend.jvm.codegen"})
public final class CompareTo
extends IntrinsicMethod {
    @NotNull
    public static final CompareTo INSTANCE = new CompareTo();

    private CompareTo() {
    }

    private final void genInvoke(Type type2, InstructionAdapter v) {
        Type type3 = type2;
        if (Intrinsics.areEqual((Object)type3, (Object)Type.CHAR_TYPE) || Intrinsics.areEqual((Object)type3, (Object)Type.BYTE_TYPE) || Intrinsics.areEqual((Object)type3, (Object)Type.SHORT_TYPE) || Intrinsics.areEqual((Object)type3, (Object)Type.INT_TYPE)) {
            v.invokestatic("kotlin/jvm/internal/Intrinsics", "compare", "(II)I", false);
        } else if (Intrinsics.areEqual((Object)type3, (Object)Type.LONG_TYPE)) {
            v.invokestatic("kotlin/jvm/internal/Intrinsics", "compare", "(JJ)I", false);
        } else if (Intrinsics.areEqual((Object)type3, (Object)Type.FLOAT_TYPE)) {
            v.invokestatic("java/lang/Float", "compare", "(FF)I", false);
        } else if (Intrinsics.areEqual((Object)type3, (Object)Type.DOUBLE_TYPE)) {
            v.invokestatic("java/lang/Double", "compare", "(DD)I", false);
        } else if (Intrinsics.areEqual((Object)type3, (Object)Type.BOOLEAN_TYPE)) {
            v.invokestatic("java/lang/Boolean", "compare", "(ZZ)I", false);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    @NotNull
    public IntrinsicFunction toCallable(@NotNull IrFunctionAccessExpression expression2, @NotNull JvmMethodSignature signature2, @NotNull ClassCodegen classCodegen) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)signature2, (String)"signature");
        Intrinsics.checkNotNullParameter((Object)classCodegen, (String)"classCodegen");
        IrFunction callee = ((IrFunctionSymbol)expression2.getSymbol()).getOwner();
        IrValueParameter irValueParameter = callee.getDispatchReceiverParameter();
        if (irValueParameter == null) {
            IrValueParameter irValueParameter2 = callee.getExtensionReceiverParameter();
            irValueParameter = irValueParameter2;
            Intrinsics.checkNotNull((Object)irValueParameter2);
        }
        IrValueParameter calleeParameter = irValueParameter;
        Type type2 = IrTypeMapper.mapType$default(classCodegen.getTypeMapper(), calleeParameter.getType(), null, null, false, 14, null);
        List<JvmMethodParameterSignature> list2 = signature2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getValueParameters(...)");
        Type parameterType = AsmUtil.comparisonOperandType(type2, ((JvmMethodParameterSignature)CollectionsKt.single(list2)).getAsmType());
        Object[] objectArray = new Type[]{parameterType, parameterType};
        return IntrinsicFunction.Companion.create(expression2, signature2, classCodegen, CollectionsKt.listOf((Object[])objectArray), (Function2<? super IntrinsicFunction, ? super InstructionAdapter, Unit>)((Function2)new Function2<IntrinsicFunction, InstructionAdapter, Unit>(parameterType){
            final /* synthetic */ Type $parameterType;
            {
                this.$parameterType = $parameterType;
                super(2);
            }

            public final void invoke(IntrinsicFunction $this$create, InstructionAdapter it) {
                Intrinsics.checkNotNullParameter((Object)$this$create, (String)"$this$create");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                CompareTo.access$genInvoke(CompareTo.INSTANCE, this.$parameterType, it);
            }
        }));
    }

    public static final /* synthetic */ void access$genInvoke(CompareTo $this, Type type2, InstructionAdapter v) {
        $this.genInvoke(type2, v);
    }
}

