/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava.classes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.builder.LightMemberOrigin;
import org.jetbrains.kotlin.asJava.classes.KtExtensibleLightClass;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.asJava.elements.KtLightParameter;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.ModificationTracker;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.openapi.util.Ref;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.ExternallyDefinedPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.HierarchicalMethodSignature;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotation;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotationMemberValue;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayType;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiCodeBlock;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiField;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiIdentifier;
import org.jetbrains.kotlin.com.intellij.psi.PsiMember;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierList;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameterList;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceList;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameterList;
import org.jetbrains.kotlin.com.intellij.psi.SyntheticElement;
import org.jetbrains.kotlin.com.intellij.psi.augment.PsiAugmentProvider;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiClassImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiSuperMethodImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightIdentifier;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightModifierList;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightParameter;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightParameterListBuilder;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightReferenceListBuilder;
import org.jetbrains.kotlin.com.intellij.psi.javadoc.PsiDocComment;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.kotlin.com.intellij.psi.util.MethodSignature;
import org.jetbrains.kotlin.com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentFactoryMap;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.Interner;
import org.jetbrains.kotlin.com.intellij.util.containers.JBIterable;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;

public final class ClassInnerStuffCache {
    public static final String NOT_NULL_ANNOTATION_QUALIFIER = "@" + NotNull.class.getName();
    @NotNull
    private final KtExtensibleLightClass myClass;
    @NotNull
    private final List<ModificationTracker> myModificationTrackers;
    @NotNull
    private final Ref<Pair<Long, Interner<PsiMember>>> myInterner;
    private final boolean myGenerateEnumMethods;

    public ClassInnerStuffCache(@NotNull KtExtensibleLightClass aClass, boolean generateEnumMethods, @NotNull List<ModificationTracker> modificationTrackers) {
        if (aClass == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(0);
        }
        if (modificationTrackers == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(1);
        }
        this.myInterner = Ref.create();
        this.myGenerateEnumMethods = generateEnumMethods;
        this.myClass = aClass;
        this.myModificationTrackers = modificationTrackers;
    }

    @NotNull
    public PsiMethod[] getConstructors() {
        PsiMethod[] psiMethodArray = (PsiMethod[])ClassInnerStuffCache.copy((Object[])CachedValuesManager.getCachedValue(this.myClass, () -> CachedValueProvider.Result.create(PsiImplUtil.getConstructors(this.myClass), this.myModificationTrackers)));
        if (psiMethodArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(2);
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiField[] getFields() {
        PsiField[] psiFieldArray = (PsiField[])ClassInnerStuffCache.copy((Object[])CachedValuesManager.getCachedValue(this.myClass, () -> CachedValueProvider.Result.create(this.calcFields(), this.myModificationTrackers)));
        if (psiFieldArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(3);
        }
        return psiFieldArray;
    }

    @NotNull
    public PsiMethod[] getMethods() {
        PsiMethod[] psiMethodArray = (PsiMethod[])ClassInnerStuffCache.copy((Object[])CachedValuesManager.getCachedValue(this.myClass, () -> CachedValueProvider.Result.create(this.calcMethods(), this.myModificationTrackers)));
        if (psiMethodArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(4);
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiClass[] getInnerClasses() {
        PsiClass[] psiClassArray = (PsiClass[])ClassInnerStuffCache.copy((Object[])CachedValuesManager.getCachedValue(this.myClass, () -> CachedValueProvider.Result.create(this.calcInnerClasses(), this.myModificationTrackers)));
        if (psiClassArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(5);
        }
        return psiClassArray;
    }

    @Nullable
    public PsiField findFieldByName(String name2, boolean checkBases) {
        if (checkBases) {
            return PsiClassImplUtil.findFieldByName(this.myClass, name2, true);
        }
        return (PsiField)((Map)CachedValuesManager.getCachedValue(this.myClass, () -> CachedValueProvider.Result.create(this.getFieldsMap(), this.myModificationTrackers))).get(name2);
    }

    @NotNull
    public PsiMethod[] findMethodsByName(String name2, boolean checkBases) {
        if (checkBases) {
            PsiMethod[] psiMethodArray = PsiClassImplUtil.findMethodsByName(this.myClass, name2, true);
            if (psiMethodArray == null) {
                ClassInnerStuffCache.$$$reportNull$$$0(6);
            }
            return psiMethodArray;
        }
        PsiMethod[] psiMethodArray = (PsiMethod[])ClassInnerStuffCache.copy((Object[])ObjectUtils.notNull(((Map)CachedValuesManager.getCachedValue(this.myClass, () -> CachedValueProvider.Result.create(this.getMethodsMap(), this.myModificationTrackers))).get(name2), PsiMethod.EMPTY_ARRAY));
        if (psiMethodArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(7);
        }
        return psiMethodArray;
    }

    @Nullable
    public PsiClass findInnerClassByName(String name2, boolean checkBases) {
        if (checkBases) {
            return PsiClassImplUtil.findInnerByName(this.myClass, name2, true);
        }
        return (PsiClass)((Map)CachedValuesManager.getCachedValue(this.myClass, () -> CachedValueProvider.Result.create(this.getInnerClassesMap(), this.myModificationTrackers))).get(name2);
    }

    @Nullable
    private PsiMethod getValuesMethod() {
        return this.isEnum() ? (PsiMethod)this.internMember((PsiMember)CachedValuesManager.getCachedValue(this.myClass, () -> CachedValueProvider.Result.create(ClassInnerStuffCache.makeValuesMethod(this.myClass), this.myModificationTrackers))) : null;
    }

    @Nullable
    private PsiMethod getValueOfMethod() {
        return this.isEnum() ? (PsiMethod)this.internMember((PsiMember)CachedValuesManager.getCachedValue(this.myClass, () -> CachedValueProvider.Result.create(ClassInnerStuffCache.makeValueOfMethod(this.myClass), this.myModificationTrackers))) : null;
    }

    private boolean isEnum() {
        return this.myGenerateEnumMethods && this.myClass.isEnum();
    }

    private static <T> T[] copy(T[] value2) {
        return value2.length == 0 ? value2 : (Object[])value2.clone();
    }

    @NotNull
    private PsiField[] calcFields() {
        List<PsiField> own = this.myClass.getOwnFields();
        List<PsiField> ext = this.internMembers(PsiAugmentProvider.collectAugments(this.myClass, PsiField.class, null));
        PsiField[] psiFieldArray = ArrayUtil.mergeCollections(own, ext, PsiField.ARRAY_FACTORY);
        if (psiFieldArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(8);
        }
        return psiFieldArray;
    }

    @NotNull
    private <T extends PsiMember> List<T> internMembers(List<T> members) {
        List<PsiMember> list2 = ContainerUtil.map(members, this::internMember);
        if (list2 == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(9);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends PsiMember> T internMember(T m) {
        if (m == null) {
            return null;
        }
        long modCount = 0L;
        for (ModificationTracker tracker : this.myModificationTrackers) {
            modCount += tracker.getModificationCount();
        }
        Ref<Pair<Long, Interner<PsiMember>>> ref = this.myInterner;
        synchronized (ref) {
            Pair<Long, Interner<PsiMember>> pair = this.myInterner.get();
            if (pair == null || (Long)pair.first != modCount) {
                pair = Pair.create(modCount, Interner.createWeakInterner());
                this.myInterner.set(pair);
            }
            return ((Interner)pair.second).intern(m);
        }
    }

    @NotNull
    private PsiMethod[] calcMethods() {
        List<PsiMethod> own = this.myClass.getOwnMethods();
        List<PsiMethod> ext = this.internMembers(PsiAugmentProvider.collectAugments(this.myClass, PsiMethod.class, null));
        if (this.isEnum()) {
            ext = new ArrayList<PsiMethod>(ext);
            ContainerUtil.addIfNotNull(ext, this.getValuesMethod());
            ContainerUtil.addIfNotNull(ext, this.getValueOfMethod());
        }
        PsiMethod[] psiMethodArray = ArrayUtil.mergeCollections(own, ext, PsiMethod.ARRAY_FACTORY);
        if (psiMethodArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(10);
        }
        return psiMethodArray;
    }

    @NotNull
    private PsiClass[] calcInnerClasses() {
        List<PsiClass> own = this.myClass.getOwnInnerClasses();
        List<PsiClass> ext = this.internMembers(PsiAugmentProvider.collectAugments(this.myClass, PsiClass.class, null));
        PsiClass[] psiClassArray = ArrayUtil.mergeCollections(own, ext, PsiClass.ARRAY_FACTORY);
        if (psiClassArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(11);
        }
        return psiClassArray;
    }

    @NotNull
    private Map<String, PsiField> getFieldsMap() {
        HashMap<String, PsiField> cachedFields = new HashMap<String, PsiField>();
        for (PsiField field2 : this.myClass.getOwnFields()) {
            String name3 = field2.getName();
            cachedFields.putIfAbsent(name3, field2);
        }
        ConcurrentMap<String, PsiField> concurrentMap = ConcurrentFactoryMap.createMap(name2 -> {
            PsiField result2 = (PsiField)cachedFields.get(name2);
            return result2 != null ? result2 : (PsiField)this.internMember((PsiMember)ContainerUtil.getFirstItem(PsiAugmentProvider.collectAugments(this.myClass, PsiField.class, name2)));
        });
        if (concurrentMap == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(12);
        }
        return concurrentMap;
    }

    @NotNull
    private Map<String, PsiMethod[]> getMethodsMap() {
        List<PsiMethod> ownMethods2 = this.myClass.getOwnMethods();
        ConcurrentMap<String, PsiMethod[]> concurrentMap = ConcurrentFactoryMap.createMap(name2 -> JBIterable.from(ownMethods2).filter(m -> name2.equals(m.getName())).append("values".equals(name2) ? this.getValuesMethod() : null).append("valueOf".equals(name2) ? this.getValueOfMethod() : null).append((PsiMethod)((Object)this.internMembers(PsiAugmentProvider.collectAugments(this.myClass, PsiMethod.class, name2)))).toArray(PsiMethod.EMPTY_ARRAY));
        if (concurrentMap == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(13);
        }
        return concurrentMap;
    }

    @NotNull
    private Map<String, PsiClass> getInnerClassesMap() {
        HashMap<String, PsiClass> cachedInners = new HashMap<String, PsiClass>();
        for (PsiClass psiClass : this.myClass.getOwnInnerClasses()) {
            String name3 = psiClass.getName();
            if (name3 == null) {
                Logger.getInstance(ClassInnerStuffCache.class).error(psiClass);
                continue;
            }
            if (psiClass instanceof ExternallyDefinedPsiElement && cachedInners.containsKey(name3)) continue;
            cachedInners.put(name3, psiClass);
        }
        ConcurrentMap<String, PsiClass> concurrentMap = ConcurrentFactoryMap.createMap(name2 -> {
            PsiClass result2 = (PsiClass)cachedInners.get(name2);
            return result2 != null ? result2 : (PsiClass)this.internMember((PsiMember)ContainerUtil.getFirstItem(PsiAugmentProvider.collectAugments(this.myClass, PsiClass.class, name2)));
        });
        if (concurrentMap == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(14);
        }
        return concurrentMap;
    }

    private static PsiMethod makeValuesMethod(KtExtensibleLightClass enumClass2) {
        return new EnumSyntheticMethod(enumClass2, EnumMethodKind.Values);
    }

    private static PsiMethod makeValueOfMethod(KtExtensibleLightClass enumClass2) {
        return new EnumSyntheticMethod(enumClass2, EnumMethodKind.ValueOf);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modificationTrackers";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/asJava/classes/ClassInnerStuffCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/asJava/classes/ClassInnerStuffCache";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructors";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFields";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethods";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInnerClasses";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodsByName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "calcFields";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "internMembers";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "calcMethods";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "calcInnerClasses";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldsMap";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodsMap";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getInnerClassesMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class EnumSyntheticMethod
    extends LightElement
    implements PsiMethod,
    SyntheticElement,
    KtLightMethod {
        private final KtExtensibleLightClass myClass;
        private final EnumMethodKind myKind;
        private final PsiType myReturnType;
        private final LightParameterListBuilder myParameterList;
        private final LightModifierList myModifierList;

        EnumSyntheticMethod(@NotNull KtExtensibleLightClass enumClass2, EnumMethodKind kind) {
            if (enumClass2 == null) {
                EnumSyntheticMethod.$$$reportNull$$$0(0);
            }
            super(enumClass2.getManager(), enumClass2.getLanguage());
            this.myClass = enumClass2;
            this.myKind = kind;
            this.myReturnType = this.createReturnType();
            this.myParameterList = this.createParameterList();
            this.myModifierList = this.createModifierList();
        }

        @Override
        public void accept(@NotNull PsiElementVisitor visitor2) {
            if (visitor2 == null) {
                EnumSyntheticMethod.$$$reportNull$$$0(1);
            }
            if (visitor2 instanceof JavaElementVisitor) {
                ((JavaElementVisitor)visitor2).visitMethod(this);
            } else {
                visitor2.visitElement(this);
            }
        }

        @NotNull
        private PsiAnnotation[] createNotNullAnnotation() {
            PsiAnnotation[] psiAnnotationArray = new PsiAnnotation[]{PsiElementFactory.getInstance(this.getProject()).createAnnotationFromText(NOT_NULL_ANNOTATION_QUALIFIER, this.myClass)};
            if (psiAnnotationArray == null) {
                EnumSyntheticMethod.$$$reportNull$$$0(2);
            }
            return psiAnnotationArray;
        }

        @NotNull
        private PsiType createReturnType() {
            PsiClassType type2 = JavaPsiFacade.getElementFactory(this.getProject()).createType(this.myClass);
            if (this.myKind == EnumMethodKind.Values) {
                PsiArrayType psiArrayType = type2.createArrayType();
                if (psiArrayType == null) {
                    EnumSyntheticMethod.$$$reportNull$$$0(3);
                }
                return psiArrayType;
            }
            PsiClassType psiClassType = type2;
            if (psiClassType == null) {
                EnumSyntheticMethod.$$$reportNull$$$0(4);
            }
            return psiClassType;
        }

        @NotNull
        private LightModifierList createModifierList() {
            return new LightModifierList(this.myManager, this.getLanguage(), new String[]{"public", "static"}){
                private final PsiAnnotation[] notNullAnnotations;
                {
                    super(x0, x1, x2);
                    this.notNullAnnotations = this.createNotNullAnnotation();
                }

                @Override
                @NotNull
                public PsiAnnotation[] getAnnotations() {
                    PsiAnnotation[] psiAnnotationArray = (PsiAnnotation[])ClassInnerStuffCache.copy(this.notNullAnnotations);
                    if (psiAnnotationArray == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return psiAnnotationArray;
                }

                @Override
                public PsiAnnotation findAnnotation(@NotNull String qualifiedName) {
                    PsiAnnotation notNullAnnotation;
                    if (qualifiedName == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return qualifiedName == (notNullAnnotation = this.notNullAnnotations[0]).getQualifiedName() ? notNullAnnotation : null;
                }

                @Override
                public PsiElement getParent() {
                    return this;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string2;
                    switch (n) {
                        default: {
                            string2 = "@NotNull method %s.%s must not return null";
                            break;
                        }
                        case 1: {
                            string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 2;
                            break;
                        }
                        case 1: {
                            n2 = 3;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "org/jetbrains/kotlin/asJava/classes/ClassInnerStuffCache$EnumSyntheticMethod$1";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "qualifiedName";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getAnnotations";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "org/jetbrains/kotlin/asJava/classes/ClassInnerStuffCache$EnumSyntheticMethod$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            break;
                        }
                        case 1: {
                            objectArray = objectArray;
                            objectArray[2] = "findAnnotation";
                            break;
                        }
                    }
                    String string3 = String.format(string2, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalStateException(string3);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalArgumentException(string3);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
        }

        @NotNull
        private LightParameterListBuilder createParameterList() {
            LightParameterListBuilder parameters2 = new LightParameterListBuilder(this.myManager, this.getLanguage());
            if (this.myKind == EnumMethodKind.ValueOf) {
                PsiClassType string2 = PsiType.getJavaLangString(this.myManager, GlobalSearchScope.allScope(this.getProject()));
                MyKtLightParameter parameter2 = new MyKtLightParameter(string2, this);
                parameters2.addParameter(parameter2);
            }
            LightParameterListBuilder lightParameterListBuilder = parameters2;
            if (lightParameterListBuilder == null) {
                EnumSyntheticMethod.$$$reportNull$$$0(5);
            }
            return lightParameterListBuilder;
        }

        @Override
        public int getTextOffset() {
            return this.myClass.getTextOffset();
        }

        @Override
        public String toString() {
            return this.myClass.getText();
        }

        @Override
        public String getText() {
            return "";
        }

        @Override
        public TextRange getTextRange() {
            return TextRange.EMPTY_RANGE;
        }

        public boolean equals(Object another) {
            return this == another || another instanceof EnumSyntheticMethod && this.myClass.equals(((EnumSyntheticMethod)another).myClass) && this.myKind == ((EnumSyntheticMethod)another).myKind;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.myClass, this.myKind});
        }

        @Override
        public boolean isDeprecated() {
            return false;
        }

        @Override
        @Nullable
        public PsiDocComment getDocComment() {
            return null;
        }

        @Override
        @NotNull
        public KtExtensibleLightClass getContainingClass() {
            KtExtensibleLightClass ktExtensibleLightClass = this.myClass;
            if (ktExtensibleLightClass == null) {
                EnumSyntheticMethod.$$$reportNull$$$0(6);
            }
            return ktExtensibleLightClass;
        }

        @Override
        @Nullable
        public PsiType getReturnType() {
            return this.myReturnType;
        }

        @Override
        @Nullable
        public PsiTypeElement getReturnTypeElement() {
            return null;
        }

        @Override
        @NotNull
        public PsiParameterList getParameterList() {
            LightParameterListBuilder lightParameterListBuilder = this.myParameterList;
            if (lightParameterListBuilder == null) {
                EnumSyntheticMethod.$$$reportNull$$$0(7);
            }
            return lightParameterListBuilder;
        }

        @Override
        @NotNull
        public PsiReferenceList getThrowsList() {
            LightReferenceListBuilder throwsList = new LightReferenceListBuilder(this.myManager, this.getLanguage(), PsiReferenceList.Role.THROWS_LIST);
            if (this.myKind == EnumMethodKind.ValueOf) {
                throwsList.addReference(IllegalArgumentException.class.getName());
                throwsList.addReference(NullPointerException.class.getName());
            }
            LightReferenceListBuilder lightReferenceListBuilder = throwsList;
            if (lightReferenceListBuilder == null) {
                EnumSyntheticMethod.$$$reportNull$$$0(8);
            }
            return lightReferenceListBuilder;
        }

        @Override
        @Nullable
        public PsiCodeBlock getBody() {
            return null;
        }

        @Override
        public boolean isConstructor() {
            return false;
        }

        @Override
        public boolean isVarArgs() {
            return false;
        }

        @Override
        @NotNull
        public MethodSignature getSignature(@NotNull PsiSubstitutor substitutor2) {
            if (substitutor2 == null) {
                EnumSyntheticMethod.$$$reportNull$$$0(9);
            }
            MethodSignatureBackedByPsiMethod methodSignatureBackedByPsiMethod = MethodSignatureBackedByPsiMethod.create(this, substitutor2);
            if (methodSignatureBackedByPsiMethod == null) {
                EnumSyntheticMethod.$$$reportNull$$$0(10);
            }
            return methodSignatureBackedByPsiMethod;
        }

        @Override
        @Nullable
        public PsiIdentifier getNameIdentifier() {
            return new LightIdentifier(this.myManager, this.getName());
        }

        @Override
        @NotNull
        public String getName() {
            if (this.myKind == EnumMethodKind.ValueOf) {
                return "valueOf";
            }
            return "values";
        }

        @Override
        @NotNull
        public PsiMethod[] findSuperMethods() {
            PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethods(this);
            if (psiMethodArray == null) {
                EnumSyntheticMethod.$$$reportNull$$$0(11);
            }
            return psiMethodArray;
        }

        @Override
        @NotNull
        public PsiMethod[] findSuperMethods(boolean checkAccess) {
            PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethods((PsiMethod)this, checkAccess);
            if (psiMethodArray == null) {
                EnumSyntheticMethod.$$$reportNull$$$0(12);
            }
            return psiMethodArray;
        }

        @Override
        @NotNull
        public PsiMethod[] findSuperMethods(PsiClass parentClass) {
            PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethods((PsiMethod)this, parentClass);
            if (psiMethodArray == null) {
                EnumSyntheticMethod.$$$reportNull$$$0(13);
            }
            return psiMethodArray;
        }

        @Override
        @NotNull
        public List<MethodSignatureBackedByPsiMethod> findSuperMethodSignaturesIncludingStatic(boolean checkAccess) {
            List<MethodSignatureBackedByPsiMethod> list2 = PsiSuperMethodImplUtil.findSuperMethodSignaturesIncludingStatic(this, checkAccess);
            if (list2 == null) {
                EnumSyntheticMethod.$$$reportNull$$$0(14);
            }
            return list2;
        }

        @Override
        @Deprecated
        @Nullable
        public PsiMethod findDeepestSuperMethod() {
            return PsiSuperMethodImplUtil.findDeepestSuperMethod(this);
        }

        @Override
        @NotNull
        public PsiMethod[] findDeepestSuperMethods() {
            if (PsiMethod.EMPTY_ARRAY == null) {
                EnumSyntheticMethod.$$$reportNull$$$0(15);
            }
            return PsiMethod.EMPTY_ARRAY;
        }

        @Override
        @NotNull
        public PsiModifierList getModifierList() {
            LightModifierList lightModifierList2 = this.myModifierList;
            if (lightModifierList2 == null) {
                EnumSyntheticMethod.$$$reportNull$$$0(16);
            }
            return lightModifierList2;
        }

        @Override
        public boolean hasModifierProperty(@NonNls @NotNull String name2) {
            if (name2 == null) {
                EnumSyntheticMethod.$$$reportNull$$$0(17);
            }
            return name2.equals("public") || name2.equals("static");
        }

        @Override
        public PsiElement setName(@NonNls @NotNull String name2) throws IncorrectOperationException {
            if (name2 == null) {
                EnumSyntheticMethod.$$$reportNull$$$0(18);
            }
            throw new IncorrectOperationException();
        }

        @Override
        @NotNull
        public HierarchicalMethodSignature getHierarchicalMethodSignature() {
            HierarchicalMethodSignature hierarchicalMethodSignature = PsiSuperMethodImplUtil.getHierarchicalMethodSignature(this);
            if (hierarchicalMethodSignature == null) {
                EnumSyntheticMethod.$$$reportNull$$$0(19);
            }
            return hierarchicalMethodSignature;
        }

        @Override
        @Nullable
        public PsiAnnotationMemberValue getDefaultValue() {
            return null;
        }

        @Override
        public boolean hasTypeParameters() {
            return false;
        }

        @Override
        @Nullable
        public PsiTypeParameterList getTypeParameterList() {
            return null;
        }

        @Override
        public PsiFile getContainingFile() {
            return this.myClass.getContainingFile();
        }

        @Override
        @NotNull
        public PsiTypeParameter[] getTypeParameters() {
            if (PsiTypeParameter.EMPTY_ARRAY == null) {
                EnumSyntheticMethod.$$$reportNull$$$0(20);
            }
            return PsiTypeParameter.EMPTY_ARRAY;
        }

        @Override
        public boolean isMangled() {
            return false;
        }

        @Override
        @Nullable
        public KtDeclaration getKotlinOrigin() {
            return null;
        }

        @Override
        @Nullable
        public LightMemberOrigin getLightMemberOrigin() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 19: 
                case 20: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 19: 
                case 20: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "enumClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 19: 
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/asJava/classes/ClassInnerStuffCache$EnumSyntheticMethod";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "substitutor";
                    break;
                }
                case 17: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/asJava/classes/ClassInnerStuffCache$EnumSyntheticMethod";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNotNullAnnotation";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createReturnType";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createParameterList";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContainingClass";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParameterList";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getThrowsList";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSignature";
                    break;
                }
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findSuperMethods";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findSuperMethodSignaturesIncludingStatic";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findDeepestSuperMethods";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModifierList";
                    break;
                }
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHierarchicalMethodSignature";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeParameters";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "accept";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 19: 
                case 20: {
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getSignature";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "hasModifierProperty";
                    break;
                }
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "setName";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 19: 
                case 20: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }

        private static final class MyKtLightParameter
        extends LightParameter
        implements KtLightParameter {
            @NotNull
            private final KtLightMethod myMethod;

            MyKtLightParameter(@NotNull PsiType type2, @NotNull KtLightMethod declarationScope) {
                if (type2 == null) {
                    MyKtLightParameter.$$$reportNull$$$0(0);
                }
                if (declarationScope == null) {
                    MyKtLightParameter.$$$reportNull$$$0(1);
                }
                super("name", type2, (PsiElement)declarationScope, declarationScope.getLanguage(), false);
                this.myMethod = declarationScope;
            }

            @Override
            @Nullable
            public KtParameter getKotlinOrigin() {
                return null;
            }

            @Override
            @NotNull
            public KtLightMethod getMethod() {
                KtLightMethod ktLightMethod = this.myMethod;
                if (ktLightMethod == null) {
                    MyKtLightParameter.$$$reportNull$$$0(2);
                }
                return ktLightMethod;
            }

            @Override
            public PsiElement getParent() {
                return this.myMethod;
            }

            @Override
            public PsiFile getContainingFile() {
                return this.myMethod.getContainingFile();
            }

            @Override
            public String getText() {
                return this.getName();
            }

            @Override
            public TextRange getTextRange() {
                return TextRange.EMPTY_RANGE;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string2;
                switch (n) {
                    default: {
                        string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string2 = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "declarationScope";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/kotlin/asJava/classes/ClassInnerStuffCache$EnumSyntheticMethod$MyKtLightParameter";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/kotlin/asJava/classes/ClassInnerStuffCache$EnumSyntheticMethod$MyKtLightParameter";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getMethod";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string3 = String.format(string2, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string3);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string3);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }

    private static enum EnumMethodKind {
        ValueOf,
        Values;

    }
}

