/*
 * Decompiled with CFR 0.152.
 */
package javaslang.collection;

import java.io.Serializable;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;
import javaslang.collection.Comparators;
import javaslang.collection.Iterator;
import javaslang.collection.RedBlackTree;
import javaslang.collection.Set;
import javaslang.collection.SortedSet;
import javaslang.control.Option;

public final class TreeSet<T>
implements Serializable,
SortedSet<T> {
    private static final long serialVersionUID = 1L;
    private final RedBlackTree<T> tree;

    TreeSet(RedBlackTree<T> tree) {
        this.tree = tree;
    }

    public static <T extends Comparable<? super T>> TreeSet<T> empty() {
        return new TreeSet(RedBlackTree.empty());
    }

    public static <T> TreeSet<T> empty(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator, "comparator is null");
        return new TreeSet<T>(RedBlackTree.empty(comparator));
    }

    public static <T> TreeSet<T> ofAll(Comparator<? super T> comparator, Iterable<? extends T> values2) {
        Objects.requireNonNull(comparator, "comparator is null");
        Objects.requireNonNull(values2, "values is null");
        return values2.iterator().hasNext() ? new TreeSet<T>(RedBlackTree.ofAll(comparator, values2)) : TreeSet.empty();
    }

    @Override
    public TreeSet<T> add(T element) {
        return this.contains(element) ? this : new TreeSet<T>(this.tree.insert(element));
    }

    public Comparator<T> comparator() {
        return this.tree.comparator();
    }

    @Override
    public boolean contains(T element) {
        return this.tree.contains(element);
    }

    @Override
    public T head() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("head of empty TreeSet");
        }
        return this.tree.min().get();
    }

    @Override
    public TreeSet<T> intersect(Set<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        if (elements instanceof TreeSet) {
            RedBlackTree<T> that = ((TreeSet)elements).tree;
            return new TreeSet<T>(this.tree.intersection(that));
        }
        return this.retainAll(elements);
    }

    @Override
    public boolean isEmpty() {
        return this.tree.isEmpty();
    }

    @Override
    public boolean isTraversableAgain() {
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        return this.tree.iterator();
    }

    @Override
    public int length() {
        return this.tree.size();
    }

    public <U> TreeSet<U> map(Comparator<? super U> comparator, Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return TreeSet.ofAll(comparator, this.iterator().map(mapper));
    }

    @Override
    public <U> TreeSet<U> map(Function<? super T, ? extends U> mapper) {
        return this.map(Comparators.naturalComparator(), mapper);
    }

    @Override
    public Option<T> max() {
        return this.tree.max();
    }

    public TreeSet<T> retainAll(Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        if (this.isEmpty()) {
            return this;
        }
        RedBlackTree<? extends T> kept = RedBlackTree.ofAll(this.tree.comparator(), elements);
        RedBlackTree<T> newTree = this.tree.intersection(kept);
        return newTree.size() == this.tree.size() ? this : new TreeSet<T>(this.tree.intersection(kept));
    }

    @Override
    public TreeSet<T> tail() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("tail of empty TreeSet");
        }
        return new TreeSet<T>(this.tree.delete(this.tree.min().get()));
    }

    @Override
    public java.util.TreeSet<T> toJavaSet() {
        return this.toJavaSet(() -> new java.util.TreeSet<T>(this.comparator()));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TreeSet) {
            TreeSet that = (TreeSet)o;
            return this.tree.equals(that.tree);
        }
        return false;
    }

    public int hashCode() {
        return this.tree.hashCode();
    }

    @Override
    public String stringPrefix() {
        return "TreeSet";
    }

    @Override
    public String toString() {
        return this.mkString(this.stringPrefix() + "(", ", ", ")");
    }
}

