/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.builtins;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.builtins.jvm.JvmBuiltInClassDescriptorFactory;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.CommonCompilerPerformanceManager;
import org.jetbrains.kotlin.cli.common.config.ContentRootsKt;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;
import org.jetbrains.kotlin.cli.common.messages.GroupingMessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;
import org.jetbrains.kotlin.cli.common.messages.PrintingMessageCollector;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.cli.metadata.CommonAnalysisResult;
import org.jetbrains.kotlin.cli.metadata.MetadataSerializer;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.impl.EmptyPackageFragmentDescriptor;
import org.jetbrains.kotlin.metadata.builtins.BuiltInsBinaryVersion;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.serialization.KotlinSerializerExtensionBase;
import org.jetbrains.kotlin.serialization.builtins.BuiltInsSerializer;
import org.jetbrains.kotlin.serialization.builtins.BuiltInsSerializerExtension;
import org.jetbrains.kotlin.serialization.deserialization.builtins.BuiltInSerializerProtocol;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.storage.StorageManager;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/serialization/builtins/BuiltInsSerializer;", "Lorg/jetbrains/kotlin/cli/metadata/MetadataSerializer;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "environment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "dependOnOldBuiltIns", "", "<init>", "(Lorg/jetbrains/kotlin/config/CompilerConfiguration;Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;Z)V", "serialize", "", "analysisResult", "Lorg/jetbrains/kotlin/cli/metadata/CommonAnalysisResult;", "destDir", "Ljava/io/File;", "createSerializerExtension", "Lorg/jetbrains/kotlin/serialization/KotlinSerializerExtensionBase;", "createCloneable", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "Companion", "cli"})
@SourceDebugExtension(value={"SMAP\nBuiltInsSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuiltInsSerializer.kt\norg/jetbrains/kotlin/serialization/builtins/BuiltInsSerializer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,124:1\n1549#2:125\n1620#2,3:126\n1855#2:129\n1360#2:130\n1446#2,5:131\n1856#2:136\n*S KotlinDebug\n*F\n+ 1 BuiltInsSerializer.kt\norg/jetbrains/kotlin/serialization/builtins/BuiltInsSerializer\n*L\n100#1:125\n100#1:126,3\n100#1:129\n104#1:130\n104#1:131,5\n100#1:136\n*E\n"})
public final class BuiltInsSerializer
extends MetadataSerializer {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public BuiltInsSerializer(@NotNull CompilerConfiguration configuration2, @NotNull KotlinCoreEnvironment environment, boolean dependOnOldBuiltIns) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        super(configuration2, environment, dependOnOldBuiltIns, BuiltInsBinaryVersion.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void serialize(@NotNull CommonAnalysisResult analysisResult2, @NotNull File destDir) {
        Iterable it;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)analysisResult2, (String)"analysisResult");
        Intrinsics.checkNotNullParameter((Object)destDir, (String)"destDir");
        List<KtFile> files2 = this.getEnvironment().getSourceFiles();
        ModuleDescriptor module2 = analysisResult2.getModuleDescriptor();
        FilesKt.deleteRecursively((File)destDir);
        if (!destDir.mkdirs()) {
            throw new AssertionError((Object)("Could not make directories: " + destDir));
        }
        Iterable $this$map$iv = files2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            KtFile ktFile = (KtFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((KtFile)((Object)it)).getPackageFqName());
        }
        Iterable $this$forEach$iv = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            FqName fqName2 = (FqName)element$iv;
            boolean bl = false;
            PackageViewDescriptor packageView = module2.getPackage(fqName2);
            it = packageView.getFragments();
            Collection collection = CollectionsKt.plus((Collection)ResolutionScope.DefaultImpls.getContributedDescriptors$default(packageView.getMemberScope(), DescriptorKindFilter.CLASSIFIERS, null, 2, null), (Object)this.createCloneable(module2));
            MetadataSerializer metadataSerializer2 = this;
            boolean $i$f$flatMap = false;
            void var16_20 = $this$flatMap$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                PackageFragmentDescriptor fragment = (PackageFragmentDescriptor)element$iv$iv;
                boolean bl2 = false;
                Collection<DeclarationDescriptor> collection2 = DescriptorUtils.getAllDescriptors(fragment.getMemberScope());
                Intrinsics.checkNotNullExpressionValue(collection2, (String)"getAllDescriptors(...)");
                Iterable list$iv$iv = collection2;
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            List list2 = (List)destination$iv$iv2;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 32;
            Project project = null;
            LanguageVersionSettings languageVersionSettings2 = CommonConfigurationKeysKt.getLanguageVersionSettings(this.getEnvironment().getConfiguration());
            File file2 = new File(destDir, BuiltInSerializerProtocol.INSTANCE.getBuiltInsFilePath(packageView.getFqName()));
            FqName fqName3 = packageView.getFqName();
            Collection collection3 = list2;
            Collection collection4 = collection;
            MetadataSerializer metadataSerializer3 = metadataSerializer2;
            new MetadataSerializer.PackageSerializer(metadataSerializer3, collection4, collection3, fqName3, file2, languageVersionSettings2, project, n, defaultConstructorMarker).run();
        }
    }

    @Override
    @NotNull
    protected KotlinSerializerExtensionBase createSerializerExtension() {
        return new BuiltInsSerializerExtension();
    }

    private final ClassDescriptor createCloneable(ModuleDescriptor module2) {
        StorageManager storageManager = LockBasedStorageManager.NO_LOCKS;
        Intrinsics.checkNotNullExpressionValue((Object)storageManager, (String)"NO_LOCKS");
        JvmBuiltInClassDescriptorFactory factory2 = new JvmBuiltInClassDescriptorFactory(storageManager, module2, (Function1<? super ModuleDescriptor, ? extends DeclarationDescriptor>)((Function1)new Function1<ModuleDescriptor, DeclarationDescriptor>(module2){
            final /* synthetic */ ModuleDescriptor $module;
            {
                this.$module = $module;
                super(1);
            }

            public final DeclarationDescriptor invoke(ModuleDescriptor it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new EmptyPackageFragmentDescriptor(this.$module, StandardNames.BUILT_INS_PACKAGE_FQ_NAME);
            }
        }));
        FqName fqName2 = StandardNames.FqNames.cloneable.toSafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"toSafe(...)");
        ClassDescriptor classDescriptor2 = factory2.createClass(ClassId.Companion.topLevel(fqName2));
        if (classDescriptor2 == null) {
            throw new IllegalStateException(("Could not create kotlin.Cloneable in " + module2).toString());
        }
        return classDescriptor2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000=\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\b\u0003*\u0001\u0015\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003Jj\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\u000b\u001a\u00020\f26\u0010\r\u001a2\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00050\u000eJ\r\u0010\u0014\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/serialization/builtins/BuiltInsSerializer$Companion;", "", "<init>", "()V", "analyzeAndSerialize", "", "destDir", "Ljava/io/File;", "srcDirs", "", "extraClassPath", "dependOnOldBuiltIns", "", "onComplete", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "totalSize", "totalFiles", "createMessageCollector", "org/jetbrains/kotlin/serialization/builtins/BuiltInsSerializer$Companion$createMessageCollector$1", "()Lorg/jetbrains/kotlin/serialization/builtins/BuiltInsSerializer$Companion$createMessageCollector$1;", "cli"})
    @SourceDebugExtension(value={"SMAP\nBuiltInsSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuiltInsSerializer.kt\norg/jetbrains/kotlin/serialization/builtins/BuiltInsSerializer$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,124:1\n1549#2:125\n1620#2,3:126\n*S KotlinDebug\n*F\n+ 1 BuiltInsSerializer.kt\norg/jetbrains/kotlin/serialization/builtins/BuiltInsSerializer$Companion\n*L\n56#1:125\n56#1:126,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public final void analyzeAndSerialize(@NotNull File destDir, @NotNull List<? extends File> srcDirs, @NotNull List<? extends File> extraClassPath, boolean dependOnOldBuiltIns, @NotNull Function2<? super Integer, ? super Integer, Unit> onComplete) {
            Intrinsics.checkNotNullParameter((Object)destDir, (String)"destDir");
            Intrinsics.checkNotNullParameter(srcDirs, (String)"srcDirs");
            Intrinsics.checkNotNullParameter(extraClassPath, (String)"extraClassPath");
            Intrinsics.checkNotNullParameter(onComplete, (String)"onComplete");
            Disposable disposable = Disposer.newDisposable();
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
            Disposable rootDisposable = disposable;
            createMessageCollector.1 messageCollector = this.createMessageCollector();
            CommonCompilerPerformanceManager performanceManager2 = new CommonCompilerPerformanceManager(){};
            try {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                CompilerConfiguration compilerConfiguration2;
                CompilerConfiguration $this$analyzeAndSerialize_u24lambda_u241 = compilerConfiguration2 = new CompilerConfiguration();
                boolean bl = false;
                $this$analyzeAndSerialize_u24lambda_u241.put(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, messageCollector);
                Iterable iterable = srcDirs;
                CompilerConfiguration compilerConfiguration3 = $this$analyzeAndSerialize_u24lambda_u241;
                boolean $i$f$map = false;
                void var16_15 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    File file2 = (File)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it.getPath());
                }
                ContentRootsKt.addKotlinSourceRoots(compilerConfiguration3, (List)destination$iv$iv);
                JvmContentRootsKt.addJvmClasspathRoots($this$analyzeAndSerialize_u24lambda_u241, extraClassPath);
                JvmContentRootsKt.configureJdkClasspathRoots($this$analyzeAndSerialize_u24lambda_u241);
                $this$analyzeAndSerialize_u24lambda_u241.put(CLIConfigurationKeys.METADATA_DESTINATION_DIRECTORY, destDir);
                $this$analyzeAndSerialize_u24lambda_u241.put(CommonConfigurationKeys.MODULE_NAME, "module for built-ins serialization");
                $this$analyzeAndSerialize_u24lambda_u241.put(CLIConfigurationKeys.PERF_MANAGER, performanceManager2);
                CompilerConfiguration configuration2 = compilerConfiguration2;
                KotlinCoreEnvironment environment = KotlinCoreEnvironment.Companion.createForProduction(rootDisposable, configuration2, EnvironmentConfigFiles.JVM_CONFIG_FILES);
                BuiltInsSerializer serializer2 = new BuiltInsSerializer(configuration2, environment, dependOnOldBuiltIns);
                serializer2.analyzeAndSerialize();
                onComplete.invoke((Object)serializer2.getTotalSize(), (Object)serializer2.getTotalFiles());
            }
            finally {
                messageCollector.flush();
                Disposer.dispose(rootDisposable);
            }
        }

        private final createMessageCollector.1 createMessageCollector() {
            PrintingMessageCollector printingMessageCollector = new PrintingMessageCollector(System.err, MessageRenderer.PLAIN_RELATIVE_PATHS, false);
            return new GroupingMessageCollector(printingMessageCollector){

                public void report(CompilerMessageSeverity severity, String message2, CompilerMessageSourceLocation location) {
                    Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
                    Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                    if (location == null) {
                        super.report(severity, message2, location);
                    }
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

