/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeAttributes;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JavaClassOnCompanionChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend.java"})
public final class JavaClassOnCompanionChecker
implements CallChecker {
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object descriptor2 = resolvedCall2.getResultingDescriptor();
        if (!(descriptor2 instanceof PropertyDescriptor) || !Intrinsics.areEqual((Object)((PropertyDescriptor)descriptor2).getName().asString(), (Object)"javaClass")) {
            return;
        }
        DeclarationDescriptor declarationDescriptor = ((PropertyDescriptor)descriptor2).getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
        DeclarationDescriptor container = declarationDescriptor;
        if (!(container instanceof PackageFragmentDescriptor) || !Intrinsics.areEqual((Object)((PackageFragmentDescriptor)container).getFqName().asString(), (Object)"kotlin.jvm")) {
            return;
        }
        KotlinType kotlinType = ((PropertyDescriptor)descriptor2).getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
        KotlinType actualType = kotlinType;
        Object object = (TypeProjection)CollectionsKt.singleOrNull(actualType.getArguments());
        ClassifierDescriptor classifierDescriptor = object != null && (object = object.getType()) != null && (object = ((KotlinType)object).getConstructor()) != null ? object.getDeclarationDescriptor() : null;
        ClassDescriptor classDescriptor2 = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
        if (classDescriptor2 == null) {
            return;
        }
        ClassDescriptor companionObject2 = classDescriptor2;
        if (companionObject2.isCompanionObject()) {
            DeclarationDescriptor declarationDescriptor2 = companionObject2.getContainingDeclaration();
            Intrinsics.checkNotNull((Object)declarationDescriptor2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            ClassDescriptor containingClass = (ClassDescriptor)declarationDescriptor2;
            ClassifierDescriptor classifierDescriptor2 = actualType.getConstructor().getDeclarationDescriptor();
            ClassDescriptor classDescriptor3 = classifierDescriptor2 instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor2 : null;
            if (classDescriptor3 == null) {
                return;
            }
            ClassDescriptor javaLangClass2 = classDescriptor3;
            List arguments2 = CollectionsKt.listOf((Object)new TypeProjectionImpl(containingClass.getDefaultType()));
            TypeAttributes typeAttributes = TypeAttributes.Companion.getEmpty();
            TypeConstructor typeConstructor2 = javaLangClass2.getTypeConstructor();
            Intrinsics.checkNotNullExpressionValue((Object)typeConstructor2, (String)"getTypeConstructor(...)");
            SimpleType expectedType = KotlinTypeFactory.simpleType$default(typeAttributes, typeConstructor2, arguments2, actualType.isMarkedNullable(), null, 16, null);
            context2.getTrace().report(ErrorsJvm.JAVA_CLASS_ON_COMPANION.on(reportOn, actualType, expectedType));
        }
    }
}

