/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.BooleanValue;
import org.jetbrains.kotlin.resolve.constants.ByteValue;
import org.jetbrains.kotlin.resolve.constants.CharValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValueFactoryKt;
import org.jetbrains.kotlin.resolve.constants.DoubleValue;
import org.jetbrains.kotlin.resolve.constants.FloatValue;
import org.jetbrains.kotlin.resolve.constants.IntValue;
import org.jetbrains.kotlin.resolve.constants.IntegerValueConstant;
import org.jetbrains.kotlin.resolve.constants.LongValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.constants.ShortValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.constants.TypedArrayValue;
import org.jetbrains.kotlin.resolve.constants.UByteValue;
import org.jetbrains.kotlin.resolve.constants.UIntValue;
import org.jetbrains.kotlin.resolve.constants.ULongValue;
import org.jetbrains.kotlin.resolve.constants.UShortValue;
import org.jetbrains.kotlin.resolve.constants.UnsignedValueConstant;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0010\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u00072\u0006\u0010\t\u001a\u00020\nJ\"\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rJ\u0018\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\bJ&\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J$\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b2\u0006\u0010\u0006\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/ConstantValueFactory;", "", "<init>", "()V", "createArrayValue", "Lorg/jetbrains/kotlin/resolve/constants/ArrayValue;", "value", "", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "createConstantValue", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "createUnsignedValue", "Lorg/jetbrains/kotlin/resolve/constants/UnsignedValueConstant;", "constantValue", "componentType", "Lorg/jetbrains/kotlin/builtins/PrimitiveType;", "createIntegerConstantValue", "", "expectedType", "isUnsigned", "", "descriptors"})
@SourceDebugExtension(value={"SMAP\nConstantValueFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConstantValueFactory.kt\norg/jetbrains/kotlin/resolve/constants/ConstantValueFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,103:1\n1603#2,9:104\n1855#2:113\n1856#2:115\n1612#2:116\n1#3:114\n*S KotlinDebug\n*F\n+ 1 ConstantValueFactory.kt\norg/jetbrains/kotlin/resolve/constants/ConstantValueFactory\n*L\n64#1:104,9\n64#1:113\n64#1:115\n64#1:116\n64#1:114\n*E\n"})
public final class ConstantValueFactory {
    @NotNull
    public static final ConstantValueFactory INSTANCE = new ConstantValueFactory();

    private ConstantValueFactory() {
    }

    @NotNull
    public final ArrayValue createArrayValue(@NotNull List<? extends ConstantValue<?>> value2, @NotNull KotlinType type2) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        return new TypedArrayValue(value2, type2);
    }

    @Nullable
    public final ConstantValue<?> createConstantValue(@Nullable Object value2, @Nullable ModuleDescriptor module2) {
        Object object = value2;
        return object instanceof Byte ? (ConstantValue)new ByteValue(((Number)value2).byteValue()) : (object instanceof Short ? (ConstantValue)new ShortValue(((Number)value2).shortValue()) : (object instanceof Integer ? (ConstantValue)new IntValue(((Number)value2).intValue()) : (object instanceof Long ? (ConstantValue)new LongValue(((Number)value2).longValue()) : (object instanceof Character ? (ConstantValue)new CharValue(((Character)value2).charValue()) : (object instanceof Float ? (ConstantValue)new FloatValue(((Number)value2).floatValue()) : (object instanceof Double ? (ConstantValue)new DoubleValue(((Number)value2).doubleValue()) : (object instanceof Boolean ? (ConstantValue)new BooleanValue((Boolean)value2) : (object instanceof String ? (ConstantValue)new StringValue((String)value2) : (object instanceof byte[] ? (ConstantValue)this.createArrayValue(ArraysKt.toList((byte[])((byte[])value2)), module2, PrimitiveType.BYTE) : (object instanceof short[] ? (ConstantValue)this.createArrayValue(ArraysKt.toList((short[])((short[])value2)), module2, PrimitiveType.SHORT) : (object instanceof int[] ? (ConstantValue)this.createArrayValue(ArraysKt.toList((int[])((int[])value2)), module2, PrimitiveType.INT) : (object instanceof long[] ? (ConstantValue)this.createArrayValue(ArraysKt.toList((long[])((long[])value2)), module2, PrimitiveType.LONG) : (object instanceof char[] ? (ConstantValue)this.createArrayValue(ArraysKt.toList((char[])((char[])value2)), module2, PrimitiveType.CHAR) : (object instanceof float[] ? (ConstantValue)this.createArrayValue(ArraysKt.toList((float[])((float[])value2)), module2, PrimitiveType.FLOAT) : (object instanceof double[] ? (ConstantValue)this.createArrayValue(ArraysKt.toList((double[])((double[])value2)), module2, PrimitiveType.DOUBLE) : (object instanceof boolean[] ? (ConstantValue)this.createArrayValue(ArraysKt.toList((boolean[])((boolean[])value2)), module2, PrimitiveType.BOOLEAN) : (object == null ? (ConstantValue)new NullValue() : null)))))))))))))))));
    }

    public static /* synthetic */ ConstantValue createConstantValue$default(ConstantValueFactory constantValueFactory, Object object, ModuleDescriptor moduleDescriptor, int n, Object object2) {
        if ((n & 2) != 0) {
            moduleDescriptor = null;
        }
        return constantValueFactory.createConstantValue(object, moduleDescriptor);
    }

    @Nullable
    public final UnsignedValueConstant<?> createUnsignedValue(@NotNull ConstantValue<?> constantValue) {
        Intrinsics.checkNotNullParameter(constantValue, (String)"constantValue");
        ConstantValue<?> constantValue2 = constantValue;
        return constantValue2 instanceof ByteValue ? (UnsignedValueConstant)new UByteValue(((Number)((ByteValue)constantValue).getValue()).byteValue()) : (constantValue2 instanceof ShortValue ? (UnsignedValueConstant)new UShortValue(((Number)((ShortValue)constantValue).getValue()).shortValue()) : (constantValue2 instanceof IntValue ? (UnsignedValueConstant)new UIntValue(((Number)((IntValue)constantValue).getValue()).intValue()) : (constantValue2 instanceof LongValue ? (UnsignedValueConstant)new ULongValue(((Number)((LongValue)constantValue).getValue()).longValue()) : null)));
    }

    /*
     * WARNING - void declaration
     */
    private final ArrayValue createArrayValue(List<?> value2, ModuleDescriptor module2, PrimitiveType componentType) {
        ArrayValue arrayValue;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = CollectionsKt.toList((Iterable)value2);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ConstantValue it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Object p0 = element$iv$iv;
            boolean bl2 = false;
            if (ConstantValueFactory.createConstantValue$default(this, p0, null, 2, null) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List elements = (List)destination$iv$iv;
        if (module2 != null) {
            SimpleType simpleType2 = module2.getBuiltIns().getPrimitiveArrayKotlinType(componentType);
            Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"getPrimitiveArrayKotlinType(...)");
            arrayValue = new TypedArrayValue(elements, simpleType2);
        } else {
            arrayValue = new ArrayValue(elements, (Function1<? super ModuleDescriptor, ? extends KotlinType>)((Function1)new Function1<ModuleDescriptor, KotlinType>(componentType){
                final /* synthetic */ PrimitiveType $componentType;
                {
                    this.$componentType = $componentType;
                    super(1);
                }

                public final KotlinType invoke(ModuleDescriptor it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    SimpleType simpleType2 = it.getBuiltIns().getPrimitiveArrayKotlinType(this.$componentType);
                    Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"getPrimitiveArrayKotlinType(...)");
                    return simpleType2;
                }
            }));
        }
        return arrayValue;
    }

    @Nullable
    public final ConstantValue<?> createIntegerConstantValue(long value2, @NotNull KotlinType expectedType, boolean isUnsigned) {
        Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
        KotlinType kotlinType = TypeUtils.makeNotNullable(expectedType);
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"makeNotNullable(...)");
        KotlinType notNullExpected = kotlinType;
        return isUnsigned ? (ConstantValue)(KotlinBuiltIns.isUByte(notNullExpected) && value2 == ConstantValueFactoryKt.fromUByteToLong((byte)value2) ? (UnsignedValueConstant)new UByteValue((byte)value2) : (KotlinBuiltIns.isUShort(notNullExpected) && value2 == ConstantValueFactoryKt.fromUShortToLong((short)value2) ? (UnsignedValueConstant)new UShortValue((short)value2) : (KotlinBuiltIns.isUInt(notNullExpected) && value2 == ConstantValueFactoryKt.fromUIntToLong((int)value2) ? (UnsignedValueConstant)new UIntValue((int)value2) : (KotlinBuiltIns.isULong(notNullExpected) ? (UnsignedValueConstant)new ULongValue(value2) : null)))) : (ConstantValue)(KotlinBuiltIns.isLong(notNullExpected) ? (IntegerValueConstant)new LongValue(value2) : (KotlinBuiltIns.isInt(notNullExpected) && value2 == (long)((int)value2) ? (IntegerValueConstant)new IntValue((int)value2) : (KotlinBuiltIns.isShort(notNullExpected) && value2 == (long)((short)value2) ? (IntegerValueConstant)new ShortValue((short)value2) : (KotlinBuiltIns.isByte(notNullExpected) && value2 == (long)((byte)value2) ? (IntegerValueConstant)new ByteValue((byte)value2) : (KotlinBuiltIns.isChar(notNullExpected) ? (IntegerValueConstant)new IntValue((int)value2) : null)))));
    }
}

