/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.resolve.calls.components.ApplicableContextReceiverArgumentWithConstraint;
import org.jetbrains.kotlin.resolve.calls.components.ImplicitInvokeCheckStatus;
import org.jetbrains.kotlin.resolve.calls.components.ReceiverInfo;
import org.jetbrains.kotlin.resolve.calls.components.ResolutionPartsKt;
import org.jetbrains.kotlin.resolve.calls.components.candidate.CallableReferenceResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.components.candidate.ResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.model.ResolutionPart;
import org.jetbrains.kotlin.resolve.calls.model.SimpleKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.StubBuilderInferenceReceiver;
import org.jetbrains.kotlin.resolve.calls.tower.ContextReceiverAmbiguity;
import org.jetbrains.kotlin.resolve.calls.tower.NoMatchingContextReceiver;
import org.jetbrains.kotlin.types.StubTypeForBuilderInference;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\f\u0010\t\u001a\u00020\b*\u00020\u0006H\u0016J\u000e\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\u0006H\u0002J(\u0010\f\u001a\u00020\u0005*\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/components/CheckReceivers;", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolutionPart;", "<init>", "()V", "process", "", "Lorg/jetbrains/kotlin/resolve/calls/components/candidate/ResolutionCandidate;", "workIndex", "", "workCount", "chooseExtensionReceiverCandidate", "Lorg/jetbrains/kotlin/resolve/calls/model/SimpleKotlinCallArgument;", "checkReceiver", "receiverArgument", "receiverParameter", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "shouldCheckImplicitInvoke", "", "resolution"})
@SourceDebugExtension(value={"SMAP\nResolutionParts.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResolutionParts.kt\norg/jetbrains/kotlin/resolve/calls/components/CheckReceivers\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,964:1\n1603#2,9:965\n1855#2:974\n1856#2:976\n1612#2:977\n1#3:975\n*S KotlinDebug\n*F\n+ 1 ResolutionParts.kt\norg/jetbrains/kotlin/resolve/calls/components/CheckReceivers\n*L\n705#1:965,9\n705#1:974\n705#1:976\n705#1:977\n705#1:975\n*E\n"})
public final class CheckReceivers
extends ResolutionPart {
    @NotNull
    public static final CheckReceivers INSTANCE = new CheckReceivers();

    private CheckReceivers() {
    }

    @Override
    public void process(@NotNull ResolutionCandidate $this$process, int workIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$process, (String)"<this>");
        switch (workIndex) {
            case 0: {
                this.checkReceiver($this$process, $this$process.getResolvedCall().getDispatchReceiverArgument(), this.getCandidateDescriptor($this$process).getDispatchReceiverParameter(), true);
                break;
            }
            case 1: {
                boolean checkBuilderInferenceRestriction;
                SimpleKotlinCallArgument extensionReceiverArgument = $this$process.getResolvedCall().getExtensionReceiverArgument();
                if (extensionReceiverArgument == null) {
                    SimpleKotlinCallArgument simpleKotlinCallArgument = this.chooseExtensionReceiverCandidate($this$process);
                    if (simpleKotlinCallArgument == null) {
                        return;
                    }
                    extensionReceiverArgument = simpleKotlinCallArgument;
                    $this$process.getResolvedCall().setExtensionReceiverArgument(extensionReceiverArgument);
                }
                boolean bl = checkBuilderInferenceRestriction = !$this$process.getCallComponents().getLanguageVersionSettings().supportsFeature(LanguageFeature.NoBuilderInferenceWithoutAnnotationRestriction);
                if (checkBuilderInferenceRestriction && extensionReceiverArgument.getReceiver().getReceiverValue().getType() instanceof StubTypeForBuilderInference) {
                    ReceiverParameterDescriptor receiverParameterDescriptor = this.getCandidateDescriptor($this$process).getExtensionReceiverParameter();
                    Intrinsics.checkNotNull((Object)receiverParameterDescriptor);
                    $this$process.addDiagnostic(new StubBuilderInferenceReceiver(extensionReceiverArgument, receiverParameterDescriptor));
                }
                this.checkReceiver($this$process, $this$process.getResolvedCall().getExtensionReceiverArgument(), this.getCandidateDescriptor($this$process).getExtensionReceiverParameter(), false);
            }
        }
    }

    @Override
    public int workCount(@NotNull ResolutionCandidate $this$workCount) {
        Intrinsics.checkNotNullParameter((Object)$this$workCount, (String)"<this>");
        return 2;
    }

    /*
     * WARNING - void declaration
     */
    private final SimpleKotlinCallArgument chooseExtensionReceiverCandidate(ResolutionCandidate $this$chooseExtensionReceiverCandidate) {
        SimpleKotlinCallArgument simpleKotlinCallArgument;
        void $this$mapNotNullTo$iv$iv;
        List<SimpleKotlinCallArgument> receiverCandidates = $this$chooseExtensionReceiverCandidate.getResolvedCall().getExtensionReceiverArgumentCandidates();
        Collection collection = receiverCandidates;
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        if (receiverCandidates.size() == 1) {
            return (SimpleKotlinCallArgument)CollectionsKt.single(receiverCandidates);
        }
        ReceiverParameterDescriptor receiverParameterDescriptor = this.getCandidateDescriptor($this$chooseExtensionReceiverCandidate).getExtensionReceiverParameter();
        if (receiverParameterDescriptor == null) {
            return null;
        }
        ReceiverParameterDescriptor extensionReceiverParameter2 = receiverParameterDescriptor;
        Iterable $this$mapNotNull$iv = receiverCandidates;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ApplicableContextReceiverArgumentWithConstraint it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            SimpleKotlinCallArgument it = (SimpleKotlinCallArgument)element$iv$iv;
            boolean bl2 = false;
            if (ResolutionPartsKt.access$getReceiverArgumentWithConstraintIfCompatible($this$chooseExtensionReceiverCandidate, it, extensionReceiverParameter2) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List compatible = (List)destination$iv$iv;
        switch (compatible.size()) {
            case 0: {
                $this$chooseExtensionReceiverCandidate.addDiagnostic(new NoMatchingContextReceiver());
                simpleKotlinCallArgument = null;
                break;
            }
            case 1: {
                simpleKotlinCallArgument = ((ApplicableContextReceiverArgumentWithConstraint)CollectionsKt.single((List)compatible)).getArgument();
                break;
            }
            default: {
                $this$chooseExtensionReceiverCandidate.addDiagnostic(new ContextReceiverAmbiguity());
                simpleKotlinCallArgument = null;
            }
        }
        return simpleKotlinCallArgument;
    }

    private final void checkReceiver(ResolutionCandidate $this$checkReceiver, SimpleKotlinCallArgument receiverArgument, ReceiverParameterDescriptor receiverParameter, boolean shouldCheckImplicitInvoke) {
        if (!($this$checkReceiver instanceof CallableReferenceResolutionCandidate) && receiverArgument == null != (receiverParameter == null)) {
            throw new IllegalStateException(("Inconsistency receiver state for call " + this.getKotlinCall($this$checkReceiver) + " and candidate descriptor: " + this.getCandidateDescriptor($this$checkReceiver)).toString());
        }
        if (receiverArgument == null || receiverParameter == null) {
            return;
        }
        ImplicitInvokeCheckStatus implicitInvokeState = shouldCheckImplicitInvoke ? ResolutionPartsKt.access$checkUnsafeImplicitInvokeAfterSafeCall($this$checkReceiver, receiverArgument) : ImplicitInvokeCheckStatus.NO_INVOKE;
        ReceiverInfo receiverInfo = new ReceiverInfo(true, implicitInvokeState != ImplicitInvokeCheckStatus.UNSAFE_INVOKE_REPORTED, implicitInvokeState == ImplicitInvokeCheckStatus.INVOKE_ON_NOT_NULL_VARIABLE, $this$checkReceiver.getResolvedCall().getAtom());
        ResolutionPartsKt.access$resolveKotlinArgument($this$checkReceiver, receiverArgument, receiverParameter, receiverInfo);
    }
}

