/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.checkers.AbstractReflectionApiCallCheckerKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.storage.StorageKt;
import org.jetbrains.kotlin.storage.StorageManager;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H$J\u0018\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\"\u0010\u001f\u001a\u00020\f2\n\u0010 \u001a\u0006\u0012\u0002\b\u00030!2\u0006\u0010\"\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J \u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\f\u0010'\u001a\u00020\t*\u00020\u0013H\u0002J\u0010\u0010(\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\tX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\nR!\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R\u001b\u0010\u0018\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0017\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/AbstractReflectionApiCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "reflectionTypes", "Lorg/jetbrains/kotlin/builtins/ReflectionTypes;", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "<init>", "(Lorg/jetbrains/kotlin/builtins/ReflectionTypes;Lorg/jetbrains/kotlin/storage/StorageManager;)V", "isWholeReflectionApiAvailable", "", "()Z", "report", "", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "kPropertyClasses", "", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getKPropertyClasses", "()Ljava/util/Set;", "kPropertyClasses$delegate", "Lorg/jetbrains/kotlin/storage/NotNullLazyValue;", "kClass", "getKClass", "()Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "kClass$delegate", "isAllowedKClassMember", "name", "Lorg/jetbrains/kotlin/name/Name;", "check", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "isAllowedReflectionApi", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "containingClass", "isKPropertyClass", "isReflectionSource", "frontend"})
@SourceDebugExtension(value={"SMAP\nAbstractReflectionApiCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractReflectionApiCallChecker.kt\norg/jetbrains/kotlin/resolve/calls/checkers/AbstractReflectionApiCallChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n1747#2,3:103\n*S KotlinDebug\n*F\n+ 1 AbstractReflectionApiCallChecker.kt\norg/jetbrains/kotlin/resolve/calls/checkers/AbstractReflectionApiCallChecker\n*L\n95#1:103,3\n*E\n"})
public abstract class AbstractReflectionApiCallChecker
implements CallChecker {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final ReflectionTypes reflectionTypes;
    @NotNull
    private final NotNullLazyValue kPropertyClasses$delegate;
    @NotNull
    private final NotNullLazyValue kClass$delegate;

    public AbstractReflectionApiCallChecker(@NotNull ReflectionTypes reflectionTypes, @NotNull StorageManager storageManager) {
        Intrinsics.checkNotNullParameter((Object)reflectionTypes, (String)"reflectionTypes");
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        this.reflectionTypes = reflectionTypes;
        this.kPropertyClasses$delegate = storageManager.createLazyValue((Function0)new Function0<Set<? extends ClassDescriptor>>(this){
            final /* synthetic */ AbstractReflectionApiCallChecker this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Set<ClassDescriptor> invoke() {
                Object[] objectArray = new ClassDescriptor[]{AbstractReflectionApiCallChecker.access$getReflectionTypes$p(this.this$0).getKProperty0(), AbstractReflectionApiCallChecker.access$getReflectionTypes$p(this.this$0).getKProperty1(), AbstractReflectionApiCallChecker.access$getReflectionTypes$p(this.this$0).getKProperty2()};
                return SetsKt.setOf((Object[])objectArray);
            }
        });
        this.kClass$delegate = storageManager.createLazyValue((Function0)new Function0<ClassDescriptor>(this){
            final /* synthetic */ AbstractReflectionApiCallChecker this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final ClassDescriptor invoke() {
                return AbstractReflectionApiCallChecker.access$getReflectionTypes$p(this.this$0).getKClass();
            }
        });
    }

    protected abstract boolean isWholeReflectionApiAvailable();

    protected abstract void report(@NotNull PsiElement var1, @NotNull CallCheckerContext var2);

    private final Set<ClassDescriptor> getKPropertyClasses() {
        return (Set)StorageKt.getValue(this.kPropertyClasses$delegate, (Object)this, $$delegatedProperties[0]);
    }

    private final ClassDescriptor getKClass() {
        return (ClassDescriptor)StorageKt.getValue(this.kClass$delegate, (Object)this, $$delegatedProperties[1]);
    }

    protected boolean isAllowedKClassMember(@NotNull Name name2, @NotNull CallCheckerContext context2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        switch (name2.asString()) {
            case "isInstance": 
            case "simpleName": {
                bl = true;
                break;
            }
            case "qualifiedName": {
                bl = context2.getLanguageVersionSettings().getFlag(AnalysisFlags.getAllowFullyQualifiedNameInKClass());
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public final void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (this.isWholeReflectionApiAvailable()) {
            return;
        }
        if (this.isReflectionSource(reportOn)) {
            return;
        }
        Object descriptor2 = resolvedCall2.getResultingDescriptor();
        DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
        ClassDescriptor classDescriptor2 = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
        if (classDescriptor2 == null) {
            return;
        }
        ClassDescriptor containingClass = classDescriptor2;
        if (!ReflectionTypes.Companion.isReflectionClass(containingClass)) {
            return;
        }
        if (!this.isAllowedReflectionApi((CallableDescriptor)descriptor2, containingClass, context2)) {
            this.report(reportOn, context2);
        }
    }

    protected boolean isAllowedReflectionApi(@NotNull CallableDescriptor descriptor2, @NotNull ClassDescriptor containingClass, @NotNull CallCheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)containingClass, (String)"containingClass");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Name name2 = descriptor2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"getName(...)");
        Name name3 = name2;
        return AbstractReflectionApiCallCheckerKt.access$getALLOWED_MEMBER_NAMES$p().contains(name3.asString()) || DescriptorUtils.isSubclass(containingClass, this.getKClass()) && this.isAllowedKClassMember(name3, context2) || (Intrinsics.areEqual((Object)name3.asString(), (Object)"get") || Intrinsics.areEqual((Object)name3.asString(), (Object)"set")) && this.isKPropertyClass(containingClass) || AbstractReflectionApiCallCheckerKt.access$getALLOWED_CLASSES$p().contains(DescriptorUtilsKt.getFqNameSafe(containingClass));
    }

    private final boolean isKPropertyClass(ClassDescriptor $this$isKPropertyClass) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.getKPropertyClasses();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ClassDescriptor kProperty = (ClassDescriptor)element$iv;
                    boolean bl2 = false;
                    if (!DescriptorUtils.isSubclass($this$isKPropertyClass, kProperty)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isReflectionSource(PsiElement reportOn) {
        PsiFile psiFile = reportOn.getContainingFile();
        KtFile ktFile = psiFile instanceof KtFile ? (KtFile)psiFile : null;
        if (ktFile == null) {
            return false;
        }
        KtFile file2 = ktFile;
        return file2.getPackageFqName().startsWith(StandardNames.KOTLIN_REFLECT_FQ_NAME);
    }

    public static final /* synthetic */ ReflectionTypes access$getReflectionTypes$p(AbstractReflectionApiCallChecker $this) {
        return $this.reflectionTypes;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(AbstractReflectionApiCallChecker.class), "kPropertyClasses", "getKPropertyClasses()Ljava/util/Set;"))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(AbstractReflectionApiCallChecker.class), "kClass", "getKClass()Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;")))};
        $$delegatedProperties = kPropertyArray;
    }
}

