/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library.abi.impl;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.library.KotlinAbiVersion;
import org.jetbrains.kotlin.library.KotlinIrSignatureVersion;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.KotlinLibraryKt;
import org.jetbrains.kotlin.library.KotlinLibraryVersioning;
import org.jetbrains.kotlin.library.SingleFileResolveKt;
import org.jetbrains.kotlin.library.ToolingSingleFileKlibResolveStrategy;
import org.jetbrains.kotlin.library.abi.AbiReadingFilter;
import org.jetbrains.kotlin.library.abi.AbiSignatureVersion;
import org.jetbrains.kotlin.library.abi.ExperimentalLibraryAbiReader;
import org.jetbrains.kotlin.library.abi.LibraryAbi;
import org.jetbrains.kotlin.library.abi.LibraryManifest;
import org.jetbrains.kotlin.library.abi.impl.AbiSignatureVersions;
import org.jetbrains.kotlin.library.abi.impl.LibraryDeserializer;

@ExperimentalLibraryAbiReader
@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/library/abi/impl/LibraryAbiReaderImpl;", "", "libraryFile", "Ljava/io/File;", "filters", "", "Lorg/jetbrains/kotlin/library/abi/AbiReadingFilter;", "<init>", "(Ljava/io/File;Ljava/util/List;)V", "library", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "compositeFilter", "Lorg/jetbrains/kotlin/library/abi/AbiReadingFilter$Composite;", "readAbi", "Lorg/jetbrains/kotlin/library/abi/LibraryAbi;", "readManifest", "Lorg/jetbrains/kotlin/library/abi/LibraryManifest;", "readSupportedSignatureVersions", "", "Lorg/jetbrains/kotlin/library/abi/AbiSignatureVersion;", "kotlin-util-klib-abi"})
@SourceDebugExtension(value={"SMAP\nLibraryAbiReaderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryAbiReaderImpl.kt\norg/jetbrains/kotlin/library/abi/impl/LibraryAbiReaderImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,796:1\n1620#2,3:797\n*S KotlinDebug\n*F\n+ 1 LibraryAbiReaderImpl.kt\norg/jetbrains/kotlin/library/abi/impl/LibraryAbiReaderImpl\n*L\n87#1:797,3\n*E\n"})
public final class LibraryAbiReaderImpl {
    @NotNull
    private final KotlinLibrary library;
    @Nullable
    private final AbiReadingFilter.Composite compositeFilter;

    public LibraryAbiReaderImpl(@NotNull File libraryFile, @NotNull List<? extends AbiReadingFilter> filters) {
        Intrinsics.checkNotNullParameter((Object)libraryFile, (String)"libraryFile");
        Intrinsics.checkNotNullParameter(filters, (String)"filters");
        String string2 = libraryFile.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
        this.library = SingleFileResolveKt.resolveSingleFileKlib$default(new org.jetbrains.kotlin.konan.file.File(string2), null, ToolingSingleFileKlibResolveStrategy.INSTANCE, 2, null);
        this.compositeFilter = !((Collection)filters).isEmpty() ? new AbiReadingFilter.Composite(filters) : null;
    }

    @NotNull
    public final LibraryAbi readAbi() {
        Set<AbiSignatureVersion> supportedSignatureVersions = this.readSupportedSignatureVersions();
        return new LibraryAbi(this.readManifest(), KotlinLibraryKt.getUniqueName(this.library), supportedSignatureVersions, new LibraryDeserializer(this.library, supportedSignatureVersions, this.compositeFilter).deserialize());
    }

    private final LibraryManifest readManifest() {
        KotlinLibraryVersioning versions2 = this.library.getVersions();
        KotlinAbiVersion kotlinAbiVersion = versions2.getAbiVersion();
        return new LibraryManifest(KotlinLibraryKt.getBuiltInsPlatform(this.library), CollectionsKt.sorted((Iterable)KotlinLibraryKt.getNativeTargets(this.library)), versions2.getCompilerVersion(), kotlinAbiVersion != null ? kotlinAbiVersion.toString() : null, versions2.getLibraryVersion(), KotlinLibraryKt.getIrProviderName(this.library));
    }

    /*
     * WARNING - void declaration
     */
    private final Set<AbiSignatureVersion> readSupportedSignatureVersions() {
        void var2_2;
        void $this$mapTo$iv;
        Iterable iterable = this.library.getVersions().getIrSignatureVersions();
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            KotlinIrSignatureVersion kotlinIrSignatureVersion = (KotlinIrSignatureVersion)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(AbiSignatureVersions.INSTANCE.resolveByVersionNumber(it.getNumber()));
        }
        return (Set)var2_2;
    }
}

