/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.konan.file;

import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.zip.ZipException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.konan.file.File;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u001e\u0010\u0005\u001a\u00020\u0006*\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00012\b\b\u0002\u0010\b\u001a\u00020\tH\u0002\u001a\u0014\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b*\u00020\u0001H\u0002\u001a&\u0010\r\u001a\u00020\u0006*\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\b\b\u0002\u0010\u000f\u001a\u00020\u000b2\b\b\u0002\u0010\b\u001a\u00020\t\u001a&\u0010\r\u001a\u00020\u0006*\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u00012\b\b\u0002\u0010\u000f\u001a\u00020\u00012\b\b\u0002\u0010\b\u001a\u00020\t\u001a)\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u0011*\u00020\u00012\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H\u00110\u0013\u00a2\u0006\u0002\u0010\u0014\u001a1\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u0011*\u00020\u00012\u0006\u0010\u0015\u001a\u00020\t2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H\u00110\u0013\u00a2\u0006\u0002\u0010\u0016\u001a\u0012\u0010\u0017\u001a\u00020\u0006*\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0001\u001a\u0016\u0010\u0019\u001a\u00020\u0002*\u00020\u00012\b\b\u0002\u0010\u0015\u001a\u00020\tH\u0000\u00a8\u0006\u001a"}, d2={"file", "Lorg/jetbrains/kotlin/konan/file/File;", "Ljava/nio/file/FileSystem;", "path", "", "recursiveCopyTo", "", "destination", "resetTimeAttributes", "", "toPath", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "unzipTo", "destinationDirectory", "fromSubdirectory", "withZipFileSystem", "T", "action", "Lkotlin/Function1;", "(Lorg/jetbrains/kotlin/konan/file/File;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "create", "(Lorg/jetbrains/kotlin/konan/file/File;ZLkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "zipDirAs", "unixFile", "zipFileSystem", "kotlin-util-io"})
@SourceDebugExtension(value={"SMAP\nZipUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZipUtil.kt\norg/jetbrains/kotlin/konan/file/ZipUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 File.kt\norg/jetbrains/kotlin/konan/file/FileKt\n*L\n1#1,115:1\n766#2:116\n857#2,2:117\n1603#2,9:119\n1855#2:128\n1856#2:130\n1612#2:131\n1#3:129\n210#4,13:132\n*S KotlinDebug\n*F\n+ 1 ZipUtil.kt\norg/jetbrains/kotlin/konan/file/ZipUtilKt\n*L\n25#1:116\n25#1:117,2\n25#1:119,9\n25#1:128\n25#1:130\n25#1:131\n25#1:129\n79#1:132,13\n*E\n"})
public final class ZipUtilKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FileSystem zipFileSystem(@NotNull File $this$zipFileSystem, boolean create2) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$zipFileSystem, (String)"<this>");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"create", (Object)String.valueOf(create2))};
        HashMap attributes2 = MapsKt.hashMapOf((Pair[])pairArray);
        List<FileSystemProvider> list2 = FileSystemProvider.installedProviders();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"installedProviders()");
        Iterable $this$filter$iv = list2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FileSystemProvider it = (FileSystemProvider)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getScheme(), (Object)"jar")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            FileSystem it$iv$iv;
            FileSystem fileSystem;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FileSystemProvider it = (FileSystemProvider)element$iv$iv;
            boolean bl2 = false;
            try {
                fileSystem = it.newFileSystem(ZipUtilKt.toPath($this$zipFileSystem), (Map)attributes2);
            }
            catch (Exception e) {
                Exception exception = e;
                if (!(exception instanceof UnsupportedOperationException ? true : exception instanceof IllegalArgumentException)) {
                    throw e;
                }
                fileSystem = null;
            }
            if (fileSystem == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (FileSystem)CollectionsKt.first((List)((List)destination$iv$iv));
    }

    public static /* synthetic */ FileSystem zipFileSystem$default(File file2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return ZipUtilKt.zipFileSystem(file2, bl);
    }

    @NotNull
    public static final File file(@NotNull FileSystem $this$file, @NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)$this$file, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Path path = $this$file.getPath(file2.getPath(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"this.getPath(file.path)");
        return new File(path);
    }

    @NotNull
    public static final File file(@NotNull FileSystem $this$file, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)$this$file, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path path2 = $this$file.getPath(path, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"this.getPath(path)");
        return new File(path2);
    }

    private static final Path toPath(File $this$toPath) {
        return Paths.get($this$toPath.getPath(), new String[0]);
    }

    public static final void zipDirAs(@NotNull File $this$zipDirAs, @NotNull File unixFile) {
        Intrinsics.checkNotNullParameter((Object)$this$zipDirAs, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)unixFile, (String)"unixFile");
        ZipUtilKt.withZipFileSystem(unixFile, true, (Function1)new Function1<FileSystem, Unit>($this$zipDirAs){
            final /* synthetic */ File $this_zipDirAs;
            {
                this.$this_zipDirAs = $receiver;
                super(1);
            }

            public final void invoke(FileSystem it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ZipUtilKt.access$recursiveCopyTo(this.$this_zipDirAs, ZipUtilKt.file(it, "/"), true);
            }
        });
    }

    public static final void unzipTo(@NotNull File $this$unzipTo, @NotNull File destinationDirectory, @NotNull File fromSubdirectory, boolean resetTimeAttributes) {
        Intrinsics.checkNotNullParameter((Object)$this$unzipTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)destinationDirectory, (String)"destinationDirectory");
        Intrinsics.checkNotNullParameter((Object)fromSubdirectory, (String)"fromSubdirectory");
        ZipUtilKt.withZipFileSystem($this$unzipTo, (Function1)new Function1<FileSystem, Unit>(fromSubdirectory, destinationDirectory, resetTimeAttributes){
            final /* synthetic */ File $fromSubdirectory;
            final /* synthetic */ File $destinationDirectory;
            final /* synthetic */ boolean $resetTimeAttributes;
            {
                this.$fromSubdirectory = $fromSubdirectory;
                this.$destinationDirectory = $destinationDirectory;
                this.$resetTimeAttributes = $resetTimeAttributes;
                super(1);
            }

            public final void invoke(FileSystem it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ZipUtilKt.access$recursiveCopyTo(ZipUtilKt.file(it, this.$fromSubdirectory), this.$destinationDirectory, this.$resetTimeAttributes);
            }
        });
    }

    public static /* synthetic */ void unzipTo$default(File file2, File file3, File file4, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            file4 = new File("/");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        ZipUtilKt.unzipTo(file2, file3, file4, bl);
    }

    public static final void unzipTo(@NotNull Path $this$unzipTo, @NotNull Path destinationDirectory, @NotNull Path fromSubdirectory, boolean resetTimeAttributes) {
        Intrinsics.checkNotNullParameter((Object)$this$unzipTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)destinationDirectory, (String)"destinationDirectory");
        Intrinsics.checkNotNullParameter((Object)fromSubdirectory, (String)"fromSubdirectory");
        ZipUtilKt.unzipTo(new File($this$unzipTo), new File(destinationDirectory), new File(fromSubdirectory), resetTimeAttributes);
    }

    public static /* synthetic */ void unzipTo$default(Path path, Path path2, Path path3, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            Path path4 = Paths.get("/", new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"get(\"/\")");
            path3 = path4;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        ZipUtilKt.unzipTo(path, path2, path3, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T withZipFileSystem(@NotNull File $this$withZipFileSystem, boolean create2, @NotNull Function1<? super FileSystem, ? extends T> action) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$withZipFileSystem, (String)"<this>");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        AutoCloseable $this$use$iv = ZipUtilKt.zipFileSystem($this$withZipFileSystem, create2);
        boolean $i$f$use = false;
        boolean closed$iv = false;
        try {
            object = action.invoke((Object)$this$use$iv);
        }
        catch (Exception e$iv) {
            try {
                closed$iv = true;
                try {
                    AutoCloseable autoCloseable = $this$use$iv;
                    if (autoCloseable != null) {
                        autoCloseable.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e$iv;
            }
            catch (Throwable throwable) {
                if (!closed$iv) {
                    AutoCloseable autoCloseable = $this$use$iv;
                    if (autoCloseable != null) {
                        autoCloseable.close();
                    }
                }
                throw throwable;
            }
        }
        AutoCloseable autoCloseable = $this$use$iv;
        if (autoCloseable != null) {
            autoCloseable.close();
        }
        return (T)object;
    }

    public static final <T> T withZipFileSystem(@NotNull File $this$withZipFileSystem, @NotNull Function1<? super FileSystem, ? extends T> action) {
        Intrinsics.checkNotNullParameter((Object)$this$withZipFileSystem, (String)"<this>");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        return ZipUtilKt.withZipFileSystem($this$withZipFileSystem, false, action);
    }

    private static final void recursiveCopyTo(File $this$recursiveCopyTo, File destination, boolean resetTimeAttributes) {
        Path sourcePath = $this$recursiveCopyTo.getJavaPath$kotlin_util_io();
        Path destPath = destination.getJavaPath$kotlin_util_io();
        FileSystem destFs = destPath.getFileSystem();
        Path normalizedDestPath = destPath.normalize();
        Files.walk(sourcePath, new FileVisitOption[0]).forEach(new Consumer(sourcePath, destFs, destPath, normalizedDestPath, destination, resetTimeAttributes){
            final /* synthetic */ Path $sourcePath;
            final /* synthetic */ FileSystem $destFs;
            final /* synthetic */ Path $destPath;
            final /* synthetic */ Path $normalizedDestPath;
            final /* synthetic */ File $destination;
            final /* synthetic */ boolean $resetTimeAttributes;
            {
                this.$sourcePath = $sourcePath;
                this.$destFs = $destFs;
                this.$destPath = $destPath;
                this.$normalizedDestPath = $normalizedDestPath;
                this.$destination = $destination;
                this.$resetTimeAttributes = $resetTimeAttributes;
            }

            public final void accept(Path oldPath) {
                Path relative = this.$sourcePath.relativize(oldPath);
                Object[] objectArray = new String[]{((Object)relative).toString()};
                Path newPath = this.$destFs.getPath(((Object)this.$destPath).toString(), (String[])objectArray);
                if (!newPath.normalize().startsWith(this.$normalizedDestPath)) {
                    throw new ZipException(relative + " attempted to escape the destination directory " + this.$destination);
                }
                if (Intrinsics.areEqual((Object)newPath, (Object)newPath.getRoot())) {
                    return;
                }
                if (Files.isDirectory(newPath, new LinkOption[0])) {
                    Files.createDirectories(newPath, new FileAttribute[0]);
                } else {
                    objectArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                    Files.copy(oldPath, newPath, (CopyOption[])objectArray);
                }
                if (this.$resetTimeAttributes) {
                    FileTime zero = FileTime.fromMillis(0L);
                    Files.getFileAttributeView(newPath, BasicFileAttributeView.class, new LinkOption[0]).setTimes(zero, zero, zero);
                }
            }
        });
    }

    public static final /* synthetic */ void access$recursiveCopyTo(File $receiver, File destination, boolean resetTimeAttributes) {
        ZipUtilKt.recursiveCopyTo($receiver, destination, resetTimeAttributes);
    }
}

