/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsEmpty;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsTry;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\f\u001a\u00020\u000bJ\b\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\bH\u0002J\u001e\u0010\u000f\u001a\u00020\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u00132\u0006\u0010\u0011\u001a\u00020\bH\u0002J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\bH\u0002J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/RedundantLabelRemoval;", "", "root", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "<init>", "(Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;)V", "labelUsages", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "", "hasChanges", "", "apply", "analyze", "", "perform", "statement", "name", "statements", "", "useLabel", "unuseLabel", "js.translator"})
@SourceDebugExtension(value={"SMAP\nRedundantLabelRemoval.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedundantLabelRemoval.kt\norg/jetbrains/kotlin/js/inline/clean/RedundantLabelRemoval\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,106:1\n1#2:107\n*E\n"})
public final class RedundantLabelRemoval {
    @NotNull
    private final JsStatement root;
    @NotNull
    private final Map<JsName, Integer> labelUsages;
    private boolean hasChanges;

    public RedundantLabelRemoval(@NotNull JsStatement root2) {
        Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
        this.root = root2;
        this.labelUsages = new LinkedHashMap();
    }

    public final boolean apply() {
        this.analyze();
        this.perform();
        return this.hasChanges;
    }

    private final void analyze() {
        new JsVisitorWithContextImpl(this){
            final /* synthetic */ RedundantLabelRemoval this$0;
            {
                this.this$0 = $receiver;
            }

            public void endVisit(JsBreak x, JsContext<?> ctx) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                    Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                    super.endVisit(x, ctx);
                    JsNameRef jsNameRef = x.getLabel();
                    if (jsNameRef == null) break block0;
                    JsNameRef jsNameRef2 = jsNameRef;
                    RedundantLabelRemoval redundantLabelRemoval = this.this$0;
                    JsNameRef it = jsNameRef2;
                    boolean bl = false;
                    JsName jsName = it.getName();
                    Intrinsics.checkNotNull((Object)jsName);
                    RedundantLabelRemoval.access$useLabel(redundantLabelRemoval, jsName);
                }
            }

            public void endVisit(JsContinue x, JsContext<?> ctx) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                    Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                    super.endVisit(x, ctx);
                    JsNameRef jsNameRef = x.getLabel();
                    if (jsNameRef == null) break block0;
                    JsNameRef jsNameRef2 = jsNameRef;
                    RedundantLabelRemoval redundantLabelRemoval = this.this$0;
                    JsNameRef it = jsNameRef2;
                    boolean bl = false;
                    JsName jsName = it.getName();
                    Intrinsics.checkNotNull((Object)jsName);
                    RedundantLabelRemoval.access$useLabel(redundantLabelRemoval, jsName);
                }
            }
        }.accept((JsNode)this.root);
    }

    private final void perform() {
        new JsVisitorWithContextImpl(this){
            final /* synthetic */ RedundantLabelRemoval this$0;
            {
                this.this$0 = $receiver;
            }

            public void endVisit(JsLabel x, JsContext<JsNode> ctx) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                if (MetadataProperties.getSynthetic(x)) {
                    JsStatement jsStatement = x.getStatement();
                    Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"getStatement(...)");
                    JsName jsName = x.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"getName(...)");
                    x.setStatement(RedundantLabelRemoval.access$perform(this.this$0, jsStatement, jsName));
                    Integer n = (Integer)RedundantLabelRemoval.access$getLabelUsages$p(this.this$0).get(x.getName());
                    if ((n != null ? n : 0) == 0) {
                        RedundantLabelRemoval.access$setHasChanges$p(this.this$0, true);
                        ctx.replaceMe((JsNode)x.getStatement());
                    }
                }
                super.endVisit(x, ctx);
            }

            public boolean visit(JsFunction x, JsContext<?> ctx) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                return false;
            }
        }.accept((JsNode)this.root);
    }

    /*
     * WARNING - void declaration
     */
    private final JsStatement perform(JsStatement statement2, JsName name2) {
        JsStatement jsStatement;
        JsStatement jsStatement2 = statement2;
        if (jsStatement2 instanceof JsBreak) {
            JsNode jsNode;
            JsNameRef jsNameRef = ((JsBreak)statement2).getLabel();
            if (Intrinsics.areEqual((Object)name2, (Object)(jsNameRef != null ? jsNameRef.getName() : null))) {
                this.unuseLabel(name2);
                this.hasChanges = true;
                jsNode = JsEmpty.INSTANCE;
            } else {
                jsNode = statement2;
            }
            jsStatement = (JsStatement)jsNode;
        } else if (jsStatement2 instanceof JsLabel) {
            JsStatement jsStatement3 = ((JsLabel)statement2).getStatement();
            Intrinsics.checkNotNullExpressionValue((Object)jsStatement3, (String)"getStatement(...)");
            this.perform(jsStatement3, name2);
            jsStatement = statement2;
        } else if (jsStatement2 instanceof JsBlock) {
            List<JsStatement> list2 = ((JsBlock)statement2).getStatements();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getStatements(...)");
            this.perform(list2, name2);
            jsStatement = statement2;
        } else if (jsStatement2 instanceof JsIf) {
            JsStatement jsStatement4;
            JsIf jsIf = (JsIf)statement2;
            JsStatement jsStatement5 = ((JsIf)statement2).getThenStatement();
            Intrinsics.checkNotNullExpressionValue((Object)jsStatement5, (String)"getThenStatement(...)");
            jsIf.setThenStatement(this.perform(jsStatement5, name2));
            JsIf jsIf2 = (JsIf)statement2;
            JsStatement jsStatement6 = ((JsIf)statement2).getElseStatement();
            if (jsStatement6 != null) {
                void it;
                JsStatement jsStatement7 = jsStatement6;
                JsIf jsIf3 = jsIf2;
                boolean bl = false;
                jsStatement4 = this.perform((JsStatement)it, name2);
                jsIf2 = jsIf3;
            } else {
                jsStatement4 = null;
            }
            jsIf2.setElseStatement(jsStatement4);
            jsStatement = statement2;
        } else if (jsStatement2 instanceof JsTry) {
            JsBlock jsBlock = ((JsTry)statement2).getTryBlock();
            Intrinsics.checkNotNullExpressionValue((Object)jsBlock, (String)"getTryBlock(...)");
            this.perform(jsBlock, name2);
            jsStatement = statement2;
        } else {
            jsStatement = statement2;
        }
        return jsStatement;
    }

    private final void perform(List<JsStatement> statements2, JsName name2) {
        block0: {
            JsStatement jsStatement = (JsStatement)CollectionsKt.lastOrNull(statements2);
            if (jsStatement == null) break block0;
            JsStatement it = jsStatement;
            boolean bl = false;
            statements2.set(CollectionsKt.getLastIndex(statements2), this.perform(it, name2));
        }
    }

    private final void useLabel(JsName name2) {
        Map<JsName, Integer> map = this.labelUsages;
        Integer n = this.labelUsages.get(name2);
        Integer n2 = (n != null ? n : 0) + 1;
        map.put(name2, n2);
    }

    private final void unuseLabel(JsName name2) {
        Integer n = this.labelUsages.get(name2);
        Intrinsics.checkNotNull((Object)n);
        this.labelUsages.put(name2, ((Number)n).intValue() - 1);
    }

    public static final /* synthetic */ void access$useLabel(RedundantLabelRemoval $this, JsName name2) {
        $this.useLabel(name2);
    }

    public static final /* synthetic */ JsStatement access$perform(RedundantLabelRemoval $this, JsStatement statement2, JsName name2) {
        return $this.perform(statement2, name2);
    }

    public static final /* synthetic */ Map access$getLabelUsages$p(RedundantLabelRemoval $this) {
        return $this.labelUsages;
    }

    public static final /* synthetic */ void access$setHasChanges$p(RedundantLabelRemoval $this, boolean bl) {
        $this.hasChanges = bl;
    }
}

