/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SpecialFunction;
import org.jetbrains.kotlin.js.inline.FunctionReaderKt;
import org.jetbrains.kotlin.js.inline.util.CollectionUtilsKt;
import org.jetbrains.kotlin.js.inline.util.InvocationUtilsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 0, 0}, k=2, xi=50, d1={"\u0000R\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0010\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a2\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00190\t2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\f\u001a\u00020\r*\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000f\u00a8\u0006\u001d"}, d2={"JS_IDENTIFIER_START", "", "JS_IDENTIFIER_PART", "JS_IDENTIFIER", "DEFINE_MODULE_PATTERN", "Ljava/util/regex/Pattern;", "DEFINE_MODULE_FIND_PATTERN", "specialFunctions", "specialFunctionsByName", "", "Lorg/jetbrains/kotlin/js/backend/ast/metadata/SpecialFunction;", "SPECIAL_FUNCTION_PATTERN", "isWhitespaceOrComma", "", "", "(C)Z", "markInlineArguments", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "replaceExternalNames", "node", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "replacements", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "definedNames", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "js.translator"})
@SourceDebugExtension(value={"SMAP\nFunctionReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FunctionReader.kt\norg/jetbrains/kotlin/js/inline/FunctionReaderKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,428:1\n8541#2,2:429\n8801#2,4:431\n*S KotlinDebug\n*F\n+ 1 FunctionReader.kt\norg/jetbrains/kotlin/js/inline/FunctionReaderKt\n*L\n44#1:429,2\n44#1:431,4\n*E\n"})
public final class FunctionReaderKt {
    @NotNull
    private static final String JS_IDENTIFIER_START;
    @NotNull
    private static final String JS_IDENTIFIER_PART;
    @NotNull
    private static final String JS_IDENTIFIER;
    @NotNull
    private static final Pattern DEFINE_MODULE_PATTERN;
    @NotNull
    private static final String DEFINE_MODULE_FIND_PATTERN;
    @NotNull
    private static final String specialFunctions;
    @NotNull
    private static final Map<String, SpecialFunction> specialFunctionsByName;
    @NotNull
    private static final Pattern SPECIAL_FUNCTION_PATTERN;

    private static final boolean isWhitespaceOrComma(char $this$isWhitespaceOrComma) {
        return $this$isWhitespaceOrComma == ',' || CharsKt.isWhitespace((char)$this$isWhitespaceOrComma);
    }

    private static final void markInlineArguments(JsFunction $this$markInlineArguments, CallableDescriptor descriptor2) {
        List<ValueParameterDescriptor> list2 = descriptor2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getValueParameters(...)");
        List<ValueParameterDescriptor> params = list2;
        List<JsParameter> list3 = $this$markInlineArguments.getParameters();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"getParameters(...)");
        List<JsParameter> paramsJs = list3;
        Set<JsName> inlineFuns = CollectionUtilsKt.IdentitySet();
        int offset2 = DescriptorUtilsKt.isExtension(descriptor2) ? 1 : 0;
        Iterator<ValueParameterDescriptor> iterator2 = params.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            KotlinType type2;
            int i = n++;
            ValueParameterDescriptor param = iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)param.getType(), (String)"getType(...)");
            if (!FunctionTypesKt.isFunctionTypeOrSubtype(type2)) continue;
            JsName jsName = paramsJs.get(i + offset2).getName();
            Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"getName(...)");
            inlineFuns.add(jsName);
        }
        JsVisitorWithContextImpl visitor2 = new JsVisitorWithContextImpl(inlineFuns){
            final /* synthetic */ Set<JsName> $inlineFuns;
            {
                this.$inlineFuns = $inlineFuns;
            }

            public void endVisit(JsInvocation x, JsContext<?> ctx) {
                block3: {
                    HasMetadata hasMetadata;
                    JsExpression qualifier2;
                    JsExpression jsExpression;
                    Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                    Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                    if (InvocationUtilsKt.isCallInvocation(x)) {
                        JsExpression jsExpression2 = x.getQualifier();
                        JsNameRef jsNameRef = jsExpression2 instanceof JsNameRef ? (JsNameRef)jsExpression2 : null;
                        jsExpression = jsNameRef != null ? jsNameRef.getQualifier() : null;
                    } else {
                        jsExpression = qualifier2 = x.getQualifier();
                    }
                    if ((hasMetadata = qualifier2 instanceof JsNameRef ? (JsNameRef)qualifier2 : null) == null || (hasMetadata = hasMetadata.getName()) == null) break block3;
                    HasMetadata hasMetadata2 = hasMetadata;
                    Set<JsName> set = this.$inlineFuns;
                    HasMetadata name2 = hasMetadata2;
                    boolean bl = false;
                    if (set.contains(name2)) {
                        MetadataProperties.setInline(x, (Boolean)true);
                    }
                }
            }
        };
        visitor2.accept((JsNode)$this$markInlineArguments);
    }

    private static final void replaceExternalNames(JsNode node, Map<String, ? extends JsExpression> replacements, Set<? extends JsName> definedNames) {
        JsVisitorWithContextImpl visitor2 = new JsVisitorWithContextImpl(definedNames, replacements){
            final /* synthetic */ Set<JsName> $definedNames;
            final /* synthetic */ Map<String, JsExpression> $replacements;
            {
                this.$definedNames = $definedNames;
                this.$replacements = $replacements;
            }

            public void endVisit(JsNameRef x, JsContext<JsNode> ctx) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                    Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                    if (x.getQualifier() != null || CollectionsKt.contains((Iterable)this.$definedNames, (Object)x.getName())) {
                        return;
                    }
                    JsExpression jsExpression = this.$replacements.get(x.getIdent());
                    if (jsExpression == null) break block1;
                    JsExpression it = jsExpression;
                    boolean bl = false;
                    ctx.replaceMe((JsNode)it);
                }
            }
        };
        visitor2.accept(node);
    }

    public static final /* synthetic */ void access$replaceExternalNames(JsNode node, Map replacements, Set definedNames) {
        FunctionReaderKt.replaceExternalNames(node, replacements, definedNames);
    }

    public static final /* synthetic */ boolean access$isWhitespaceOrComma(char $receiver) {
        return FunctionReaderKt.isWhitespaceOrComma($receiver);
    }

    public static final /* synthetic */ void access$markInlineArguments(JsFunction $receiver, CallableDescriptor descriptor2) {
        FunctionReaderKt.markInlineArguments($receiver, descriptor2);
    }

    public static final /* synthetic */ Map access$getSpecialFunctionsByName$p() {
        return specialFunctionsByName;
    }

    public static final /* synthetic */ String access$getDEFINE_MODULE_FIND_PATTERN$p() {
        return DEFINE_MODULE_FIND_PATTERN;
    }

    public static final /* synthetic */ Pattern access$getDEFINE_MODULE_PATTERN$p() {
        return DEFINE_MODULE_PATTERN;
    }

    public static final /* synthetic */ Pattern access$getSPECIAL_FUNCTION_PATTERN$p() {
        return SPECIAL_FUNCTION_PATTERN;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$associateByTo$iv$iv;
        JS_IDENTIFIER_START = "\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}\\$_";
        JS_IDENTIFIER_PART = JS_IDENTIFIER_START + "\\p{Pc}\\p{Mc}\\p{Mn}\\d";
        JS_IDENTIFIER = '[' + JS_IDENTIFIER_START + "][" + JS_IDENTIFIER_PART + "]*";
        DEFINE_MODULE_PATTERN = new Regex('(' + JS_IDENTIFIER + ")\\.defineModule\\(\\s*(['\"])([^'\"]+)\\2\\s*,\\s*(\\w+)\\s*\\)").toPattern();
        DEFINE_MODULE_FIND_PATTERN = ".defineModule(";
        specialFunctions = ArraysKt.joinToString$default((Object[])SpecialFunction.values(), (CharSequence)"|", null, null, (int)0, null, (Function1)specialFunctions.1.INSTANCE, (int)30, null);
        SpecialFunction[] $this$associateBy$iv = SpecialFunction.values();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateBy$iv.length), (int)16);
        SpecialFunction[] specialFunctionArray = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        int n = ((void)$this$associateByTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void element$iv$iv;
            void var9_9 = element$iv$iv = $this$associateByTo$iv$iv[i];
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getSuggestedName(), element$iv$iv);
        }
        specialFunctionsByName = destination$iv$iv;
        SPECIAL_FUNCTION_PATTERN = new Regex("var\\s+(" + JS_IDENTIFIER + ")\\s*=\\s*(" + JS_IDENTIFIER + ")\\.(" + specialFunctions + ")\\s*;").toPattern();
    }
}

